/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.services.impl;

import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.ken.bo.NotificationChannelBo;
import org.kuali.rice.ken.bo.NotificationProducerBo;
import org.kuali.rice.ken.test.KENTestCase;
import org.kuali.rice.ken.test.TestConstants;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public class NotificationAuthorizationServiceImplTest
extends KENTestCase {
    @Test
    public void testIsProducerAuthorizedForNotificationChannel_validInput() {
        NotificationChannelBo channel = (NotificationChannelBo)KRADServiceLocator.getDataObjectService().find(NotificationChannelBo.class, (Object)TestConstants.CHANNEL_ID_1);
        NotificationProducerBo producer = (NotificationProducerBo)KRADServiceLocator.getDataObjectService().find(NotificationProducerBo.class, (Object)TestConstants.PRODUCER_3.getId());
        Assert.assertTrue((boolean)this.services.getNotificationAuthorizationService().isProducerAuthorizedToSendNotificationForChannel(producer, channel));
    }

    @Test
    public void testIsProducerAuthorizedForNotificationChannel_invalidInput() {
        NotificationChannelBo channel = (NotificationChannelBo)KRADServiceLocator.getDataObjectService().find(NotificationChannelBo.class, (Object)TestConstants.CHANNEL_ID_1);
        NotificationProducerBo producer = (NotificationProducerBo)KRADServiceLocator.getDataObjectService().find(NotificationProducerBo.class, (Object)TestConstants.PRODUCER_4.getId());
        Assert.assertFalse((boolean)this.services.getNotificationAuthorizationService().isProducerAuthorizedToSendNotificationForChannel(producer, channel));
    }

    @Test
    public void testIsUserAdministrator_validAdmin() {
        Assert.assertTrue((boolean)this.services.getNotificationAuthorizationService().isUserAdministrator("testadmin1"));
    }

    @Test
    public void testIsUserAdministrator_nonAdmin() {
        Assert.assertFalse((boolean)this.services.getNotificationAuthorizationService().isUserAdministrator("testuser1"));
    }

    @Test
    public void testIsUserAdministrator_invalidUser() {
        Assert.assertFalse((boolean)this.services.getNotificationAuthorizationService().isUserAdministrator("InvalidUser"));
    }
}

