/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.notes.service.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Timestamp;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.notes.Attachment;
import org.kuali.rice.kew.notes.Note;
import org.kuali.rice.kew.notes.service.NoteService;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.springframework.core.io.Resource;

public class AmazonS3AttachmentServiceTest
extends KEWTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSaveAttachments() throws Exception {
        File file = null;
        try {
            Note note = new Note();
            note.setDocumentId("12345");
            String ewestfalId = this.getPrincipalIdForName("ewestfal");
            note.setNoteAuthorWorkflowId(ewestfalId);
            note.setNoteCreateDate(new Timestamp(System.currentTimeMillis()));
            note.setNoteText("This is my note");
            file = File.createTempFile("file", "txt");
            FileWriter writer = new FileWriter(file);
            String fileContent = "This is the file text";
            writer.write(fileContent);
            writer.close();
            Attachment attachment = new Attachment();
            attachment.setFileName("file.txt");
            attachment.setMimeType("text/plain");
            attachment.setAttachedObject((InputStream)new FileInputStream(file));
            attachment.setNote(note);
            note.getAttachments().add(attachment);
            note = this.getNoteService().saveNote(note);
            Attachment savedAttachment = (Attachment)note.getAttachments().get(0);
            Assert.assertTrue((boolean)savedAttachment.getFileLoc().startsWith("s3://"));
            Assert.assertNotNull((Object)savedAttachment.getAttachmentId());
            Attachment loadedAttachment = this.getNoteService().findAttachment(savedAttachment.getAttachmentId());
            loadedAttachment.setAttachedObject(this.getNoteService().findAttachmentResource(loadedAttachment).getInputStream());
            InputStreamReader reader = new InputStreamReader(loadedAttachment.getAttachedObject());
            char[] cbuf = new char[fileContent.length()];
            reader.read(cbuf, 0, fileContent.length());
            Assert.assertEquals((Object)fileContent, (Object)new String(cbuf));
            Resource attachmentResource = this.getNoteService().findAttachmentResource(loadedAttachment);
            Assert.assertTrue((String)"attachment resource should exist", (boolean)attachmentResource.exists());
            this.getNoteService().deleteAttachment(loadedAttachment);
            attachmentResource = this.getNoteService().findAttachmentResource(loadedAttachment);
            Assert.assertFalse((String)"attachment resource has been deleted so should no longer exist", (boolean)attachmentResource.exists());
        }
        finally {
            file.delete();
        }
    }

    private NoteService getNoteService() {
        return KEWServiceLocator.getNoteService();
    }
}

