/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.edl.impl;

import javax.servlet.http.HttpServletRequest;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.edl.impl.EDLContext;
import org.kuali.rice.edl.impl.EDLController;
import org.kuali.rice.edl.impl.RequestParser;
import org.kuali.rice.edl.impl.TestConfigProcessor;
import org.kuali.rice.edl.impl.TestPostProcessor;
import org.kuali.rice.edl.impl.TestPreProcessor;
import org.kuali.rice.edl.impl.TestStateComponent;
import org.kuali.rice.edl.impl.service.EDocLiteService;
import org.kuali.rice.edl.impl.service.EdlServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.springframework.mock.web.MockHttpServletRequest;
import org.w3c.dom.Element;

public class EDLControllerTest
extends KEWTestCase {
    @Override
    protected void loadTestData() throws Exception {
        super.loadXmlFile("widgets.xml");
        super.loadXmlFile("edlstyle.xml");
        super.loadXmlFile("FakeyEDL.xml");
    }

    @Test
    public void testEDLControllerCreation() throws Exception {
        ConfigContext.getCurrentContextConfig().putProperty("edl.config.loc", "classpath:org/kuali/rice/kew/edl/TestEDLConfig.xml");
        EDLController edlController = this.getEDLService().getEDLControllerUsingEdlName("FakeyEDL");
        edlController.setEdlContext(this.getEDLcontext());
        Assert.assertNotNull((String)"There should be a default dom in the edlcontoller", (Object)edlController.getDefaultDOM());
        edlController.notifyComponents();
        Assert.assertTrue((String)"PreProcess component should have been notified", (boolean)TestPreProcessor.isContacted());
        Assert.assertTrue((String)"PostProcessor component should have been notified", (boolean)TestPostProcessor.isContacted());
        Assert.assertTrue((String)"State component should have been notified", (boolean)TestStateComponent.isContacted());
        Assert.assertTrue((String)"ConfigProcess component should have been notified", (boolean)TestConfigProcessor.isContacted());
        Element preProcessorConfigElement = (Element)edlController.getEdlGlobalConfig().getPreProcessors().entrySet().iterator().next().getKey();
        Assert.assertEquals((String)"PreProcessor config element is of the wrong class", (Object)"org.kuali.rice.edl.impl.TestPreProcessor", (Object)preProcessorConfigElement.getFirstChild().getNodeValue());
        Element postProcessorConfigElement = (Element)edlController.getEdlGlobalConfig().getPostProcessors().entrySet().iterator().next().getKey();
        Assert.assertEquals((String)"PostProcessor config element is of the wrong class", (Object)"org.kuali.rice.edl.impl.TestPostProcessor", (Object)postProcessorConfigElement.getFirstChild().getNodeValue());
        Element stateConfigElement = (Element)edlController.getEdlGlobalConfig().getStateComponents().entrySet().iterator().next().getKey();
        Assert.assertEquals((String)"State config element is of the wrong class", (Object)"org.kuali.rice.edl.impl.TestStateComponent", (Object)stateConfigElement.getFirstChild().getNodeValue());
        Element configProcessorConfigElement = (Element)edlController.getConfigProcessors().entrySet().iterator().next().getKey();
        Assert.assertEquals((String)"Config processor element should be fielDef", (Object)"fieldDef", (Object)configProcessorConfigElement.getNodeName());
    }

    private EDLContext getEDLcontext() {
        EDLContext edlContext = new EDLContext();
        edlContext.setRequestParser(new RequestParser((HttpServletRequest)new MockHttpServletRequest()));
        return edlContext;
    }

    private EDocLiteService getEDLService() {
        return EdlServiceLocator.getEDocLiteService();
    }
}

