/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actionlist;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.delegation.DelegationType;
import org.kuali.rice.kew.actionitem.ActionItem;
import org.kuali.rice.kew.actionlist.ActionListFilter;
import org.kuali.rice.kew.actionlist.service.ActionListService;
import org.kuali.rice.kew.actionlist.web.ActionListUtil;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actionrequest.KimGroupRecipient;
import org.kuali.rice.kew.actionrequest.Recipient;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.document.DocumentUpdate;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routeheader.service.RouteHeaderService;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kew.test.TestUtilities;
import org.kuali.rice.kew.util.WebFriendlyRecipient;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.springframework.jdbc.core.StatementCallback;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class ActionListTest
extends KEWTestCase {
    private static final String[] AUTHENTICATION_IDS = new String[]{"ewestfal", "rkirkend", "jhopf", "bmcgough"};
    private static final String[] WORKGROUP_IDS = new String[]{"1", "2", "3", "4"};
    private DocumentRouteHeaderValue routeHeader1;
    private DocumentRouteHeaderValue routeHeader2;
    private DocumentRouteHeaderValue routeHeader3;
    private List<ActionItem> actionItems = new ArrayList<ActionItem>();

    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("ActionListConfig.xml");
    }

    private void setUpOldSchool() throws Exception {
        int i;
        super.setUpAfterDataLoad();
        ArrayList<ActionItem> actionItems1 = new ArrayList<ActionItem>();
        ArrayList<ActionItem> actionItems2 = new ArrayList<ActionItem>();
        ArrayList<ActionItem> actionItems3 = new ArrayList<ActionItem>();
        this.routeHeader1 = this.generateDocRouteHeader();
        this.routeHeader2 = this.generateDocRouteHeader();
        this.routeHeader3 = this.generateDocRouteHeader();
        this.getRouteHeaderService().saveRouteHeader(this.routeHeader1);
        this.getRouteHeaderService().saveRouteHeader(this.routeHeader2);
        this.getRouteHeaderService().saveRouteHeader(this.routeHeader3);
        for (i = 0; i < AUTHENTICATION_IDS.length; ++i) {
            actionItems1.add(this.generateActionItem(this.routeHeader1, "K", AUTHENTICATION_IDS[i], null));
            actionItems2.add(this.generateActionItem(this.routeHeader2, "A", AUTHENTICATION_IDS[i], null));
        }
        for (i = 0; i < WORKGROUP_IDS.length; ++i) {
            actionItems3.add(this.generateActionItem(this.routeHeader3, "A", AUTHENTICATION_IDS[i], WORKGROUP_IDS[i]));
        }
        this.actionItems.addAll(actionItems1);
        this.actionItems.addAll(actionItems2);
        this.actionItems.addAll(actionItems3);
        for (ActionItem actionItem : this.actionItems) {
            this.getActionListService().saveActionItem(actionItem);
        }
    }

    @Test
    public void testRouteHeaderDelete() throws Exception {
        this.setUpOldSchool();
        Collection actionItems = this.getActionListService().findByDocumentId(this.routeHeader1.getDocumentId());
        Assert.assertEquals((String)("Route header " + this.routeHeader1.getDocumentId() + " should have action items."), (long)AUTHENTICATION_IDS.length, (long)actionItems.size());
        this.getActionListService().deleteByDocumentId(this.routeHeader1.getDocumentId());
        actionItems = this.getActionListService().findByDocumentId(this.routeHeader1.getDocumentId());
        Assert.assertEquals((String)("There should be no remaining action items for route header " + this.routeHeader1.getDocumentId()), (long)0L, (long)actionItems.size());
        actionItems = this.getActionListService().findByDocumentId(this.routeHeader2.getDocumentId());
        Assert.assertEquals((String)("Route header " + this.routeHeader2.getDocumentId() + " should have action items."), (long)AUTHENTICATION_IDS.length, (long)actionItems.size());
    }

    @Test
    public void testActionListCount() throws Exception {
        this.setUpOldSchool();
        TransactionTemplate transactionTemplate = this.getTransactionTemplate();
        transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                return TestUtilities.getJdbcTemplate().execute(new StatementCallback(){

                    public Object doInStatement(Statement stmt) {
                        try {
                            Connection conn = stmt.getConnection();
                            PreparedStatement ps = conn.prepareStatement("select distinct PRNCPL_ID from krew_actn_itm_t");
                            ResultSet rs = ps.executeQuery();
                            int emplIdCnt = 0;
                            int loopCnt = 0;
                            while (rs.next() && ++loopCnt < 6) {
                                String workflowId = rs.getString(1);
                                PreparedStatement ps1 = conn.prepareStatement("select count(*) from krew_actn_itm_t where PRNCPL_ID = ?");
                                ps1.setString(1, workflowId);
                                ResultSet rsWorkflowIdCnt = ps1.executeQuery();
                                if (!rsWorkflowIdCnt.next()) {
                                    throw new Exception("WorkflowId " + workflowId + " didn't return a count.  Test SQL invalid.");
                                }
                                emplIdCnt = rsWorkflowIdCnt.getInt(1);
                                Collection actionList = ActionListTest.this.getActionListService().findByPrincipalId(workflowId);
                                Assert.assertEquals((String)("ActionItemService returned incorrect number of ActionItems for user " + workflowId + " ActionList"), (long)emplIdCnt, (long)actionList.size());
                                ps1.close();
                                rsWorkflowIdCnt.close();
                            }
                            rs.close();
                            ps.close();
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        return null;
                    }
                });
            }
        });
    }

    @Test
    public void testActionListMaxActionItemDateAssignedAndCountForUser() throws Exception {
        this.setUpOldSchool();
        TransactionTemplate transactionTemplate = this.getTransactionTemplate();
        transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                return TestUtilities.getJdbcTemplate().execute(new StatementCallback(){

                    public Object doInStatement(Statement stmt) {
                        try {
                            Connection conn = stmt.getConnection();
                            PreparedStatement ps = conn.prepareStatement("select distinct PRNCPL_ID from krew_actn_itm_t");
                            ResultSet rs = ps.executeQuery();
                            int cnt = 0;
                            Timestamp maxDate = null;
                            int loopCnt = 0;
                            while (rs.next() && ++loopCnt < 6) {
                                String workflowId = rs.getString(1);
                                PreparedStatement ps1 = conn.prepareStatement("select max(ASND_DT) as max_date, count(distinct(doc_hdr_id)) as total_records  from (  select ASND_DT,doc_hdr_id   from KREW_ACTN_ITM_T   where    prncpl_id=?   group by  ASND_DT,doc_hdr_id   ) T");
                                ps1.setString(1, workflowId);
                                ResultSet rsWorkflowIdCnt = ps1.executeQuery();
                                if (!rsWorkflowIdCnt.next()) {
                                    throw new Exception("WorkflowId " + workflowId + " didn't return a result set.  Test SQL invalid.");
                                }
                                maxDate = rsWorkflowIdCnt.getTimestamp(1);
                                cnt = rsWorkflowIdCnt.getInt(2);
                                List ls = ActionListTest.this.getActionListService().getMaxActionItemDateAssignedAndCountForUser(workflowId);
                                Assert.assertEquals((Object)cnt, ls.get(1));
                                Assert.assertEquals((Object)maxDate, ls.get(0));
                                ps1.close();
                                rsWorkflowIdCnt.close();
                            }
                            rs.close();
                            ps.close();
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        return null;
                    }
                });
            }
        });
    }

    @Test
    public void testSecondaryActionList() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("jhopf"), (String)"ActionListDocumentType");
        document.route("");
        String bmcgoughPrincipalId = this.getPrincipalIdForName("bmcgough");
        String rkirkendPrincipalId = this.getPrincipalIdForName("rkirkend");
        String ewestfalPrincipalId = this.getPrincipalIdForName("ewestfal");
        String jitruePrincipalId = this.getPrincipalIdForName("jitrue");
        String user1PrincipalId = this.getPrincipalIdForName("user1");
        Group NonSIT = KimApiServiceLocator.getGroupService().getGroupByNamespaceCodeAndName("KR-WKFLW", "NonSIT");
        ActionListFilter noFilter = new ActionListFilter();
        ActionListFilter excludeSecondaryFilter = new ActionListFilter();
        excludeSecondaryFilter.setDelegationType(DelegationType.SECONDARY.getCode());
        excludeSecondaryFilter.setExcludeDelegationType(true);
        ActionListFilter secondaryFilter = new ActionListFilter();
        secondaryFilter.setDelegationType(DelegationType.SECONDARY.getCode());
        Collection actionItems = null;
        ActionItem actionItem = null;
        actionItems = this.getActionListService().getActionList(bmcgoughPrincipalId, excludeSecondaryFilter);
        Assert.assertEquals((String)"bmcgough should have 0 items in his primary action list.", (long)0L, (long)actionItems.size());
        actionItems = this.getActionListService().getActionList(bmcgoughPrincipalId, secondaryFilter);
        Assert.assertEquals((String)"bmcgough should have 1 item in his secondary action list.", (long)1L, (long)actionItems.size());
        actionItem = (ActionItem)actionItems.iterator().next();
        Assert.assertEquals((String)"Should be an approve request.", (Object)"A", (Object)actionItem.getActionRequestCd());
        Assert.assertEquals((String)"Should be a secondary delegation request.", (Object)DelegationType.SECONDARY, (Object)actionItem.getDelegationType());
        actionItem = (ActionItem)actionItems.iterator().next();
        Assert.assertEquals((String)"Should be an approve request.", (Object)"A", (Object)actionItem.getActionRequestCd());
        Assert.assertEquals((String)"Should be a secondary delegation request.", (Object)DelegationType.SECONDARY, (Object)actionItem.getDelegationType());
        actionItems = this.getActionListService().getActionList(bmcgoughPrincipalId, noFilter);
        Assert.assertEquals((String)"bmcgough should have 1 item in his entire action list.", (long)1L, (long)actionItems.size());
        actionItems = this.getActionListService().getActionList(rkirkendPrincipalId, excludeSecondaryFilter);
        Assert.assertEquals((String)"bmcgough should have 1 item in his primary action list.", (long)1L, (long)actionItems.size());
        actionItems = this.getActionListService().getActionList(jitruePrincipalId, excludeSecondaryFilter);
        Assert.assertEquals((String)"jitrue should have 1 item in his primary action list.", (long)1L, (long)actionItems.size());
        actionItems = this.getActionListService().getActionList(ewestfalPrincipalId, secondaryFilter);
        Assert.assertEquals((String)"ewestfal should have 1 item in his secondary action list.", (long)1L, (long)actionItems.size());
        actionItems = this.getActionListService().getActionList(user1PrincipalId, noFilter);
        Assert.assertEquals((String)"user1 should have 1 item in his primary action list.", (long)1L, (long)actionItems.size());
        actionItem = (ActionItem)actionItems.iterator().next();
        Assert.assertEquals((String)"Should be an approve request.", (Object)"A", (Object)actionItem.getActionRequestCd());
        Assert.assertEquals((String)"Should be to a workgroup.", (Object)NonSIT.getId(), (Object)actionItem.getGroupId());
        ActionListFilter ackFilter = new ActionListFilter();
        ackFilter.setActionRequestCd("K");
        actionItems = this.getActionListService().getActionList(user1PrincipalId, ackFilter);
        Assert.assertEquals((String)"user1 should have 1 item in his primary action list.", (long)1L, (long)actionItems.size());
        actionItem = (ActionItem)actionItems.iterator().next();
        Assert.assertEquals((String)"Should be an acknowledge request.", (Object)"K", (Object)actionItem.getActionRequestCd());
        Assert.assertNull((String)"Should not be to a workgroup.", (Object)actionItem.getGroupId());
        List memberPrincipalIds = KimApiServiceLocator.getGroupService().getMemberPrincipalIds(NonSIT.getId());
        for (String memberPrincipalId : memberPrincipalIds) {
            actionItems = this.getActionListService().getActionList(memberPrincipalId, excludeSecondaryFilter);
            Assert.assertEquals((String)("Workgroup Member " + memberPrincipalId + " should have 1 action item."), (long)1L, (long)actionItems.size());
            actionItem = (ActionItem)actionItems.iterator().next();
            Assert.assertEquals((String)"Should be an approve request.", (Object)"A", (Object)actionItem.getActionRequestCd());
            Assert.assertEquals((String)"Should be to a workgroup.", (Object)NonSIT.getId(), (Object)actionItem.getGroupId());
        }
        document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("jhopf"), (String)"ActionListDocumentType_PrimaryDelegate");
        document.route("");
        document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("jhopf"), (String)"ActionListDocumentType_PrimaryDelegate2");
        document.route("");
        actionItems = this.getActionListService().getActionList(bmcgoughPrincipalId, excludeSecondaryFilter);
        Assert.assertEquals((String)"bmcgough should have 0 items in his primary action list.", (long)0L, (long)actionItems.size());
        actionItems = this.getActionListService().getActionList(bmcgoughPrincipalId, secondaryFilter);
        Assert.assertEquals((String)"bmcgough should have 1 item in his secondary action list.", (long)3L, (long)actionItems.size());
        actionItems = this.getActionListService().getActionList(bmcgoughPrincipalId, new ActionListFilter());
        Assert.assertEquals((String)"bmcgough should have 1 item in his entire action list.", (long)3L, (long)actionItems.size());
        ActionListFilter filter = null;
        filter = new ActionListFilter();
        filter.setDelegatorId("Choose Secondary Delegation");
        filter.setPrimaryDelegateId("Choose Primary Delegate");
        actionItems = this.getActionListService().getActionList(bmcgoughPrincipalId, filter);
        Assert.assertEquals((String)"bmcgough should have 0 items in his entire action list.", (long)0L, (long)actionItems.size());
        filter = new ActionListFilter();
        filter.setDelegationType(DelegationType.SECONDARY.getCode());
        filter.setDelegatorId("All");
        actionItems = this.getActionListService().getActionList(bmcgoughPrincipalId, filter);
        Assert.assertEquals((String)"bmcgough has incorrect action list item count.", (long)3L, (long)actionItems.size());
        filter = new ActionListFilter();
        filter.setDelegationType(DelegationType.SECONDARY.getCode());
        filter.setDelegatorId("Choose Secondary Delegation");
        actionItems = this.getActionListService().getActionList(bmcgoughPrincipalId, filter);
        Assert.assertEquals((String)"bmcgough has incorrect action list item count.", (long)0L, (long)actionItems.size());
        filter = new ActionListFilter();
        filter.setDelegationType(DelegationType.SECONDARY.getCode());
        filter.setDelegatorId(bmcgoughPrincipalId);
        actionItems = this.getActionListService().getActionList(bmcgoughPrincipalId, filter);
        Assert.assertEquals((String)"bmcgough has incorrect action list item count.", (long)3L, (long)actionItems.size());
        filter = new ActionListFilter();
        filter.setDelegationType(DelegationType.SECONDARY.getCode());
        filter.setDelegatorId(bmcgoughPrincipalId);
        actionItems = this.getActionListService().getActionList(ewestfalPrincipalId, filter);
        Assert.assertEquals((String)"ewestfal has incorrect action list item count.", (long)3L, (long)actionItems.size());
        filter = new ActionListFilter();
        filter.setDelegationType(DelegationType.SECONDARY.getCode());
        filter.setDelegatorId(jitruePrincipalId);
        actionItems = this.getActionListService().getActionList(jitruePrincipalId, filter);
        Assert.assertEquals((String)"jitrue has incorrect action list item count.", (long)3L, (long)actionItems.size());
    }

    @Test
    public void testPrimaryDelegationActionList() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("jhopf"), (String)"ActionListDocumentType");
        document.route("");
        String bmcgoughPrincipalId = this.getPrincipalIdForName("bmcgough");
        String rkirkendPrincipalId = this.getPrincipalIdForName("rkirkend");
        String delyeaPrincipalId = this.getPrincipalIdForName("delyea");
        String temayPrincipalId = this.getPrincipalIdForName("temay");
        String jhopfPrincipalId = this.getPrincipalIdForName("jhopf");
        ActionListFilter showPrimaryFilter = new ActionListFilter();
        showPrimaryFilter.setDelegationType(DelegationType.PRIMARY.getCode());
        Collection actionItems = null;
        Object actionItem = null;
        actionItems = this.getActionListService().getActionList(bmcgoughPrincipalId, showPrimaryFilter);
        Assert.assertEquals((String)"bmcgough should have 1 item in his primary delegation action list.", (long)1L, (long)actionItems.size());
        actionItems = this.getActionListService().getActionList(bmcgoughPrincipalId, new ActionListFilter());
        Assert.assertEquals((String)"bmcgough should have 1 item in his entire action list.", (long)1L, (long)actionItems.size());
        document = WorkflowDocumentFactory.createDocument((String)jhopfPrincipalId, (String)"ActionListDocumentType_PrimaryDelegate");
        document.route("");
        document = WorkflowDocumentFactory.createDocument((String)jhopfPrincipalId, (String)"ActionListDocumentType_PrimaryDelegate2");
        document.route("");
        actionItems = this.getActionListService().getActionList(bmcgoughPrincipalId, showPrimaryFilter);
        Assert.assertEquals((String)"bmcgough should have 1 item in his primary delegation action list.", (long)3L, (long)actionItems.size());
        ActionListFilter filter = null;
        filter = new ActionListFilter();
        filter.setDelegatorId("Choose Secondary Delegation");
        filter.setPrimaryDelegateId("Choose Primary Delegate");
        actionItems = this.getActionListService().getActionList(bmcgoughPrincipalId, filter);
        Assert.assertEquals((String)"bmcgough should have 0 items in his entire action list.", (long)0L, (long)actionItems.size());
        filter = new ActionListFilter();
        filter.setDelegationType(DelegationType.PRIMARY.getCode());
        filter.setPrimaryDelegateId("All");
        actionItems = this.getActionListService().getActionList(bmcgoughPrincipalId, filter);
        Assert.assertEquals((String)"bmcgough should have 1 item in his entire action list.", (long)3L, (long)actionItems.size());
        filter = new ActionListFilter();
        filter.setDelegationType(DelegationType.PRIMARY.getCode());
        filter.setPrimaryDelegateId("Choose Primary Delegate");
        actionItems = this.getActionListService().getActionList(bmcgoughPrincipalId, filter);
        Assert.assertEquals((String)"bmcgough should have 1 item in his entire action list.", (long)0L, (long)actionItems.size());
        filter = new ActionListFilter();
        filter.setDelegationType(DelegationType.PRIMARY.getCode());
        filter.setPrimaryDelegateId(rkirkendPrincipalId);
        actionItems = this.getActionListService().getActionList(bmcgoughPrincipalId, filter);
        Assert.assertEquals((String)"bmcgough should have 3 items in his entire action list.", (long)3L, (long)actionItems.size());
        filter = new ActionListFilter();
        filter.setDelegationType(DelegationType.PRIMARY.getCode());
        filter.setPrimaryDelegateId(delyeaPrincipalId);
        actionItems = this.getActionListService().getActionList(bmcgoughPrincipalId, filter);
        Assert.assertEquals((String)"bmcgough should have 2 items in his entire action list.", (long)2L, (long)actionItems.size());
        filter = new ActionListFilter();
        filter.setDelegationType(DelegationType.PRIMARY.getCode());
        filter.setPrimaryDelegateId(temayPrincipalId);
        actionItems = this.getActionListService().getActionList(bmcgoughPrincipalId, filter);
        Assert.assertEquals((String)"bmcgough should have 1 item in his entire action list.", (long)1L, (long)actionItems.size());
    }

    @Test
    public void testGettingDelegationUsers() throws Exception {
        Recipient recipient2;
        Person jhopf = KimApiServiceLocator.getPersonService().getPersonByPrincipalName("jhopf");
        Person bmcgough = KimApiServiceLocator.getPersonService().getPersonByPrincipalName("bmcgough");
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("jhopf"), (String)"ActionListDocumentType");
        document.route("");
        document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("jhopf"), (String)"ActionListDocumentType_PrimaryDelegate");
        document.route("");
        document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("jhopf"), (String)"ActionListDocumentType_PrimaryDelegate2");
        document.route("");
        Collection recipients = this.getActionListService().findUserPrimaryDelegations(jhopf.getPrincipalId());
        Assert.assertEquals((String)"Wrong size of users who were delegated to via Primary Delegation", (long)0L, (long)recipients.size());
        recipients = this.getActionListService().findUserPrimaryDelegations(bmcgough.getPrincipalId());
        Assert.assertEquals((String)"Wrong size of users who were delegated to via Primary Delegation", (long)3L, (long)recipients.size());
        String user1 = KimApiServiceLocator.getPersonService().getPersonByPrincipalName("rkirkend").getPrincipalId();
        String user2 = KimApiServiceLocator.getPersonService().getPersonByPrincipalName("temay").getPrincipalId();
        String user3 = KimApiServiceLocator.getPersonService().getPersonByPrincipalName("delyea").getPrincipalId();
        boolean foundUser1 = false;
        boolean foundUser2 = false;
        boolean foundUser3 = false;
        for (Recipient recipient2 : recipients) {
            if (user1.equals(((WebFriendlyRecipient)recipient2).getRecipientId())) {
                foundUser1 = true;
                continue;
            }
            if (user2.equals(((WebFriendlyRecipient)recipient2).getRecipientId())) {
                foundUser2 = true;
                continue;
            }
            if (user3.equals(((WebFriendlyRecipient)recipient2).getRecipientId())) {
                foundUser3 = true;
                continue;
            }
            Assert.fail((String)("Found invalid recipient in list with display name '" + ((WebFriendlyRecipient)recipient2).getDisplayName() + "'"));
        }
        Assert.assertTrue((String)("Should have found user " + user1), (boolean)foundUser1);
        Assert.assertTrue((String)("Should have found user " + user2), (boolean)foundUser2);
        Assert.assertTrue((String)("Should have found user " + user3), (boolean)foundUser3);
        recipients = this.getActionListService().findUserSecondaryDelegators(bmcgough.getPrincipalId());
        Assert.assertEquals((String)"Wrong size of users who were have delegated to given user via Secondary Delegation", (long)2L, (long)recipients.size());
        Iterator recipientsIt = recipients.iterator();
        recipient2 = (WebFriendlyRecipient)recipientsIt.next();
        Assert.assertEquals((String)"Wrong employee id of delegator", (Object)"bmcgough", (Object)this.getPrincipalNameForId(recipient2.getRecipientId()));
        Assert.assertEquals((String)"Wrong group id of delegator", (Object)this.getGroupIdForName("KR-WKFLW", "NonSIT"), (Object)((KimGroupRecipient)recipientsIt.next()).getGroupId());
    }

    @Test
    public void testCreateActionItemForActionRequest() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"ActionListDocumentType");
        document.route("");
        List requests = document.getRootActionRequests();
        Assert.assertTrue((String)"there must be ActionRequestDTOs to test!", (requests != null && requests.size() > 0 ? 1 : 0) != 0);
        for (ActionRequest reqDTO : requests) {
            if (reqDTO.getParentActionRequestId() != null) continue;
            ActionRequestValue reqVal = ActionRequestValue.from((ActionRequest)reqDTO);
            ArrayList<ActionItem> actionItems = new ArrayList<ActionItem>();
            actionItems.add(this.getActionListService().createActionItemForActionRequest(reqVal));
            Assert.assertTrue((actionItems.size() > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testDeleteActionItem() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("jhopf"), (String)"ActionListDocumentType");
        document.route("");
        Collection actionItems = this.getActionListService().getActionList(this.getPrincipalIdForName("bmcgough"), new ActionListFilter());
        Assert.assertEquals((String)"bmcgough should have 1 item in his action list.", (long)1L, (long)actionItems.size());
        ActionItem itm = null;
        Iterator iterator = actionItems.iterator();
        if (iterator.hasNext()) {
            ActionItem actionItem = (ActionItem)iterator.next();
            itm = this.getActionListService().findByActionItemId(actionItem.getId());
            this.getActionListService().deleteActionItem(itm);
        }
        actionItems = this.getActionListService().getActionList(this.getPrincipalIdForName("bmcgough"), new ActionListFilter());
        Assert.assertEquals((String)"bmcgough should have 0 item in his action list.", (long)0L, (long)actionItems.size());
    }

    @Test
    public void testFindByDocumentTypeName() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("jhopf"), (String)"ActionListDocumentType");
        document.route("");
        Collection actionItems = this.getActionListService().findByDocumentTypeName("ActionListDocumentType");
        Assert.assertEquals((String)"There should be 10 action items", (long)10L, (long)actionItems.size());
    }

    @Test
    public void testFindByActionRequestId() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("jhopf"), (String)"ActionListDocumentType");
        document.route("");
        List actionRequests = document.getRootActionRequests();
        for (ActionRequest actionRequest : actionRequests) {
            if (!actionRequest.getActionRequested().getCode().equals("K")) continue;
            Collection actionItems = this.getActionListService().findByActionRequestId(actionRequest.getId());
            Assert.assertTrue((actionItems.size() == 1 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testUpdateActionItemForTitleChange() throws Exception {
        this.setUpOldSchool();
        Collection actionItems = this.getActionListService().findByDocumentId(this.routeHeader1.getDocumentId());
        for (ActionItem actionItem : actionItems) {
            Assert.assertEquals((Object)"Test", (Object)actionItem.getDocTitle());
        }
        DocumentUpdate.Builder builder = DocumentUpdate.Builder.create();
        builder.setTitle("NewTitle");
        DocumentUpdate documentUpdate = builder.build();
        this.routeHeader1.applyDocumentUpdate(documentUpdate);
        actionItems = this.getActionListService().findByDocumentId(this.routeHeader1.getDocumentId());
        for (ActionItem actionItem : actionItems) {
            Assert.assertEquals((Object)"NewTitle", (Object)actionItem.getDocTitle());
        }
    }

    @Test
    public void testGetWebFriendlyRecipientsWithGroup() {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("jhopf"), (String)"ActionListDocumentType_PrimaryDelegate");
        document.route("");
        Person bmcgough = KimApiServiceLocator.getPersonService().getPersonByPrincipalName("bmcgough");
        Collection delegators = this.getActionListService().findUserSecondaryDelegators(bmcgough.getPrincipalId());
        String nonSITGroupId = this.getGroupIdForName("KR-WKFLW", "NonSIT");
        Assert.assertFalse((boolean)delegators.isEmpty());
        boolean nonSITGroupFound = false;
        for (Recipient d : delegators) {
            if (!(d instanceof KimGroupRecipient) || !nonSITGroupId.equals(((KimGroupRecipient)d).getGroupId())) continue;
            nonSITGroupFound = true;
        }
        Assert.assertTrue((String)"NonSIT group was not found as a delegator to bmcgough (has test config changed?)", (boolean)nonSITGroupFound);
        ActionListUtil.getWebFriendlyRecipients((Collection)delegators);
    }

    private DocumentRouteHeaderValue generateDocRouteHeader() {
        DocumentRouteHeaderValue routeHeader = new DocumentRouteHeaderValue();
        routeHeader.setAppDocId("Test");
        routeHeader.setApprovedDate(null);
        routeHeader.setCreateDate(new Timestamp(new Date().getTime()));
        routeHeader.setDocContent("test");
        routeHeader.setDocRouteLevel(Integer.valueOf(1));
        routeHeader.setDocRouteStatus("R");
        routeHeader.setDocTitle("Test");
        routeHeader.setDocumentTypeId("1");
        routeHeader.setDocVersion(Integer.valueOf(1));
        routeHeader.setRouteStatusDate(new Timestamp(new Date().getTime()));
        routeHeader.setDateModified(new Timestamp(new Date().getTime()));
        routeHeader.setInitiatorWorkflowId("someone");
        return routeHeader;
    }

    private ActionItem generateActionItem(DocumentRouteHeaderValue routeHeader, String actionRequested, String authenticationId, String groupId) {
        ActionItem actionItem = new ActionItem();
        actionItem.setActionRequestCd(actionRequested);
        actionItem.setActionRequestId("1");
        actionItem.setPrincipalId(this.getPrincipalIdForName(authenticationId));
        actionItem.setDocumentId(routeHeader.getDocumentId());
        actionItem.setDateAssigned(new Timestamp(new Date().getTime()));
        actionItem.setDocHandlerURL("Unit testing");
        actionItem.setDocLabel("unit testing");
        actionItem.setDocTitle(routeHeader.getDocTitle());
        actionItem.setDocName("docname");
        actionItem.setGroupId(groupId);
        return actionItem;
    }

    private ActionListService getActionListService() {
        return KEWServiceLocator.getActionListService();
    }

    private RouteHeaderService getRouteHeaderService() {
        return KEWServiceLocator.getRouteHeaderService();
    }
}

