/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actionrequest;

import java.util.HashSet;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.document.DocumentRefreshQueue;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;

public class DocumentRefreshQueueTest
extends KEWTestCase {
    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("ActionRequestsConfig.xml");
    }

    @Test
    public void testDocumentRequeueSingleNode() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"DRSeqDocType");
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document.getDocumentId());
        Assert.assertTrue((boolean)document.isEnroute());
        List requests = document.getRootActionRequests();
        Assert.assertEquals((String)"Should be 2 requests.", (long)2L, (long)requests.size());
        HashSet<String> requestIds = new HashSet<String>();
        for (ActionRequest request : requests) {
            requestIds.add(request.getId());
        }
        DocumentRouteHeaderValue documentH = KEWServiceLocator.getRouteHeaderService().getRouteHeader(document.getDocumentId());
        DocumentRefreshQueue documentRequeuer = KewApiServiceLocator.getDocumentRequeuerService((String)documentH.getDocumentType().getApplicationId(), (String)documentH.getDocumentId(), (long)0L);
        documentRequeuer.refreshDocument(document.getDocumentId());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("bmcgough"), (String)document.getDocumentId());
        Assert.assertTrue((boolean)document.isEnroute());
        requests = document.getRootActionRequests();
        Assert.assertEquals((String)"Should be 2 requests.", (long)2L, (long)requests.size());
        for (ActionRequest requestVO : requests) {
            Assert.assertTrue((String)"Request ids should be different.", (!requestIds.contains(requestVO.getId()) ? 1 : 0) != 0);
        }
        Assert.assertTrue((boolean)document.isApprovalRequested());
        document.approve("");
        documentRequeuer.refreshDocument(document.getDocumentId());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        Assert.assertTrue((boolean)document.isEnroute());
        requests = document.getRootActionRequests();
        Assert.assertEquals((String)"Should be 2 requests.", (long)2L, (long)requests.size());
        boolean pendingToRkirkend = false;
        for (ActionRequest requestVO : requests) {
            if (requestVO.getPrincipalId().equals(this.getPrincipalIdForName("rkirkend")) && requestVO.isActivated()) {
                Assert.assertFalse((String)"rkirkend has too many requests!", (boolean)pendingToRkirkend);
                pendingToRkirkend = true;
                continue;
            }
            Assert.assertTrue((String)"previous request to all others should be done.", (boolean)requestVO.isDone());
        }
        Assert.assertTrue((boolean)document.isApprovalRequested());
    }

    private class SeqSetup {
        public static final String DOCUMENT_TYPE_NAME = "DRSeqDocType";
        public static final String ADHOC_NODE = "AdHoc";
        public static final String WORKFLOW_DOCUMENT_NODE = "WorkflowDocument";
        public static final String WORKFLOW_DOCUMENT_2_NODE = "WorkflowDocument2";

        private SeqSetup() {
        }
    }
}

