/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actions;

import mocks.MockEmailNotificationService;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kew.test.TestUtilities;

public class DisapproveActionTest
extends KEWTestCase {
    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("ActionsConfig.xml");
    }

    @Test
    public void testDisapprove() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"NotificationTest");
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("jhopf"), (String)document.getDocumentId());
        Assert.assertTrue((String)"This user should have an approve request", (boolean)document.isApprovalRequested());
        document.approve("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document.getDocumentId());
        Assert.assertTrue((String)"This user should have an approve request", (boolean)document.isApprovalRequested());
        document.approve("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        Assert.assertTrue((String)"This user should have an approve request", (boolean)document.isApprovalRequested());
        document.approve("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("natjohns"), (String)document.getDocumentId());
        Assert.assertTrue((String)"This user should have an approve request", (boolean)document.isApprovalRequested());
        document.approve("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("bmcgough"), (String)document.getDocumentId());
        Assert.assertTrue((String)"This user should have an approve request", (boolean)document.isApprovalRequested());
        TestUtilities.assertAtNode(document, "NotifyFinal");
        document.disapprove("");
        TestUtilities.assertAtNode(document, "NotifyFinal");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("bmcgough"), (String)document.getDocumentId());
        TestUtilities.assertAtNode(document, "NotifyFinal");
        Assert.assertTrue((String)"Document should be disapproved", (boolean)document.isDisapproved());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document.getDocumentId());
        Assert.assertTrue((String)"ack should be requested as part of disapprove notification", (boolean)document.isAcknowledgeRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("jhopf"), (String)document.getDocumentId());
        Assert.assertTrue((String)"ack should be requested as part of disapprove notification", (boolean)document.isAcknowledgeRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        Assert.assertTrue((String)"ack should be requested as part of disapprove notification", (boolean)document.isAcknowledgeRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("jitrue"), (String)document.getDocumentId());
        Assert.assertFalse((String)"ack should be requested as part of disapprove notification", (boolean)document.isAcknowledgeRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("natjohns"), (String)document.getDocumentId());
        Assert.assertTrue((String)"ack should be requested as part of disapprove notification", (boolean)document.isAcknowledgeRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("shenl"), (String)document.getDocumentId());
        Assert.assertFalse((String)"ack should be requested as part of disapprove notification", (boolean)document.isAcknowledgeRequested());
        Assert.assertEquals((String)"jhopf should have been sent an approve email", (long)1L, (long)this.getMockEmailService().immediateReminderEmailsSent("jhopf", document.getDocumentId(), "A"));
        Assert.assertEquals((String)"jhopf should have been sent an ack email", (long)1L, (long)this.getMockEmailService().immediateReminderEmailsSent("jhopf", document.getDocumentId(), "K"));
        Assert.assertEquals((String)"ewestfal should have been sent an approve email", (long)1L, (long)this.getMockEmailService().immediateReminderEmailsSent("ewestfal", document.getDocumentId(), "A"));
        Assert.assertEquals((String)"ewestfal should have been sent an ack email", (long)1L, (long)this.getMockEmailService().immediateReminderEmailsSent("ewestfal", document.getDocumentId(), "K"));
        Assert.assertEquals((String)"rkirkend should not have been sent an approve email", (long)0L, (long)this.getMockEmailService().immediateReminderEmailsSent("rkirkend", document.getDocumentId(), "A"));
        Assert.assertEquals((String)"rkirkend should have been sent an ack email", (long)1L, (long)this.getMockEmailService().immediateReminderEmailsSent("rkirkend", document.getDocumentId(), "K"));
        Assert.assertEquals((String)"temay should have been sent an approve email", (long)1L, (long)this.getMockEmailService().immediateReminderEmailsSent("temay", document.getDocumentId(), "A"));
        Assert.assertEquals((String)"temay should have been sent an ack email", (long)0L, (long)this.getMockEmailService().immediateReminderEmailsSent("temay", document.getDocumentId(), "K"));
        Assert.assertEquals((String)"pmckown should not have been sent an approve email", (long)0L, (long)this.getMockEmailService().immediateReminderEmailsSent("pmckown", document.getDocumentId(), "A"));
        Assert.assertEquals((String)"pmckown should not have been sent an ack email", (long)0L, (long)this.getMockEmailService().immediateReminderEmailsSent("pmckown", document.getDocumentId(), "K"));
        Assert.assertEquals((String)"jitrue should have been sent an approve email", (long)1L, (long)this.getMockEmailService().immediateReminderEmailsSent("jitrue", document.getDocumentId(), "A"));
        Assert.assertEquals((String)"jitrue should have been sent an ack email", (long)0L, (long)this.getMockEmailService().immediateReminderEmailsSent("jitrue", document.getDocumentId(), "K"));
        Assert.assertEquals((String)"natjohns should not have been sent an approve email", (long)0L, (long)this.getMockEmailService().immediateReminderEmailsSent("natjohns", document.getDocumentId(), "A"));
        Assert.assertEquals((String)"natjohns should not have been sent an ack email", (long)1L, (long)this.getMockEmailService().immediateReminderEmailsSent("natjohns", document.getDocumentId(), "K"));
        Assert.assertEquals((String)"shenl should not have been sent an approve email", (long)0L, (long)this.getMockEmailService().immediateReminderEmailsSent("shenl", document.getDocumentId(), "A"));
        Assert.assertEquals((String)"shenl should not have been sent an ack email", (long)0L, (long)this.getMockEmailService().immediateReminderEmailsSent("shenl", document.getDocumentId(), "K"));
        Assert.assertEquals((String)"bmcgough should have been sent an approve email", (long)1L, (long)this.getMockEmailService().immediateReminderEmailsSent("bmcgough", document.getDocumentId(), "A"));
        Assert.assertEquals((String)"bmcgough should not have been sent an ack email", (long)0L, (long)this.getMockEmailService().immediateReminderEmailsSent("bmcgough", document.getDocumentId(), "K"));
    }

    @Ignore(value="This test will fail until KULRICE-752 is resolved")
    @Test
    public void testInitiatorRoleDisapprove() throws WorkflowException {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("arh14"), (String)"InitiatorRoleApprovalTest");
        document.route("routing document");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("arh14"), (String)document.getDocumentId());
        document.disapprove("disapproving the document");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("arh14"), (String)document.getDocumentId());
        Assert.assertFalse((String)"Initiator should not have an Ack request from disapproval because they were the disapprover user", (boolean)document.isAcknowledgeRequested());
    }

    @Ignore(value="This test will fail until KULRICE-752 is resolved")
    @Test
    public void testInitiatorDisapprove() throws WorkflowException {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"NotificationTest");
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document.getDocumentId());
        document.disapprove("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document.getDocumentId());
        Assert.assertFalse((String)"Initiator should not have an Ack request from disapproval because they were the disapprover user", (boolean)document.isAcknowledgeRequested());
    }

    @Test
    public void testDisapproveByArbitraryRecipient() throws WorkflowException {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"BlanketApproveSequentialTest");
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("bmcgough"), (String)document.getDocumentId());
        document.disapprove("disapproving as bmcgough");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("bmcgough"), (String)document.getDocumentId());
        Assert.assertFalse((String)"Acknowledge was incorrectly sent to non-initiator disapprover", (boolean)document.isAcknowledgeRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Acknowledge was not sent to initiator", (boolean)document.isAcknowledgeRequested());
    }

    private MockEmailNotificationService getMockEmailService() {
        return (MockEmailNotificationService)KEWServiceLocator.getActionListEmailService();
    }
}

