/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine;

import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.doctype.ProcessDefinition;
import org.kuali.rice.kew.api.doctype.RoutePath;
import org.kuali.rice.kew.test.KEWTestCase;

public class EmptyProcessTest
extends KEWTestCase {
    private static final String DOCUMENT_TYPE_NAME = "EmptyProcessDocType";

    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("EngineConfig.xml");
    }

    @Test
    public void testEmptyProcess() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)DOCUMENT_TYPE_NAME);
        document.route("test");
        Assert.assertNotNull((Object)document.getDocumentId());
        Assert.assertTrue((boolean)document.isFinal());
    }

    @Test
    public void testGetRoutePathForDocumentTypeName() throws Exception {
        RoutePath routePath = KewApiServiceLocator.getDocumentTypeService().getRoutePathForDocumentTypeName(DOCUMENT_TYPE_NAME);
        Assert.assertNotNull((Object)routePath);
        ProcessDefinition processDefinition = routePath.getPrimaryProcess();
        Assert.assertNotNull((Object)processDefinition);
        Assert.assertNull((String)"The initial route node *should* be null since this is an empty process", (Object)processDefinition.getInitialRouteNode());
    }
}

