/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.action.ActionRequestStatus;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;

public class ParallelRoutingTest
extends KEWTestCase {
    private static final String DOCUMENT_TYPE_NAME = "ParallelDocType";
    private static final String PARALLEL_EMPTY_DOCUMENT_TYPE_NAME = "ParallelEmptyDocType";
    private static final String PARALLEL_EMPTY_DOCUMENT_TYPE_2_NAME = "ParallelEmptyDocType2";
    private static final String ACKNOWLEDGE_1_NODE = "Acknowledge1";
    private static final String WORKFLOW_DOCUMENT_2_NODE = "WorkflowDocument2";
    private static final String WORKFLOW_DOCUMENT_3_NODE = "WorkflowDocument3";
    private static final String JOIN_NODE = "Join";
    private static final String WORKFLOW_DOCUMENT_FINAL_NODE = "WorkflowDocumentFinal";

    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("EngineConfig.xml");
    }

    @Test
    public void testParallelRoute() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)DOCUMENT_TYPE_NAME);
        document.saveDocumentData();
        Assert.assertTrue((String)"Document should be initiated", (boolean)document.isInitiated());
        Assert.assertEquals((String)"Should be no action requests.", (long)0L, (long)document.getRootActionRequests().size());
        List nodeInstances = KEWServiceLocator.getRouteNodeService().getActiveNodeInstances(document.getDocumentId());
        Assert.assertEquals((String)"Wrong number of active nodes.", (long)1L, (long)nodeInstances.size());
        document.route("Routing for parallel");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("bmcgough"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Document should be enroute", (boolean)document.isEnroute());
        List actionRequests = KEWServiceLocator.getActionRequestService().findPendingByDoc(document.getDocumentId());
        Assert.assertEquals((String)"Incorrect pending action requests.", (long)1L, (long)actionRequests.size());
        ActionRequestValue bRequest = (ActionRequestValue)actionRequests.get(0);
        Assert.assertNotNull((String)"Should have been routed through node instance.", (Object)bRequest.getNodeInstance());
        Assert.assertTrue((boolean)document.isApprovalRequested());
        document.approve("Approving test");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Document should be enroute", (boolean)document.isEnroute());
        actionRequests = KEWServiceLocator.getActionRequestService().findPendingByDoc(document.getDocumentId());
        Assert.assertEquals((String)"Incorrect pending action requests.", (long)3L, (long)actionRequests.size());
        boolean isToTemay = false;
        boolean isToPmckown = false;
        boolean isToRkirkend = false;
        for (ActionRequestValue actionRequest : actionRequests) {
            if (actionRequest.getPrincipalId().equals(this.getPrincipalIdForName("temay"))) {
                isToTemay = true;
                Assert.assertEquals((String)"Request should be activated.", (Object)ActionRequestStatus.ACTIVATED.getCode(), (Object)actionRequest.getStatus());
                Assert.assertEquals((String)"Wrong action requested.", (Object)"K", (Object)actionRequest.getActionRequested());
                Assert.assertNotNull((String)"Should have been routed through node instance.", (Object)actionRequest.getNodeInstance());
                Assert.assertEquals((String)"Invalid node.", (Object)ACKNOWLEDGE_1_NODE, (Object)actionRequest.getNodeInstance().getRouteNode().getRouteNodeName());
            }
            if (actionRequest.getPrincipalId().equals(this.getPrincipalIdForName("rkirkend"))) {
                isToRkirkend = true;
                Assert.assertEquals((String)"Request should be activated.", (Object)ActionRequestStatus.ACTIVATED.getCode(), (Object)actionRequest.getStatus());
                Assert.assertEquals((String)"Wrong action requested.", (Object)"A", (Object)actionRequest.getActionRequested());
                Assert.assertNotNull((String)"Should have been routed through node instance.", (Object)actionRequest.getNodeInstance());
                Assert.assertEquals((String)"Invalid node.", (Object)WORKFLOW_DOCUMENT_2_NODE, (Object)actionRequest.getNodeInstance().getRouteNode().getRouteNodeName());
            }
            if (!actionRequest.getPrincipalId().equals(this.getPrincipalIdForName("pmckown"))) continue;
            isToPmckown = true;
            Assert.assertEquals((String)"Request should be activated.", (Object)ActionRequestStatus.ACTIVATED.getCode(), (Object)actionRequest.getStatus());
            Assert.assertEquals((String)"Wrong action requested.", (Object)"A", (Object)actionRequest.getActionRequested());
            Assert.assertNotNull((String)"Should have been routed through node instance.", (Object)actionRequest.getNodeInstance());
            Assert.assertEquals((String)"Invalid node.", (Object)WORKFLOW_DOCUMENT_3_NODE, (Object)actionRequest.getNodeInstance().getRouteNode().getRouteNodeName());
        }
        Assert.assertTrue((String)"No request to temay.", (boolean)isToTemay);
        Assert.assertTrue((String)"No request to pmckown.", (boolean)isToPmckown);
        Assert.assertTrue((String)"No request to rkirkend.", (boolean)isToRkirkend);
        Set nodeNames = document.getNodeNames();
        Assert.assertEquals((String)"Wrong number of node names.", (long)2L, (long)nodeNames.size());
        boolean isNode2 = false;
        boolean isNode3 = false;
        for (String name : nodeNames) {
            if (name.equals(WORKFLOW_DOCUMENT_2_NODE)) {
                isNode2 = true;
            }
            if (!name.equals(WORKFLOW_DOCUMENT_3_NODE)) continue;
            isNode3 = true;
        }
        Assert.assertTrue((String)"Not at node2.", (boolean)isNode2);
        Assert.assertTrue((String)"Not at node3.", (boolean)isNode3);
        nodeInstances = KEWServiceLocator.getRouteNodeService().getActiveNodeInstances(document.getDocumentId());
        Assert.assertEquals((String)"Wrong number of active nodes.", (long)2L, (long)nodeInstances.size());
        Iterator iterator = nodeInstances.iterator();
        RouteNodeInstance instance1 = (RouteNodeInstance)iterator.next();
        RouteNodeInstance instance2 = (RouteNodeInstance)iterator.next();
        Assert.assertNotNull((String)"Node should be in branch.", (Object)instance1.getBranch());
        Assert.assertNotNull((String)"Node should be in branch.", (Object)instance2.getBranch());
        Assert.assertTrue((String)"Branches should be different.", (!instance1.getBranch().getBranchId().equals(instance2.getBranch().getBranchId()) ? 1 : 0) != 0);
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Should have request.", (boolean)document.isApprovalRequested());
        document.approve("Git-r-dun");
        nodeInstances = KEWServiceLocator.getRouteNodeService().getActiveNodeInstances(document.getDocumentId());
        Assert.assertEquals((String)"Wrong number of active nodes.", (long)2L, (long)nodeInstances.size());
        boolean isAtJoin = false;
        boolean isAtWD3 = false;
        for (RouteNodeInstance nodeInstance : nodeInstances) {
            if (nodeInstance.getRouteNode().getRouteNodeName().equals(JOIN_NODE)) {
                Assert.assertEquals((String)"Join branch should be split branch.", (Object)instance1.getBranch().getParentBranch().getBranchId(), (Object)nodeInstance.getBranch().getBranchId());
                isAtJoin = true;
            }
            if (!nodeInstance.getRouteNode().getRouteNodeName().equals(WORKFLOW_DOCUMENT_3_NODE)) continue;
            isAtWD3 = true;
        }
        Assert.assertTrue((String)"Not at join", (boolean)isAtJoin);
        Assert.assertTrue((String)"Not at WD3", (boolean)isAtWD3);
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("pmckown"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Should have request.", (boolean)document.isApprovalRequested());
        document.approve("Do it.");
        nodeInstances = KEWServiceLocator.getRouteNodeService().getActiveNodeInstances(document.getDocumentId());
        Assert.assertEquals((String)"Wrong number of active nodes.", (long)1L, (long)nodeInstances.size());
        boolean isAtWDF = false;
        for (RouteNodeInstance nodeInstance : nodeInstances) {
            if (!nodeInstance.getRouteNode().getRouteNodeName().equals(WORKFLOW_DOCUMENT_FINAL_NODE)) continue;
            isAtWDF = true;
        }
        Assert.assertTrue((String)"Not at WDF", (boolean)isAtWDF);
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("xqi"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Should still be enroute.", (boolean)document.isEnroute());
        Assert.assertTrue((String)"Should have request.", (boolean)document.isApprovalRequested());
        document.approve("I'm the last approver");
        Assert.assertTrue((String)"Document should be processed.", (boolean)document.isProcessed());
        nodeInstances = KEWServiceLocator.getRouteNodeService().getActiveNodeInstances(document.getDocumentId());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("temay"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Should have request.", (boolean)document.isAcknowledgeRequested());
        document.acknowledge("");
        Assert.assertTrue((boolean)document.isFinal());
    }

    @Test
    public void testEmptyParallelBranches() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)PARALLEL_EMPTY_DOCUMENT_TYPE_NAME);
        document.saveDocumentData();
        Assert.assertTrue((String)"Document should be initiated", (boolean)document.isInitiated());
        Assert.assertEquals((String)"Should be no action requests.", (long)0L, (long)document.getRootActionRequests().size());
        List nodeInstances = KEWServiceLocator.getRouteNodeService().getActiveNodeInstances(document.getDocumentId());
        Assert.assertEquals((String)"Wrong number of active nodes.", (long)1L, (long)nodeInstances.size());
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("bmcgough"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Document should be enroute", (boolean)document.isEnroute());
        List actionRequests = KEWServiceLocator.getActionRequestService().findPendingByDoc(document.getDocumentId());
        Assert.assertEquals((String)"Incorrect pending action requests.", (long)1L, (long)actionRequests.size());
        ActionRequestValue bRequest = (ActionRequestValue)actionRequests.get(0);
        Assert.assertNotNull((String)"Should have been routed through node instance.", (Object)bRequest.getNodeInstance());
        Assert.assertTrue((boolean)document.isApprovalRequested());
        document.approve("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("xqi"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Document should be enroute", (boolean)document.isEnroute());
        Assert.assertTrue((boolean)document.isApprovalRequested());
    }

    @Test
    public void testAdhocApproversJoinScenario() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"AdHocApproversDocType");
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("bmcgough"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Bmcgough should have approve request.", (boolean)document.isApprovalRequested());
        document.approve("");
        Set nodeNames = document.getNodeNames();
        Assert.assertEquals((String)"There should be two node names.", (long)2L, (long)nodeNames.size());
        Assert.assertTrue((String)"Should be at WorkflowDocument2 node.", (boolean)nodeNames.contains(WORKFLOW_DOCUMENT_2_NODE));
        Assert.assertTrue((String)"Should be at WorkflowDocument2 node.", (boolean)nodeNames.contains("AdHocApproversJoin"));
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("pmckown"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Pmckown should have approve request.", (boolean)document.isApprovalRequested());
        document.approve("");
        nodeNames = document.getNodeNames();
        Assert.assertEquals((String)"There should be two node names.", (long)2L, (long)nodeNames.size());
        Assert.assertTrue((String)"Should be at WorkflowDocument2 node.", (boolean)nodeNames.contains(WORKFLOW_DOCUMENT_2_NODE));
        Assert.assertTrue((String)"Should be at WorkflowDocument2 node.", (boolean)nodeNames.contains("AdHocApproversJoin"));
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Rkirkend should have approve request.", (boolean)document.isApprovalRequested());
        document.approve("");
        nodeNames = document.getNodeNames();
        Assert.assertEquals((String)"There should be one node name.", (long)1L, (long)nodeNames.size());
        Assert.assertTrue((String)"Should be at WorkflowDocumentFinal node.", (boolean)nodeNames.contains(WORKFLOW_DOCUMENT_FINAL_NODE));
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("xqi"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Document should still be enroute.", (boolean)document.isEnroute());
        document.approve("");
        Assert.assertTrue((String)"Document should now be final.", (boolean)document.isFinal());
    }
}

