/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.routemanager;

import org.apache.log4j.Logger;
import org.kuali.rice.kew.messaging.exceptionhandling.ExceptionRoutingServiceImpl;
import org.kuali.rice.kew.test.TestUtilities;
import org.kuali.rice.ksb.messaging.PersistedMessageBO;
import org.kuali.rice.test.ThreadMonitor;

public class TestExceptionRoutingServiceImpl
extends ExceptionRoutingServiceImpl {
    private static final Logger LOG = Logger.getLogger(TestExceptionRoutingServiceImpl.class);

    public void placeInExceptionRouting(Throwable throwable, PersistedMessageBO persistedMessage, String documentId) {
        LOG.info((Object)"Invoking placeInExceptionRouting on TestExceptionRoutingServiceImpl");
        ExceptionThreader exceptionThreader = new ExceptionThreader(throwable, persistedMessage, documentId, this);
        ThreadMonitor.addThread((Thread)exceptionThreader);
        exceptionThreader.start();
        LOG.info((Object)"ExceptionThreader has been started");
    }

    public void callRealPlaceInExceptionRouting(Throwable throwable, PersistedMessageBO message, String documentId) throws Exception {
        LOG.info((Object)"Invoking the real place in exception routing");
        super.placeInExceptionRouting(throwable, message, documentId);
        LOG.info((Object)"Document should now be in exception status");
    }

    private static class ExceptionThreader
    extends Thread {
        private Throwable throwable;
        private PersistedMessageBO message;
        String documentId;
        private TestExceptionRoutingServiceImpl testExceptionService;

        public ExceptionThreader(Throwable throwable, PersistedMessageBO message, String documentId, TestExceptionRoutingServiceImpl testExceptionService) {
            this.throwable = throwable;
            this.message = message;
            this.documentId = documentId;
            this.testExceptionService = testExceptionService;
            TestUtilities.setExceptionThreader(this);
        }

        @Override
        public void run() {
            try {
                this.testExceptionService.callRealPlaceInExceptionRouting(this.throwable, this.message, this.documentId);
            }
            catch (Exception e) {
                LOG.error((Object)"Exception encountered when attempting to callRealPlaceInExceptionRouting", (Throwable)e);
            }
        }
    }
}

