/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule;

import java.util.List;
import org.junit.Assert;
import org.kuali.rice.core.api.delegation.DelegationType;
import org.kuali.rice.kew.rule.RuleBaseValues;
import org.kuali.rice.kew.rule.RuleDelegationBo;
import org.kuali.rice.kew.rule.RuleResponsibilityBo;
import org.kuali.rice.kew.rule.bo.RuleTemplateBo;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.workgroup.GroupId;
import org.kuali.rice.kew.workgroup.GroupNameId;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public final class RuleTestUtils {
    private RuleTestUtils() {
        throw new UnsupportedOperationException("do not call");
    }

    public static RuleDelegationBo createDelegationToUser(String docType, String ruleTemplate, String delegateUser) {
        RuleBaseValues originalRule = RuleTestUtils.getRule(docType, ruleTemplate);
        List responsibilities = originalRule.getRuleResponsibilities();
        Assert.assertTrue((String)"assuming there is 1 responsibility", (responsibilities != null && responsibilities.size() == 1 ? 1 : 0) != 0);
        RuleResponsibilityBo originalResp = (RuleResponsibilityBo)responsibilities.get(0);
        Principal delegatePrincipal = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName(delegateUser);
        return RuleTestUtils.createRuleDelegationToUser(originalRule, originalResp, (PrincipalContract)delegatePrincipal);
    }

    public static RuleDelegationBo createDelegationToGroup(String docType, String ruleTemplate, String delegateGroupId) {
        RuleBaseValues originalRule = RuleTestUtils.getRule(docType, ruleTemplate);
        List responsibilities = originalRule.getRuleResponsibilities();
        Assert.assertTrue((String)"assuming there is 1 responsibility", (responsibilities != null && responsibilities.size() == 1 ? 1 : 0) != 0);
        RuleResponsibilityBo originalResp = (RuleResponsibilityBo)responsibilities.get(0);
        Group delegateGroup = KEWServiceLocator.getIdentityHelperService().getGroup((GroupId)new GroupNameId(delegateGroupId));
        return RuleTestUtils.createRuleDelegationToGroup(originalRule, originalResp, delegateGroup);
    }

    public static RuleBaseValues getRule(String docType, String ruleTemplate) {
        List rules = KEWServiceLocator.getRuleService().fetchAllCurrentRulesForTemplateDocCombination(ruleTemplate, docType);
        Assert.assertTrue((String)"assuming there is 1 rule", (rules != null && rules.size() == 1 ? 1 : 0) != 0);
        RuleBaseValues originalRule = (RuleBaseValues)rules.get(0);
        return originalRule;
    }

    public static RuleDelegationBo createRuleDelegationToUser(RuleBaseValues parentRule, RuleResponsibilityBo parentResponsibility, PrincipalContract delegatePrincipal) {
        return RuleTestUtils.createRuleDelegation(parentRule, parentResponsibility, delegatePrincipal.getPrincipalId(), "F");
    }

    public static RuleDelegationBo createRuleDelegationToGroup(RuleBaseValues parentRule, RuleResponsibilityBo parentResponsibility, Group delegateGroup) {
        return RuleTestUtils.createRuleDelegation(parentRule, parentResponsibility, delegateGroup.getId(), "G");
    }

    private static RuleDelegationBo createRuleDelegation(RuleBaseValues parentRule, RuleResponsibilityBo parentResponsibility, String delegateId, String groupTypeCode) {
        RuleTemplateBo delegationTemplate = parentRule.getRuleTemplate();
        RuleDelegationBo ruleDelegation = new RuleDelegationBo();
        ruleDelegation.setResponsibilityId(parentResponsibility.getResponsibilityId());
        ruleDelegation.setDelegationType(DelegationType.PRIMARY);
        RuleBaseValues rule = new RuleBaseValues();
        ruleDelegation.setDelegationRule(rule);
        rule.setDelegateRule(Boolean.valueOf(true));
        rule.setActive(true);
        rule.setCurrentInd(Boolean.valueOf(true));
        rule.setDocTypeName(parentRule.getDocTypeName());
        rule.setRuleTemplateId(delegationTemplate.getDelegationTemplateId());
        rule.setRuleTemplate(delegationTemplate);
        rule.setDescription("Description of this delegate rule");
        rule.setForceAction(true);
        RuleResponsibilityBo delegationResponsibility = new RuleResponsibilityBo();
        rule.getRuleResponsibilities().add(delegationResponsibility);
        delegationResponsibility.setRuleBaseValues(rule);
        delegationResponsibility.setRuleResponsibilityName(delegateId);
        delegationResponsibility.setRuleResponsibilityType(groupTypeCode);
        KEWServiceLocator.getRuleService().saveRuleDelegation(ruleDelegation, true);
        return ruleDelegation;
    }
}

