/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.xml;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.impl.impex.xml.ClassLoaderEntityResolver;
import org.kuali.rice.test.BaseRiceTestCase;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DocumentTypeXmlValidationTest
extends BaseRiceTestCase {
    private final XPath xpath = XPathFactory.newInstance().newXPath();

    private void testPolicyValue(String name, boolean expected, String xml) throws XPathExpressionException {
        Boolean b = (Boolean)this.xpath.evaluate("/doc/policies/policy[name='" + name + "']/value", new InputSource(new StringReader(xml)), XPathConstants.BOOLEAN);
        Assert.assertNotNull((Object)b);
        if (b.booleanValue()) {
            String value = (String)this.xpath.evaluate("/doc/policies/policy[name='" + name + "']/value", new InputSource(new StringReader(xml)), XPathConstants.STRING);
            this.log.error((Object)(name + " value: " + value));
            b = Boolean.valueOf(value);
        } else {
            b = Boolean.FALSE;
        }
        Assert.assertNotNull((Object)b);
        Assert.assertEquals((String)(name + " policy value was not " + expected), (Object)expected, (Object)b);
    }

    @Test
    public void testXPathBooleanEvaluation() throws XPathExpressionException {
        String xml = "<doc><policies><policy><inherited>false</inherited><name>DEFAULT_APPROVE</name><value>false</value></policy><policy><inherited>false</inherited><name>TEST1</name><value>blah</value></policy><policy><inherited>false</inherited><name>TEST2</name><value></value></policy><policy><inherited>false</inherited><name>TEST3</name></policy></policies></doc>";
        this.testPolicyValue("DEFAULT_APPROVE", false, xml);
        this.testPolicyValue("TEST1", false, xml);
        this.testPolicyValue("TEST2", false, xml);
        this.testPolicyValue("TEST3", false, xml);
        this.testPolicyValue("BOGUS", false, xml);
    }

    @Test
    public void testValidActivationTypes() throws Exception {
        DocumentTypeXmlValidationTest.validate(new InputSource(((Object)((Object)this)).getClass().getResourceAsStream("ValidActivationTypes.xml")));
    }

    @Test
    public void testBadActivationType() throws Exception {
        try {
            DocumentTypeXmlValidationTest.validate(new InputSource(((Object)((Object)this)).getClass().getResourceAsStream("BadActivationType.xml")));
            Assert.fail((String)"Bad activation type passed validation");
        }
        catch (SAXParseException spe) {
            this.log.error((Object)("Bad activation type exception: " + spe));
        }
    }

    @Test
    public void testValidPolicyNames() throws Exception {
        DocumentTypeXmlValidationTest.validate(new InputSource(((Object)((Object)this)).getClass().getResourceAsStream("ValidPolicyNames.xml")));
    }

    @Test
    public void testBadPolicyName() throws Exception {
        try {
            DocumentTypeXmlValidationTest.validate(new InputSource(((Object)((Object)this)).getClass().getResourceAsStream("BadPolicyName.xml")));
            Assert.fail((String)"Bad policy name passed validation");
        }
        catch (SAXParseException spe) {
            this.log.error((Object)("Bad policy name exception: " + spe));
        }
    }

    @Test
    public void testNoDocHandler() throws Exception {
        DocumentTypeXmlValidationTest.validate(new InputSource(((Object)((Object)this)).getClass().getResourceAsStream("NoDocHandler.xml")));
    }

    @Test
    public void testInvalidParentDocType() throws Exception {
        DocumentTypeXmlValidationTest.validate(new InputSource(((Object)((Object)this)).getClass().getResourceAsStream("InvalidParent.xml")));
    }

    @Test
    public void testDualDocumentTypeIngestion() throws Exception {
        DocumentTypeXmlValidationTest.validate(new InputSource(((Object)((Object)this)).getClass().getResourceAsStream("DualDocumentTypes.xml")));
    }

    @Test
    public void testRoutePathOnly() throws Exception {
        DocumentTypeXmlValidationTest.validate(new InputSource(((Object)((Object)this)).getClass().getResourceAsStream("RoutePathOnlyDocument.xml")));
    }

    @Test
    public void testNoRoutePathOnly() throws Exception {
        DocumentTypeXmlValidationTest.validate(new InputSource(((Object)((Object)this)).getClass().getResourceAsStream("NoRoutePathOnlyDocument.xml")));
    }

    public static void validate(InputSource source) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(true);
        dbf.setNamespaceAware(true);
        dbf.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        DocumentBuilder db = dbf.newDocumentBuilder();
        db.setEntityResolver((EntityResolver)new ClassLoaderEntityResolver());
        db.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException se) throws SAXException {
                throw se;
            }

            @Override
            public void error(SAXParseException se) throws SAXException {
                throw se;
            }

            @Override
            public void fatalError(SAXParseException se) throws SAXException {
                throw se;
            }
        });
        db.parse(source);
    }
}

