/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actionrequest;

import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.document.DocumentRefreshQueue;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;

public class DocumentRefreshQueueTest
extends KEWTestCase {
    private static final String SEQ_DOCUMENT_TYPE_NAME = "DRSeqDocType";
    private static final String PAR_DOCUMENT_TYPE_NAME = "DRParDocType";

    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("ActionRequestsConfig.xml");
    }

    @Test
    public void testDocumentRequeueSingleNode() throws Exception {
        String initiatorPrincipalId = this.getPrincipalIdForName("ewestfal");
        String firstApproverPrincipalId = this.getPrincipalIdForName("bmcgough");
        String secondApproverPrincipalId = this.getPrincipalIdForName("rkirkend");
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)initiatorPrincipalId, (String)SEQ_DOCUMENT_TYPE_NAME);
        String documentNumber = document.getDocumentId();
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)initiatorPrincipalId, (String)documentNumber);
        Assert.assertTrue((boolean)document.isEnroute());
        Assert.assertEquals((String)"Wrong number of requests", (long)2L, (long)document.getRootActionRequests().size());
        HashSet<String> initialRequestIds = new HashSet<String>();
        for (ActionRequest request : document.getRootActionRequests()) {
            initialRequestIds.add(request.getId());
        }
        DocumentRouteHeaderValue documentRouteHeader = KEWServiceLocator.getRouteHeaderService().getRouteHeader(documentNumber);
        DocumentRefreshQueue documentRequeuer = KewApiServiceLocator.getDocumentRequeuerService((String)documentRouteHeader.getDocumentType().getApplicationId(), (String)documentNumber, (long)0L);
        documentRequeuer.refreshDocument(documentNumber);
        document = WorkflowDocumentFactory.loadDocument((String)firstApproverPrincipalId, (String)documentNumber);
        Assert.assertTrue((boolean)document.isEnroute());
        Assert.assertEquals((String)"Wrong number of requests", (long)2L, (long)document.getRootActionRequests().size());
        for (ActionRequest request : document.getRootActionRequests()) {
            Assert.assertTrue((String)"Request ids should be different", (!initialRequestIds.contains(request.getId()) ? 1 : 0) != 0);
        }
        Assert.assertTrue((boolean)document.isApprovalRequested());
        document.approve("");
        documentRequeuer.refreshDocument(document.getDocumentId());
        document = WorkflowDocumentFactory.loadDocument((String)secondApproverPrincipalId, (String)documentNumber);
        Assert.assertTrue((boolean)document.isEnroute());
        Assert.assertEquals((String)"Wrong number of requests", (long)2L, (long)document.getRootActionRequests().size());
        boolean pendingToSecondApprover = false;
        for (ActionRequest request : document.getRootActionRequests()) {
            if (request.getPrincipalId().equals(secondApproverPrincipalId) && request.isActivated()) {
                Assert.assertFalse((String)"Second approver has too many requests", (boolean)pendingToSecondApprover);
                pendingToSecondApprover = true;
                continue;
            }
            Assert.assertTrue((String)"Previous requests to all others should be done", (boolean)request.isDone());
        }
        Assert.assertTrue((boolean)document.isApprovalRequested());
    }

    @Test
    public void testDocumentRequeueMultipleNodes() throws Exception {
        String initiatorPrincipalId = this.getPrincipalIdForName("ewestfal");
        String firstApproverPrincipalId = this.getPrincipalIdForName("bmcgough");
        String secondApproverPrincipalId = this.getPrincipalIdForName("rkirkend");
        String thirdApproverPrincipalId = this.getPrincipalIdForName("pmckown");
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)initiatorPrincipalId, (String)PAR_DOCUMENT_TYPE_NAME);
        String documentNumber = document.getDocumentId();
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)initiatorPrincipalId, (String)documentNumber);
        Assert.assertTrue((boolean)document.isEnroute());
        Assert.assertEquals((String)"Wrong number of requests", (long)3L, (long)document.getRootActionRequests().size());
        HashSet<String> initialRequestIds = new HashSet<String>();
        for (ActionRequest request : document.getRootActionRequests()) {
            initialRequestIds.add(request.getId());
        }
        DocumentRouteHeaderValue documentRouteHeader = KEWServiceLocator.getRouteHeaderService().getRouteHeader(documentNumber);
        DocumentRefreshQueue documentRequeuer = KewApiServiceLocator.getDocumentRequeuerService((String)documentRouteHeader.getDocumentType().getApplicationId(), (String)documentNumber, (long)0L);
        documentRequeuer.refreshDocument(documentNumber);
        document = WorkflowDocumentFactory.loadDocument((String)firstApproverPrincipalId, (String)documentNumber);
        Assert.assertTrue((boolean)document.isEnroute());
        Assert.assertEquals((String)"Wrong number of requests", (long)3L, (long)document.getRootActionRequests().size());
        for (Object request : document.getRootActionRequests()) {
            Assert.assertTrue((String)"Request ids should be different", (!initialRequestIds.contains(request.getId()) ? 1 : 0) != 0);
        }
        Assert.assertTrue((boolean)document.isApprovalRequested());
        document.approve("");
        documentRequeuer.refreshDocument(document.getDocumentId());
        document = WorkflowDocumentFactory.loadDocument((String)secondApproverPrincipalId, (String)documentNumber);
        Assert.assertTrue((boolean)document.isEnroute());
        Assert.assertEquals((String)"Wrong number of requests", (long)3L, (long)document.getRootActionRequests().size());
        boolean pendingToSecondApprover = false;
        for (ActionRequest request : document.getRootActionRequests()) {
            if (!request.getPrincipalId().equals(secondApproverPrincipalId) || !request.isActivated()) continue;
            Assert.assertFalse((String)"Second approver has too many requests.", (boolean)pendingToSecondApprover);
            pendingToSecondApprover = true;
        }
        Assert.assertTrue((boolean)document.isApprovalRequested());
        document.approve("");
        documentRequeuer.refreshDocument(document.getDocumentId());
        document = WorkflowDocumentFactory.loadDocument((String)thirdApproverPrincipalId, (String)documentNumber);
        Assert.assertTrue((boolean)document.isEnroute());
        Assert.assertEquals((String)"Wrong number of requests", (long)3L, (long)document.getRootActionRequests().size());
        boolean pendingToThirdApprover = false;
        for (ActionRequest request : document.getRootActionRequests()) {
            if (request.getPrincipalId().equals(thirdApproverPrincipalId) && request.isActivated()) {
                Assert.assertFalse((String)"Third approver has too many requests.", (boolean)pendingToThirdApprover);
                pendingToThirdApprover = true;
                continue;
            }
            Assert.assertTrue((String)"Previous requests to all others should be done.", (boolean)request.isDone());
        }
        Assert.assertTrue((boolean)document.isApprovalRequested());
        document.approve("");
    }
}

