/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actions;

import java.util.List;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kew.api.action.ReturnPoint;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kew.test.TestUtilities;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.NONE)
public class SuperUserActionTest
extends KEWTestCase {
    private static final Logger LOG = Logger.getLogger(SuperUserActionTest.class);

    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("ActionsConfig.xml");
    }

    @Test
    public void testSuperUserApprove() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"NotificationTest");
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("jhopf"), (String)document.getDocumentId());
        Assert.assertTrue((String)"WorkflowDocument should indicate jhopf as SuperUser", (boolean)document.isValidAction(ActionType.SU_BLANKET_APPROVE));
        document.superUserBlanketApprove("");
        Assert.assertTrue((String)"Document should be 'processed' after Super User Approve", (boolean)document.isProcessed());
        List requests = KEWServiceLocator.getActionRequestService().findPendingByDoc(document.getDocumentId());
        Assert.assertTrue((String)"Should be active requests still", (requests.size() == 2 ? 1 : 0) != 0);
        for (ActionRequestValue request : requests) {
            if (!request.isApproveOrCompleteRequest()) continue;
            Assert.fail((String)"There should be no approve or complete requests after su approve");
        }
    }

    @Test
    public void testSuperUserApproveDisallowedOnFinalNode() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"SUApproveFinalNodeDisallowed");
        document.route("");
        String nodeBeforeLast = null;
        for (String user : new String[]{"jhopf", "ewestfal", "rkirkend", "natjohns"}) {
            document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("jhopf"), (String)document.getDocumentId());
            System.err.println(document.getCurrentNodeNames());
            nodeBeforeLast = (String)document.getCurrentNodeNames().iterator().next();
            Assert.assertTrue((String)"jhopf should be able to SU Approve", (boolean)document.isValidAction(ActionType.SU_BLANKET_APPROVE));
            WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName(user), (String)document.getDocumentId()).approve("");
        }
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("jhopf"), (String)document.getDocumentId());
        Assert.assertFalse((String)"jhopf should NOT be able to SU Approve", (boolean)document.isValidAction(ActionType.SU_BLANKET_APPROVE));
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("jhopf"), (String)document.getDocumentId());
        document.superUserReturnToPreviousNode(ReturnPoint.create((String)"Split"), "returning to non-final node");
        Assert.assertTrue((String)"jhopf should be able to SU Approve", (boolean)document.isValidAction(ActionType.SU_BLANKET_APPROVE));
        document.superUserBlanketApprove("blanket approving as jhopf");
        Assert.assertEquals((String)"Document status incorrect", (Object)DocumentStatus.PROCESSED, (Object)document.getStatus());
        Assert.assertFalse((String)"jhopf should NOT be able to SU Approve", (boolean)document.isValidAction(ActionType.SU_BLANKET_APPROVE));
        List requests = KEWServiceLocator.getActionRequestService().findPendingByDoc(document.getDocumentId());
        Assert.assertEquals((String)"Should be active requests still", (long)5L, (long)requests.size());
        for (ActionRequestValue request : requests) {
            System.err.println(request.getActionRequestedLabel() + " -> " + request.getPrincipal().getPrincipalName());
            if (!request.isApproveOrCompleteRequest()) continue;
            Assert.fail((String)("There should be no approve or complete requests after su approve.  Found: " + request));
        }
    }

    @Test
    public void testSuperUserApproveExceptionCases() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("user1"), (String)"SUApproveDocument");
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user2"), (String)document.getDocumentId());
        try {
            document.approve("");
        }
        catch (Exception exception) {
            // empty catch block
        }
        TestUtilities.getExceptionThreader().join();
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        Assert.assertEquals((String)"Document status incorrect", (Object)DocumentStatus.EXCEPTION, (Object)document.getStatus());
        document.superUserBlanketApprove("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        Assert.assertEquals((String)"Document status incorrect", (Object)DocumentStatus.FINAL, (Object)document.getStatus());
        List actionRequests = KEWServiceLocator.getActionRequestService().findPendingByDoc(document.getDocumentId());
        Assert.assertEquals((String)("Should be no active requests for SU Approved document.  Found: " + actionRequests), (long)0L, (long)actionRequests.size());
    }

    @Test
    public void testSuperUserApproveExceptionCasesWithNotifications() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("user1"), (String)"SUApproveDocumentNotifications");
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user2"), (String)document.getDocumentId());
        try {
            document.approve("");
        }
        catch (Exception exception) {
            // empty catch block
        }
        TestUtilities.getExceptionThreader().join();
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        Assert.assertEquals((String)"Document status incorrect", (Object)DocumentStatus.EXCEPTION, (Object)document.getStatus());
        document.superUserBlanketApprove("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        Assert.assertEquals((String)"Document status incorrect after blanket approve", (Object)DocumentStatus.PROCESSED, (Object)document.getStatus());
        List actionRequests = KEWServiceLocator.getActionRequestService().findPendingByDoc(document.getDocumentId());
        Assert.assertFalse((String)"Should be active requests for SU Approved document", (boolean)actionRequests.isEmpty());
        for (ActionRequestValue request : actionRequests) {
            Assert.assertEquals((String)"Should be an ack notification request", (Object)ActionType.ACKNOWLEDGE, (Object)ActionType.fromCode((String)request.getActionRequested()));
        }
    }

    @Test
    public void testSuperUserInitiatorApprove() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"NotificationTest");
        Assert.assertTrue((String)"WorkflowDocument should indicate ewestfal as SuperUser", (boolean)document.isValidAction(ActionType.SU_BLANKET_APPROVE));
        document.superUserBlanketApprove("");
        Assert.assertEquals((String)"Document status incorrect after super user approve", (Object)DocumentStatus.PROCESSED, (Object)document.getStatus());
        List requests = KEWServiceLocator.getActionRequestService().findPendingByDoc(document.getDocumentId());
        Assert.assertEquals((String)"Should be active requests still", (long)2L, (long)requests.size());
        for (ActionRequestValue request : requests) {
            if (!request.isApproveOrCompleteRequest()) continue;
            Assert.fail((String)"There should be no approve or complete requests after su approve");
        }
    }

    @Test
    public void testSuperUserApproveWithNotifications() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"NotificationTestChild");
        Assert.assertTrue((String)"WorkflowDocument should indicate ewestfal as SuperUser", (boolean)document.isValidAction(ActionType.SU_BLANKET_APPROVE));
        document.superUserBlanketApprove("");
        Assert.assertEquals((String)"Document status incorrect after super user approve", (Object)DocumentStatus.PROCESSED, (Object)document.getStatus());
        List requests = KEWServiceLocator.getActionRequestService().findPendingByDoc(document.getDocumentId());
        Assert.assertTrue((String)"Should be active requests still", (requests.size() > 2 ? 1 : 0) != 0);
        for (ActionRequestValue request : requests) {
            if (!request.isApproveOrCompleteRequest()) continue;
            Assert.fail((String)"There should be no approve or complete requests after su approve");
        }
    }

    @Test
    public void testSuperUserApproveInvalidUser() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"NotificationTest");
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("quickstart"), (String)document.getDocumentId());
        try {
            Assert.assertFalse((String)"WorkflowDocument should not indicate quickstart as SuperUser", (boolean)document.isValidAction(ActionType.SU_BLANKET_APPROVE));
            document.superUserBlanketApprove("");
            Assert.fail((String)"invalid user attempted to SuperUserApprove");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testSuperUserActionDisregardPostProcessing() throws Exception {
        String bmcgoughPrincipalId = this.getPrincipalIdForName("bmcgough");
        WorkflowDocument document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)this.generateDummyEnrouteDocument("ewestfal").getDocumentId());
        try {
            document.superUserBlanketApprove("");
            Assert.fail((String)"Document should throw exception from post processor");
        }
        catch (Exception exception) {
            // empty catch block
        }
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)this.generateDummyEnrouteDocument("ewestfal").getDocumentId());
        try {
            KEWServiceLocator.getWorkflowDocumentService().superUserCancelAction(bmcgoughPrincipalId, KEWServiceLocator.getRouteHeaderService().getRouteHeader(document.getDocumentId()), "", false);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception Found:", (Throwable)e);
            Assert.fail((String)("Document should not throw an exception when ignoring post processor during superUserCancelAction " + e.getClass().getName() + " : " + e.getMessage()));
        }
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)this.generateDummyEnrouteDocument("ewestfal").getDocumentId());
        try {
            KEWServiceLocator.getWorkflowDocumentService().superUserDisapproveAction(bmcgoughPrincipalId, KEWServiceLocator.getRouteHeaderService().getRouteHeader(document.getDocumentId()), "", false);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception Found:", (Throwable)e);
            Assert.fail((String)"Document should not throw an exception when ignoring post processor during superUserDisapproveAction");
        }
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)this.generateDummyEnrouteDocument("ewestfal").getDocumentId());
        try {
            KEWServiceLocator.getWorkflowDocumentService().superUserApprove(bmcgoughPrincipalId, KEWServiceLocator.getRouteHeaderService().getRouteHeader(document.getDocumentId()), "", false);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception Found:", (Throwable)e);
            Assert.fail((String)"Document should not throw an exception when ignoring post processor during superUserApprove");
        }
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)this.generateDummyEnrouteDocument("ewestfal").getDocumentId());
        try {
            KEWServiceLocator.getWorkflowDocumentService().superUserNodeApproveAction(bmcgoughPrincipalId, document.getDocumentId(), "Acknowledge1", "", false);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception Found:", (Throwable)e);
            Assert.fail((String)"Document should not throw an exception when ignoring post processor during superUserNodeApprove");
        }
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)this.generateDummyEnrouteDocument("ewestfal").getDocumentId());
        try {
            KEWServiceLocator.getWorkflowDocumentService().superUserReturnDocumentToPreviousNode(bmcgoughPrincipalId, document.getDocumentId(), "WorkflowDocumentTemplate", "", false);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception Found:", (Throwable)e);
            Assert.fail((String)"Document should not throw an exception when ignoring post processor during superUserReturnDocumentToPreviousNode");
        }
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)this.generateDummyEnrouteDocument("ewestfal").getDocumentId());
        try {
            String actionRequestId = null;
            List actionRequests = KewApiServiceLocator.getWorkflowDocumentService().getRootActionRequests(document.getDocumentId());
            for (ActionRequest actionRequest : actionRequests) {
                if (!actionRequest.isActivated()) continue;
                if (actionRequestId != null) {
                    Assert.fail((String)("Found two active action requests for document.  Ids: " + actionRequestId + "  &  " + actionRequest.getId()));
                }
                actionRequestId = actionRequest.getId();
            }
            KEWServiceLocator.getWorkflowDocumentService().superUserActionRequestApproveAction(bmcgoughPrincipalId, document.getDocumentId(), actionRequestId, "", false);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception Found:", (Throwable)e);
            Assert.fail((String)"Document should not throw an exception when ignoring post processor during superUserActionRequestApproveAction");
        }
    }

    private WorkflowDocument generateDummyEnrouteDocument(String initiatorNetworkId) throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName(initiatorNetworkId), (String)"SuperUserActionInvalidPostProcessor");
        Assert.assertEquals((String)"Document should be at start node", (Object)"AdHoc", document.getNodeNames().iterator().next());
        document.route("");
        Assert.assertEquals((String)"Document should be at WorkflowDocument2 node", (Object)"WorkflowDocument2", document.getNodeNames().iterator().next());
        Assert.assertEquals((String)"Document should be enroute", (Object)DocumentStatus.ENROUTE, (Object)document.getStatus());
        return document;
    }
}

