/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.doctype;

import java.sql.Timestamp;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.doctype.ApplicationDocumentStatus;
import org.kuali.rice.kew.doctype.ApplicationDocumentStatusCategory;
import org.kuali.rice.kew.doctype.DocumentTypeAttributeBo;
import org.kuali.rice.kew.doctype.DocumentTypePolicy;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.engine.node.ProcessDefinitionBo;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.rule.bo.RuleAttribute;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.service.KRADServiceLocator;

public abstract class KewDocumentTypeBaseTest
extends KEWTestCase {
    protected DocumentType setupDocumentType(boolean persist) {
        DocumentType documentType = new DocumentType();
        documentType.setActionsUrl("/test");
        documentType.setActive(true);
        documentType.setActualApplicationId("tst");
        documentType.setActualNotificationFromAddress("blah@iu.edu");
        documentType.setApplyRetroactively(Boolean.valueOf(true));
        documentType.setAuthorizer("TestAuthorizer");
        documentType.setBlanketApprovePolicy("GoodPolicy");
        documentType.setBlanketApproveWorkgroupId("TestGroup");
        documentType.setCurrentInd(Boolean.valueOf(true));
        documentType.setDescription("testing descr");
        documentType.setCustomEmailStylesheet("blah@iu.edu");
        documentType.setDocumentId("1234");
        documentType.setLabel("doc type stuff");
        documentType.setName("gooddoctype");
        documentType.setReturnUrl("returnUrl");
        documentType.setPostProcessorName("PostProcessMe");
        documentType.setDocTypeParentId(null);
        if (persist) {
            return (DocumentType)this.getDataObjectService().save((Object)documentType, new PersistenceOption[]{PersistenceOption.FLUSH});
        }
        return documentType;
    }

    protected DocumentTypePolicy setupDocumentTypePolicy(DocumentType documentType) throws Exception {
        DocumentTypePolicy dtp = new DocumentTypePolicy();
        dtp.setDocumentType(documentType);
        dtp.setInheritedFlag(Boolean.valueOf(true));
        dtp.setPolicyName("DISAPPROVE");
        dtp.setPolicyStringValue("somevalue");
        dtp.setPolicyValue(Boolean.valueOf(true));
        return (DocumentTypePolicy)this.getDataObjectService().save((Object)dtp, new PersistenceOption[]{PersistenceOption.FLUSH});
    }

    protected ApplicationDocumentStatusCategory setupApplicationDocumentStatusCategory(DocumentType documentType) {
        ApplicationDocumentStatusCategory applicationDocumentStatusCategory = new ApplicationDocumentStatusCategory();
        applicationDocumentStatusCategory.setCategoryName("TestCategory");
        applicationDocumentStatusCategory.setDocumentType(documentType);
        return (ApplicationDocumentStatusCategory)this.getDataObjectService().save((Object)applicationDocumentStatusCategory, new PersistenceOption[]{PersistenceOption.FLUSH});
    }

    protected DocumentTypeAttributeBo setupDocumentTypeAttributeBo(DocumentType documentType) {
        DocumentTypeAttributeBo documentTypeAttributeBo = new DocumentTypeAttributeBo();
        documentTypeAttributeBo.setDocumentType(documentType);
        documentTypeAttributeBo.setOrderIndex(1);
        documentTypeAttributeBo.setLockVerNbr(Integer.valueOf(1));
        RuleAttribute ruleAttribute = this.setupRuleAttribute();
        documentTypeAttributeBo.setRuleAttribute(ruleAttribute);
        return (DocumentTypeAttributeBo)this.getDataObjectService().save((Object)documentTypeAttributeBo, new PersistenceOption[]{PersistenceOption.FLUSH});
    }

    protected ProcessDefinitionBo setupProcessDefinitionBo(DocumentType documentType) {
        ProcessDefinitionBo processDefinitionBo = new ProcessDefinitionBo();
        processDefinitionBo.setDocumentType(documentType);
        processDefinitionBo.setInitial(true);
        processDefinitionBo.setName("testing");
        return (ProcessDefinitionBo)this.getDataObjectService().save((Object)processDefinitionBo, new PersistenceOption[]{PersistenceOption.FLUSH});
    }

    protected DocumentRouteHeaderValue setupDocumentRouteHeaderValueWithRouteHeaderAssigned(String documentTypeId) {
        DocumentRouteHeaderValue routeHeader = new DocumentRouteHeaderValue();
        routeHeader.setDocumentId("1234");
        routeHeader.setAppDocId("Test");
        routeHeader.setApprovedDate(null);
        routeHeader.setCreateDate(new Timestamp(new Date().getTime()));
        routeHeader.setDocContent("test");
        routeHeader.setDocRouteLevel(Integer.valueOf(1));
        routeHeader.setDocRouteStatus("R");
        routeHeader.setDocTitle("Test");
        routeHeader.setDocumentTypeId(documentTypeId);
        routeHeader.setDocVersion(Integer.valueOf(1));
        routeHeader.setRouteStatusDate(new Timestamp(new Date().getTime()));
        routeHeader.setDateModified(new Timestamp(new Date().getTime()));
        routeHeader.setInitiatorWorkflowId("someone");
        return (DocumentRouteHeaderValue)this.getDataObjectService().save((Object)routeHeader, new PersistenceOption[]{PersistenceOption.FLUSH});
    }

    private RuleAttribute setupRuleAttribute() {
        RuleAttribute ruleAttribute = new RuleAttribute();
        ruleAttribute.setApplicationId("TST");
        ruleAttribute.setDescription("Testing");
        ruleAttribute.setLabel("New Label");
        ruleAttribute.setResourceDescriptor("ResourceDescriptor");
        ruleAttribute.setType("newType");
        ruleAttribute.setName("Attr");
        return (RuleAttribute)this.getDataObjectService().save((Object)ruleAttribute, new PersistenceOption[]{PersistenceOption.FLUSH});
    }

    private ApplicationDocumentStatus setApplicationDocumentStatus(DocumentType documentType, ApplicationDocumentStatusCategory category) {
        ApplicationDocumentStatus applicationDocumentStatus = new ApplicationDocumentStatus();
        applicationDocumentStatus.setDocumentType(documentType);
        applicationDocumentStatus.setCategory(category);
        applicationDocumentStatus.setSequenceNumber(Integer.valueOf(1));
        applicationDocumentStatus.setStatusName("someStatus");
        return (ApplicationDocumentStatus)this.getDataObjectService().save((Object)applicationDocumentStatus, new PersistenceOption[]{PersistenceOption.FLUSH});
    }

    @Test
    public void testDocumentTypePersistAndFetch() throws Exception {
        DocumentType dt = this.setupDocumentType(true);
        Assert.assertTrue((String)"DocumentType Persisted correctly", (dt != null && StringUtils.isNotBlank((String)dt.getDocumentTypeId()) ? 1 : 0) != 0);
        DocumentTypePolicy dtp = this.setupDocumentTypePolicy(dt);
        Assert.assertTrue((String)"DocumentTypePolicy persisted correctly", (dtp != null && StringUtils.isNotBlank((String)dtp.getDocumentType().getDocumentTypeId()) ? 1 : 0) != 0);
        dt.getDocumentTypePolicies().add(dtp);
        ApplicationDocumentStatusCategory appDocStatusCategory = this.setupApplicationDocumentStatusCategory(dt);
        Assert.assertTrue((String)"ApplicationDocumentStatusCategory persisted correctly", (appDocStatusCategory != null ? 1 : 0) != 0);
        dt.getApplicationStatusCategories().add(appDocStatusCategory);
        ApplicationDocumentStatus appDocStatus = this.setApplicationDocumentStatus(dt, appDocStatusCategory);
        Assert.assertTrue((String)"Application Document Status persisted correctly", (appDocStatus != null && StringUtils.isNotBlank((String)appDocStatus.getDocumentTypeId()) ? 1 : 0) != 0);
        dt.getValidApplicationStatuses().add(appDocStatus);
        DocumentTypeAttributeBo documentTypeAttributeBo = this.setupDocumentTypeAttributeBo(dt);
        Assert.assertTrue((String)"DocumentTypeAttributeBo persisted correctly", (documentTypeAttributeBo != null && StringUtils.isNotBlank((String)documentTypeAttributeBo.getId()) ? 1 : 0) != 0);
        dt.getDocumentTypeAttributes().add(documentTypeAttributeBo);
        ProcessDefinitionBo processDefinitionBo = this.setupProcessDefinitionBo(dt);
        Assert.assertTrue((String)"ProcessDefinitionBo persisted correctly", (processDefinitionBo != null && StringUtils.isNotBlank((String)processDefinitionBo.getProcessId()) ? 1 : 0) != 0);
        dt.addProcess(processDefinitionBo);
        dt = (DocumentType)KRADServiceLocator.getDataObjectService().save((Object)dt, new PersistenceOption[]{PersistenceOption.FLUSH});
        dt = this.fetchDocumentType(dt);
        Assert.assertTrue((String)"Document Type fetched correctly", (dt != null && StringUtils.isNotBlank((String)dt.getDocumentTypeId()) ? 1 : 0) != 0);
        Assert.assertTrue((String)"App doc status grabbed for doc type", (dt.getValidApplicationStatuses() != null && dt.getValidApplicationStatuses().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Document type policy fetched correctly", (dt.getDocumentTypePolicies() != null && dt.getDocumentTypePolicies().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"ApplicationDocStatusCategory fetched correctly", (dt.getApplicationStatusCategories() != null && dt.getApplicationStatusCategories().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"DocumentTypeAttributeBo fetched correctly", (dt.getDocumentTypeAttributes() != null && dt.getDocumentTypeAttributes().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"ProcessDefinitionBo fetched correctly", (dt.getProcesses() != null && dt.getProcesses().size() == 1 ? 1 : 0) != 0);
    }

    protected abstract DataObjectService getDataObjectService();

    protected abstract DocumentType fetchDocumentType(DocumentType var1);
}

