/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kew.util.Utilities;
import org.xml.sax.SAXException;

public class RouteNodeConfigParamTest
extends KEWTestCase {
    private static final Logger LOG = Logger.getLogger(RouteNodeConfigParamTest.class);

    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("RouteNodeConfigParams.xml");
    }

    protected void assertHasConfigParam(RouteNode routeNodeDef, String key, String value) {
        Map cfgMap = Utilities.getKeyValueCollectionAsMap((List)routeNodeDef.getConfigParams());
        try {
            XMLUnit.setIgnoreWhitespace((boolean)true);
            XMLAssert.assertXMLEqual((String)value, (String)((String)cfgMap.get(key)));
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testRouteNodeConfigParams() {
        DocumentType docType = KEWServiceLocator.getDocumentTypeService().findByName("RouteNodeConfigParams");
        Assert.assertNotNull((Object)docType);
        Assert.assertNotNull((Object)docType.getDocumentTypeId());
        RouteNode routeNodeDef = KEWServiceLocator.getRouteNodeService().findRouteNodeByName(docType.getDocumentTypeId(), "AdHoc");
        Assert.assertNotNull((Object)routeNodeDef);
        this.assertHasConfigParam(routeNodeDef, "contentFragment", "<start name=\"AdHoc\"><activationType>P</activationType></start>");
        this.assertHasConfigParam(routeNodeDef, "activationType", "P");
        routeNodeDef = KEWServiceLocator.getRouteNodeService().findRouteNodeByName(docType.getDocumentTypeId(), "setStartedVar");
        Assert.assertNotNull((Object)routeNodeDef);
        this.assertHasConfigParam(routeNodeDef, "contentFragment", "<simple name=\"setStartedVar\"><type>org.kuali.rice.kew.engine.node.var.SetVarNode</type><name>started</name><value>startedVariableValue</value></simple>");
        this.assertHasConfigParam(routeNodeDef, "type", "org.kuali.rice.kew.engine.node.var.SetVarNode");
        this.assertHasConfigParam(routeNodeDef, "name", "started");
        this.assertHasConfigParam(routeNodeDef, "value", "startedVariableValue");
        routeNodeDef = KEWServiceLocator.getRouteNodeService().findRouteNodeByName(docType.getDocumentTypeId(), "setCopiedVar");
        Assert.assertNotNull((Object)routeNodeDef);
        this.assertHasConfigParam(routeNodeDef, "contentFragment", "<simple name=\"setCopiedVar\"><type>org.kuali.rice.kew.engine.node.var.SetVarNode</type><name>copiedVar</name><value>var:started</value></simple>");
        this.assertHasConfigParam(routeNodeDef, "type", "org.kuali.rice.kew.engine.node.var.SetVarNode");
        this.assertHasConfigParam(routeNodeDef, "name", "copiedVar");
        this.assertHasConfigParam(routeNodeDef, "value", "var:started");
        routeNodeDef = KEWServiceLocator.getRouteNodeService().findRouteNodeByName(docType.getDocumentTypeId(), "PreApprovalTestOne");
        Assert.assertNotNull((Object)routeNodeDef);
        this.assertHasConfigParam(routeNodeDef, "contentFragment", "<requests name=\"PreApprovalTestOne\"><activationType>S</activationType><ruleSelector>Named</ruleSelector><ruleName>TestRule1</ruleName></requests>");
        this.assertHasConfigParam(routeNodeDef, "activationType", "S");
        this.assertHasConfigParam(routeNodeDef, "ruleSelector", "Named");
        this.assertHasConfigParam(routeNodeDef, "ruleName", "TestRule1");
        routeNodeDef = KEWServiceLocator.getRouteNodeService().findRouteNodeByName(docType.getDocumentTypeId(), "setEndedVar");
        Assert.assertNotNull((Object)routeNodeDef);
        this.assertHasConfigParam(routeNodeDef, "contentFragment", "<simple name=\"setEndedVar\"><type>org.kuali.rice.kew.engine.node.var.SetVarNode</type><name>ended</name><value>endedVariableValue</value></simple>");
        this.assertHasConfigParam(routeNodeDef, "type", "org.kuali.rice.kew.engine.node.var.SetVarNode");
        this.assertHasConfigParam(routeNodeDef, "name", "ended");
        this.assertHasConfigParam(routeNodeDef, "value", "endedVariableValue");
        routeNodeDef = KEWServiceLocator.getRouteNodeService().findRouteNodeByName(docType.getDocumentTypeId(), "setGoogleVar");
        Assert.assertNotNull((Object)routeNodeDef);
        this.assertHasConfigParam(routeNodeDef, "contentFragment", "<simple name=\"setGoogleVar\"><type>org.kuali.rice.kew.engine.node.var.SetVarNode</type><name>google</name><value>url:http://google.com</value></simple>");
        this.assertHasConfigParam(routeNodeDef, "type", "org.kuali.rice.kew.engine.node.var.SetVarNode");
        this.assertHasConfigParam(routeNodeDef, "name", "google");
        this.assertHasConfigParam(routeNodeDef, "value", "url:http://google.com");
        routeNodeDef = KEWServiceLocator.getRouteNodeService().findRouteNodeByName(docType.getDocumentTypeId(), "setXPathVar");
        Assert.assertNotNull((Object)routeNodeDef);
        this.assertHasConfigParam(routeNodeDef, "contentFragment", "<simple name=\"setXPathVar\"><type>org.kuali.rice.kew.engine.node.var.SetVarNode</type><name>xpath</name><value>xpath:concat(local-name(//documentContent),$ended)</value></simple>");
        this.assertHasConfigParam(routeNodeDef, "type", "org.kuali.rice.kew.engine.node.var.SetVarNode");
        this.assertHasConfigParam(routeNodeDef, "name", "xpath");
        this.assertHasConfigParam(routeNodeDef, "value", "xpath:concat(local-name(//documentContent),$ended)");
        routeNodeDef = KEWServiceLocator.getRouteNodeService().findRouteNodeByName(docType.getDocumentTypeId(), "resetStartedVar");
        Assert.assertNotNull((Object)routeNodeDef);
        this.assertHasConfigParam(routeNodeDef, "contentFragment", "<simple name=\"resetStartedVar\"><type>org.kuali.rice.kew.engine.node.var.SetVarNode</type><name>started</name><value>aNewStartedVariableValue</value></simple>");
        this.assertHasConfigParam(routeNodeDef, "type", "org.kuali.rice.kew.engine.node.var.SetVarNode");
        this.assertHasConfigParam(routeNodeDef, "name", "started");
        this.assertHasConfigParam(routeNodeDef, "value", "aNewStartedVariableValue");
        routeNodeDef = KEWServiceLocator.getRouteNodeService().findRouteNodeByName(docType.getDocumentTypeId(), "logNode");
        Assert.assertNotNull((Object)routeNodeDef);
        this.assertHasConfigParam(routeNodeDef, "contentFragment", "<simple name=\"logNode\"><type>org.kuali.rice.kew.engine.node.LogNode</type><message>var:xpath</message></simple>");
        this.assertHasConfigParam(routeNodeDef, "type", "org.kuali.rice.kew.engine.node.LogNode");
        this.assertHasConfigParam(routeNodeDef, "message", "var:xpath");
        routeNodeDef = KEWServiceLocator.getRouteNodeService().findRouteNodeByName(docType.getDocumentTypeId(), "logNode2");
        Assert.assertNotNull((Object)routeNodeDef);
        this.assertHasConfigParam(routeNodeDef, "contentFragment", "<simple name=\"logNode2\"><type>org.kuali.rice.kew.engine.node.LogNode</type><level>ErRoR</level><log>Custom.Logger.Name</log><message>THAT'S ALL FOLKS</message></simple>");
        this.assertHasConfigParam(routeNodeDef, "type", "org.kuali.rice.kew.engine.node.LogNode");
        this.assertHasConfigParam(routeNodeDef, "level", "ErRoR");
        this.assertHasConfigParam(routeNodeDef, "message", "THAT'S ALL FOLKS");
    }
}

