/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.peopleflow;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.core.api.delegation.DelegationType;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.action.ActionRequestPolicy;
import org.kuali.rice.kew.api.action.ActionRequestStatus;
import org.kuali.rice.kew.api.action.RecipientType;
import org.kuali.rice.kew.api.peopleflow.PeopleFlowDefinition;
import org.kuali.rice.kew.api.peopleflow.PeopleFlowDelegate;
import org.kuali.rice.kew.api.peopleflow.PeopleFlowMember;
import org.kuali.rice.kew.api.peopleflow.PeopleFlowService;
import org.kuali.rice.kew.impl.peopleflow.RulesEngineExecutorMock;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kim.api.common.delegate.DelegateMember;
import org.kuali.rice.kim.api.common.delegate.DelegateType;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.role.RoleMember;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public class PeopleFlowRoutingTest
extends KEWTestCase {
    private static final String NAMESPACE_CODE = "TEST";
    private static final String PEOPLE_FLOW_1 = "PeopleFlow1";
    private static final String PEOPLE_FLOW_2 = "PeopleFlow2";
    private static final String PEOPLE_FLOW_3 = "PeopleFlow3";
    private static final String PEOPLE_FLOW_4 = "PeopleFlow4";
    private static final String PEOPLE_FLOW_5 = "PeopleFlow5";
    private static final String PEOPLE_FLOW_6 = "PeopleFlow6";
    private static final String PEOPLE_FLOW_7 = "PeopleFlow7";
    private static final String PEOPLE_FLOW_8 = "PeopleFlow8";
    private static final String PEOPLE_FLOW_9 = "PeopleFlow9";
    private static final String PEOPLE_FLOW_10 = "PeopleFlow10";
    private static final String PEOPLE_FLOW_11 = "PeopleFlow11";
    private static final String PEOPLE_FLOW_12 = "PeopleFlow12";
    private static final String PEOPLE_FLOW_13 = "PeopleFlow13";
    private static final String SINGLE_PEOPLE_FLOW_PARALLEL_APPROVE = "SinglePeopleFlow-Parallel-Approve";
    private static final String SINGLE_PEOPLE_FLOW_SEQUENTIAL_APPROVE = "SinglePeopleFlow-Sequential-Approve";
    private static final String SINGLE_PEOPLE_FLOW_PRIORITY_PARALLEL_APPROVE = "SinglePeopleFlow-PriorityParallel-Approve";
    private static final String MULTIPLE_PEOPLE_FLOW_PRIORITY_PARALLEL = "MultiplePeopleFlow-PriorityParallel";
    private static final String DELEGATE_PEOPLE_FLOW_PRIORITY_PARALLEL_APPROVE = "DelegatePeopleFlow-PriorityParallel-Approve";
    private static final String RULESENGINE_PEOPLEFLOW_PRIORITYPARALLEL_APPROVE = "RulesEngine-PeopleFlow-PriorityParallel-Approve";
    private static final String ROLE_DELEGATE_PEOPLE_FLOW_JUST_KIM_DELEGATE = "RoleDelegatePeopleFlow-JustKimDelegate";
    private static final String ROLE_DELEGATE_PEOPLE_FLOW_PRIMARY_DELEGATE = "RoleDelegatePeopleFlow-PrimaryDelegate";
    private static final String ROLE_DELEGATE_PEOPLE_FLOW_SECONDARY_DELEGATE = "RoleDelegatePeopleFlow-SecondaryDelegate";
    private static final String ROLE_DELEGATE_PEOPLE_FLOW_DELEGATE_ROLE_HAS_KIM_DELEGATE = "RoleDelegatePeopleFlow-DelegateRoleHasKimDelegate";
    private static final String ROLE_DELEGATE_PEOPLE_FLOW_PRINCIPAL_MEMBER_HAS_ROLE_DELEGATE = "RoleDelegatePeopleFlow-PrincipalMemberHasRoleDelegate";
    private static final String ROLE_DELEGATE_PEOPLE_FLOW_ROLE_MEMBER_HAS_PRINCIPAL_DELEGATE = "RoleDelegatePeopleFlow-RoleMemberHasPrincipalDelegate";
    private static final String ROLE_DELEGATE_PEOPLE_FLOW_ROLE_MULTIPLE_MEMBERS = "RoleDelegatePeopleFlow-MultipleRoleMembers";
    private static final String ROLE_DELEGATE_PEOPLE_FLOW_ROLE_MULTIPLE_MEMBERS_FIRST_APPROVE = "RoleDelegatePeopleFlow-MultipleRoleMembers-FirstApprove";
    private static final String ROLE_DELEGATE_PEOPLE_FLOW_ROLE_MULTIPLE_MEMBERS_DELEGATE_FIRST_APPROVE = "RoleDelegatePeopleFlow-MultipleRoleMembers-DelegateFirstApprove";
    private static final String GROUP_DELEGATE_PEOPLE_FLOW_ROLE_MULTIPLE_MEMBERS = "GroupDelegatePeopleFlow-MultipleRoleMembers";
    private PeopleFlowService peopleFlowService;
    private String user1;
    private String user2;
    private String user3;
    private String testuser1;
    private String testuser2;
    private String testuser3;
    private String ewestfal;
    private String fran;
    private String earl;
    private String testWorkgroup;
    private String ppfTestRole1;
    private String ppfTestRole2;
    private String ppfTestRole3;
    private String ppfTestRole4;
    private String ppfTestGroup1;
    private String roleId = null;

    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("PeopleFlowRoutingTest.xml");
    }

    @Before
    public void setupServiceUnderTest() {
        this.setPeopleFlowService(KewApiServiceLocator.getPeopleFlowService());
        this.user1 = this.getPrincipalIdForName("user1");
        this.user2 = this.getPrincipalIdForName("user2");
        this.user3 = this.getPrincipalIdForName("user3");
        this.testuser1 = this.getPrincipalIdForName("testuser1");
        this.testuser2 = this.getPrincipalIdForName("testuser2");
        this.testuser3 = this.getPrincipalIdForName("testuser3");
        this.ewestfal = this.getPrincipalIdForName("ewestfal");
        this.fran = this.getPrincipalIdForName("fran");
        this.earl = this.getPrincipalIdForName("earl");
        this.testWorkgroup = this.getGroupIdForName("KR-WKFLW", "TestWorkgroup");
        this.createTestRolesAndGroupsIfNotExists();
        this.ppfTestRole1 = this.getRoleIdForName(NAMESPACE_CODE, "ppfTestRole1");
        this.ppfTestRole2 = this.getRoleIdForName(NAMESPACE_CODE, "ppfTestRole2");
        this.ppfTestRole3 = this.getRoleIdForName(NAMESPACE_CODE, "ppfTestRole3");
        this.ppfTestRole4 = this.getRoleIdForName(NAMESPACE_CODE, "ppfTestRole4");
        this.ppfTestGroup1 = this.getGroupIdForName(NAMESPACE_CODE, "ppfTestGroup1");
    }

    protected void setPeopleFlowService(PeopleFlowService peopleFlowService) {
        this.peopleFlowService = peopleFlowService;
    }

    protected PeopleFlowService getPeopleFlowService() {
        return this.peopleFlowService;
    }

    private void createTestRolesAndGroupsIfNotExists() {
        RoleMember roleMember;
        RoleMember user1RoleMember;
        RoleService roleService = KimApiServiceLocator.getRoleService();
        GroupService groupService = KimApiServiceLocator.getGroupService();
        if (groupService.getGroupByNamespaceCodeAndName(NAMESPACE_CODE, "ppfTestGroup1") == null) {
            Group.Builder testgroup1Builder = Group.Builder.create((String)NAMESPACE_CODE, (String)"ppfTestGroup1", (String)"1");
            testgroup1Builder.setActive(true);
            Group testgroup1Group = groupService.createGroup(testgroup1Builder.build());
            groupService.addPrincipalToGroup("earl", testgroup1Group.getId());
            groupService.addPrincipalToGroup("fran", testgroup1Group.getId());
        }
        if (this.getRoleIdForName(NAMESPACE_CODE, "ppfTestRole1") == null) {
            Role.Builder testRole1Builder = Role.Builder.create(null, (String)"ppfTestRole1", (String)NAMESPACE_CODE, (String)"test role 1", (String)"1");
            Role roleTestRole1 = roleService.createRole(testRole1Builder.build());
            user1RoleMember = roleService.assignPrincipalToRole(this.user1, NAMESPACE_CODE, "ppfTestRole1", Collections.emptyMap());
            DelegateType.Builder delegateTypeBuilder = DelegateType.Builder.create((String)roleTestRole1.getId(), (DelegationType)DelegationType.PRIMARY, Collections.emptyList());
            delegateTypeBuilder.setKimTypeId("1");
            DelegateType delegateType = roleService.createDelegateType(delegateTypeBuilder.build());
            DelegateMember.Builder testRole1DelegateBuilder = DelegateMember.Builder.create();
            testRole1DelegateBuilder.setActiveFromDate(DateTime.now());
            testRole1DelegateBuilder.setDelegationId(delegateType.getDelegationId());
            testRole1DelegateBuilder.setRoleMemberId(user1RoleMember.getId());
            testRole1DelegateBuilder.setMemberId(this.ewestfal);
            testRole1DelegateBuilder.setType(MemberType.PRINCIPAL);
            DelegateMember delegateMember = roleService.createDelegateMember(testRole1DelegateBuilder.build());
        }
        if (this.getRoleIdForName(NAMESPACE_CODE, "ppfTestRole2") == null) {
            Role.Builder testRole2Builder = Role.Builder.create(null, (String)"ppfTestRole2", (String)NAMESPACE_CODE, (String)"test role 2", (String)"1");
            Role roleTestRole2 = roleService.createRole(testRole2Builder.build());
            user1RoleMember = roleService.assignPrincipalToRole(this.user2, NAMESPACE_CODE, "ppfTestRole2", Collections.emptyMap());
        }
        if (this.getRoleIdForName(NAMESPACE_CODE, "ppfTestRole3") == null) {
            Role.Builder testRole3Builder = Role.Builder.create(null, (String)"ppfTestRole3", (String)NAMESPACE_CODE, (String)"test role 3", (String)"1");
            Role roleTestRole3 = roleService.createRole(testRole3Builder.build());
            user1RoleMember = roleService.assignPrincipalToRole(this.user1, NAMESPACE_CODE, "ppfTestRole3", Collections.emptyMap());
            roleMember = roleService.assignPrincipalToRole(this.user2, NAMESPACE_CODE, "ppfTestRole3", Collections.emptyMap());
        }
        if (this.getRoleIdForName(NAMESPACE_CODE, "ppfTestRole4") == null) {
            Role.Builder testRole4Builder = Role.Builder.create(null, (String)"ppfTestRole4", (String)NAMESPACE_CODE, (String)"test role 4", (String)"1");
            Role roleTestRole4 = roleService.createRole(testRole4Builder.build());
            RoleMember testuser1RoleMember = roleService.assignPrincipalToRole(this.testuser1, NAMESPACE_CODE, "ppfTestRole4", Collections.emptyMap());
            roleMember = roleService.assignPrincipalToRole(this.testuser2, NAMESPACE_CODE, "ppfTestRole4", Collections.emptyMap());
        }
    }

    private void createSimplePeopleFlow() {
        PeopleFlowDefinition.Builder peopleFlow = PeopleFlowDefinition.Builder.create((String)NAMESPACE_CODE, (String)PEOPLE_FLOW_1);
        peopleFlow.addPrincipal(this.user1).setPriority(1);
        peopleFlow.addPrincipal(this.user2).setPriority(2);
        peopleFlow.addGroup(this.testWorkgroup).setPriority(3);
        this.peopleFlowService.createPeopleFlow(peopleFlow.build());
    }

    @Test
    public void test_SinglePeopleFlow_Parallel_Approve() throws Exception {
        this.createSimplePeopleFlow();
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.user3, (String)SINGLE_PEOPLE_FLOW_PARALLEL_APPROVE);
        document.route("");
        Assert.assertTrue((String)"Document should be enroute.", (boolean)document.isEnroute());
        document.switchPrincipal(this.user3);
        this.assertApproveRequested(document, this.user1, this.user2, this.ewestfal);
        document.switchPrincipal(this.ewestfal);
        document.approve("approving as ewestfal");
        Assert.assertTrue((String)"Document should still be enroute.", (boolean)document.isEnroute());
        document.switchPrincipal(this.user1);
        document.approve("approving as user1");
        Assert.assertTrue((String)"Document should still be enroute.", (boolean)document.isEnroute());
        document.switchPrincipal(this.user2);
        document.approve("approving as user2");
        Assert.assertTrue((String)"Document should now be FINAL.", (boolean)document.isFinal());
    }

    @Test
    public void test_SinglePeopleFlow_Sequential_Approve() throws Exception {
        this.createSimplePeopleFlow();
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.user3, (String)SINGLE_PEOPLE_FLOW_SEQUENTIAL_APPROVE);
        document.route("");
        Assert.assertTrue((String)"Document should be enroute.", (boolean)document.isEnroute());
        document.switchPrincipal(this.user3);
        List rootActionRequests = document.getRootActionRequests();
        Assert.assertEquals((String)"Should have 3 root action requests", (long)3L, (long)rootActionRequests.size());
        ActionRequest user1Request = null;
        ActionRequest user2Request = null;
        ActionRequest testWorkgroupRequest = null;
        for (ActionRequest actionRequest : rootActionRequests) {
            RecipientType recipientType = actionRequest.getRecipientType();
            if (recipientType == RecipientType.PRINCIPAL) {
                if (this.user1.equals(actionRequest.getPrincipalId())) {
                    user1Request = actionRequest;
                    continue;
                }
                if (!this.user2.equals(actionRequest.getPrincipalId())) continue;
                user2Request = actionRequest;
                continue;
            }
            if (recipientType != RecipientType.GROUP || !this.testWorkgroup.equals(actionRequest.getGroupId())) continue;
            testWorkgroupRequest = actionRequest;
        }
        Assert.assertNotNull(user1Request);
        Assert.assertEquals((Object)ActionRequestStatus.ACTIVATED, (Object)user1Request.getStatus());
        Assert.assertNotNull(user2Request);
        Assert.assertEquals((Object)ActionRequestStatus.INITIALIZED, (Object)user2Request.getStatus());
        Assert.assertNotNull(testWorkgroupRequest);
        Assert.assertEquals((Object)ActionRequestStatus.INITIALIZED, (Object)testWorkgroupRequest.getStatus());
        this.assertApproveNotRequested(document, this.user2, this.ewestfal);
        this.assertApproveRequested(document, this.user1);
        document.switchPrincipal(this.user1);
        document.approve("");
        Assert.assertTrue((boolean)document.isEnroute());
        this.assertApproveNotRequested(document, this.user1, this.ewestfal);
        this.assertApproveRequested(document, this.user2);
        document.switchPrincipal(this.user2);
        document.approve("");
        Assert.assertTrue((boolean)document.isEnroute());
        this.assertApproveNotRequested(document, this.user2, this.user1);
        this.assertApproveRequested(document, this.ewestfal);
        document.switchPrincipal(this.ewestfal);
        document.approve("");
        Assert.assertTrue((boolean)document.isFinal());
    }

    private void createPriorityParallelPeopleFlow() {
        PeopleFlowDefinition.Builder peopleFlow = PeopleFlowDefinition.Builder.create((String)NAMESPACE_CODE, (String)PEOPLE_FLOW_2);
        peopleFlow.addPrincipal(this.user1).setPriority(1);
        peopleFlow.addPrincipal(this.user2).setPriority(1);
        peopleFlow.addPrincipal(this.testuser1).setPriority(2);
        peopleFlow.addPrincipal(this.testuser2).setPriority(2);
        peopleFlow.addGroup(this.testWorkgroup).setPriority(10);
        peopleFlow.addPrincipal(this.testuser3).setPriority(10);
        this.peopleFlowService.createPeopleFlow(peopleFlow.build());
    }

    @Test
    public void test_SinglePeopleFlow_PriorityParallel_Approve() throws Exception {
        this.createPriorityParallelPeopleFlow();
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.user3, (String)SINGLE_PEOPLE_FLOW_PRIORITY_PARALLEL_APPROVE);
        document.route("");
        Assert.assertTrue((String)"Document should be enroute.", (boolean)document.isEnroute());
        document.switchPrincipal(this.user3);
        List rootActionRequests = document.getRootActionRequests();
        Assert.assertEquals((String)"Should have 6 root action requests", (long)6L, (long)rootActionRequests.size());
        ActionRequest user1Request = null;
        ActionRequest user2Request = null;
        ActionRequest testuser1Request = null;
        ActionRequest testuser2Request = null;
        ActionRequest testWorkgroupRequest = null;
        ActionRequest testuser3Request = null;
        for (ActionRequest actionRequest : rootActionRequests) {
            RecipientType recipientType = actionRequest.getRecipientType();
            if (recipientType == RecipientType.PRINCIPAL) {
                if (this.user1.equals(actionRequest.getPrincipalId())) {
                    user1Request = actionRequest;
                    continue;
                }
                if (this.user2.equals(actionRequest.getPrincipalId())) {
                    user2Request = actionRequest;
                    continue;
                }
                if (this.testuser1.equals(actionRequest.getPrincipalId())) {
                    testuser1Request = actionRequest;
                    continue;
                }
                if (this.testuser2.equals(actionRequest.getPrincipalId())) {
                    testuser2Request = actionRequest;
                    continue;
                }
                if (!this.testuser3.equals(actionRequest.getPrincipalId())) continue;
                testuser3Request = actionRequest;
                continue;
            }
            if (recipientType != RecipientType.GROUP || !this.testWorkgroup.equals(actionRequest.getGroupId())) continue;
            testWorkgroupRequest = actionRequest;
        }
        Assert.assertNotNull(user1Request);
        Assert.assertEquals((Object)ActionRequestStatus.ACTIVATED, (Object)user1Request.getStatus());
        Assert.assertNotNull(user2Request);
        Assert.assertEquals((Object)ActionRequestStatus.ACTIVATED, (Object)user2Request.getStatus());
        Assert.assertNotNull(testuser1Request);
        Assert.assertEquals((Object)ActionRequestStatus.INITIALIZED, (Object)testuser1Request.getStatus());
        Assert.assertNotNull(testuser2Request);
        Assert.assertEquals((Object)ActionRequestStatus.INITIALIZED, (Object)testuser2Request.getStatus());
        Assert.assertNotNull((Object)testWorkgroupRequest);
        Assert.assertEquals((Object)ActionRequestStatus.INITIALIZED, (Object)testWorkgroupRequest.getStatus());
        Assert.assertNotNull(testuser3Request);
        Assert.assertEquals((Object)ActionRequestStatus.INITIALIZED, (Object)testuser3Request.getStatus());
        this.assertApproveRequested(document, this.user1, this.user2);
        this.assertApproveNotRequested(document, this.testuser1, this.testuser2, this.testuser3, this.ewestfal);
        document.switchPrincipal(this.user1);
        document.approve("");
        this.assertApproveRequested(document, this.user2);
        this.assertApproveNotRequested(document, this.user1);
        document.switchPrincipal(this.user2);
        document.approve("");
        Assert.assertTrue((boolean)document.isEnroute());
        this.assertApproveRequested(document, this.testuser1, this.testuser2);
        this.assertApproveNotRequested(document, this.user1, this.user2, this.testuser3, this.ewestfal);
        document.switchPrincipal(this.testuser1);
        document.approve("");
        document.switchPrincipal(this.testuser2);
        document.approve("");
        Assert.assertTrue((boolean)document.isEnroute());
        this.assertApproveRequested(document, this.testuser3, this.ewestfal);
        this.assertApproveNotRequested(document, this.user1, this.user2, this.testuser1, this.testuser2);
        document.switchPrincipal(this.testuser3);
        document.approve("");
        document.switchPrincipal(this.ewestfal);
        document.approve("");
        Assert.assertTrue((boolean)document.isFinal());
    }

    @Test
    public void test_SinglePeopleFlow_forceActionTrue() throws Exception {
        PeopleFlowDefinition.Builder peopleFlowBuilder = PeopleFlowDefinition.Builder.create((String)NAMESPACE_CODE, (String)PEOPLE_FLOW_2);
        peopleFlowBuilder.addPrincipal(this.user1).setPriority(1);
        peopleFlowBuilder.addPrincipal(this.user2).setPriority(2);
        peopleFlowBuilder.addPrincipal(this.user1).setPriority(3);
        PeopleFlowDefinition peopleFlow = this.peopleFlowService.createPeopleFlow(peopleFlowBuilder.build());
        RulesEngineExecutorMock.setPeopleFlowId(peopleFlow.getId());
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.user3, (String)RULESENGINE_PEOPLEFLOW_PRIORITYPARALLEL_APPROVE);
        document.route("");
        Assert.assertTrue((String)"Document should be enroute.", (boolean)document.isEnroute());
        this.assertApproveRequested(document, this.user1);
        this.assertApproveNotRequested(document, this.user2, this.user3);
        document.switchPrincipal(this.user1);
        document.approve("");
        this.assertApproveRequested(document, this.user2);
        this.assertApproveNotRequested(document, this.user1, this.user3);
        document.switchPrincipal(this.user2);
        document.approve("");
        Assert.assertTrue((boolean)document.isEnroute());
        this.assertApproveRequested(document, this.user1);
        this.assertApproveNotRequested(document, this.user2, this.user2);
        document.switchPrincipal(this.user1);
        document.approve("");
        Assert.assertTrue((boolean)document.isFinal());
    }

    @Test
    public void test_SinglePeopleFlow_forceActionFalse() throws Exception {
        PeopleFlowDefinition.Builder peopleFlowBuilder = PeopleFlowDefinition.Builder.create((String)NAMESPACE_CODE, (String)PEOPLE_FLOW_2);
        PeopleFlowMember.Builder member1 = peopleFlowBuilder.addPrincipal(this.user1);
        member1.setPriority(1);
        member1.setForceAction(Boolean.valueOf(false));
        PeopleFlowMember.Builder member2 = peopleFlowBuilder.addPrincipal(this.user2);
        member2.setPriority(2);
        member2.setForceAction(Boolean.valueOf(false));
        PeopleFlowMember.Builder member3 = peopleFlowBuilder.addPrincipal(this.user1);
        member3.setPriority(3);
        member3.setForceAction(Boolean.valueOf(false));
        PeopleFlowDefinition peopleFlow = this.peopleFlowService.createPeopleFlow(peopleFlowBuilder.build());
        RulesEngineExecutorMock.setPeopleFlowId(peopleFlow.getId());
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.user3, (String)RULESENGINE_PEOPLEFLOW_PRIORITYPARALLEL_APPROVE);
        document.route("");
        Assert.assertTrue((String)"Document should be enroute.", (boolean)document.isEnroute());
        this.assertApproveRequested(document, this.user1);
        this.assertApproveNotRequested(document, this.user2, this.user3);
        document.switchPrincipal(this.user1);
        document.approve("");
        this.assertApproveRequested(document, this.user2);
        this.assertApproveNotRequested(document, this.user1, this.user3);
        document.switchPrincipal(this.user2);
        document.approve("");
        Assert.assertTrue((boolean)document.isFinal());
    }

    private void createMultiplePeopleFlows() {
        PeopleFlowDefinition.Builder peopleFlow1 = PeopleFlowDefinition.Builder.create((String)NAMESPACE_CODE, (String)PEOPLE_FLOW_1);
        peopleFlow1.addPrincipal(this.user1).setPriority(1);
        peopleFlow1.addPrincipal(this.user2).setPriority(2);
        this.peopleFlowService.createPeopleFlow(peopleFlow1.build());
        PeopleFlowDefinition.Builder peopleFlow2 = PeopleFlowDefinition.Builder.create((String)NAMESPACE_CODE, (String)PEOPLE_FLOW_2);
        peopleFlow2.addPrincipal(this.testuser1).setPriority(1);
        peopleFlow2.addPrincipal(this.testuser2).setPriority(2);
        this.peopleFlowService.createPeopleFlow(peopleFlow2.build());
        PeopleFlowDefinition.Builder peopleFlow3 = PeopleFlowDefinition.Builder.create((String)NAMESPACE_CODE, (String)PEOPLE_FLOW_3);
        peopleFlow3.addGroup(this.testWorkgroup).setPriority(1);
        peopleFlow3.addPrincipal(this.testuser3).setPriority(10);
        this.peopleFlowService.createPeopleFlow(peopleFlow3.build());
    }

    @Test
    public void test_MultiplePeopleFlow_PriorityParallel() throws Exception {
        this.createMultiplePeopleFlows();
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.user3, (String)MULTIPLE_PEOPLE_FLOW_PRIORITY_PARALLEL);
        document.route("");
        Assert.assertTrue((String)"Document should be enroute.", (boolean)document.isEnroute());
        document.switchPrincipal(this.user3);
        List rootActionRequests = document.getRootActionRequests();
        Assert.assertEquals((String)"Should have 2 root action requests", (long)2L, (long)rootActionRequests.size());
        ActionRequest user1Request = null;
        ActionRequest user2Request = null;
        for (ActionRequest actionRequest : rootActionRequests) {
            RecipientType recipientType = actionRequest.getRecipientType();
            if (recipientType != RecipientType.PRINCIPAL) continue;
            if (this.user1.equals(actionRequest.getPrincipalId())) {
                user1Request = actionRequest;
                continue;
            }
            if (!this.user2.equals(actionRequest.getPrincipalId())) continue;
            user2Request = actionRequest;
        }
        Assert.assertNotNull(user1Request);
        Assert.assertEquals((Object)ActionRequestStatus.ACTIVATED, (Object)user1Request.getStatus());
        Assert.assertNotNull(user2Request);
        Assert.assertEquals((Object)ActionRequestStatus.INITIALIZED, (Object)user2Request.getStatus());
        document.switchPrincipal(this.user1);
        document.approve("");
        document.switchPrincipal(this.user2);
        Assert.assertTrue((boolean)document.isApprovalRequested());
        document.approve("");
        Assert.assertTrue((boolean)document.isEnroute());
        this.assertApproveRequested(document, this.ewestfal);
        this.assertApproveNotRequested(document, this.user1, this.user2, this.testuser1, this.testuser2, this.testuser3);
        this.assertAcknowledgeRequested(document, this.testuser1, this.testuser2);
        document.switchPrincipal(this.ewestfal);
        Assert.assertTrue((boolean)document.isApprovalRequested());
        document.approve("");
        Assert.assertTrue((boolean)document.isEnroute());
        this.assertApproveRequested(document, this.testuser3);
        document.switchPrincipal(this.testuser2);
        Assert.assertTrue((boolean)document.isAcknowledgeRequested());
        document.acknowledge("");
        Assert.assertTrue((boolean)document.isEnroute());
        this.assertApproveRequested(document, this.testuser3);
        document.switchPrincipal(this.testuser3);
        document.approve("");
        Assert.assertTrue((boolean)document.isProcessed());
        document.switchPrincipal(this.testuser1);
        Assert.assertTrue((boolean)document.isAcknowledgeRequested());
        document.acknowledge("");
        Assert.assertTrue((boolean)document.isFinal());
    }

    @Test
    public void test_PrincipalMember_roleDelegate() throws Exception {
        PeopleFlowMember.Builder member = PeopleFlowMember.Builder.create((String)this.testuser3, (MemberType)MemberType.PRINCIPAL);
        PeopleFlowDelegate.Builder delegate = PeopleFlowDelegate.Builder.create((String)this.ppfTestRole2, (MemberType)MemberType.ROLE);
        delegate.setDelegationType(DelegationType.PRIMARY);
        delegate.setActionRequestPolicy(ActionRequestPolicy.FIRST);
        this.createSimplePeopleFlow(PEOPLE_FLOW_8, member, delegate);
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.user3, (String)ROLE_DELEGATE_PEOPLE_FLOW_PRINCIPAL_MEMBER_HAS_ROLE_DELEGATE);
        document.route("");
        Assert.assertTrue((String)"Document should be enroute.", (boolean)document.isEnroute());
        List rootActionRequests = document.getRootActionRequests();
        Assert.assertEquals((String)"Should have 1 root action requests", (long)1L, (long)rootActionRequests.size());
        ActionRequest testuser3Request = null;
        for (ActionRequest actionRequest : rootActionRequests) {
            RecipientType recipientType = actionRequest.getRecipientType();
            if (recipientType != RecipientType.PRINCIPAL || !this.testuser3.equals(actionRequest.getPrincipalId())) continue;
            testuser3Request = actionRequest;
        }
        Assert.assertNotNull(testuser3Request);
        Assert.assertEquals((Object)ActionRequestStatus.ACTIVATED, (Object)testuser3Request.getStatus());
        Assert.assertEquals((long)1L, (long)testuser3Request.getChildRequests().size());
        ActionRequest user2Request = (ActionRequest)testuser3Request.getChildRequests().get(0);
        Assert.assertEquals((Object)this.user2, (Object)user2Request.getPrincipalId());
        Assert.assertEquals((Object)DelegationType.PRIMARY, (Object)user2Request.getDelegationType());
        Assert.assertEquals((Object)ActionRequestStatus.ACTIVATED, (Object)user2Request.getStatus());
        this.assertApproveRequested(document, this.user2, this.testuser3);
        this.assertApproveNotRequested(document, this.user1, this.user3, this.testuser1, this.testuser2, this.ewestfal);
        document.switchPrincipal(this.user2);
        document.approve("");
        this.assertApproveNotRequested(document, this.user2, this.testuser3);
        Assert.assertTrue((boolean)document.isFinal());
    }

    @Test
    public void test_RoleMember_principalDelegate() throws Exception {
        PeopleFlowMember.Builder member = PeopleFlowMember.Builder.create((String)this.ppfTestRole2, (MemberType)MemberType.ROLE);
        member.setActionRequestPolicy(ActionRequestPolicy.FIRST);
        PeopleFlowDelegate.Builder delegate = PeopleFlowDelegate.Builder.create((String)this.testuser3, (MemberType)MemberType.PRINCIPAL);
        delegate.setDelegationType(DelegationType.PRIMARY);
        this.createSimplePeopleFlow(PEOPLE_FLOW_9, member, delegate);
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.user3, (String)ROLE_DELEGATE_PEOPLE_FLOW_ROLE_MEMBER_HAS_PRINCIPAL_DELEGATE);
        document.route("");
        Assert.assertTrue((String)"Document should be enroute.", (boolean)document.isEnroute());
        List rootActionRequests = document.getRootActionRequests();
        Assert.assertEquals((String)"Should have 1 root action requests", (long)1L, (long)rootActionRequests.size());
        ActionRequest user2Request = null;
        for (ActionRequest actionRequest : rootActionRequests) {
            RecipientType recipientType = actionRequest.getRecipientType();
            if (recipientType != RecipientType.PRINCIPAL || !this.user2.equals(actionRequest.getPrincipalId())) continue;
            user2Request = actionRequest;
        }
        Assert.assertNotNull(user2Request);
        Assert.assertEquals((Object)ActionRequestStatus.ACTIVATED, (Object)user2Request.getStatus());
        Assert.assertEquals((long)1L, (long)user2Request.getChildRequests().size());
        ActionRequest testuser3Request = (ActionRequest)user2Request.getChildRequests().get(0);
        Assert.assertEquals((Object)this.testuser3, (Object)testuser3Request.getPrincipalId());
        Assert.assertEquals((Object)DelegationType.PRIMARY, (Object)testuser3Request.getDelegationType());
        Assert.assertEquals((Object)ActionRequestStatus.ACTIVATED, (Object)testuser3Request.getStatus());
        this.assertApproveRequested(document, this.user2, this.testuser3);
        this.assertApproveNotRequested(document, this.user1, this.user3, this.testuser1, this.testuser2, this.ewestfal);
        document.switchPrincipal(this.testuser3);
        document.approve("");
        this.assertApproveNotRequested(document, this.user2, this.testuser3);
        Assert.assertTrue((boolean)document.isFinal());
    }

    @Test
    public void test_RoleDelegate_justKimDelegate() throws Exception {
        this.createSimpleRoleDelegatePeopleFlow(PEOPLE_FLOW_4, this.ppfTestRole1, null, null);
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.user3, (String)ROLE_DELEGATE_PEOPLE_FLOW_JUST_KIM_DELEGATE);
        document.route("");
        Assert.assertTrue((String)"Document should be enroute.", (boolean)document.isEnroute());
        List rootActionRequests = document.getRootActionRequests();
        Assert.assertEquals((String)"Should have 1 root action requests", (long)1L, (long)rootActionRequests.size());
        ActionRequest user1Request = null;
        for (ActionRequest actionRequest : rootActionRequests) {
            RecipientType recipientType = actionRequest.getRecipientType();
            if (recipientType != RecipientType.PRINCIPAL || !this.user1.equals(actionRequest.getPrincipalId())) continue;
            user1Request = actionRequest;
        }
        Assert.assertNotNull(user1Request);
        Assert.assertEquals((Object)ActionRequestStatus.ACTIVATED, (Object)user1Request.getStatus());
        Assert.assertEquals((long)1L, (long)user1Request.getChildRequests().size());
        ActionRequest ewestfalDelegateRequest = (ActionRequest)user1Request.getChildRequests().get(0);
        Assert.assertEquals((Object)this.ewestfal, (Object)ewestfalDelegateRequest.getPrincipalId());
        Assert.assertEquals((Object)DelegationType.PRIMARY, (Object)ewestfalDelegateRequest.getDelegationType());
        Assert.assertEquals((Object)ActionRequestStatus.ACTIVATED, (Object)ewestfalDelegateRequest.getStatus());
        this.assertApproveRequested(document, this.user1, this.ewestfal);
        this.assertApproveNotRequested(document, this.user2, this.user3, this.testuser1, this.testuser2, this.testuser3);
        document.switchPrincipal(this.ewestfal);
        document.approve("");
        this.assertApproveNotRequested(document, this.user1, this.ewestfal);
        Assert.assertTrue((boolean)document.isFinal());
    }

    @Test
    public void test_RoleDelegate_primaryDelegateRole() throws Exception {
        this.createSimpleRoleDelegatePeopleFlow(PEOPLE_FLOW_5, this.ppfTestRole1, this.ppfTestRole2, DelegationType.PRIMARY);
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.user3, (String)ROLE_DELEGATE_PEOPLE_FLOW_PRIMARY_DELEGATE);
        document.route("");
        Assert.assertTrue((String)"Document should be enroute.", (boolean)document.isEnroute());
        List rootActionRequests = document.getRootActionRequests();
        Assert.assertEquals((String)"Should have 1 root action requests", (long)1L, (long)rootActionRequests.size());
        ActionRequest user1Request = null;
        for (ActionRequest actionRequest : rootActionRequests) {
            RecipientType recipientType = actionRequest.getRecipientType();
            if (recipientType != RecipientType.PRINCIPAL || !this.user1.equals(actionRequest.getPrincipalId())) continue;
            user1Request = actionRequest;
        }
        Assert.assertNotNull(user1Request);
        Assert.assertEquals((Object)ActionRequestStatus.ACTIVATED, (Object)user1Request.getStatus());
        Assert.assertEquals((long)1L, (long)user1Request.getChildRequests().size());
        ActionRequest user2DelegateRequest = (ActionRequest)user1Request.getChildRequests().get(0);
        Assert.assertEquals((Object)this.user2, (Object)user2DelegateRequest.getPrincipalId());
        Assert.assertEquals((Object)DelegationType.PRIMARY, (Object)user2DelegateRequest.getDelegationType());
        Assert.assertEquals((Object)ActionRequestStatus.ACTIVATED, (Object)user2DelegateRequest.getStatus());
        this.assertApproveRequested(document, this.user1, this.user2);
        this.assertApproveNotRequested(document, this.user3, this.testuser1, this.testuser2, this.testuser3, this.ewestfal);
        document.switchPrincipal(this.user2);
        document.approve("");
        this.assertApproveNotRequested(document, this.user1, this.user2);
        Assert.assertTrue((boolean)document.isFinal());
    }

    @Test
    public void test_RoleDelegate_secondaryDelegateRole() throws Exception {
        this.createSimpleRoleDelegatePeopleFlow(PEOPLE_FLOW_6, this.ppfTestRole1, this.ppfTestRole2, DelegationType.SECONDARY);
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.user3, (String)ROLE_DELEGATE_PEOPLE_FLOW_SECONDARY_DELEGATE);
        document.route("");
        Assert.assertTrue((String)"Document should be enroute.", (boolean)document.isEnroute());
        List rootActionRequests = document.getRootActionRequests();
        Assert.assertEquals((String)"Should have 1 root action requests", (long)1L, (long)rootActionRequests.size());
        ActionRequest user1Request = null;
        for (ActionRequest actionRequest : rootActionRequests) {
            RecipientType recipientType = actionRequest.getRecipientType();
            if (recipientType != RecipientType.PRINCIPAL || !this.user1.equals(actionRequest.getPrincipalId())) continue;
            user1Request = actionRequest;
        }
        Assert.assertNotNull(user1Request);
        Assert.assertEquals((Object)ActionRequestStatus.ACTIVATED, (Object)user1Request.getStatus());
        Assert.assertEquals((long)1L, (long)user1Request.getChildRequests().size());
        ActionRequest user2DelegateRequest = (ActionRequest)user1Request.getChildRequests().get(0);
        Assert.assertEquals((Object)this.user2, (Object)user2DelegateRequest.getPrincipalId());
        Assert.assertEquals((Object)DelegationType.SECONDARY, (Object)user2DelegateRequest.getDelegationType());
        Assert.assertEquals((Object)ActionRequestStatus.ACTIVATED, (Object)user2DelegateRequest.getStatus());
        this.assertApproveRequested(document, this.user1, this.user2);
        this.assertApproveNotRequested(document, this.user3, this.testuser1, this.testuser2, this.testuser3, this.ewestfal);
        document.switchPrincipal(this.user2);
        document.approve("");
        this.assertApproveNotRequested(document, this.user1, this.user2);
        Assert.assertTrue((boolean)document.isFinal());
    }

    @Test
    public void test_RoleDelegate_delegateRoleHasKimDelegate() throws Exception {
        this.createSimpleRoleDelegatePeopleFlow(PEOPLE_FLOW_7, this.ppfTestRole2, this.ppfTestRole1, DelegationType.PRIMARY);
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.user3, (String)ROLE_DELEGATE_PEOPLE_FLOW_DELEGATE_ROLE_HAS_KIM_DELEGATE);
        document.route("");
        Assert.assertTrue((String)"Document should be enroute.", (boolean)document.isEnroute());
        List rootActionRequests = document.getRootActionRequests();
        Assert.assertEquals((String)"Should have 1 root action requests", (long)1L, (long)rootActionRequests.size());
        ActionRequest user2Request = null;
        for (ActionRequest actionRequest : rootActionRequests) {
            RecipientType recipientType = actionRequest.getRecipientType();
            if (recipientType != RecipientType.PRINCIPAL || !this.user2.equals(actionRequest.getPrincipalId())) continue;
            user2Request = actionRequest;
        }
        Assert.assertNotNull(user2Request);
        Assert.assertEquals((Object)ActionRequestStatus.ACTIVATED, (Object)user2Request.getStatus());
        Assert.assertEquals((long)1L, (long)user2Request.getChildRequests().size());
        ActionRequest user1DelegateRequest = (ActionRequest)user2Request.getChildRequests().get(0);
        Assert.assertEquals((Object)this.user1, (Object)user1DelegateRequest.getPrincipalId());
        Assert.assertEquals((Object)DelegationType.PRIMARY, (Object)user1DelegateRequest.getDelegationType());
        Assert.assertEquals((Object)ActionRequestStatus.ACTIVATED, (Object)user1DelegateRequest.getStatus());
        this.assertApproveRequested(document, this.user1, this.user2);
        this.assertApproveNotRequested(document, this.user3, this.testuser1, this.testuser2, this.testuser3, this.ewestfal);
        document.switchPrincipal(this.user1);
        document.approve("");
        this.assertApproveNotRequested(document, this.user1, this.user2);
        Assert.assertTrue((boolean)document.isFinal());
    }

    @Test
    public void test_RoleDelegate_RoleMemberWithMultiplePrincipals_AllApprove() throws Exception {
        PeopleFlowMember.Builder member = PeopleFlowMember.Builder.create((String)this.ppfTestRole3, (MemberType)MemberType.ROLE);
        member.setActionRequestPolicy(ActionRequestPolicy.ALL);
        PeopleFlowDelegate.Builder delegate = PeopleFlowDelegate.Builder.create((String)this.ppfTestRole4, (MemberType)MemberType.ROLE);
        delegate.setDelegationType(DelegationType.PRIMARY);
        delegate.setActionRequestPolicy(ActionRequestPolicy.ALL);
        this.createSimplePeopleFlow(PEOPLE_FLOW_10, member, delegate);
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.user3, (String)ROLE_DELEGATE_PEOPLE_FLOW_ROLE_MULTIPLE_MEMBERS);
        document.route("");
        Assert.assertTrue((String)"Document should be enroute.", (boolean)document.isEnroute());
        this.assertApproveRequested(document, this.user1, this.user2, this.testuser1, this.testuser2);
        this.assertApproveNotRequested(document, this.user3, this.testuser3, this.ewestfal);
        document.switchPrincipal(this.user1);
        document.approve("");
        document.switchPrincipal(this.user2);
        document.approve("");
        this.assertApproveNotRequested(document, this.user1, this.user2, this.testuser1, this.testuser2);
        Assert.assertTrue((boolean)document.isFinal());
        document = WorkflowDocumentFactory.createDocument((String)this.user3, (String)ROLE_DELEGATE_PEOPLE_FLOW_ROLE_MULTIPLE_MEMBERS);
        document.route("");
        Assert.assertTrue((String)"Document should be enroute.", (boolean)document.isEnroute());
        this.assertApproveRequested(document, this.user1, this.user2, this.testuser1, this.testuser2);
        this.assertApproveNotRequested(document, this.user3, this.testuser3, this.ewestfal);
        document.switchPrincipal(this.testuser1);
        document.approve("");
        document.switchPrincipal(this.testuser2);
        document.approve("");
        this.assertApproveNotRequested(document, this.user1, this.user2, this.testuser1, this.testuser2);
        Assert.assertTrue((boolean)document.isFinal());
        document = WorkflowDocumentFactory.createDocument((String)this.user3, (String)ROLE_DELEGATE_PEOPLE_FLOW_ROLE_MULTIPLE_MEMBERS);
        document.route("");
        Assert.assertTrue((String)"Document should be enroute.", (boolean)document.isEnroute());
        this.assertApproveRequested(document, this.user1, this.user2, this.testuser1, this.testuser2);
        this.assertApproveNotRequested(document, this.user3, this.testuser3, this.ewestfal);
        document.switchPrincipal(this.user1);
        document.approve("");
        this.assertApproveNotRequested(document, this.user1);
        document.switchPrincipal(this.testuser1);
        document.approve("");
        document.switchPrincipal(this.testuser2);
        document.approve("");
        this.assertApproveNotRequested(document, this.user1, this.user2, this.testuser1, this.testuser2);
        Assert.assertTrue((boolean)document.isFinal());
    }

    @Test
    public void test_RoleDelegate_RoleMemberWithMultiplePrincipals_FirstApprove() throws Exception {
        PeopleFlowMember.Builder member = PeopleFlowMember.Builder.create((String)this.ppfTestRole3, (MemberType)MemberType.ROLE);
        member.setActionRequestPolicy(ActionRequestPolicy.FIRST);
        PeopleFlowDelegate.Builder delegate = PeopleFlowDelegate.Builder.create((String)this.ppfTestRole4, (MemberType)MemberType.ROLE);
        delegate.setDelegationType(DelegationType.PRIMARY);
        delegate.setActionRequestPolicy(ActionRequestPolicy.FIRST);
        this.createSimplePeopleFlow(PEOPLE_FLOW_11, member, delegate);
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.user3, (String)ROLE_DELEGATE_PEOPLE_FLOW_ROLE_MULTIPLE_MEMBERS_FIRST_APPROVE);
        document.route("");
        Assert.assertTrue((String)"Document should be enroute.", (boolean)document.isEnroute());
        this.assertApproveRequested(document, this.user1, this.user2, this.testuser1, this.testuser2);
        this.assertApproveNotRequested(document, this.user3, this.testuser3, this.ewestfal);
        document.switchPrincipal(this.testuser1);
        document.approve("");
        this.assertApproveNotRequested(document, this.user1, this.user2, this.testuser1, this.testuser2, this.user3, this.ewestfal);
        Assert.assertTrue((boolean)document.isFinal());
        document = WorkflowDocumentFactory.createDocument((String)this.user3, (String)ROLE_DELEGATE_PEOPLE_FLOW_ROLE_MULTIPLE_MEMBERS_FIRST_APPROVE);
        document.route("");
        Assert.assertTrue((String)"Document should be enroute.", (boolean)document.isEnroute());
        this.assertApproveRequested(document, this.user1, this.user2, this.testuser1, this.testuser2);
        this.assertApproveNotRequested(document, this.user3, this.testuser3, this.ewestfal);
        document.switchPrincipal(this.user1);
        document.approve("");
        this.assertApproveNotRequested(document, this.user1, this.user2, this.testuser1, this.testuser2, this.user3, this.ewestfal);
        Assert.assertTrue((boolean)document.isFinal());
    }

    @Test
    public void test_RoleDelegate_RoleMemberWithMultiplePrincipals_DelegateFirstApprove() throws Exception {
        PeopleFlowMember.Builder member = PeopleFlowMember.Builder.create((String)this.ppfTestRole3, (MemberType)MemberType.ROLE);
        member.setActionRequestPolicy(ActionRequestPolicy.ALL);
        PeopleFlowDelegate.Builder delegate = PeopleFlowDelegate.Builder.create((String)this.ppfTestRole4, (MemberType)MemberType.ROLE);
        delegate.setDelegationType(DelegationType.PRIMARY);
        delegate.setActionRequestPolicy(ActionRequestPolicy.FIRST);
        this.createSimplePeopleFlow(PEOPLE_FLOW_12, member, delegate);
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.user3, (String)ROLE_DELEGATE_PEOPLE_FLOW_ROLE_MULTIPLE_MEMBERS_DELEGATE_FIRST_APPROVE);
        document.route("");
        Assert.assertTrue((String)"Document should be enroute.", (boolean)document.isEnroute());
        this.assertApproveRequested(document, this.user1, this.user2, this.testuser1, this.testuser2);
        this.assertApproveNotRequested(document, this.user3, this.testuser3, this.ewestfal);
        document.switchPrincipal(this.user1);
        document.approve("");
        this.assertApproveRequested(document, this.user2, this.testuser1, this.testuser2);
        this.assertApproveNotRequested(document, this.user1);
        document.switchPrincipal(this.user2);
        document.approve("");
        this.assertApproveNotRequested(document, this.user1, this.user2, this.testuser1, this.testuser2);
        Assert.assertTrue((boolean)document.isFinal());
        document = WorkflowDocumentFactory.createDocument((String)this.user3, (String)ROLE_DELEGATE_PEOPLE_FLOW_ROLE_MULTIPLE_MEMBERS_DELEGATE_FIRST_APPROVE);
        document.route("");
        Assert.assertTrue((String)"Document should be enroute.", (boolean)document.isEnroute());
        this.assertApproveRequested(document, this.user1, this.user2, this.testuser1, this.testuser2);
        this.assertApproveNotRequested(document, this.user3, this.testuser3, this.ewestfal);
        document.switchPrincipal(this.testuser1);
        document.approve("");
        this.assertApproveNotRequested(document, this.user1, this.user2, this.testuser1, this.testuser2);
        Assert.assertTrue((boolean)document.isFinal());
        document = WorkflowDocumentFactory.createDocument((String)this.user3, (String)ROLE_DELEGATE_PEOPLE_FLOW_ROLE_MULTIPLE_MEMBERS_DELEGATE_FIRST_APPROVE);
        document.route("");
        Assert.assertTrue((String)"Document should be enroute.", (boolean)document.isEnroute());
        this.assertApproveRequested(document, this.user1, this.user2, this.testuser1, this.testuser2);
        this.assertApproveNotRequested(document, this.user3, this.testuser3, this.ewestfal);
        document.switchPrincipal(this.user1);
        document.approve("");
        this.assertApproveRequested(document, this.user2, this.testuser1, this.testuser2);
        this.assertApproveNotRequested(document, this.user1);
        document.switchPrincipal(this.testuser1);
        document.approve("");
        this.assertApproveNotRequested(document, this.user1, this.user2, this.testuser1, this.testuser2);
        Assert.assertTrue((boolean)document.isFinal());
    }

    @Test
    public void test_GroupDelegate_RoleMemberWithMultiplePrincipals_AllApprove() throws Exception {
        PeopleFlowMember.Builder member = PeopleFlowMember.Builder.create((String)this.ppfTestGroup1, (MemberType)MemberType.GROUP);
        PeopleFlowDelegate.Builder delegate = PeopleFlowDelegate.Builder.create((String)this.ppfTestRole4, (MemberType)MemberType.ROLE);
        delegate.setDelegationType(DelegationType.PRIMARY);
        delegate.setActionRequestPolicy(ActionRequestPolicy.ALL);
        this.createSimplePeopleFlow(PEOPLE_FLOW_13, member, delegate);
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.user3, (String)GROUP_DELEGATE_PEOPLE_FLOW_ROLE_MULTIPLE_MEMBERS);
        document.route("");
        Assert.assertTrue((String)"Document should be enroute.", (boolean)document.isEnroute());
        this.assertApproveRequested(document, this.earl, this.fran, this.testuser1, this.testuser2);
        this.assertApproveNotRequested(document, this.user1, this.user2, this.user3, this.testuser3, this.ewestfal);
        document.switchPrincipal(this.earl);
        document.approve("");
        this.assertApproveNotRequested(document, this.user1, this.user2, this.earl, this.fran, this.testuser1, this.testuser2);
        Assert.assertTrue((boolean)document.isFinal());
        document = WorkflowDocumentFactory.createDocument((String)this.user3, (String)GROUP_DELEGATE_PEOPLE_FLOW_ROLE_MULTIPLE_MEMBERS);
        document.route("");
        Assert.assertTrue((String)"Document should be enroute.", (boolean)document.isEnroute());
        this.assertApproveRequested(document, this.earl, this.fran, this.testuser1, this.testuser2);
        this.assertApproveNotRequested(document, this.user1, this.user2, this.user3, this.testuser3, this.ewestfal);
        document.switchPrincipal(this.testuser1);
        document.approve("");
        Assert.assertFalse((boolean)document.isFinal());
        document.switchPrincipal(this.testuser2);
        document.approve("");
        this.assertApproveNotRequested(document, this.user1, this.user2, this.earl, this.fran, this.testuser1, this.testuser2);
        Assert.assertTrue((boolean)document.isFinal());
    }

    private PeopleFlowDefinition createSimpleRoleDelegatePeopleFlow(String peopleFlowName, String memberRoleId, String delegateRoleId, DelegationType delegationType) {
        PeopleFlowDefinition.Builder peopleFlow = PeopleFlowDefinition.Builder.create((String)NAMESPACE_CODE, (String)peopleFlowName);
        PeopleFlowMember.Builder memberBuilder = peopleFlow.addRole(memberRoleId);
        memberBuilder.setPriority(1);
        memberBuilder.setActionRequestPolicy(ActionRequestPolicy.FIRST);
        if (delegateRoleId != null) {
            PeopleFlowDelegate.Builder delegateBuilder = PeopleFlowDelegate.Builder.create((String)delegateRoleId, (MemberType)MemberType.ROLE);
            delegateBuilder.setDelegationType(delegationType);
            delegateBuilder.setActionRequestPolicy(ActionRequestPolicy.FIRST);
            memberBuilder.getDelegates().add(delegateBuilder);
        }
        return this.peopleFlowService.createPeopleFlow(peopleFlow.build());
    }

    private PeopleFlowDefinition createSimplePeopleFlow(String peopleFlowName, PeopleFlowMember.Builder member, PeopleFlowDelegate.Builder delegate) {
        PeopleFlowDefinition.Builder peopleFlow = PeopleFlowDefinition.Builder.create((String)NAMESPACE_CODE, (String)peopleFlowName);
        member.setPriority(1);
        if (delegate != null) {
            member.getDelegates().add(delegate);
        }
        peopleFlow.getMembers().add(member);
        return this.peopleFlowService.createPeopleFlow(peopleFlow.build());
    }

    private void createDelegatePeopleFlow() {
        PeopleFlowDefinition.Builder peopleFlow = PeopleFlowDefinition.Builder.create((String)NAMESPACE_CODE, (String)PEOPLE_FLOW_1);
        peopleFlow.addPrincipal(this.user1).setPriority(1);
        PeopleFlowMember.Builder user2Builder = peopleFlow.addPrincipal(this.user2);
        user2Builder.setPriority(1);
        PeopleFlowDelegate.Builder user2PrimaryDelegateBuilder = PeopleFlowDelegate.Builder.create((String)this.testuser2, (MemberType)MemberType.PRINCIPAL);
        user2PrimaryDelegateBuilder.setDelegationType(DelegationType.PRIMARY);
        user2Builder.getDelegates().add(user2PrimaryDelegateBuilder);
        PeopleFlowMember.Builder testuser1Builder = peopleFlow.addPrincipal(this.testuser1);
        testuser1Builder.setPriority(2);
        PeopleFlowDelegate.Builder testWorkgroupSecondaryDelegateBuilder = PeopleFlowDelegate.Builder.create((String)this.testWorkgroup, (MemberType)MemberType.GROUP);
        testWorkgroupSecondaryDelegateBuilder.setDelegationType(DelegationType.SECONDARY);
        testuser1Builder.getDelegates().add(testWorkgroupSecondaryDelegateBuilder);
        PeopleFlowDelegate.Builder testuser3PrimaryDelegateBuilder = PeopleFlowDelegate.Builder.create((String)this.testuser3, (MemberType)MemberType.PRINCIPAL);
        testuser3PrimaryDelegateBuilder.setDelegationType(DelegationType.PRIMARY);
        testuser1Builder.getDelegates().add(testuser3PrimaryDelegateBuilder);
        peopleFlow.addPrincipal(this.user3).setPriority(2);
        this.peopleFlowService.createPeopleFlow(peopleFlow.build());
    }

    @Test
    public void test_DelegatePeopleFlow_PriorityParallel_Approve() throws Exception {
        this.createDelegatePeopleFlow();
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.user3, (String)DELEGATE_PEOPLE_FLOW_PRIORITY_PARALLEL_APPROVE);
        document.route("");
        Assert.assertTrue((String)"Document should be enroute.", (boolean)document.isEnroute());
        document.switchPrincipal(this.user3);
        List rootActionRequests = document.getRootActionRequests();
        Assert.assertEquals((String)"Should have 4 root action requests", (long)4L, (long)rootActionRequests.size());
        ActionRequest user1Request = null;
        ActionRequest user2Request = null;
        ActionRequest user3Request = null;
        ActionRequest testuser1Request = null;
        for (ActionRequest actionRequest : rootActionRequests) {
            RecipientType recipientType = actionRequest.getRecipientType();
            if (recipientType != RecipientType.PRINCIPAL) continue;
            if (this.user1.equals(actionRequest.getPrincipalId())) {
                user1Request = actionRequest;
                continue;
            }
            if (this.user2.equals(actionRequest.getPrincipalId())) {
                user2Request = actionRequest;
                continue;
            }
            if (this.user3.equals(actionRequest.getPrincipalId())) {
                user3Request = actionRequest;
                continue;
            }
            if (!this.testuser1.equals(actionRequest.getPrincipalId())) continue;
            testuser1Request = actionRequest;
        }
        Assert.assertNotNull(user1Request);
        Assert.assertEquals((Object)ActionRequestStatus.ACTIVATED, (Object)user1Request.getStatus());
        Assert.assertNotNull(user2Request);
        Assert.assertEquals((Object)ActionRequestStatus.ACTIVATED, (Object)user2Request.getStatus());
        Assert.assertNotNull(user3Request);
        Assert.assertEquals((Object)ActionRequestStatus.INITIALIZED, (Object)user3Request.getStatus());
        Assert.assertNotNull(testuser1Request);
        Assert.assertEquals((Object)ActionRequestStatus.INITIALIZED, (Object)testuser1Request.getStatus());
        Assert.assertEquals((long)1L, (long)user2Request.getChildRequests().size());
        ActionRequest testuser2DelegateRequest = (ActionRequest)user2Request.getChildRequests().get(0);
        Assert.assertEquals((Object)this.testuser2, (Object)testuser2DelegateRequest.getPrincipalId());
        Assert.assertEquals((Object)DelegationType.PRIMARY, (Object)testuser2DelegateRequest.getDelegationType());
        Assert.assertEquals((Object)ActionRequestStatus.ACTIVATED, (Object)testuser2DelegateRequest.getStatus());
        Assert.assertEquals((long)2L, (long)testuser1Request.getChildRequests().size());
        ActionRequest testWorkgroupRequest = null;
        ActionRequest testuser3Request = null;
        for (ActionRequest childActionRequest : testuser1Request.getChildRequests()) {
            RecipientType recipientType = childActionRequest.getRecipientType();
            if (recipientType == RecipientType.PRINCIPAL) {
                if (!this.testuser3.equals(childActionRequest.getPrincipalId())) continue;
                testuser3Request = childActionRequest;
                continue;
            }
            if (recipientType != RecipientType.GROUP || !this.testWorkgroup.equals(childActionRequest.getGroupId())) continue;
            testWorkgroupRequest = childActionRequest;
        }
        Assert.assertNotNull(testWorkgroupRequest);
        Assert.assertEquals((Object)ActionRequestStatus.INITIALIZED, (Object)testWorkgroupRequest.getStatus());
        Assert.assertEquals((Object)DelegationType.SECONDARY, (Object)testWorkgroupRequest.getDelegationType());
        Assert.assertNotNull(testuser3Request);
        Assert.assertEquals((Object)ActionRequestStatus.INITIALIZED, (Object)testuser3Request.getStatus());
        Assert.assertEquals((Object)DelegationType.PRIMARY, (Object)testuser3Request.getDelegationType());
        this.assertApproveRequested(document, this.user1, this.user2, this.testuser2);
        this.assertApproveNotRequested(document, this.testuser1, this.user3, this.ewestfal, this.testuser3);
        document.switchPrincipal(this.testuser2);
        document.approve("");
        this.assertApproveRequested(document, this.user1);
        this.assertApproveNotRequested(document, this.user2, this.testuser2, this.testuser1, this.user3, this.ewestfal, this.testuser3);
        document.switchPrincipal(this.user1);
        document.approve("");
        this.assertApproveRequested(document, this.testuser1, this.user3, this.ewestfal, this.testuser3);
        this.assertApproveNotRequested(document, this.user1, this.user2, this.testuser2);
        document.switchPrincipal(this.ewestfal);
        document.approve("");
        this.assertApproveRequested(document, this.user3);
        this.assertApproveNotRequested(document, this.user1, this.user2, this.testuser2, this.testuser1, this.ewestfal, this.testuser3);
        document.switchPrincipal(this.user3);
        document.approve("");
        Assert.assertTrue((boolean)document.isFinal());
    }

    private void createFirstApproveRolePeopleFlow() {
        RoleService roleService = KimApiServiceLocator.getRoleService();
        Role role = roleService.getRoleByNamespaceCodeAndName("KR-SYS", "Technical Administrator");
        Assert.assertNotNull((String)"Technical Administrator role should exist!", (Object)role);
        Assert.assertEquals((long)2L, (long)roleService.getRoleMembers(Collections.singletonList(role.getId()), new HashMap()).size());
        this.roleId = role.getId();
        PeopleFlowDefinition.Builder peopleFlow = PeopleFlowDefinition.Builder.create((String)NAMESPACE_CODE, (String)PEOPLE_FLOW_2);
        PeopleFlowMember.Builder memberBuilder = peopleFlow.addRole(role.getId());
        memberBuilder.setPriority(1);
        memberBuilder.setActionRequestPolicy(ActionRequestPolicy.FIRST);
        this.peopleFlowService.createPeopleFlow(peopleFlow.build());
    }

    @Test
    public void test_FirstApproveRolePeopleFlow() throws Exception {
        this.createFirstApproveRolePeopleFlow();
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.user3, (String)SINGLE_PEOPLE_FLOW_PRIORITY_PARALLEL_APPROVE);
        document.route("");
        Assert.assertTrue((String)"Document should be enroute.", (boolean)document.isEnroute());
        List rootActionRequests = document.getRootActionRequests();
        Assert.assertEquals((long)1L, (long)rootActionRequests.size());
        ActionRequest roleRequest = (ActionRequest)rootActionRequests.get(0);
        Assert.assertEquals((Object)ActionRequestPolicy.FIRST, (Object)roleRequest.getRequestPolicy());
        Assert.assertEquals((Object)this.roleId, (Object)roleRequest.getRoleName());
        Assert.assertEquals((Object)RecipientType.ROLE, (Object)roleRequest.getRecipientType());
        Assert.assertEquals((long)2L, (long)roleRequest.getChildRequests().size());
        for (ActionRequest childRequest : roleRequest.getChildRequests()) {
            if (RecipientType.PRINCIPAL.equals((Object)childRequest.getRecipientType())) {
                Assert.assertEquals((Object)this.getPrincipalIdForName("admin"), (Object)childRequest.getPrincipalId());
                continue;
            }
            if (RecipientType.GROUP.equals((Object)childRequest.getRecipientType())) {
                Assert.assertEquals((Object)this.getGroupIdForName("KR-WKFLW", "WorkflowAdmin"), (Object)childRequest.getGroupId());
                continue;
            }
            Assert.fail((String)("Found a child request i didn't expect with a recipient type of: " + childRequest.getRecipientType()));
        }
        document.switchPrincipal(this.getPrincipalNameForId("admin"));
        Assert.assertTrue((boolean)document.isApprovalRequested());
        document.switchPrincipal(this.getPrincipalIdForName("bmcgough"));
        Assert.assertTrue((boolean)document.isApprovalRequested());
        document.approve("");
        Assert.assertTrue((boolean)document.isFinal());
        document = WorkflowDocumentFactory.createDocument((String)this.user3, (String)SINGLE_PEOPLE_FLOW_PRIORITY_PARALLEL_APPROVE);
        document.route("");
        Assert.assertTrue((String)"Document should be enroute.", (boolean)document.isEnroute());
        document.switchPrincipal(this.getPrincipalIdForName("bmcgough"));
        Assert.assertTrue((boolean)document.isApprovalRequested());
        document.switchPrincipal(this.getPrincipalNameForId("admin"));
        Assert.assertTrue((boolean)document.isApprovalRequested());
        document.approve("");
        Assert.assertTrue((boolean)document.isFinal());
    }

    private void createAllApproveRolePeopleFlow() {
        RoleService roleService = KimApiServiceLocator.getRoleService();
        Role role = roleService.getRoleByNamespaceCodeAndName("KR-SYS", "Technical Administrator");
        Assert.assertNotNull((String)"Technical Administrator role should exist!", (Object)role);
        Assert.assertEquals((long)2L, (long)roleService.getRoleMembers(Collections.singletonList(role.getId()), new HashMap()).size());
        this.roleId = role.getId();
        PeopleFlowDefinition.Builder peopleFlow = PeopleFlowDefinition.Builder.create((String)NAMESPACE_CODE, (String)PEOPLE_FLOW_2);
        PeopleFlowMember.Builder memberBuilder = peopleFlow.addRole(role.getId());
        memberBuilder.setPriority(1);
        memberBuilder.setActionRequestPolicy(ActionRequestPolicy.ALL);
        this.peopleFlowService.createPeopleFlow(peopleFlow.build());
    }

    @Test
    public void test_AllApproveRolePeopleFlow() throws Exception {
        this.createAllApproveRolePeopleFlow();
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.user3, (String)SINGLE_PEOPLE_FLOW_PRIORITY_PARALLEL_APPROVE);
        document.route("");
        Assert.assertTrue((String)"Document should be enroute.", (boolean)document.isEnroute());
        List rootActionRequests = document.getRootActionRequests();
        Assert.assertEquals((long)1L, (long)rootActionRequests.size());
        ActionRequest roleRequest = (ActionRequest)rootActionRequests.get(0);
        Assert.assertEquals((Object)ActionRequestPolicy.ALL, (Object)roleRequest.getRequestPolicy());
        Assert.assertEquals((Object)this.roleId, (Object)roleRequest.getRoleName());
        Assert.assertEquals((Object)RecipientType.ROLE, (Object)roleRequest.getRecipientType());
        Assert.assertEquals((long)2L, (long)roleRequest.getChildRequests().size());
        for (ActionRequest childRequest : roleRequest.getChildRequests()) {
            if (RecipientType.PRINCIPAL.equals((Object)childRequest.getRecipientType())) {
                Assert.assertEquals((Object)this.getPrincipalIdForName("admin"), (Object)childRequest.getPrincipalId());
                continue;
            }
            if (RecipientType.GROUP.equals((Object)childRequest.getRecipientType())) {
                Assert.assertEquals((Object)this.getGroupIdForName("KR-WKFLW", "WorkflowAdmin"), (Object)childRequest.getGroupId());
                continue;
            }
            Assert.fail((String)("Found a child request i didn't expect with a recipient type of: " + childRequest.getRecipientType()));
        }
        document.switchPrincipal(this.getPrincipalNameForId("admin"));
        Assert.assertTrue((boolean)document.isApprovalRequested());
        document.switchPrincipal(this.getPrincipalIdForName("bmcgough"));
        Assert.assertTrue((boolean)document.isApprovalRequested());
        document.approve("");
        Assert.assertTrue((boolean)document.isEnroute());
        Assert.assertFalse((boolean)document.isApprovalRequested());
        document.switchPrincipal(this.getPrincipalNameForId("admin"));
        Assert.assertTrue((boolean)document.isApprovalRequested());
        document.approve("");
        Assert.assertTrue((boolean)document.isFinal());
    }

    private void assertApproveRequested(WorkflowDocument document, String ... principalIds) {
        for (String principalId : principalIds) {
            document.switchPrincipal(principalId);
            Assert.assertTrue((String)("Approve should have been requested for '" + principalId + "'"), (boolean)document.isApprovalRequested());
        }
    }

    private void assertAcknowledgeRequested(WorkflowDocument document, String ... principalIds) {
        for (String principalId : principalIds) {
            document.switchPrincipal(principalId);
            Assert.assertTrue((String)("Acknowledge should have been requested for '" + principalId + "'"), (boolean)document.isAcknowledgeRequested());
        }
    }

    private void assertApproveNotRequested(WorkflowDocument document, String ... principalIds) {
        for (String principalId : principalIds) {
            document.switchPrincipal(principalId);
            Assert.assertFalse((String)("Approve should *NOT* have been requested for '" + principalId + "'"), (boolean)document.isApprovalRequested());
        }
    }
}

