/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.messaging.exceptionhandling;

import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kew.test.TestUtilities;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public class ExceptionRoutingServiceTest
extends KEWTestCase {
    @Test
    public void testKimExceptionRouting() throws Exception {
        this.loadXmlFile("RouteExceptionTestDoc.xml");
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("admin"), (String)"TestFinalApproverDocumentType");
        document.setTitle("");
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        try {
            document.approve("");
            Assert.fail((String)"document should have thrown routing exception");
        }
        catch (Exception e) {
            TestUtilities.getExceptionThreader().join();
            document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
            Assert.assertTrue((String)"Document should be in exception routing", (boolean)document.isException());
        }
    }

    @Test
    public void testKimExceptionRoutingWithDocHierarchy() throws Exception {
        this.loadXmlFile("RouteExceptionTestDoc.xml");
        String[] docNames = new String[]{"TestFinalApproverDocumentType_Child", "TestFinalApproverDocumentType_GrandChild"};
        for (int i = 0; i < docNames.length; ++i) {
            WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("admin"), (String)docNames[i]);
            document.setTitle("");
            document.route("");
            document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
            try {
                document.approve("");
                Assert.fail((String)"document should have thrown routing exception");
                continue;
            }
            catch (Exception e) {
                TestUtilities.getExceptionThreader().join();
                document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
                Assert.assertTrue((String)"Document should be in exception routing", (boolean)document.isException());
            }
        }
    }

    @Test
    public void testKimExceptionRoutingWithRiceDocumentChild() throws Exception {
        this.loadXmlFile("RouteExceptionTestDoc.xml");
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("admin"), (String)"DocumentTypeDocument_New");
        document.setTitle("");
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        try {
            document.approve("");
            Assert.fail((String)"document should have thrown routing exception");
        }
        catch (Exception e) {
            TestUtilities.getExceptionThreader().join();
            document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
            Assert.assertTrue((String)"Document should be in exception routing", (boolean)document.isException());
        }
    }

    @Test
    public void testExplicitlyPlacingDocumentInException() {
        this.loadXmlFile("org/kuali/rice/kew/routeheader/AppDocStatusTestConfig.xml");
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("rkirkend"), (String)"TestAppDocStatusDoc1");
        document.setTitle("");
        document.route("");
        document.placeInExceptionRouting("explicitly placing in exception routing");
        Assert.assertEquals((Object)DocumentStatus.EXCEPTION, (Object)document.getStatus());
    }
}

