/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.routemodule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.rice.kew.actionrequest.ActionRequestFactory;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actionrequest.KimGroupRecipient;
import org.kuali.rice.kew.actionrequest.KimPrincipalRecipient;
import org.kuali.rice.kew.actionrequest.Recipient;
import org.kuali.rice.kew.api.action.RecipientType;
import org.kuali.rice.kew.api.exception.ResourceUnavailableException;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routemodule.RouteModule;
import org.kuali.rice.kew.routemodule.TestDelegation;
import org.kuali.rice.kew.routemodule.TestRecipient;
import org.kuali.rice.kew.routemodule.TestResponsibility;
import org.kuali.rice.kew.routemodule.TestRouteLevel;
import org.kuali.rice.kew.routemodule.TestRouteModuleXMLHelper;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.util.ResponsibleParty;

public class TestRouteModule
implements RouteModule {
    private static Map responsibilityMap = new HashMap();

    public List findActionRequests(RouteContext context) throws ResourceUnavailableException, WorkflowException {
        return this.findActionRequests(context.getDocument());
    }

    public List findActionRequests(DocumentRouteHeaderValue routeHeader) throws ResourceUnavailableException, WorkflowException {
        TestRouteLevel routeLevel = TestRouteModuleXMLHelper.parseCurrentRouteLevel(routeHeader);
        ArrayList<ActionRequestValue> actionRequests = new ArrayList<ActionRequestValue>();
        if (routeLevel == null) {
            return actionRequests;
        }
        for (TestResponsibility responsibility : routeLevel.getResponsibilities()) {
            TestRecipient recipient = responsibility.getRecipient();
            Recipient realRecipient = this.getRealRecipient(recipient);
            ActionRequestFactory arFactory = new ActionRequestFactory(routeHeader);
            String responsibilityId = KEWServiceLocator.getResponsibilityIdService().getNewResponsibilityId();
            ActionRequestValue request = arFactory.addRootActionRequest(responsibility.getActionRequested(), new Integer(responsibility.getPriority()), realRecipient, "", responsibilityId, Boolean.FALSE, null, null);
            responsibilityMap.put(request.getResponsibilityId(), recipient);
            for (TestDelegation delegation : responsibility.getDelegations()) {
                TestRecipient delegationRecipient = delegation.getResponsibility().getRecipient();
                Recipient realDelegationRecipient = this.getRealRecipient(delegationRecipient);
                responsibilityId = KEWServiceLocator.getResponsibilityIdService().getNewResponsibilityId();
                ActionRequestValue delegationRequest = arFactory.addDelegationRequest(request, realDelegationRecipient, responsibilityId, Boolean.FALSE, delegation.getType(), "", null);
                responsibilityMap.put(delegationRequest.getResponsibilityId(), delegationRecipient);
            }
            actionRequests.add(request);
        }
        return actionRequests;
    }

    public Recipient getRealRecipient(TestRecipient recipient) throws WorkflowException {
        KimPrincipalRecipient realRecipient = null;
        if (recipient.getType().equals(RecipientType.PRINCIPAL.getCode())) {
            realRecipient = new KimPrincipalRecipient(recipient.getId());
        } else if (recipient.getType().equals(RecipientType.GROUP.getCode())) {
            realRecipient = new KimGroupRecipient(recipient.getId());
        } else {
            throw new WorkflowException("Could not resolve recipient with type " + recipient.getType());
        }
        return realRecipient;
    }

    public ResponsibleParty resolveResponsibilityId(String responsibilityId) throws ResourceUnavailableException, WorkflowException {
        TestRecipient recipient = (TestRecipient)responsibilityMap.get(responsibilityId);
        if (recipient == null) {
            return null;
        }
        ResponsibleParty responsibleParty = new ResponsibleParty();
        if (recipient.getType().equals(RecipientType.PRINCIPAL.getCode())) {
            responsibleParty.setPrincipalId(recipient.getId());
        } else if (recipient.getType().equals(RecipientType.GROUP.getCode())) {
            responsibleParty.setGroupId(recipient.getId());
        } else if (recipient.getType().equals(RecipientType.ROLE.getCode())) {
            responsibleParty.setRoleName(recipient.getId());
        } else {
            throw new WorkflowException("Invalid recipient type code of '" + recipient.getType() + "' for responsibility id " + responsibilityId);
        }
        return responsibleParty;
    }

    public boolean isMoreRequestsAvailable(RouteContext context) {
        return false;
    }
}

