/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.xml;

import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.rule.RuleBaseValues;
import org.kuali.rice.kew.rule.RuleTemplateOptionBo;
import org.kuali.rice.kew.rule.bo.RuleTemplateAttributeBo;
import org.kuali.rice.kew.rule.bo.RuleTemplateBo;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kew.xml.RuleTemplateXmlParser;

public class RuleTemplateXmlParserTest
extends KEWTestCase {
    private static Logger LOG = Logger.getLogger(RuleTemplateXmlParserTest.class);
    private static final String RULE_ATTRIBUTE_ONE = "TemplateTestRuleAttribute1";
    private static final String RULE_ATTRIBUTE_TWO = "TemplateTestRuleAttribute2";
    private static final String RULE_ATTRIBUTE_THREE = "TemplateTestRuleAttribute3";
    private static final String RULE_ATTRIBUTE_FOUR = "TemplateTestRuleAttribute4";
    private static final String RULE_ATTRIBUTE_FIVE = "TemplateTestRuleAttribute5";

    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("RuleTemplateConfig.xml");
    }

    private void testTemplate(String docName, Class expectedException) throws Exception {
        RuleTemplateXmlParser parser = new RuleTemplateXmlParser();
        String filename = "RT_" + docName + ".xml";
        try {
            parser.parseRuleTemplates(((Object)((Object)this)).getClass().getResourceAsStream(filename));
            if (expectedException != null) {
                Assert.fail((String)(filename + " successfully loaded.  Expected exception of class '" + expectedException + "'"));
            }
        }
        catch (Exception e) {
            if (expectedException == null || !expectedException.isAssignableFrom(e.getClass())) {
                throw e;
            }
            this.log.error((Object)(filename + " exception: " + e));
        }
    }

    private void testListOfTemplateAttributes(List ruleTemplateAttributes, String[] activeRuleTemplateAttributeNames, String[] requiredRuleTemplateAttributeNames) {
        for (RuleTemplateAttributeBo templateAttribute : ruleTemplateAttributes) {
            String ruleAttributeName = templateAttribute.getRuleAttribute().getName();
            LOG.info((Object)("Attribute name '" + ruleAttributeName + "' active indicator is " + templateAttribute.isActive()));
            if (activeRuleTemplateAttributeNames == null) {
                Assert.assertEquals((String)("Active indicator should be false for all attributes but is not for attribute '" + ruleAttributeName + "'"), (Object)Boolean.FALSE, (Object)templateAttribute.getActive());
            } else {
                this.runTestsOnTemplateAttributeField(ruleAttributeName, templateAttribute.isActive(), activeRuleTemplateAttributeNames, "active");
            }
            LOG.info((Object)("Attribute name '" + ruleAttributeName + "' required indicator is " + templateAttribute.isRequired()));
            if (requiredRuleTemplateAttributeNames == null) {
                Assert.assertEquals((String)("Required indicator should be false for all attributes but is not for attribute '" + ruleAttributeName + "'"), (Object)Boolean.FALSE, (Object)templateAttribute.getRequired());
                continue;
            }
            this.runTestsOnTemplateAttributeField(ruleAttributeName, templateAttribute.isRequired(), requiredRuleTemplateAttributeNames, "required");
        }
    }

    private void testAllAttributesActive(List activeRuleTemplateAttributes, String[] activeRuleTemplateAttributeNames) {
        for (RuleTemplateAttributeBo activeTemplateAttribute : activeRuleTemplateAttributes) {
            String ruleAttributeName = activeTemplateAttribute.getRuleAttribute().getName();
            Assert.assertEquals((String)("Template Attribute with name '" + ruleAttributeName + "' has invalid active value"), (Object)Boolean.TRUE, (Object)activeTemplateAttribute.getActive());
            boolean foundAttribute = false;
            for (int i = 0; i < activeRuleTemplateAttributeNames.length; ++i) {
                String shouldBeActiveAttributeName = activeRuleTemplateAttributeNames[i];
                if (!shouldBeActiveAttributeName.equals(ruleAttributeName)) continue;
                foundAttribute = true;
                break;
            }
            if (foundAttribute) continue;
            Assert.fail((String)("Template Attribute with name '" + ruleAttributeName + "' should have been in active template name list but was not found"));
        }
    }

    private void runTestsOnTemplateAttributeField(String ruleAttributeName, boolean valueToConfirm, String[] attributeNamesShouldBeTrue, String errorMessageIdentifier) {
        boolean foundAttribute = false;
        for (String attributeNameThatShouldPass : attributeNamesShouldBeTrue) {
            if (!ruleAttributeName.equals(attributeNameThatShouldPass)) continue;
            foundAttribute = true;
            if (valueToConfirm) continue;
            Assert.fail((String)("Attribute with name '" + ruleAttributeName + "' should have been " + errorMessageIdentifier + " but is not"));
        }
        if (!foundAttribute && valueToConfirm) {
            Assert.fail((String)("Attribute with name '" + ruleAttributeName + "' should not be " + errorMessageIdentifier + " but is"));
        }
    }

    @Test
    public void testLoadValidTemplate() throws Exception {
        this.testTemplate(TemplateParserGeneralFixture.VALID_TEMPLATE_FULL_XML.fileNameParameter, null);
        this.testTemplate(TemplateParserGeneralFixture.VALID_TEMPLATE_MIN_XML.fileNameParameter, null);
        RuleTemplateBo template = KEWServiceLocator.getRuleTemplateService().findByRuleTemplateName(TemplateParserGeneralFixture.VALID_TEMPLATE_MIN_XML.ruleTemplateName);
        this.testListOfTemplateAttributes(template.getRuleTemplateAttributes(), TemplateParserGeneralFixture.VALID_TEMPLATE_MIN_XML.activeAttributeNames, TemplateParserGeneralFixture.VALID_TEMPLATE_MIN_XML.requiredAttributeNames);
        this.testAllAttributesActive(template.getActiveRuleTemplateAttributes(), TemplateParserGeneralFixture.VALID_TEMPLATE_MIN_XML.activeAttributeNames);
        this.assertNoDefaultsSpecified(template);
    }

    @Test
    public void testLoadValidTemplateWithOverwrite() throws Exception {
        this.testTemplate(TemplateParserGeneralFixture.VALID_TEMPLATE_MIN_XML.fileNameParameter, null);
        this.testTemplate(TemplateParserGeneralFixture.VALID_TEMPLATE_OVERWRITE.fileNameParameter, null);
        RuleTemplateBo template = KEWServiceLocator.getRuleTemplateService().findByRuleTemplateName(TemplateParserGeneralFixture.VALID_TEMPLATE_OVERWRITE.ruleTemplateName);
        this.testListOfTemplateAttributes(template.getRuleTemplateAttributes(), TemplateParserGeneralFixture.VALID_TEMPLATE_OVERWRITE.activeAttributeNames, TemplateParserGeneralFixture.VALID_TEMPLATE_OVERWRITE.requiredAttributeNames);
        this.testAllAttributesActive(template.getActiveRuleTemplateAttributes(), TemplateParserGeneralFixture.VALID_TEMPLATE_OVERWRITE.activeAttributeNames);
        this.assertNoDefaultsSpecified(template);
    }

    @Test
    public void testLoadValidTemplateFullWithOverwrite() throws Exception {
        this.testTemplate(TemplateParserGeneralFixture.VALID_TEMPLATE_FULL_XML.fileNameParameter, null);
        this.testTemplate(TemplateParserGeneralFixture.VALID_TEMPLATE_FULL_OVERWRITE.fileNameParameter, null);
        RuleTemplateBo template = KEWServiceLocator.getRuleTemplateService().findByRuleTemplateName(TemplateParserGeneralFixture.VALID_TEMPLATE_FULL_OVERWRITE.ruleTemplateName);
        this.testListOfTemplateAttributes(template.getRuleTemplateAttributes(), TemplateParserGeneralFixture.VALID_TEMPLATE_FULL_OVERWRITE.activeAttributeNames, TemplateParserGeneralFixture.VALID_TEMPLATE_FULL_OVERWRITE.requiredAttributeNames);
        this.testAllAttributesActive(template.getActiveRuleTemplateAttributes(), TemplateParserGeneralFixture.VALID_TEMPLATE_FULL_OVERWRITE.activeAttributeNames);
        this.assertNoDefaultsSpecified(template);
    }

    @Test
    public void testLoadInvalidTemplateWithOverwrite() throws Exception {
        this.testTemplate(TemplateParserGeneralFixture.VALID_TEMPLATE_MIN_XML.fileNameParameter, null);
        this.testTemplate(TemplateParserGeneralFixture.VALID_TEMPLATE_MIN_XML.fileNameParameter, RuntimeException.class);
        this.testTemplate(TemplateParserGeneralFixture.INVALID_TEMPLATE_OVERWRITE.fileNameParameter, RuntimeException.class);
    }

    @Test
    public void testLoadValidTemplateWithFullDefaults() throws Exception {
        this.testTemplate(TemplateParserGeneralFixture.VALID_TEMPLATE_WITH_FULL_DEFAULTS.fileNameParameter, null);
        RuleTemplateBo template = KEWServiceLocator.getRuleTemplateService().findByRuleTemplateName(TemplateParserGeneralFixture.VALID_TEMPLATE_WITH_FULL_DEFAULTS.ruleTemplateName);
        List options = template.getRuleTemplateOptions();
        Assert.assertEquals((long)5L, (long)options.size());
        this.assertOptionValue(template, "K", "false");
        this.assertOptionValue(template, "A", "true");
        this.assertOptionValue(template, "C", "false");
        this.assertOptionValue(template, "F", "false");
        this.assertOptionValue(template, "D", "A");
        RuleBaseValues ruleDefaults = KEWServiceLocator.getRuleService().findDefaultRuleByRuleTemplateId(template.getId());
        Assert.assertTrue((boolean)ruleDefaults.getTemplateRuleInd());
        Assert.assertEquals((Object)"Testy Me A Template", (Object)ruleDefaults.getDescription());
        Assert.assertEquals((Object)"01/11/2006", (Object)ruleDefaults.getFromDateString());
        Assert.assertEquals((Object)"01/01/2100", (Object)ruleDefaults.getToDateString());
        Assert.assertTrue((boolean)ruleDefaults.isForceAction());
        Assert.assertFalse((boolean)ruleDefaults.isActive());
    }

    @Test
    public void testLoadValidTemplateWithSomeDefaults() throws Exception {
        this.testTemplate(TemplateParserGeneralFixture.VALID_TEMPLATE_WITH_LIMITED_DEFAULTS.fileNameParameter, null);
        RuleTemplateBo template = KEWServiceLocator.getRuleTemplateService().findByRuleTemplateName(TemplateParserGeneralFixture.VALID_TEMPLATE_WITH_LIMITED_DEFAULTS.ruleTemplateName);
        List options = template.getRuleTemplateOptions();
        Assert.assertEquals((long)5L, (long)options.size());
        this.assertOptionValue(template, "K", "false");
        this.assertOptionValue(template, "A", "true");
        this.assertOptionValue(template, "C", "false");
        this.assertOptionValue(template, "F", "false");
        this.assertOptionValue(template, "D", "A");
        RuleBaseValues ruleDefaults = KEWServiceLocator.getRuleService().findDefaultRuleByRuleTemplateId(template.getId());
        Assert.assertTrue((boolean)ruleDefaults.getTemplateRuleInd());
        Assert.assertEquals((Object)"a rule based on RuleTemplate_Valid_Some_Defaults", (Object)ruleDefaults.getDescription());
        Assert.assertFalse((boolean)ruleDefaults.isForceAction());
        Assert.assertFalse((boolean)ruleDefaults.isActive());
        Assert.assertEquals((Object)"01/11/2006", (Object)ruleDefaults.getFromDateString());
        Assert.assertEquals((Object)"01/01/2100", (Object)ruleDefaults.getToDateString());
        Assert.assertNotNull((Object)ruleDefaults.getActivationDate());
        Assert.assertTrue((new Date(System.currentTimeMillis() - 10000L).before(ruleDefaults.getActivationDate()) && new Date(System.currentTimeMillis() + 100L).after(ruleDefaults.getActivationDate()) ? 1 : 0) != 0);
        Assert.assertNull((Object)ruleDefaults.getDeactivationDate());
    }

    @Test
    public void testLoadValidTemplateWithSomeDefaultsOverwrite() throws Exception {
        this.testTemplate(TemplateParserGeneralFixture.VALID_TEMPLATE_WITH_LIMITED_DEFAULTS.fileNameParameter, null);
        RuleTemplateBo template = KEWServiceLocator.getRuleTemplateService().findByRuleTemplateName(TemplateParserGeneralFixture.VALID_TEMPLATE_WITH_LIMITED_DEFAULTS.ruleTemplateName);
        List options = template.getRuleTemplateOptions();
        Assert.assertEquals((long)5L, (long)options.size());
        this.assertOptionValue(template, "K", "false");
        this.assertOptionValue(template, "A", "true");
        this.assertOptionValue(template, "C", "false");
        this.assertOptionValue(template, "F", "false");
        this.assertOptionValue(template, "D", "A");
        RuleBaseValues ruleDefaults = KEWServiceLocator.getRuleService().findDefaultRuleByRuleTemplateId(template.getId());
        Assert.assertTrue((boolean)ruleDefaults.getTemplateRuleInd());
        Assert.assertEquals((Object)"a rule based on RuleTemplate_Valid_Some_Defaults", (Object)ruleDefaults.getDescription());
        Assert.assertFalse((boolean)ruleDefaults.isForceAction());
        Assert.assertFalse((boolean)ruleDefaults.isActive());
        Assert.assertEquals((Object)"01/11/2006", (Object)ruleDefaults.getFromDateString());
        Assert.assertEquals((Object)"01/01/2100", (Object)ruleDefaults.getToDateString());
        this.testTemplate(TemplateParserGeneralFixture.VALID_TEMPLATE_WITH_LIMITED_DEFAULTS_OVERWRITE.fileNameParameter, null);
        template = KEWServiceLocator.getRuleTemplateService().findByRuleTemplateName(TemplateParserGeneralFixture.VALID_TEMPLATE_WITH_LIMITED_DEFAULTS_OVERWRITE.ruleTemplateName);
        options = template.getRuleTemplateOptions();
        Assert.assertEquals((long)1L, (long)options.size());
        this.assertOptionValue(template, "K", "true");
        ruleDefaults = KEWServiceLocator.getRuleService().findDefaultRuleByRuleTemplateId(template.getId());
        Assert.assertTrue((boolean)ruleDefaults.getTemplateRuleInd());
        Assert.assertEquals((Object)"a rule based on (updated) RuleTemplate_Valid_Some_Defaults", (Object)ruleDefaults.getDescription());
        Assert.assertFalse((boolean)ruleDefaults.isForceAction());
        Assert.assertFalse((boolean)ruleDefaults.isActive());
        Assert.assertNull((Object)ruleDefaults.getFromDateValue());
        Assert.assertNotNull((Object)ruleDefaults.getActivationDate());
        Assert.assertTrue((new Date(System.currentTimeMillis() - 10000L).before(ruleDefaults.getActivationDate()) && new Date(System.currentTimeMillis() + 100L).after(ruleDefaults.getActivationDate()) ? 1 : 0) != 0);
        Assert.assertNull((Object)ruleDefaults.getToDateString());
        Assert.assertNull((Object)ruleDefaults.getDeactivationDate());
    }

    @Test
    public void testLoadValidTemplateWithSomeRemovedDefaults() throws Exception {
        this.testTemplate(TemplateParserGeneralFixture.VALID_TEMPLATE_WITH_LIMITED_DEFAULTS.fileNameParameter, null);
        RuleTemplateBo template = KEWServiceLocator.getRuleTemplateService().findByRuleTemplateName(TemplateParserGeneralFixture.VALID_TEMPLATE_WITH_LIMITED_DEFAULTS.ruleTemplateName);
        List options = template.getRuleTemplateOptions();
        Assert.assertEquals((long)5L, (long)options.size());
        this.assertOptionValue(template, "K", "false");
        this.assertOptionValue(template, "A", "true");
        this.assertOptionValue(template, "C", "false");
        this.assertOptionValue(template, "F", "false");
        this.assertOptionValue(template, "D", "A");
        RuleBaseValues ruleDefaults = KEWServiceLocator.getRuleService().findDefaultRuleByRuleTemplateId(template.getId());
        Assert.assertTrue((boolean)ruleDefaults.getTemplateRuleInd());
        Assert.assertEquals((Object)"a rule based on RuleTemplate_Valid_Some_Defaults", (Object)ruleDefaults.getDescription());
        Assert.assertFalse((boolean)ruleDefaults.isForceAction());
        Assert.assertFalse((boolean)ruleDefaults.isActive());
        Assert.assertEquals((Object)"01/11/2006", (Object)ruleDefaults.getFromDateString());
        Assert.assertEquals((Object)"01/01/2100", (Object)ruleDefaults.getToDateString());
        this.testTemplate(TemplateParserGeneralFixture.VALID_TEMPLATE_WITH_LIMITED_DEFAULTS_REMOVED.fileNameParameter, null);
        template = KEWServiceLocator.getRuleTemplateService().findByRuleTemplateName(TemplateParserGeneralFixture.VALID_TEMPLATE_WITH_LIMITED_DEFAULTS_REMOVED.ruleTemplateName);
        this.assertNoDefaultsSpecified(template);
    }

    @Test
    public void testLoadValidTemplateWithDescriptionDefault() throws Exception {
        this.testTemplate(TemplateParserGeneralFixture.VALID_TEMPLATE_WITH_DESCRIPTION_DEFAULT.fileNameParameter, null);
        RuleTemplateBo template = KEWServiceLocator.getRuleTemplateService().findByRuleTemplateName(TemplateParserGeneralFixture.VALID_TEMPLATE_WITH_DESCRIPTION_DEFAULT.ruleTemplateName);
        List options = template.getRuleTemplateOptions();
        Assert.assertEquals((long)0L, (long)options.size());
        RuleBaseValues ruleDefaults = KEWServiceLocator.getRuleService().findDefaultRuleByRuleTemplateId(template.getId());
        Assert.assertTrue((boolean)ruleDefaults.getTemplateRuleInd());
        Assert.assertEquals((Object)"a description", (Object)ruleDefaults.getDescription());
        Assert.assertFalse((boolean)ruleDefaults.isForceAction());
        Assert.assertFalse((boolean)ruleDefaults.isActive());
        Assert.assertNull((Object)ruleDefaults.getFromDateValue());
        Assert.assertNotNull((Object)ruleDefaults.getActivationDate());
        Assert.assertTrue((new Date(System.currentTimeMillis() - 10000L).before(ruleDefaults.getActivationDate()) && new Date(System.currentTimeMillis() + 100L).after(ruleDefaults.getActivationDate()) ? 1 : 0) != 0);
        Assert.assertNull((Object)ruleDefaults.getToDateString());
        Assert.assertNull((Object)ruleDefaults.getDeactivationDate());
    }

    protected void assertNoDefaultsSpecified(RuleTemplateBo template) {
        this.assertDefaultTemplateOptions(template);
        this.assertDefaultRuleDefaults(template);
    }

    protected void assertDefaultTemplateOptions(RuleTemplateBo template) {
        List options = template.getRuleTemplateOptions();
        Assert.assertEquals((long)0L, (long)options.size());
    }

    protected void assertDefaultRuleDefaults(RuleTemplateBo template) {
        RuleBaseValues ruleDefaults = KEWServiceLocator.getRuleService().findDefaultRuleByRuleTemplateId(template.getId());
        Assert.assertNull((Object)ruleDefaults);
    }

    protected void assertRuleDefaultsArePresent(RuleTemplateBo template, boolean present) {
        for (String key : RuleTemplateBo.DEFAULT_OPTION_KEYS) {
            this.assertOptionPresence(template, key, present);
        }
    }

    protected void assertRuleDefaultsAreNull(RuleTemplateBo template) {
        for (String key : RuleTemplateBo.DEFAULT_OPTION_KEYS) {
            this.assertOptionValue(template, key, null);
        }
    }

    protected void assertOptionPresence(RuleTemplateBo template, String key, boolean present) {
        RuleTemplateOptionBo option = template.getRuleTemplateOption(key);
        if (present) {
            if (option == null) {
                Assert.fail((String)("Rule template option '" + key + "' is not defined on template: " + template));
            }
        } else if (option != null) {
            Assert.fail((String)("Rule template option '" + key + "' is defined on template: " + template));
        }
    }

    protected void assertOptionValue(RuleTemplateBo template, String key, String value) {
        RuleTemplateOptionBo option = template.getRuleTemplateOption(key);
        if (option == null) {
            Assert.fail((String)("Rule template option '" + key + "' not defined on template: " + template));
        }
        Assert.assertEquals((String)("Incorrect rule template option value for key '" + key + "'.  Expected '" + value + "' but found '" + option.getValue() + "'"), (Object)value, (Object)option.getValue());
    }

    @Test
    public void testAttributeActivationAndRemoval() throws Exception {
        RuleTemplateBo template = null;
        int totalAttributes = -1;
        for (TemplateParserAttributeActivationFixture currentEnum : TemplateParserAttributeActivationFixture.values()) {
            String fileNameParameter = "ActivationAttributesTest_" + (currentEnum.ordinal() + 1);
            this.testTemplate(fileNameParameter, null);
            template = KEWServiceLocator.getRuleTemplateService().findByRuleTemplateName("RuleTemplate_Activation_Test");
            Assert.assertEquals((String)"Total Number of Active Attributes from Rule Template is wrong", (long)currentEnum.activeAttributeNames.length, (long)template.getActiveRuleTemplateAttributes().size());
            totalAttributes = currentEnum.activeAttributeNames.length + currentEnum.inactiveAttributeNames.length;
            Assert.assertEquals((String)"Total Number of Attributes from Rule Template is wrong", (long)totalAttributes, (long)template.getRuleTemplateAttributes().size());
            this.testListOfTemplateAttributes(template.getRuleTemplateAttributes(), currentEnum.activeAttributeNames, null);
            this.testAllAttributesActive(template.getActiveRuleTemplateAttributes(), currentEnum.activeAttributeNames);
        }
    }

    private static enum TemplateParserAttributeActivationFixture {
        ATTRIBUTE_1(new String[]{"TemplateTestRuleAttribute1"}, new String[]{"TemplateTestRuleAttribute2"}),
        ATTRIBUTE_2(new String[0], new String[]{"TemplateTestRuleAttribute1", "TemplateTestRuleAttribute2"}),
        ATTRIBUTE_3(new String[]{"TemplateTestRuleAttribute1", "TemplateTestRuleAttribute3"}, new String[]{"TemplateTestRuleAttribute2"}),
        ATTRIBUTE_4(new String[]{"TemplateTestRuleAttribute2", "TemplateTestRuleAttribute5"}, new String[]{"TemplateTestRuleAttribute1", "TemplateTestRuleAttribute3", "TemplateTestRuleAttribute4"});

        public static final String RULE_TEMPLATE_XML_FILENAME_PARM = "ActivationAttributesTest_";
        public static final String RULE_TEMPLATE_NAME = "RuleTemplate_Activation_Test";
        public String[] activeAttributeNames;
        public String[] inactiveAttributeNames;

        private TemplateParserAttributeActivationFixture(String[] activeAttributeNames, String[] inactiveAttributeNames) {
            this.activeAttributeNames = activeAttributeNames;
            this.inactiveAttributeNames = inactiveAttributeNames;
        }
    }

    private static enum TemplateParserGeneralFixture {
        VALID_TEMPLATE_MIN_XML("ValidRuleTemplate", "RuleTemplate_Valid", new String[]{"TemplateTestRuleAttribute1"}, new String[0], new String[]{"TemplateTestRuleAttribute1"}, new String[0]),
        VALID_TEMPLATE_FULL_XML("ValidRuleTemplate_Full", "RuleTemplate_Valid_Full", new String[]{"TemplateTestRuleAttribute1"}, new String[0], new String[]{"TemplateTestRuleAttribute1"}, new String[0]),
        VALID_TEMPLATE_OVERWRITE("ValidRuleTemplateOverwrite", "RuleTemplate_Valid", new String[]{"TemplateTestRuleAttribute1"}, new String[]{"TemplateTestRuleAttribute4"}, new String[]{"TemplateTestRuleAttribute4"}, new String[]{"TemplateTestRuleAttribute1"}),
        VALID_TEMPLATE_FULL_OVERWRITE("ValidRuleTemplateFullOverwrite", "RuleTemplate_Valid_Full", new String[]{"TemplateTestRuleAttribute1"}, new String[]{"TemplateTestRuleAttribute4"}, new String[]{"TemplateTestRuleAttribute4"}, new String[]{"TemplateTestRuleAttribute1"}),
        INVALID_TEMPLATE_OVERWRITE("InvalidRuleTemplateOverwrite", "RuleTemplate_Valid", new String[]{"TemplateTestRuleAttribute1"}, new String[0], new String[]{"TemplateTestRuleAttribute1"}, new String[0]),
        VALID_TEMPLATE_WITH_FULL_DEFAULTS("ValidRuleTemplateWithFullDefaults", "RuleTemplate_Valid_Defaults", new String[]{"TemplateTestRuleAttribute2"}, new String[0], new String[]{"TemplateTestRuleAttribute2"}, new String[0]),
        VALID_TEMPLATE_WITH_LIMITED_DEFAULTS("ValidRuleTemplateWithSomeDefaults", "RuleTemplate_Valid_Some_Defaults", new String[]{"TemplateTestRuleAttribute3"}, new String[0], new String[0], new String[]{"TemplateTestRuleAttribute3"}),
        VALID_TEMPLATE_WITH_LIMITED_DEFAULTS_OVERWRITE("ValidRuleTemplateWithSomeDefaultsOverwrite", "RuleTemplate_Valid_Some_Defaults", new String[]{"TemplateTestRuleAttribute3"}, new String[0], new String[0], new String[]{"TemplateTestRuleAttribute3"}),
        VALID_TEMPLATE_WITH_DESCRIPTION_DEFAULT("ValidRuleTemplateWithDefaultsDescriptionOnly", "RuleTemplate_Valid_Description_Default", new String[]{"TemplateTestRuleAttribute2"}, new String[0], new String[]{"TemplateTestRuleAttribute2"}, new String[0]),
        VALID_TEMPLATE_WITH_LIMITED_DEFAULTS_REMOVED("ValidRuleTemplateWithSomeRemovedDefaultsOverwrite", "RuleTemplate_Valid_Some_Defaults", new String[]{"TemplateTestRuleAttribute3"}, new String[0], new String[0], new String[]{"TemplateTestRuleAttribute3"});

        public String fileNameParameter;
        public String ruleTemplateName;
        public String[] activeAttributeNames;
        public String[] inactiveAttributeNames;
        public String[] requiredAttributeNames;
        public String[] nonRequiredAttributeNames;

        private TemplateParserGeneralFixture(String fileNameParameter, String ruleTemplateName, String[] activeAttributeNames, String[] inactiveAttributeNames, String[] requiredAttributeNames, String[] nonRequiredAttributeNames) {
            this.fileNameParameter = fileNameParameter;
            this.ruleTemplateName = ruleTemplateName;
            this.activeAttributeNames = activeAttributeNames;
            this.inactiveAttributeNames = inactiveAttributeNames;
            this.requiredAttributeNames = requiredAttributeNames;
            this.nonRequiredAttributeNames = nonRequiredAttributeNames;
        }
    }
}

