/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.edl.impl;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import javax.xml.transform.Templates;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.impex.xml.XmlIngestionException;
import org.kuali.rice.coreservice.api.CoreServiceApiServiceLocator;
import org.kuali.rice.coreservice.api.style.Style;
import org.kuali.rice.coreservice.api.style.StyleService;
import org.kuali.rice.edl.impl.bo.EDocLiteAssociation;
import org.kuali.rice.edl.impl.bo.EDocLiteDefinition;
import org.kuali.rice.edl.impl.service.EDocLiteService;
import org.kuali.rice.edl.impl.service.EdlServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kew.test.TestUtilities;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.NONE)
public class EDocLiteServiceImplTest
extends KEWTestCase {
    @Test
    public void testLoadXML() throws FileNotFoundException {
        this.loadXmlFile("EDocLiteContent.xml");
        this.loadXmlFile("edlstyle.xml");
        EDocLiteService edls = EdlServiceLocator.getEDocLiteService();
        StyleService styleService = CoreServiceApiServiceLocator.getStyleService();
        Assert.assertTrue((String)"Definition not found", (boolean)edls.getEDocLiteDefinitions().contains("profile"));
        Style defaultStyle = styleService.getStyle("Default");
        Assert.assertNotNull((String)"Style not found", (Object)defaultStyle);
        Assert.assertEquals((long)1L, (long)edls.getEDocLiteAssociations().size());
        EDocLiteDefinition def = edls.getEDocLiteDefinition("profile");
        Assert.assertNotNull((String)"'profile' definition not found", (Object)def);
        Assert.assertEquals((Object)"profile", (Object)def.getName());
        Assert.assertNotNull((Object)def.getActiveInd());
        Assert.assertTrue((boolean)def.getActiveInd());
        Style style = styleService.getStyle("Default");
        Assert.assertNotNull((String)"'Default' style not found", (Object)style);
        Assert.assertEquals((Object)"Default", (Object)style.getName());
        Assert.assertTrue((boolean)style.isActive());
        Assert.assertNotNull((Object)style.getXmlContent());
    }

    @Test
    public void testLoadBadDefinition() throws FileNotFoundException {
        EDocLiteService edls = EdlServiceLocator.getEDocLiteService();
        try {
            edls.loadXml(TestUtilities.loadResource(((Object)((Object)this)).getClass(), "BadDefinition.xml"), null);
            Assert.fail((String)"BadDefinition was successfully parsed.");
        }
        catch (XmlIngestionException re) {
            Assert.assertTrue((String)"Wrong exception occurred", (boolean)re.getMessage().contains("EDocLite definition contains references to non-existent attributes"));
        }
    }

    @Test
    public void testStoreDefinition() {
        EDocLiteService edls = EdlServiceLocator.getEDocLiteService();
        String defXml = "<edl></edl>";
        try {
            edls.saveEDocLiteDefinition((InputStream)new ByteArrayInputStream(defXml.getBytes()));
            Assert.fail((String)"Storing edl with no name succeeded");
        }
        catch (XmlIngestionException xmlIngestionException) {
            // empty catch block
        }
        defXml = "<edl name=\"test\"></edl>";
        edls.saveEDocLiteDefinition((InputStream)new ByteArrayInputStream(defXml.getBytes()));
        EDocLiteDefinition def = edls.getEDocLiteDefinition("test");
        Assert.assertNotNull((Object)def);
        Assert.assertEquals((Object)"test", (Object)def.getName());
    }

    @Test
    public void testStoreAssociation() {
        EDocLiteService edls = EdlServiceLocator.getEDocLiteService();
        String assocXml = "<association></association>";
        try {
            edls.saveEDocLiteAssociation((InputStream)new ByteArrayInputStream(assocXml.getBytes()));
            Assert.fail((String)"Storing association with no docType succeeded");
        }
        catch (XmlIngestionException xmlIngestionException) {
            // empty catch block
        }
        assocXml = "<association><docType></docType></association>";
        try {
            edls.saveEDocLiteAssociation((InputStream)new ByteArrayInputStream(assocXml.getBytes()));
            Assert.fail((String)"Storing association with empty docType succeeded");
        }
        catch (XmlIngestionException xmlIngestionException) {
            // empty catch block
        }
        assocXml = "<association><docType>foobar</docType></association>";
        edls.saveEDocLiteAssociation((InputStream)new ByteArrayInputStream(assocXml.getBytes()));
        EDocLiteAssociation assoc = edls.getEDocLiteAssociation("foobar");
        Assert.assertNull((String)"Inactive Association was found", (Object)assoc);
        assocXml = "<association><docType>foobar</docType><active>true</active></association>";
        edls.saveEDocLiteAssociation((InputStream)new ByteArrayInputStream(assocXml.getBytes()));
        assoc = edls.getEDocLiteAssociation("foobar");
        Assert.assertNotNull((String)"Association was not found", (Object)assoc);
        Assert.assertEquals((Object)"foobar", (Object)assoc.getEdlName());
        Assert.assertNull((Object)assoc.getDefinition());
        Assert.assertNull((Object)assoc.getStyle());
        List assocs = edls.getEDocLiteAssociations();
        Assert.assertEquals((long)1L, (long)assocs.size());
        assoc = (EDocLiteAssociation)assocs.get(0);
        Assert.assertEquals((Object)"foobar", (Object)assoc.getEdlName());
        Assert.assertNull((Object)assoc.getDefinition());
        Assert.assertNull((Object)assoc.getStyle());
        Assert.assertNotNull((Object)assoc.getActiveInd());
        Assert.assertTrue((boolean)assoc.getActiveInd());
        assocXml = "<association><style>style name</style><definition>definition name</definition><docType>foobar</docType><active>true</active></association>";
        edls.saveEDocLiteAssociation((InputStream)new ByteArrayInputStream(assocXml.getBytes()));
        assoc = edls.getEDocLiteAssociation("foobar");
        Assert.assertNotNull((String)"Association was not found", (Object)assoc);
        Assert.assertEquals((Object)"foobar", (Object)assoc.getEdlName());
        Assert.assertEquals((Object)"definition name", (Object)assoc.getDefinition());
        Assert.assertEquals((Object)"style name", (Object)assoc.getStyle());
        assocs = edls.getEDocLiteAssociations();
        Assert.assertEquals((long)1L, (long)assocs.size());
        assoc = (EDocLiteAssociation)assocs.get(0);
        Assert.assertNotNull((String)"Association was not found", (Object)assoc);
        Assert.assertEquals((Object)"foobar", (Object)assoc.getEdlName());
        Assert.assertEquals((Object)"definition name", (Object)assoc.getDefinition());
        Assert.assertEquals((Object)"style name", (Object)assoc.getStyle());
        Assert.assertNotNull((Object)assoc.getActiveInd());
        Assert.assertTrue((boolean)assoc.getActiveInd());
    }

    @Test
    public void testStyleCaching() throws Exception {
        ConfigContext.getCurrentContextConfig().putProperty("edl.config.loc", "classpath:org/kuali/rice/kew/edl/TestEDLConfig.xml");
        this.loadXmlFile("EDocLiteContent.xml");
        this.loadXmlFile("edlstyle.xml");
        this.loadXmlFile("widgets.xml");
        EDocLiteAssociation association = EdlServiceLocator.getEDocLiteService().getEDocLiteAssociation("EDocLiteDocType");
        Assert.assertNull((String)"We should be using the Default style.", (Object)association.getStyle());
        Templates templates = EdlServiceLocator.getEDocLiteService().getStyleAsTranslet(association.getStyle());
        Assert.assertNotNull((String)"Templates should not be null.", (Object)templates);
        this.loadXmlFile("edlstyle.xml");
        Templates newTemplates = EdlServiceLocator.getEDocLiteService().getStyleAsTranslet(association.getStyle());
        Assert.assertNotNull((String)"Templates should not be null.", (Object)templates);
        Assert.assertFalse((String)"Old Templates should be different from new Templates.", (boolean)templates.equals(newTemplates));
    }
}

