/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.docsearch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.core.api.uif.RemotableAttributeField;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.api.document.DocumentWithContent;
import org.kuali.rice.kew.api.document.attribute.DocumentAttribute;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeContract;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeDataType;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeFactory;
import org.kuali.rice.kew.api.document.attribute.WorkflowAttributeDefinition;
import org.kuali.rice.kew.api.document.search.DocumentSearchCriteria;
import org.kuali.rice.kew.api.document.search.DocumentSearchCriteriaContract;
import org.kuali.rice.kew.api.document.search.DocumentSearchResult;
import org.kuali.rice.kew.api.document.search.DocumentSearchResults;
import org.kuali.rice.kew.api.extension.ExtensionDefinition;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.framework.document.attribute.SearchableAttribute;
import org.kuali.rice.kew.framework.document.search.DocumentSearchCustomizerBase;
import org.kuali.rice.kew.framework.document.search.DocumentSearchResultValue;
import org.kuali.rice.kew.framework.document.search.DocumentSearchResultValues;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;

public class DocumentSearchCustomizerTest
extends KEWTestCase {
    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("DocumentSearchCustomizerTest.xml");
    }

    @Test
    public void testCustomizeCriteria() throws Exception {
        String ewestfal = this.getPrincipalIdForName("ewestfal");
        DocumentSearchCriteria.Builder builder = DocumentSearchCriteria.Builder.create();
        DocumentSearchResults results = KewApiServiceLocator.getWorkflowDocumentService().documentSearch(ewestfal, builder.build());
        Assert.assertTrue((boolean)results.getSearchResults().isEmpty());
        Assert.assertFalse((boolean)results.getCriteria().getDocumentStatuses().contains(DocumentStatus.FINAL));
        builder.setDocumentTypeName("DocumentSearchCustomizerTest");
        results = KewApiServiceLocator.getWorkflowDocumentService().documentSearch(ewestfal, builder.build());
        Assert.assertTrue((boolean)results.getSearchResults().isEmpty());
        DocumentSearchCriteria resultCriteria = results.getCriteria();
        Assert.assertTrue((String)("Document Statuses should have contained FINAL, instead contains: " + resultCriteria.getDocumentStatuses()), (boolean)resultCriteria.getDocumentStatuses().contains(DocumentStatus.FINAL));
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"DocumentSearchCustomizerTest");
        document.route("");
        Assert.assertTrue((boolean)document.isFinal());
        results = KewApiServiceLocator.getWorkflowDocumentService().documentSearch(ewestfal, builder.build());
        Assert.assertEquals((long)1L, (long)results.getSearchResults().size());
        Assert.assertEquals((Object)document.getDocumentId(), (Object)((DocumentSearchResult)results.getSearchResults().get(0)).getDocument().getDocumentId());
    }

    @Test
    public void testCustomizeClearCriteria() throws Exception {
        DocumentType testDocumentType = KEWServiceLocator.getDocumentTypeService().findByName("TestDocumentType");
        Assert.assertNotNull((Object)testDocumentType);
        DocumentType customizedDocumentType = KEWServiceLocator.getDocumentTypeService().findByName("DocumentSearchCustomizerTest");
        Assert.assertNotNull((Object)customizedDocumentType);
        DocumentSearchCriteria.Builder builder = DocumentSearchCriteria.Builder.create();
        builder.setDocumentId("12345");
        builder.setApplicationDocumentId("54321");
        DocumentSearchCriteria clearedCriteria = KEWServiceLocator.getDocumentSearchService().clearCriteria(testDocumentType, builder.build());
        Assert.assertNull((Object)clearedCriteria.getDocumentId());
        Assert.assertNull((Object)clearedCriteria.getApplicationDocumentId());
        clearedCriteria = KEWServiceLocator.getDocumentSearchService().clearCriteria(customizedDocumentType, builder.build());
        Assert.assertNull((Object)clearedCriteria.getDocumentId());
        Assert.assertEquals((Object)"54321", (Object)clearedCriteria.getApplicationDocumentId());
    }

    @Test
    public void testCustomizeResults() throws Exception {
        String ewestfal = this.getPrincipalIdForName("ewestfal");
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"DocumentSearchCustomizerTest");
        document.route("");
        Assert.assertTrue((boolean)document.isFinal());
        List attributeValues = KewApiServiceLocator.getWorkflowDocumentService().getSearchableAttributeStringValuesByKey(document.getDocumentId(), "myAttribute");
        Assert.assertEquals((long)1L, (long)attributeValues.size());
        Assert.assertEquals((Object)"myValue", attributeValues.get(0));
        attributeValues = KewApiServiceLocator.getWorkflowDocumentService().getSearchableAttributeStringValuesByKey(document.getDocumentId(), "myMultiValuedAttribute");
        Assert.assertEquals((long)2L, (long)attributeValues.size());
        Assert.assertTrue((boolean)attributeValues.contains("value1"));
        Assert.assertTrue((boolean)attributeValues.contains("value2"));
        DocumentSearchCriteria.Builder builder = DocumentSearchCriteria.Builder.create();
        DocumentSearchResults results = KewApiServiceLocator.getWorkflowDocumentService().documentSearch(ewestfal, builder.build());
        Assert.assertEquals((long)1L, (long)results.getSearchResults().size());
        DocumentSearchResult result = (DocumentSearchResult)results.getSearchResults().get(0);
        builder.setDocumentTypeName("DocumentSearchCustomizerTest");
        results = KewApiServiceLocator.getWorkflowDocumentService().documentSearch(ewestfal, builder.build());
        Assert.assertEquals((long)1L, (long)results.getSearchResults().size());
        result = (DocumentSearchResult)results.getSearchResults().get(0);
        Assert.assertEquals((long)3L, (long)result.getDocumentAttributes().size());
        for (DocumentAttribute attribute : result.getDocumentAttributes()) {
            if (attribute.getName().equals("myAttribute")) {
                Assert.assertEquals((Object)"myAttribute", (Object)attribute.getName());
                Assert.assertEquals((Object)"myCustomizedValue", (Object)attribute.getValue());
                Assert.assertEquals((Object)DocumentAttributeDataType.STRING, (Object)attribute.getDataType());
                continue;
            }
            if (attribute.getName().equals("myMultiValuedAttribute")) {
                Assert.assertEquals((Object)"myMultiValuedAttribute", (Object)attribute.getName());
                Assert.assertEquals((Object)"value0", (Object)attribute.getValue());
                Assert.assertEquals((Object)DocumentAttributeDataType.STRING, (Object)attribute.getDataType());
                continue;
            }
            if (attribute.getName().equals("criteriaUserId")) {
                Assert.assertEquals((Object)"criteriaUserId", (Object)attribute.getName());
                Assert.assertEquals((Object)ewestfal, (Object)attribute.getValue());
                continue;
            }
            Assert.fail((String)("Encountered an attribute name which i didn't understand: " + attribute.getName()));
        }
    }

    public static final class CustomSearchAttribute
    implements SearchableAttribute {
        public String generateSearchContent(ExtensionDefinition extensionDefinition, String documentTypeName, WorkflowAttributeDefinition attributeDefinition) {
            return null;
        }

        public List<DocumentAttribute> extractDocumentAttributes(ExtensionDefinition extensionDefinition, DocumentWithContent documentWithContent) {
            ArrayList<DocumentAttribute> attributes = new ArrayList<DocumentAttribute>();
            attributes.add((DocumentAttribute)DocumentAttributeFactory.createStringAttribute((String)"myAttribute", (String)"myValue"));
            attributes.add((DocumentAttribute)DocumentAttributeFactory.createStringAttribute((String)"myMultiValuedAttribute", (String)"value1"));
            attributes.add((DocumentAttribute)DocumentAttributeFactory.createStringAttribute((String)"myMultiValuedAttribute", (String)"value2"));
            attributes.add((DocumentAttribute)DocumentAttributeFactory.createStringAttribute((String)"criteriaUserId", (String)"blank"));
            return attributes;
        }

        public List<RemotableAttributeField> getSearchFields(ExtensionDefinition extensionDefinition, String documentTypeName) {
            ArrayList<RemotableAttributeField> searchFields = new ArrayList<RemotableAttributeField>();
            RemotableAttributeField.Builder builder = RemotableAttributeField.Builder.create((String)"myAttribute");
            searchFields.add(builder.build());
            builder = RemotableAttributeField.Builder.create((String)"myMultiValuedAttribute");
            searchFields.add(builder.build());
            builder = RemotableAttributeField.Builder.create((String)"criteriaUserId");
            searchFields.add(builder.build());
            return searchFields;
        }

        public List<RemotableAttributeError> validateDocumentAttributeCriteria(ExtensionDefinition extensionDefinition, DocumentSearchCriteria documentSearchCriteria) {
            return null;
        }
    }

    public static final class Customizer
    extends DocumentSearchCustomizerBase {
        public DocumentSearchCriteria customizeCriteria(DocumentSearchCriteria documentSearchCriteria) {
            DocumentSearchCriteria.Builder builder = DocumentSearchCriteria.Builder.create((DocumentSearchCriteriaContract)documentSearchCriteria);
            builder.setDocumentStatuses(Collections.singletonList(DocumentStatus.FINAL));
            return builder.build();
        }

        public boolean isCustomizeCriteriaEnabled(String documentTypeName) {
            return true;
        }

        public DocumentSearchCriteria customizeClearCriteria(DocumentSearchCriteria documentSearchCriteria) {
            DocumentSearchCriteria.Builder builder = DocumentSearchCriteria.Builder.create();
            builder.setApplicationDocumentId(documentSearchCriteria.getApplicationDocumentId());
            return builder.build();
        }

        public boolean isCustomizeClearCriteriaEnabled(String documentTypeName) {
            return true;
        }

        public DocumentSearchResultValues customizeResults(DocumentSearchCriteria documentSearchCriteria, List<DocumentSearchResult> defaultResults) {
            if (defaultResults.size() == 1) {
                Assert.assertEquals((long)1L, (long)defaultResults.size());
                DocumentSearchResultValues.Builder valuesBuilder = DocumentSearchResultValues.Builder.create();
                DocumentSearchResultValue.Builder resultValueBuilder = DocumentSearchResultValue.Builder.create((String)defaultResults.get(0).getDocument().getDocumentId());
                resultValueBuilder.getDocumentAttributes().add(DocumentAttributeFactory.loadContractIntoBuilder((DocumentAttributeContract)DocumentAttributeFactory.createStringAttribute((String)"myAttribute", (String)"myCustomizedValue")));
                resultValueBuilder.getDocumentAttributes().add(DocumentAttributeFactory.loadContractIntoBuilder((DocumentAttributeContract)DocumentAttributeFactory.createStringAttribute((String)"myMultiValuedAttribute", (String)"value0")));
                if (StringUtils.isNotBlank((String)documentSearchCriteria.getDocSearchUserId())) {
                    resultValueBuilder.getDocumentAttributes().add(DocumentAttributeFactory.loadContractIntoBuilder((DocumentAttributeContract)DocumentAttributeFactory.createStringAttribute((String)"criteriaUserId", (String)documentSearchCriteria.getDocSearchUserId())));
                }
                valuesBuilder.getResultValues().add(resultValueBuilder);
                return valuesBuilder.build();
            }
            return null;
        }

        public boolean isCustomizeResultsEnabled(String documentTypeName) {
            return true;
        }
    }
}

