/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.role;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.delegation.DelegationType;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.action.ActionRequestPolicy;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.role.RoleMembership;
import org.kuali.rice.kim.api.role.RoleResponsibilityAction;
import org.kuali.rice.kim.api.role.RoleResponsibilityActionContract;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.impl.common.attribute.KimAttributeBo;
import org.kuali.rice.kim.impl.common.delegate.DelegateMemberBo;
import org.kuali.rice.kim.impl.common.delegate.DelegateTypeBo;
import org.kuali.rice.kim.impl.responsibility.ResponsibilityAttributeBo;
import org.kuali.rice.kim.impl.responsibility.ResponsibilityBo;
import org.kuali.rice.kim.impl.responsibility.ResponsibilityTemplateBo;
import org.kuali.rice.kim.impl.role.RoleBo;
import org.kuali.rice.kim.impl.role.RoleMemberAttributeDataBo;
import org.kuali.rice.kim.impl.role.RoleMemberBo;
import org.kuali.rice.kim.impl.role.RoleResponsibilityActionBo;
import org.kuali.rice.kim.impl.role.RoleResponsibilityBo;
import org.kuali.rice.kim.impl.type.KimTypeAttributeBo;
import org.kuali.rice.kim.impl.type.KimTypeBo;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.test.BaselineTestCase;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public class RoleRouteModuleTest
extends KEWTestCase {
    private static final String NAMESPACE = "KR-WKFLW";
    private static final String ROLE_NAME = "RoleRouteModuleTestRole";
    private static boolean suiteDataInitialized = false;
    private static boolean suiteCreateDelegateInitialized = false;

    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("RoleRouteModuleTestConfig.xml");
        if (suiteDataInitialized) {
            return;
        }
        Long chartAttributeId = this.getNextSequenceLongValue("KRIM_ATTR_DEFN_ID_S");
        KimAttributeBo chartAttribute = new KimAttributeBo();
        chartAttribute.setId("" + chartAttributeId);
        chartAttribute.setAttributeName("chart");
        chartAttribute.setComponentName("org.kuali.rice.kim.bo.impl.KimAttributes");
        chartAttribute.setNamespaceCode(NAMESPACE);
        chartAttribute.setAttributeLabel("chart");
        chartAttribute.setActive(true);
        chartAttribute = (KimAttributeBo)KradDataServiceLocator.getDataObjectService().save((Object)chartAttribute, new PersistenceOption[0]);
        Long orgAttributeId = this.getNextSequenceLongValue("KRIM_ATTR_DEFN_ID_S");
        KimAttributeBo orgAttribute = new KimAttributeBo();
        orgAttribute.setId("" + orgAttributeId);
        orgAttribute.setComponentName("org.kuali.rice.kim.bo.impl.KimAttributes");
        orgAttribute.setAttributeName("org");
        orgAttribute.setNamespaceCode(NAMESPACE);
        orgAttribute.setAttributeLabel("org");
        orgAttribute.setActive(true);
        orgAttribute = (KimAttributeBo)KradDataServiceLocator.getDataObjectService().save((Object)orgAttribute, new PersistenceOption[0]);
        Long kimTypeId = this.getNextSequenceLongValue("KRIM_TYP_ID_S");
        KimTypeBo kimType = new KimTypeBo();
        kimType.setId("" + kimTypeId);
        kimType.setName("ChartOrg");
        kimType.setNamespaceCode(NAMESPACE);
        kimType.setServiceName("testBaseRoleTypeService");
        kimType.setActive(true);
        kimType = (KimTypeBo)KradDataServiceLocator.getDataObjectService().save((Object)kimType, new PersistenceOption[0]);
        Long chartTypeAttributeId = this.getNextSequenceLongValue("KRIM_TYP_ATTR_ID_S");
        KimTypeAttributeBo chartTypeAttribute = new KimTypeAttributeBo();
        chartTypeAttribute.setId("" + chartTypeAttributeId);
        chartTypeAttribute.setActive(true);
        chartTypeAttribute.setKimAttributeId(chartAttribute.getId());
        chartTypeAttribute.setKimTypeId(kimType.getId());
        chartTypeAttribute = (KimTypeAttributeBo)KradDataServiceLocator.getDataObjectService().save((Object)chartTypeAttribute, new PersistenceOption[0]);
        Long orgTypeAttributeId = this.getNextSequenceLongValue("KRIM_TYP_ATTR_ID_S");
        KimTypeAttributeBo orgTypeAttribute = new KimTypeAttributeBo();
        orgTypeAttribute.setId("" + orgTypeAttributeId);
        orgTypeAttribute.setActive(true);
        orgTypeAttribute.setKimAttributeId(orgAttribute.getId());
        orgTypeAttribute.setKimTypeId(kimType.getId());
        orgTypeAttribute = (KimTypeAttributeBo)KradDataServiceLocator.getDataObjectService().save((Object)orgTypeAttribute, new PersistenceOption[0]);
        String roleId = "" + this.getNextSequenceLongValue("KRIM_ROLE_ID_S");
        RoleBo role = new RoleBo();
        role.setId(roleId);
        role.setNamespaceCode(NAMESPACE);
        role.setDescription("");
        role.setName(ROLE_NAME);
        role.setActive(true);
        role.setKimTypeId(kimType.getId());
        String roleMemberId1 = "" + this.getNextSequenceLongValue("KRIM_ROLE_MBR_ID_S");
        RoleMemberBo adminRolePrincipal = new RoleMemberBo();
        adminRolePrincipal.setId(roleMemberId1);
        adminRolePrincipal.setRoleId(roleId);
        Principal adminPrincipal = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName("admin");
        Assert.assertNotNull((Object)adminPrincipal);
        adminRolePrincipal.setMemberId(adminPrincipal.getPrincipalId());
        adminRolePrincipal.setType(MemberType.PRINCIPAL);
        String roleMemberId2 = "" + this.getNextSequenceLongValue("KRIM_ROLE_MBR_ID_S");
        RoleMemberBo user2RolePrincipal = new RoleMemberBo();
        user2RolePrincipal.setId(roleMemberId2);
        user2RolePrincipal.setRoleId(roleId);
        Principal user2Principal = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName("user2");
        Assert.assertNotNull((Object)user2Principal);
        user2RolePrincipal.setMemberId(user2Principal.getPrincipalId());
        user2RolePrincipal.setType(MemberType.PRINCIPAL);
        String roleMemberId3 = "" + this.getNextSequenceLongValue("KRIM_ROLE_MBR_ID_S");
        RoleMemberBo user1RolePrincipal = new RoleMemberBo();
        user1RolePrincipal.setId(roleMemberId3);
        user1RolePrincipal.setRoleId(roleId);
        Principal user1Principal = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName("user1");
        Assert.assertNotNull((Object)user1Principal);
        user1RolePrincipal.setMemberId(user1Principal.getPrincipalId());
        user1RolePrincipal.setType(MemberType.PRINCIPAL);
        ArrayList<RoleMemberBo> memberPrincipals = new ArrayList<RoleMemberBo>();
        memberPrincipals.add(adminRolePrincipal);
        memberPrincipals.add(user2RolePrincipal);
        memberPrincipals.add(user1RolePrincipal);
        role.setMembers(memberPrincipals);
        String dataId = "" + this.getNextSequenceLongValue("KRIM_GRP_ATTR_DATA_ID_S");
        RoleMemberAttributeDataBo chartDataBL = new RoleMemberAttributeDataBo();
        chartDataBL.setId(dataId);
        chartDataBL.setAttributeValue("BL");
        chartDataBL.setKimAttribute(chartAttribute);
        chartDataBL.setKimAttributeId(chartAttribute.getId());
        chartDataBL.setKimTypeId(kimType.getId());
        chartDataBL.setAssignedToId(adminRolePrincipal.getId());
        dataId = "" + this.getNextSequenceLongValue("KRIM_GRP_ATTR_DATA_ID_S");
        RoleMemberAttributeDataBo chartDataBL2 = new RoleMemberAttributeDataBo();
        chartDataBL2.setId(dataId);
        chartDataBL2.setAttributeValue("BL");
        chartDataBL2.setKimAttribute(chartAttribute);
        chartDataBL2.setKimAttributeId(chartAttribute.getId());
        chartDataBL2.setKimTypeId(kimType.getId());
        chartDataBL2.setAssignedToId(user2RolePrincipal.getId());
        dataId = "" + this.getNextSequenceLongValue("KRIM_GRP_ATTR_DATA_ID_S");
        RoleMemberAttributeDataBo orgDataBUS = new RoleMemberAttributeDataBo();
        orgDataBUS.setId(dataId);
        orgDataBUS.setAttributeValue("BUS");
        orgDataBUS.setKimAttribute(orgAttribute);
        orgDataBUS.setKimAttributeId(orgAttribute.getId());
        orgDataBUS.setKimTypeId(kimType.getId());
        orgDataBUS.setAssignedToId(adminRolePrincipal.getId());
        dataId = "" + this.getNextSequenceLongValue("KRIM_GRP_ATTR_DATA_ID_S");
        RoleMemberAttributeDataBo orgDataBUS2 = new RoleMemberAttributeDataBo();
        orgDataBUS2.setId(dataId);
        orgDataBUS2.setAttributeValue("BUS");
        orgDataBUS2.setKimAttribute(orgAttribute);
        orgDataBUS2.setKimAttributeId(orgAttribute.getId());
        orgDataBUS2.setKimTypeId(kimType.getId());
        orgDataBUS2.setAssignedToId(user2RolePrincipal.getId());
        dataId = "" + this.getNextSequenceLongValue("KRIM_GRP_ATTR_DATA_ID_S");
        RoleMemberAttributeDataBo chartDataIN = new RoleMemberAttributeDataBo();
        chartDataIN.setId(dataId);
        chartDataIN.setAttributeValue("IN");
        chartDataIN.setKimAttribute(chartAttribute);
        chartDataIN.setKimAttributeId(chartAttribute.getId());
        chartDataIN.setKimTypeId(kimType.getId());
        chartDataIN.setAssignedToId(user1RolePrincipal.getId());
        dataId = "" + this.getNextSequenceLongValue("KRIM_GRP_ATTR_DATA_ID_S");
        RoleMemberAttributeDataBo orgDataMED = new RoleMemberAttributeDataBo();
        orgDataMED.setId(dataId);
        orgDataMED.setAttributeValue("MED");
        orgDataMED.setKimAttribute(orgAttribute);
        orgDataMED.setKimAttributeId(orgAttribute.getId());
        orgDataMED.setKimTypeId(kimType.getId());
        orgDataMED.setAssignedToId(user1RolePrincipal.getId());
        ArrayList<RoleMemberAttributeDataBo> user1Attributes = new ArrayList<RoleMemberAttributeDataBo>();
        user1Attributes.add(chartDataIN);
        user1Attributes.add(orgDataMED);
        user1RolePrincipal.setAttributeDetails(user1Attributes);
        ArrayList<RoleMemberAttributeDataBo> user2Attributes = new ArrayList<RoleMemberAttributeDataBo>();
        user2Attributes.add(chartDataBL2);
        user2Attributes.add(orgDataBUS2);
        user2RolePrincipal.setAttributeDetails(user2Attributes);
        ArrayList<RoleMemberAttributeDataBo> adminAttributes = new ArrayList<RoleMemberAttributeDataBo>();
        adminAttributes.add(chartDataBL);
        adminAttributes.add(orgDataBUS);
        adminRolePrincipal.setAttributeDetails(adminAttributes);
        role = (RoleBo)KradDataServiceLocator.getDataObjectService().save((Object)role, new PersistenceOption[0]);
        Long documentTypeAttributeId = this.getNextSequenceLongValue("KRIM_ATTR_DEFN_ID_S");
        KimAttributeBo documentTypeAttribute = new KimAttributeBo();
        documentTypeAttribute.setId("" + documentTypeAttributeId);
        documentTypeAttribute.setAttributeName("documentTypeName");
        documentTypeAttribute.setNamespaceCode(NAMESPACE);
        documentTypeAttribute.setAttributeLabel("documentType");
        documentTypeAttribute.setActive(true);
        documentTypeAttribute = (KimAttributeBo)KradDataServiceLocator.getDataObjectService().save((Object)documentTypeAttribute, new PersistenceOption[0]);
        Long nodeNameAttributeId = this.getNextSequenceLongValue("KRIM_ATTR_DEFN_ID_S");
        KimAttributeBo nodeNameAttribute = new KimAttributeBo();
        nodeNameAttribute.setId("" + nodeNameAttributeId);
        nodeNameAttribute.setAttributeName("routeNodeName");
        nodeNameAttribute.setNamespaceCode(NAMESPACE);
        nodeNameAttribute.setAttributeLabel("nodeName");
        nodeNameAttribute.setActive(true);
        nodeNameAttribute = (KimAttributeBo)KradDataServiceLocator.getDataObjectService().save((Object)nodeNameAttribute, new PersistenceOption[0]);
        Long kimRespTypeId = this.getNextSequenceLongValue("KRIM_TYP_ID_S");
        KimTypeBo kimRespType = new KimTypeBo();
        kimRespType.setId("" + kimRespTypeId);
        kimRespType.setName("RespDetails");
        kimRespType.setNamespaceCode(NAMESPACE);
        kimRespType.setServiceName("testBaseResponsibilityTypeService");
        kimRespType.setActive(true);
        kimRespType = (KimTypeBo)KradDataServiceLocator.getDataObjectService().save((Object)kimRespType, new PersistenceOption[0]);
        Long documentTypeTypeAttributeId = this.getNextSequenceLongValue("KRIM_TYP_ATTR_ID_S");
        KimTypeAttributeBo documentTypeTypeAttribute = new KimTypeAttributeBo();
        documentTypeTypeAttribute.setId("" + documentTypeTypeAttributeId);
        documentTypeTypeAttribute.setActive(true);
        documentTypeTypeAttribute.setKimAttributeId(chartAttribute.getId());
        documentTypeTypeAttribute.setKimTypeId(kimType.getId());
        documentTypeTypeAttribute.setSortCode("a");
        documentTypeTypeAttribute = (KimTypeAttributeBo)KradDataServiceLocator.getDataObjectService().save((Object)documentTypeTypeAttribute, new PersistenceOption[0]);
        Long nodeNameTypeAttributeId = this.getNextSequenceLongValue("KRIM_TYP_ATTR_ID_S");
        KimTypeAttributeBo nodeNameTypeAttribute = new KimTypeAttributeBo();
        nodeNameTypeAttribute.setId("" + nodeNameTypeAttributeId);
        nodeNameTypeAttribute.setActive(true);
        nodeNameTypeAttribute.setKimAttributeId(orgAttribute.getId());
        nodeNameTypeAttribute.setKimTypeId(kimType.getId());
        nodeNameTypeAttribute.setSortCode("a");
        nodeNameTypeAttribute = (KimTypeAttributeBo)KradDataServiceLocator.getDataObjectService().save((Object)nodeNameTypeAttribute, new PersistenceOption[0]);
        this.createResponsibilityForRoleRouteModuleTest(role, documentTypeAttribute, nodeNameAttribute, kimRespType, user1RolePrincipal, user2RolePrincipal, adminRolePrincipal, "FirstApproveReview", "RoleRouteModuleTest1", "resp1", "VoluntaryReview1", ActionRequestPolicy.FIRST);
        this.createResponsibilityForRoleRouteModuleTest(role, documentTypeAttribute, nodeNameAttribute, kimRespType, user1RolePrincipal, user2RolePrincipal, adminRolePrincipal, "AllApproveReview", "RoleRouteModuleTest2", "resp2", "VoluntaryReview2", ActionRequestPolicy.ALL);
        suiteDataInitialized = true;
    }

    private void createResponsibilityForRoleRouteModuleTest(RoleBo role, KimAttributeBo documentTypeAttribute, KimAttributeBo nodeNameAttribute, KimTypeBo kimRespType, RoleMemberBo user1RolePrincipal, RoleMemberBo user2RolePrincipal, RoleMemberBo adminRolePrincipal, String templateName, String docTypeDetailValue, String responsibilityName, String responsibilityDesc, ActionRequestPolicy actionRequestPolicy) {
        String templateId = String.valueOf(this.getNextSequenceLongValue("KRIM_RSP_TMPL_ID_S"));
        ResponsibilityTemplateBo template = new ResponsibilityTemplateBo();
        template.setId(templateId);
        template.setNamespaceCode(NAMESPACE);
        template.setName(templateName);
        template.setKimTypeId(kimRespType.getId());
        template.setActive(true);
        template.setDescription("description");
        template = (ResponsibilityTemplateBo)KradDataServiceLocator.getDataObjectService().save((Object)template, new PersistenceOption[0]);
        String responsibilityId = "" + this.getNextSequenceLongValue("KRIM_ROLE_RSP_ID_S");
        String dataId = "" + this.getNextSequenceLongValue("KRIM_GRP_ATTR_DATA_ID_S");
        ResponsibilityAttributeBo documentTypeDetail = new ResponsibilityAttributeBo();
        documentTypeDetail.setId(dataId);
        documentTypeDetail.setAttributeValue(docTypeDetailValue);
        documentTypeDetail.setKimAttribute(documentTypeAttribute);
        documentTypeDetail.setKimAttributeId(documentTypeAttribute.getId());
        documentTypeDetail.setKimTypeId(kimRespType.getId());
        documentTypeDetail.setAssignedToId(responsibilityId);
        dataId = "" + this.getNextSequenceLongValue("KRIM_GRP_ATTR_DATA_ID_S");
        ResponsibilityAttributeBo nodeNameDetail = new ResponsibilityAttributeBo();
        nodeNameDetail.setId(dataId);
        nodeNameDetail.setAttributeValue("Role1");
        nodeNameDetail.setKimAttribute(nodeNameAttribute);
        nodeNameDetail.setKimAttributeId(nodeNameAttribute.getId());
        nodeNameDetail.setKimTypeId(kimRespType.getId());
        nodeNameDetail.setAssignedToId(responsibilityId);
        ArrayList<ResponsibilityAttributeBo> detailObjects = new ArrayList<ResponsibilityAttributeBo>();
        detailObjects.add(documentTypeDetail);
        detailObjects.add(nodeNameDetail);
        ResponsibilityBo responsibility = new ResponsibilityBo();
        responsibility.setActive(true);
        responsibility.setDescription(responsibilityDesc);
        responsibility.setAttributeDetails(detailObjects);
        responsibility.setName(responsibilityName);
        responsibility.setNamespaceCode(NAMESPACE);
        responsibility.setId(responsibilityId);
        responsibility.setTemplate(template);
        responsibility.setTemplateId(template.getId());
        responsibility = (ResponsibilityBo)KradDataServiceLocator.getDataObjectService().save((Object)responsibility, new PersistenceOption[0]);
        String roleResponsibilityId = "" + this.getNextSequenceLongValue("KRIM_ROLE_RSP_ID_S");
        RoleResponsibilityBo roleResponsibility = new RoleResponsibilityBo();
        roleResponsibility.setRoleResponsibilityId(roleResponsibilityId);
        roleResponsibility.setActive(true);
        roleResponsibility.setResponsibilityId(responsibilityId);
        roleResponsibility.setRoleId(role.getId());
        roleResponsibility = (RoleResponsibilityBo)KradDataServiceLocator.getDataObjectService().save((Object)roleResponsibility, new PersistenceOption[0]);
        String roleResponsibilityActionId = "" + this.getNextSequenceLongValue("KRIM_ROLE_RSP_ACTN_ID_S");
        RoleResponsibilityActionBo roleResponsibilityAction1 = new RoleResponsibilityActionBo();
        roleResponsibilityAction1.setId(roleResponsibilityActionId);
        roleResponsibilityAction1.setRoleResponsibilityId(roleResponsibilityId);
        roleResponsibilityAction1.setRoleMemberId(user1RolePrincipal.getId());
        roleResponsibilityAction1.setActionTypeCode("A");
        roleResponsibilityAction1.setActionPolicyCode(actionRequestPolicy.getCode());
        roleResponsibilityAction1.setPriorityNumber(Integer.valueOf(1));
        roleResponsibilityAction1.setForceAction(true);
        roleResponsibilityAction1 = (RoleResponsibilityActionBo)KradDataServiceLocator.getDataObjectService().save((Object)roleResponsibilityAction1, new PersistenceOption[0]);
        roleResponsibilityActionId = "" + this.getNextSequenceLongValue("KRIM_ROLE_RSP_ACTN_ID_S");
        RoleResponsibilityActionBo roleResponsibilityAction2 = new RoleResponsibilityActionBo();
        roleResponsibilityAction2.setId(roleResponsibilityActionId);
        roleResponsibilityAction2.setRoleResponsibilityId(roleResponsibilityId);
        roleResponsibilityAction2.setRoleMemberId(user2RolePrincipal.getId());
        roleResponsibilityAction2.setActionTypeCode("A");
        roleResponsibilityAction2.setActionPolicyCode(actionRequestPolicy.getCode());
        roleResponsibilityAction2.setPriorityNumber(Integer.valueOf(1));
        roleResponsibilityAction2.setForceAction(true);
        roleResponsibilityAction2 = (RoleResponsibilityActionBo)KradDataServiceLocator.getDataObjectService().save((Object)roleResponsibilityAction2, new PersistenceOption[0]);
        roleResponsibilityActionId = "" + this.getNextSequenceLongValue("KRIM_ROLE_RSP_ACTN_ID_S");
        RoleResponsibilityActionBo roleResponsibilityAction3 = new RoleResponsibilityActionBo();
        roleResponsibilityAction3.setId(roleResponsibilityActionId);
        roleResponsibilityAction3.setRoleResponsibilityId(roleResponsibilityId);
        roleResponsibilityAction3.setRoleMemberId(adminRolePrincipal.getId());
        roleResponsibilityAction3.setActionTypeCode("A");
        roleResponsibilityAction3.setActionPolicyCode(actionRequestPolicy.getCode());
        roleResponsibilityAction3.setPriorityNumber(Integer.valueOf(1));
        roleResponsibilityAction3.setForceAction(true);
        roleResponsibilityAction3 = (RoleResponsibilityActionBo)KradDataServiceLocator.getDataObjectService().save((Object)roleResponsibilityAction3, new PersistenceOption[0]);
    }

    private void createDelegate() {
        if (suiteCreateDelegateInitialized) {
            return;
        }
        Long kimDlgnTypeId = this.getNextSequenceLongValue("KRIM_TYP_ID_S");
        KimTypeBo kimDlgnType = new KimTypeBo();
        kimDlgnType.setId("" + kimDlgnTypeId);
        kimDlgnType.setName("TestBaseDelegationType");
        kimDlgnType.setNamespaceCode(NAMESPACE);
        kimDlgnType.setServiceName("testBaseDelegationTypeService");
        kimDlgnType.setActive(true);
        kimDlgnType = (KimTypeBo)KradDataServiceLocator.getDataObjectService().save((Object)kimDlgnType, new PersistenceOption[0]);
        String id = "" + this.getNextSequenceLongValue("KRIM_DLGN_MBR_ID_S");
        DelegateTypeBo delegate = new DelegateTypeBo();
        delegate.setDelegationId(id);
        delegate.setDelegationType(DelegationType.PRIMARY);
        delegate.setActive(true);
        delegate.setKimTypeId("" + kimDlgnTypeId);
        Role role = KimApiServiceLocator.getRoleService().getRoleByNamespaceCodeAndName(NAMESPACE, ROLE_NAME);
        Assert.assertNotNull((String)"Role should exist.", (Object)role);
        delegate.setRoleId(role.getId());
        delegate = (DelegateTypeBo)KradDataServiceLocator.getDataObjectService().save((Object)delegate, new PersistenceOption[0]);
        String delgMemberId = "" + this.getNextSequenceLongValue("KRIM_DLGN_MBR_ID_S");
        DelegateMemberBo user1RoleDelegate = new DelegateMemberBo();
        user1RoleDelegate.setDelegationMemberId(delgMemberId);
        Principal kPrincipal = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName("ewestfal");
        Assert.assertNotNull((Object)kPrincipal);
        user1RoleDelegate.setMemberId(kPrincipal.getPrincipalId());
        user1RoleDelegate.setType(MemberType.PRINCIPAL);
        user1RoleDelegate.setDelegationId(delegate.getDelegationId());
        user1RoleDelegate = (DelegateMemberBo)KradDataServiceLocator.getDataObjectService().save((Object)user1RoleDelegate, new PersistenceOption[0]);
        suiteCreateDelegateInitialized = true;
    }

    @Test
    public void testRoleRouteModule_FirstApprove() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"RoleRouteModuleTest1");
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("admin"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Approval should be requested.", (boolean)document.isApprovalRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user1"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Approval should be requested.", (boolean)document.isApprovalRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user2"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Approval should be requested.", (boolean)document.isApprovalRequested());
        List actionRequests = KewApiServiceLocator.getWorkflowDocumentService().getRootActionRequests(document.getDocumentId());
        Assert.assertEquals((String)"Should have 3 action requests.", (long)3L, (long)actionRequests.size());
        int numRoots = 0;
        for (ActionRequest actionRequest : actionRequests) {
            if (actionRequest.getRequestPolicy() != null) {
                Assert.assertEquals((Object)ActionRequestPolicy.FIRST, (Object)actionRequest.getRequestPolicy());
            }
            if (actionRequest.getParentActionRequestId() != null) continue;
            ++numRoots;
        }
        Assert.assertEquals((String)"There should have been 3 root requests.", (long)3L, (long)numRoots);
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user1"), (String)document.getDocumentId());
        document.approve("");
        Assert.assertTrue((String)"Document should be ENROUTE.", (boolean)document.isEnroute());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("admin"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Approval should be requested.", (boolean)document.isApprovalRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user2"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Approval should be requested.", (boolean)document.isApprovalRequested());
        document.approve("");
        Assert.assertTrue((String)"Document should be ENROUTE.", (boolean)document.isEnroute());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("admin"), (String)document.getDocumentId());
        document.approve("");
        Assert.assertTrue((String)"Document should be FINAL.", (boolean)document.isFinal());
    }

    @Test
    public void testRoleRouteModule_AllApprove() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"RoleRouteModuleTest2");
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("admin"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Approval should be requested.", (boolean)document.isApprovalRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user1"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Approval should be requested.", (boolean)document.isApprovalRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user2"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Approval should be requested.", (boolean)document.isApprovalRequested());
        List actionRequests = KewApiServiceLocator.getWorkflowDocumentService().getRootActionRequests(document.getDocumentId());
        Assert.assertEquals((String)"Should have 3 action requests.", (long)3L, (long)actionRequests.size());
        int numRoots = 0;
        for (ActionRequest actionRequest : actionRequests) {
            Assert.assertNotNull((Object)actionRequest.getRequestPolicy());
            Assert.assertEquals((Object)ActionRequestPolicy.FIRST, (Object)actionRequest.getRequestPolicy());
            if (actionRequest.getParentActionRequestId() != null) continue;
            ++numRoots;
        }
        Assert.assertEquals((String)"There should have been 3 root requests.", (long)3L, (long)numRoots);
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user1"), (String)document.getDocumentId());
        document.approve("");
        Assert.assertTrue((String)"Document should still be enroute.", (boolean)document.isEnroute());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("admin"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Approval should be requested.", (boolean)document.isApprovalRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user2"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Approval should be requested.", (boolean)document.isApprovalRequested());
        document.approve("");
        Assert.assertTrue((String)"Document should be ENROUTE.", (boolean)document.isEnroute());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("admin"), (String)document.getDocumentId());
        document.approve("");
        Assert.assertTrue((String)"Document should be FINAL.", (boolean)document.isFinal());
    }

    @Test
    public void testRoleRouteModule_RoleResponsibilityActionUpdate() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"RoleRouteModuleTest1");
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("admin"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Approval should be requested.", (boolean)document.isApprovalRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user1"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Approval should be requested.", (boolean)document.isApprovalRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user2"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Approval should be requested.", (boolean)document.isApprovalRequested());
        List actionRequests = KewApiServiceLocator.getWorkflowDocumentService().getRootActionRequests(document.getDocumentId());
        Assert.assertEquals((String)"Should have 3 action requests.", (long)3L, (long)actionRequests.size());
        int numRoots = 0;
        for (ActionRequest actionRequest : actionRequests) {
            if (actionRequest.getRequestPolicy() != null) {
                Assert.assertEquals((Object)ActionRequestPolicy.FIRST, (Object)actionRequest.getRequestPolicy());
            }
            if (actionRequest.getParentActionRequestId() != null) continue;
            ++numRoots;
        }
        Assert.assertEquals((String)"There should have been 3 root requests.", (long)3L, (long)numRoots);
        RoleService roleService = KimApiServiceLocator.getRoleService();
        Role role = roleService.getRoleByNamespaceCodeAndName(NAMESPACE, ROLE_NAME);
        Assert.assertNotNull((Object)role);
        Principal user1Principal = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName("user1");
        List members = roleService.getRoleMembers(Collections.singletonList(role.getId()), null);
        RoleMembership m = null;
        for (RoleMembership rm : members) {
            if (!user1Principal.getPrincipalId().equals(rm.getMemberId())) continue;
            m = rm;
            break;
        }
        Assert.assertNotNull((String)"Failed to find user1Principal role membership", m);
        Assert.assertEquals((Object)user1Principal.getPrincipalId(), (Object)m.getMemberId());
        List rras = roleService.getRoleMemberResponsibilityActions(m.getId());
        Assert.assertEquals((long)2L, (long)rras.size());
        RoleResponsibilityAction rra = (RoleResponsibilityAction)rras.get(0);
        RoleResponsibilityAction.Builder b = RoleResponsibilityAction.Builder.create((RoleResponsibilityActionContract)rra);
        b.setActionTypeCode(ActionType.ACKNOWLEDGE.getCode());
        roleService.updateRoleResponsibilityAction(b.build());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user1"), (String)document.getDocumentId());
        Assert.assertFalse((String)"Approval should NOT be requested.", (boolean)document.isApprovalRequested());
        Assert.assertTrue((String)"Acknowledge should be requested.", (boolean)document.isAcknowledgeRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("admin"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Approval should be requested.", (boolean)document.isApprovalRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user2"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Approval should be requested.", (boolean)document.isApprovalRequested());
        roleService.deleteRoleResponsibilityAction(((RoleResponsibilityAction)rras.get(0)).getId());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user1"), (String)document.getDocumentId());
        Assert.assertTrue((boolean)document.getRequestedActions().getRequestedActions().isEmpty());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("admin"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Approval should be requested.", (boolean)document.isApprovalRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user2"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Approval should be requested.", (boolean)document.isApprovalRequested());
        actionRequests = KewApiServiceLocator.getWorkflowDocumentService().getRootActionRequests(document.getDocumentId());
        Assert.assertEquals((String)"Should have 2 action requests.", (long)2L, (long)actionRequests.size());
    }

    @Test
    public void testRoleDelegate() throws Exception {
        this.createDelegate();
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("rkirkend"), (String)"RoleRouteModuleTest2");
        document.route("");
        String ewestfalPrincipalId = this.getPrincipalIdForName("ewestfal");
        document = WorkflowDocumentFactory.loadDocument((String)ewestfalPrincipalId, (String)document.getDocumentId());
        Assert.assertTrue((String)"ewestfal should be able to approve", (boolean)document.isApprovalRequested());
        List actionRequests = document.getRootActionRequests();
        Assert.assertEquals((long)3L, (long)actionRequests.size());
        for (ActionRequest actionRequest : actionRequests) {
            Assert.assertFalse((boolean)ewestfalPrincipalId.equals(actionRequest.getPrincipalId()));
            Assert.assertEquals((long)1L, (long)actionRequest.getChildRequests().size());
            ActionRequest delegateRequest = (ActionRequest)actionRequest.getChildRequests().get(0);
            Assert.assertEquals((Object)ewestfalPrincipalId, (Object)delegateRequest.getPrincipalId());
            Assert.assertEquals((String)"Delegation type should been PRIMARY", (Object)DelegationType.PRIMARY, (Object)delegateRequest.getDelegationType());
        }
    }

    @Test
    public void testRoleDelegateApproval() throws Exception {
        this.createDelegate();
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("rkirkend"), (String)"RoleRouteModuleTest2");
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document.getDocumentId());
        Assert.assertTrue((String)"ewestfal should have an approval request", (boolean)document.isApprovalRequested());
        document.approve("");
        Assert.assertTrue((String)"Document should have been approved by the delegate.", (boolean)document.isFinal());
    }

    @Test
    public void testRoleWithNoMembers() throws Exception {
        this.getTransactionTemplate().execute((TransactionCallback)new TransactionCallback<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doInTransaction(TransactionStatus status) {
                try {
                    Role role = KimApiServiceLocator.getRoleService().getRoleByNamespaceCodeAndName(RoleRouteModuleTest.NAMESPACE, RoleRouteModuleTest.ROLE_NAME);
                    HashMap<String, String> criteria = new HashMap<String, String>();
                    criteria.put("roleId", role.getId());
                    List roleMembers = KradDataServiceLocator.getDataObjectService().findMatching(RoleMemberBo.class, QueryByCriteria.Builder.forAttribute((String)"roleId", (Object)role.getId()).build()).getResults();
                    Assert.assertFalse((String)"role member list should not currently be empty", (boolean)roleMembers.isEmpty());
                    for (RoleMemberBo roleMember : roleMembers) {
                        Assert.assertNotNull((String)"Role Member should exist.", (Object)roleMember);
                        KradDataServiceLocator.getDataObjectService().delete((Object)roleMember);
                    }
                    KradDataServiceLocator.getDataObjectService().flush(RoleMemberBo.class);
                    List roleMemberInfos = KimApiServiceLocator.getRoleService().getRoleMembers(Collections.singletonList(role.getId()), Collections.emptyMap());
                    Assert.assertEquals((String)"role member list should be empty now", (long)0L, (long)roleMemberInfos.size());
                    WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)RoleRouteModuleTest.this.getPrincipalIdForName("ewestfal"), (String)"RoleRouteModuleTest1");
                    document.route("");
                    Assert.assertTrue((String)"document should now be in final status", (boolean)document.isFinal());
                    List routeNodeInstances = document.getRouteNodeInstances();
                    Assert.assertEquals((String)"Document should have 2 route node instances", (long)2L, (long)routeNodeInstances.size());
                    Object var8_8 = null;
                    return var8_8;
                }
                finally {
                    status.setRollbackOnly();
                }
            }
        });
    }
}

