/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule.service.impl;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.rule.RuleBaseValues;
import org.kuali.rice.kew.rule.RuleDelegationBo;
import org.kuali.rice.kew.rule.RuleExpressionDef;
import org.kuali.rice.kew.rule.RuleExtensionBo;
import org.kuali.rice.kew.rule.RuleExtensionValue;
import org.kuali.rice.kew.rule.RuleResponsibilityBo;
import org.kuali.rice.kew.rule.RuleTemplateOptionBo;
import org.kuali.rice.kew.rule.bo.RuleAttribute;
import org.kuali.rice.kew.rule.bo.RuleTemplateAttributeBo;
import org.kuali.rice.kew.rule.bo.RuleTemplateBo;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.service.KRADServiceLocator;

public class KewRuleDataJpaTest
extends KEWTestCase {
    @Test
    public void testRuleBaseValuesPersistAndFetch() throws Exception {
        RuleBaseValues ruleBaseValues = this.setupRuleBaseValues();
        String ruleBaseValuesId = ruleBaseValues.getId();
        Assert.assertTrue((String)"RuleBaseValues persisted correctly", (ruleBaseValues != null && StringUtils.isNotBlank((String)ruleBaseValuesId) ? 1 : 0) != 0);
        ruleBaseValues = (RuleBaseValues)KRADServiceLocator.getDataObjectService().find(RuleBaseValues.class, (Object)ruleBaseValuesId);
        Assert.assertTrue((String)"RuleBaseValues refetched correctly", (ruleBaseValues != null && StringUtils.equals((String)ruleBaseValuesId, (String)ruleBaseValues.getId()) ? 1 : 0) != 0);
        Assert.assertTrue((String)"RuleExtension persisted correctly", (ruleBaseValues.getRuleExtensions() != null && ruleBaseValues.getRuleExtensions().size() == 1 ? 1 : 0) != 0);
        RuleExtensionBo ruleExtensionBo = (RuleExtensionBo)ruleBaseValues.getRuleExtensions().get(0);
        Assert.assertTrue((String)"RuleExtensionValue persisted correctly", (ruleExtensionBo.getExtensionValues() != null && ruleExtensionBo.getExtensionValues().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"RuleResponsibilities persisted correctly", (ruleBaseValues.getRuleResponsibilities() != null && ruleBaseValues.getRuleResponsibilities().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"RuleTemplate persisted correctly", (ruleBaseValues.getRuleTemplate() != null && StringUtils.isNotBlank((String)ruleBaseValues.getRuleTemplate().getId()) ? 1 : 0) != 0);
        Assert.assertTrue((String)"RuleExpressionDef persisted correctly", (ruleBaseValues.getRuleExpressionDef() != null && StringUtils.isNotBlank((String)ruleBaseValues.getRuleExpressionDef().getExpression()) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Rule Template Option persisted correctly", (ruleBaseValues.getRuleTemplate().getRuleTemplateOptions() != null && ruleBaseValues.getRuleTemplate().getRuleTemplateOptions().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Rule Template Attribute persisted correctly", (ruleBaseValues.getRuleTemplate().getRuleTemplateAttributes() != null && ruleBaseValues.getRuleTemplate().getRuleTemplateAttributes().size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testRuleAttributeServiceFindByRuleAttribute() throws Exception {
        RuleAttribute ruleAttribute = this.setupRuleAttribute();
        List ruleAttributeList = KEWServiceLocator.getRuleAttributeService().findByRuleAttribute(ruleAttribute);
        Assert.assertTrue((String)"Rule attribute find by rule attribute fetched correctly", (ruleAttributeList != null && ruleAttributeList.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testRuleAttributeServiceGetAllRuleAttributes() throws Exception {
        List ruleAttributeList = KEWServiceLocator.getRuleAttributeService().findAll();
        for (RuleAttribute ruleAttribute : ruleAttributeList) {
            KRADServiceLocator.getDataObjectService().delete((Object)ruleAttribute);
        }
        this.setupRuleAttribute();
        this.setupRuleAttributeSimilar();
        ruleAttributeList = KEWServiceLocator.getRuleAttributeService().findAll();
        Assert.assertTrue((String)"Rule attribute fetched all correctly", (ruleAttributeList != null && ruleAttributeList.size() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void tesRuleAttributeServiceFindByName() throws Exception {
        RuleAttribute ruleAttribute = this.setupRuleAttribute();
        ruleAttribute = KEWServiceLocator.getRuleAttributeService().findByName(ruleAttribute.getName());
        Assert.assertTrue((String)"RuleAttribute find by name fetched correctly", (ruleAttribute != null ? 1 : 0) != 0);
    }

    @Test
    public void tesRuleAttributeServiceFindByClassName() throws Exception {
        RuleAttribute ruleAttribute = this.setupRuleAttribute();
        this.setupRuleAttributeSimilar();
        List ruleAttributeList = KEWServiceLocator.getRuleAttributeService().findByClassName(ruleAttribute.getResourceDescriptor());
        Assert.assertTrue((String)"Rule attribute find by class name fetched correctly", (ruleAttributeList != null && ruleAttributeList.size() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testRuleTemplateServiceFindByRuleTemplateName() throws Exception {
        RuleTemplateBo ruleTemplateBo = this.setupRuleTemplateBo("test");
        String name = ruleTemplateBo.getName();
        ruleTemplateBo = KEWServiceLocator.getRuleTemplateService().findByRuleTemplateName(ruleTemplateBo.getName());
        Assert.assertTrue((String)"RuleTemplate fetched based on name", (ruleTemplateBo != null && StringUtils.equals((String)name, (String)ruleTemplateBo.getName()) ? 1 : 0) != 0);
    }

    @Test
    public void testRuleTemplateServiceDeleteRuleTemplateOption() throws Exception {
        RuleTemplateBo ruleTemplateBo = this.setupRuleTemplateBo("test");
        String optionId = ((RuleTemplateOptionBo)ruleTemplateBo.getRuleTemplateOptions().get(0)).getId();
        KEWServiceLocator.getRuleTemplateService().deleteRuleTemplateOption(optionId);
        RuleTemplateOptionBo ruleTemplateOptionBo = (RuleTemplateOptionBo)KRADServiceLocator.getDataObjectService().find(RuleTemplateOptionBo.class, (Object)optionId);
        Assert.assertTrue((String)"Rule Template Option is null", (ruleTemplateOptionBo == null ? 1 : 0) != 0);
    }

    @Test
    public void testRuleDelegationServiceFindAllCurrentRuleDelegations() throws Exception {
        RuleBaseValues ruleBaseValues = this.setupRuleBaseValues();
        RuleDelegationBo ruleDelegationBo = this.setupRuleDelegationBo(ruleBaseValues);
        ruleDelegationBo.setDelegationRule(ruleBaseValues);
        KRADServiceLocator.getDataObjectService().save((Object)ruleDelegationBo, new PersistenceOption[0]);
        List ruleDelegationBos = KEWServiceLocator.getRuleDelegationService().findAllCurrentRuleDelegations();
        Assert.assertTrue((String)"Rule delegation bo found", (ruleDelegationBos != null ? 1 : 0) != 0);
    }

    @Test
    public void testRuleDelegationServiceFindByDelegateRuleId() throws Exception {
        RuleBaseValues ruleBaseValues = this.setupRuleBaseValues();
        RuleDelegationBo ruleDelegationBo = this.setupRuleDelegationBo(ruleBaseValues);
        List ruleDelegationBos = KEWServiceLocator.getRuleDelegationService().findByDelegateRuleId(ruleDelegationBo.getDelegateRuleId());
        Assert.assertTrue((String)"Rule Delegation Bo fetched by rule id", (ruleDelegationBos != null && ruleDelegationBos.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testRuleTemplateServiceFindAll() throws Exception {
        List ruleTemplateBos = KEWServiceLocator.getRuleTemplateService().findAll();
        for (RuleTemplateBo ruleTemplateBo : ruleTemplateBos) {
            KRADServiceLocator.getDataObjectService().delete((Object)ruleTemplateBo);
        }
        this.setupRuleTemplateBo("test");
        this.setupRuleTemplateBo("otherTest");
        ruleTemplateBos = KEWServiceLocator.getRuleTemplateService().findAll();
        Assert.assertTrue((String)"Rule Template Bo fetched all", (ruleTemplateBos != null && ruleTemplateBos.size() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testRuleDelegationServiceFindByResponsibilityIdWithCurrentRule() throws Exception {
        RuleBaseValues ruleBaseValues = this.setupRuleBaseValues();
        RuleDelegationBo ruleDelegationBo = this.setupRuleDelegationBo(ruleBaseValues);
        ruleDelegationBo.setResponsibilityId(ruleBaseValues.getId());
        ruleDelegationBo.setDelegateRuleId(ruleBaseValues.getId());
        ruleDelegationBo = (RuleDelegationBo)KRADServiceLocator.getDataObjectService().save((Object)ruleDelegationBo, new PersistenceOption[0]);
        List ruleDelegationBos = KEWServiceLocator.getRuleDelegationService().findByResponsibilityId(ruleDelegationBo.getResponsibilityId());
        Assert.assertTrue((String)"Rule Delegation Bo fetched ", (ruleDelegationBos != null && ruleDelegationBos.size() == 1 ? 1 : 0) != 0);
    }

    private RuleDelegationBo setupRuleDelegationBo(RuleBaseValues ruleBaseValues) {
        RuleDelegationBo ruleDelegationBo = new RuleDelegationBo();
        ruleDelegationBo.setDelegationTypeCode("P");
        ruleDelegationBo.setGroupReviewerName("Testing");
        ruleDelegationBo.setPersonReviewer("blah");
        ruleDelegationBo.setDelegationRuleBaseValues(ruleBaseValues);
        ruleDelegationBo.setDelegateRuleId(ruleBaseValues.getId());
        ruleDelegationBo.setResponsibilityId("1234");
        return (RuleDelegationBo)KRADServiceLocator.getDataObjectService().save((Object)ruleDelegationBo, new PersistenceOption[0]);
    }

    private RuleTemplateBo setupRuleTemplateBo(String name) {
        RuleTemplateBo ruleTemplate = new RuleTemplateBo();
        ruleTemplate.setName(name);
        ruleTemplate.setReturnUrl("testing");
        ruleTemplate.setDescription("description");
        RuleTemplateOptionBo ruleTemplateOptionBo = new RuleTemplateOptionBo();
        ruleTemplateOptionBo.setCode("P");
        ruleTemplateOptionBo.setValue("VAL");
        ruleTemplateOptionBo.setRuleTemplate(ruleTemplate);
        ruleTemplate.getRuleTemplateOptions().add(ruleTemplateOptionBo);
        return (RuleTemplateBo)KRADServiceLocator.getDataObjectService().save((Object)ruleTemplate, new PersistenceOption[]{PersistenceOption.FLUSH});
    }

    private RuleAttribute setupRuleAttribute() {
        RuleAttribute ruleAttribute = new RuleAttribute();
        ruleAttribute.setApplicationId("TST");
        ruleAttribute.setDescription("Testing");
        ruleAttribute.setLabel("New Label");
        ruleAttribute.setResourceDescriptor("ResourceDescriptor");
        ruleAttribute.setType("newType");
        ruleAttribute.setName("Attr");
        return (RuleAttribute)KRADServiceLocator.getDataObjectService().save((Object)ruleAttribute, new PersistenceOption[]{PersistenceOption.FLUSH});
    }

    private RuleAttribute setupRuleAttributeSimilar() {
        RuleAttribute ruleAttribute = new RuleAttribute();
        ruleAttribute.setApplicationId("TST2");
        ruleAttribute.setDescription("Testingfdsa");
        ruleAttribute.setLabel("New Labefdsal");
        ruleAttribute.setResourceDescriptor("ResourceDescriptor");
        ruleAttribute.setType("newType");
        ruleAttribute.setName("Attr2");
        return (RuleAttribute)KRADServiceLocator.getDataObjectService().save((Object)ruleAttribute, new PersistenceOption[]{PersistenceOption.FLUSH});
    }

    private RuleBaseValues setupRuleBaseValues() {
        RuleBaseValues rbv = new RuleBaseValues();
        rbv.setActive(Boolean.TRUE.booleanValue());
        rbv.setCurrentInd(Boolean.TRUE);
        rbv.setDescription("A test rule");
        rbv.setDocTypeName("TestDocumentType");
        rbv.setForceAction(Boolean.FALSE.booleanValue());
        RuleResponsibilityBo ruleResponsibilityBo = new RuleResponsibilityBo();
        ruleResponsibilityBo.setResponsibilityId("1234");
        ruleResponsibilityBo.setRuleBaseValues(rbv);
        ruleResponsibilityBo.setRuleResponsibilityName("user2");
        ruleResponsibilityBo.setRuleResponsibilityType("F");
        rbv.getRuleResponsibilities().add(ruleResponsibilityBo);
        RuleTemplateBo ruleTemplate = new RuleTemplateBo();
        ruleTemplate.setName("test");
        ruleTemplate.setDescription("description");
        rbv.setRuleTemplate(ruleTemplate);
        RuleTemplateOptionBo ruleTemplateOptionBo = new RuleTemplateOptionBo();
        ruleTemplateOptionBo.setCode("TST");
        ruleTemplateOptionBo.setValue("VAL");
        ruleTemplateOptionBo.setRuleTemplate(ruleTemplate);
        ruleTemplate.getRuleTemplateOptions().add(ruleTemplateOptionBo);
        RuleTemplateAttributeBo ruleTemplateAttributeBo = new RuleTemplateAttributeBo();
        ruleTemplateAttributeBo.setActive(true);
        ruleTemplateAttributeBo.setDefaultValue("testAttr");
        ruleTemplateAttributeBo.setDisplayOrder(Integer.valueOf(1));
        ruleTemplateAttributeBo.setRequired(Boolean.valueOf(true));
        ruleTemplateAttributeBo.setRuleTemplate(ruleTemplate);
        RuleAttribute ruleAttribute = this.setupRuleAttribute();
        ruleTemplateAttributeBo.setRuleAttribute(ruleAttribute);
        ruleTemplate.getRuleTemplateAttributes().add(ruleTemplateAttributeBo);
        RuleExpressionDef ruleExpressionDef = new RuleExpressionDef();
        ruleExpressionDef.setExpression("test");
        ruleExpressionDef.setType("TST");
        rbv.setRuleExpressionDef(ruleExpressionDef);
        RuleExtensionBo ext = new RuleExtensionBo();
        RuleExtensionValue val = new RuleExtensionValue();
        val.setKey("emptyvalue");
        val.setValue("testing");
        val.setExtension(ext);
        ext.getExtensionValues().add(val);
        ext.setRuleBaseValues(rbv);
        ext.setRuleTemplateAttribute(ruleTemplateAttributeBo);
        rbv.getRuleExtensions().add(ext);
        return (RuleBaseValues)KRADServiceLocator.getDataObjectService().save((Object)rbv, new PersistenceOption[0]);
    }
}

