/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.xml;

import java.util.List;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.kew.api.extension.ExtensionDefinition;
import org.kuali.rice.kew.docsearch.DocumentSearchTestBase;
import org.kuali.rice.kew.docsearch.xml.StandardGenericXMLSearchableAttribute;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.rule.RuleBaseValues;
import org.kuali.rice.kew.rule.RuleResponsibilityBo;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kns.util.FieldUtils;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.util.GlobalVariables;

public class DeprecatedDocumentTagsTest
extends DocumentSearchTestBase {
    private static final Logger LOG = Logger.getLogger(DeprecatedDocumentTagsTest.class);
    private static final String TEST_GROUP_NAME = "TestWorkgroup";

    @Override
    protected void loadTestData() throws Exception {
        ConfigContext.getCurrentContextConfig().putProperty("test.doctype.workgroup", TEST_GROUP_NAME);
        this.loadXmlFile("DeprecatedDocumentTags.xml");
    }

    @Test
    public void testDocTypeDirectDescendantWorkgroupNames() throws Exception {
        DocumentType docType = KEWServiceLocator.getDocumentTypeService().findByName("DocumentType02");
        this.assertGroupIsCorrect("superUserWorkgroupName", TEST_GROUP_NAME, "KR-WKFLW", docType.getSuperUserWorkgroup());
        this.assertGroupIsCorrect("blanketApproveWorkgroupName", TEST_GROUP_NAME, "KR-WKFLW", docType.getBlanketApproveWorkgroup());
        docType = KEWServiceLocator.getDocumentTypeService().findByName("DocTypeWithSecurity");
        this.assertGroupIsCorrect("superUserWorkgroupName", TEST_GROUP_NAME, "KR-WKFLW", docType.getSuperUserWorkgroup());
        this.assertGroupIsCorrect("reportingWorkgroupName", "NonSIT", "KR-WKFLW", docType.getReportingWorkgroup());
        this.assertGroupIsCorrect("blanketApproveWorkgroupName", TEST_GROUP_NAME, "KR-WKFLW", docType.getBlanketApproveWorkgroup());
        docType = KEWServiceLocator.getDocumentTypeService().findByName("SeqDocType");
        this.assertGroupIsCorrect("superUserWorkgroupName", TEST_GROUP_NAME, "KR-WKFLW", docType.getSuperUserWorkgroup());
        this.assertGroupIsCorrect("blanketApproveWorkgroupName", "NonSIT", "KR-WKFLW", docType.getBlanketApproveWorkgroup());
    }

    @Test
    public void testDocTypeSecurityAndResponsibilityAndVisibilityWorkgroupNames() throws Exception {
        RuleBaseValues testRule = KEWServiceLocator.getRuleService().getRuleByName("TestRule1");
        Assert.assertNotNull((String)"TestRule1 should not be null", (Object)testRule);
        Assert.assertEquals((String)"There should be exactly one responsibility on TestRule1", (long)1L, (long)testRule.getRuleResponsibilities().size());
        RuleResponsibilityBo testResp = (RuleResponsibilityBo)testRule.getRuleResponsibilities().get(0);
        Assert.assertNotNull((String)"The responsibility on TestRule1 should not be null", (Object)testResp);
        Assert.assertEquals((String)"The responsibility on TestRule1 has the wrong type", (Object)"G", (Object)testResp.getRuleResponsibilityType());
        Group testGroup = KimApiServiceLocator.getGroupService().getGroup(testResp.getRuleResponsibilityName());
        this.assertGroupIsCorrect("<responsibility><workgroup>", TEST_GROUP_NAME, "KR-WKFLW", testGroup);
        String[] testPrincipalNames = new String[]{"rkirkend", "quickstart"};
        boolean[] visibleStates = new boolean[]{true, false};
        for (int i = 0; i < testPrincipalNames.length; ++i) {
            LOG.info((Object)("Testing visibility of the rule attribute for user '" + testPrincipalNames[i] + "'"));
            GlobalVariables.setUserSession(null);
            String testPrincipalId = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName(testPrincipalNames[i]).getPrincipalId();
            GlobalVariables.setUserSession((UserSession)new UserSession(testPrincipalNames[i]));
            StandardGenericXMLSearchableAttribute searchableAttribute = new StandardGenericXMLSearchableAttribute();
            ExtensionDefinition ed = DeprecatedDocumentTagsTest.createExtensionDefinition("SearchableAttributeVisible");
            List remotableAttributeFields = searchableAttribute.getSearchFields(ed, "DocumentType02");
            List rowList = FieldUtils.convertRemotableAttributeFields((List)remotableAttributeFields);
            Assert.assertEquals((String)"The searching rows list should have exactly one element", (long)1L, (long)rowList.size());
            Assert.assertEquals((String)"The searching row should have exactly one field", (long)1L, (long)((Row)rowList.get(0)).getFields().size());
            Assert.assertEquals((String)"The rule attribute field does not have the expected visibility", (Object)visibleStates[i], (Object)((Row)rowList.get(0)).getField(0).isColumnVisible());
        }
        DocumentType docType = KEWServiceLocator.getDocumentTypeService().findByName("DocTypeWithSecurity");
        List testGroups = docType.getDocumentTypeSecurity().getWorkgroups();
        Assert.assertEquals((String)"docTypeSecurity should have exactly one group in its security section", (long)1L, (long)testGroups.size());
        this.assertGroupIsCorrect("<security><workgroup>", "NonSIT", "KR-WKFLW", (Group)testGroups.get(0));
    }

    @Test
    public void testDeprecatedExceptionWorkgroupNameElements() throws Exception {
        DocumentType docType = KEWServiceLocator.getDocumentTypeService().findByName("SeqDocType");
        RouteNode rtNode = docType.getPrimaryProcess().getInitialRouteNode();
        String[] descriptiveNames = new String[]{"defaultExceptionWorkgroupName", "exceptionWorkgroupName", "defaultExceptionWorkgroupName", "exceptionWorkgroup"};
        String[] expectedNames = new String[]{TEST_GROUP_NAME, "NonSIT", TEST_GROUP_NAME, "NonSIT"};
        String[] expectedNamespaces = new String[]{"KR-WKFLW", "KR-WKFLW", "KR-WKFLW", "KR-WKFLW"};
        int i = 0;
        Assert.assertTrue((String)("No exception group was defined for node " + rtNode.getRouteNodeName()), (boolean)rtNode.isExceptionGroupDefined());
        this.assertGroupIsCorrect(descriptiveNames[i], expectedNames[i], expectedNamespaces[i], rtNode.getExceptionWorkgroup());
        while (!rtNode.getNextNodes().isEmpty()) {
            rtNode = (RouteNode)rtNode.getNextNodes().get(0);
            Assert.assertTrue((String)("No exception group was defined for node " + rtNode.getRouteNodeName()), (boolean)rtNode.isExceptionGroupDefined());
            this.assertGroupIsCorrect(descriptiveNames[++i], expectedNames[i], expectedNamespaces[i], rtNode.getExceptionWorkgroup());
        }
        Assert.assertEquals((String)"Final route node index is incorrect", (long)3L, (long)i);
    }

    private void assertGroupIsCorrect(String propertyName, String expectedName, String expectedNamespace, Group groupToTest) throws Exception {
        Assert.assertNotNull((String)(propertyName + " should not be null"), (Object)groupToTest);
        Assert.assertEquals((String)(propertyName + " has wrong namespace code"), (Object)expectedNamespace, (Object)groupToTest.getNamespaceCode());
        Assert.assertEquals((String)(propertyName + " has wrong group name"), (Object)expectedName, (Object)groupToTest.getName());
    }
}

