/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.docsearch;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.Years;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.api.KewApiConstants;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.action.RequestedActions;
import org.kuali.rice.kew.api.document.Document;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.api.document.DocumentStatusCategory;
import org.kuali.rice.kew.api.document.search.DocumentSearchCriteria;
import org.kuali.rice.kew.api.document.search.DocumentSearchResult;
import org.kuali.rice.kew.api.document.search.DocumentSearchResults;
import org.kuali.rice.kew.api.document.search.RouteNodeLookupLogic;
import org.kuali.rice.kew.docsearch.DocumentSearchInternalUtils;
import org.kuali.rice.kew.docsearch.service.DocumentSearchService;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.doctype.service.DocumentTypeService;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kew.useroptions.UserOptionsService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.test.BaselineTestCase;
import org.kuali.rice.test.TestHarnessServiceLocator;
import org.springframework.jdbc.core.JdbcTemplate;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public class DocumentSearchTest
extends KEWTestCase {
    private static final String KREW_DOC_HDR_T = "KREW_DOC_HDR_T";
    private static final String INITIATOR_COL = "INITR_PRNCPL_ID";
    DocumentSearchService docSearchService;
    UserOptionsService userOptionsService;

    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("SearchAttributeConfig.xml");
    }

    @Override
    protected void setUpAfterDataLoad() throws Exception {
        this.docSearchService = KEWServiceLocator.getDocumentSearchService();
        this.userOptionsService = KEWServiceLocator.getUserOptionsService();
    }

    @Test
    public void testDocSearch() throws Exception {
        Person user = KimApiServiceLocator.getPersonService().getPersonByPrincipalName("bmcgough");
        DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        DocumentSearchResults results = null;
        criteria.setTitle("*IN");
        criteria.setSaveName("bytitle");
        results = this.docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setTitle("*IN-CFSG");
        criteria.setSaveName("for in accounts");
        results = this.docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDateApprovedFrom(new DateTime(2004, 9, 16, 0, 0));
        results = this.docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        criteria = DocumentSearchCriteria.Builder.create();
        user = KimApiServiceLocator.getPersonService().getPersonByPrincipalName("bmcgough");
        DocumentSearchCriteria savedCriteria = this.docSearchService.getNamedSearchCriteria(user.getPrincipalId(), "bytitle");
        Assert.assertNotNull((Object)savedCriteria);
        Assert.assertEquals((Object)"bytitle", (Object)savedCriteria.getSaveName());
        savedCriteria = this.docSearchService.getNamedSearchCriteria(user.getPrincipalId(), "for in accounts");
        Assert.assertNotNull((Object)savedCriteria);
        Assert.assertEquals((Object)"for in accounts", (Object)savedCriteria.getSaveName());
    }

    @Test
    public void testDocSearchDocumentResult() throws Exception {
        String[] docIds = this.routeTestDocs();
        Person user = KimApiServiceLocator.getPersonService().getPersonByPrincipalName("bmcgough");
        DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        DocumentSearchResults results = this.docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((long)3L, (long)results.getSearchResults().size());
        DocumentSearchResult result = (DocumentSearchResult)results.getSearchResults().get(0);
        Document doc = result.getDocument();
        Assert.assertNotNull((Object)doc.getApplicationDocumentStatus());
        Assert.assertNotNull((Object)doc.getApplicationDocumentStatusDate());
        Assert.assertNotNull((Object)doc.getDateApproved());
        Assert.assertNotNull((Object)doc.getDateCreated());
        Assert.assertNotNull((Object)doc.getDateFinalized());
        Assert.assertNotNull((Object)doc.getDocumentId());
        Assert.assertNotNull((Object)doc.getDocumentTypeName());
        Assert.assertNotNull((Object)doc.getApplicationDocumentId());
        Assert.assertNotNull((Object)doc.getDateLastModified());
        Assert.assertNotNull((Object)doc.getDocumentHandlerUrl());
        Assert.assertNotNull((Object)doc.getDocumentTypeId());
        Assert.assertNotNull((Object)doc.getInitiatorPrincipalId());
        Assert.assertNotNull((Object)doc.getRoutedByPrincipalId());
        Assert.assertNotNull((Object)doc.getStatus());
        Assert.assertNotNull((Object)doc.getTitle());
        Assert.assertTrue((boolean)doc.getVariables().isEmpty());
    }

    @Test
    public void testDocSearch_appDocStatuses() throws Exception {
        String[] docIds = this.routeTestDocs();
        DateTime now = DateTime.now();
        DateTime before = now.minusDays(2);
        DateTime after = now.plusDays(2);
        String principalId = this.getPrincipalId("bmcgough");
        List<String> appDocStatusSearch = Arrays.asList("Submitted", "Pending");
        DocumentSearchResults results = this.doAppStatusDocSearch(principalId, appDocStatusSearch, null, null);
        Assert.assertEquals((String)"should have matched one doc for each status", (long)2L, (long)results.getSearchResults().size());
        for (DocumentSearchResult result : results.getSearchResults()) {
            Assert.assertTrue((String)("app doc status should be in " + StringUtils.join(appDocStatusSearch, (String)", ")), (boolean)appDocStatusSearch.contains(result.getDocument().getApplicationDocumentStatus()));
        }
        appDocStatusSearch = Arrays.asList("Submitted", "Pending", "Completed");
        results = this.doAppStatusDocSearch(principalId, appDocStatusSearch, before, after);
        Assert.assertEquals((String)"all docs are in the date range, should have matched them all", (long)3L, (long)results.getSearchResults().size());
        for (DocumentSearchResult result : results.getSearchResults()) {
            Assert.assertTrue((String)("app doc status should be in " + StringUtils.join(appDocStatusSearch, (String)", ")), (boolean)appDocStatusSearch.contains(result.getDocument().getApplicationDocumentStatus()));
        }
        appDocStatusSearch = Arrays.asList("Submitted", "Pending");
        results = this.doAppStatusDocSearch(principalId, appDocStatusSearch, before, after);
        Assert.assertEquals((String)"should have matched one doc for each status", (long)2L, (long)results.getSearchResults().size());
        for (DocumentSearchResult result : results.getSearchResults()) {
            Assert.assertTrue((String)("app doc status should be in " + StringUtils.join(appDocStatusSearch, (String)", ")), (boolean)appDocStatusSearch.contains(result.getDocument().getApplicationDocumentStatus()));
        }
        appDocStatusSearch = Arrays.asList("Submitted", "Pending", "Completed");
        results = this.doAppStatusDocSearch(principalId, appDocStatusSearch, after, after.plusDays(1));
        Assert.assertEquals((String)"none of the docs should be in the date range", (long)0L, (long)results.getSearchResults().size());
        DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName("SearchDocType");
        criteria.setApplicationDocumentStatus("Submitted");
        results = this.docSearchService.lookupDocuments(principalId, criteria.build());
        Assert.assertEquals((String)"legacy style app doc status search should have matched one document", (long)1L, (long)results.getSearchResults().size());
        Assert.assertTrue((String)"app doc status should match the search criteria", (boolean)"Submitted".equals(((DocumentSearchResult)results.getSearchResults().get(0)).getDocument().getApplicationDocumentStatus()));
    }

    private DocumentSearchResults doAppStatusDocSearch(String principalId, List<String> appDocStatuses, DateTime appStatusChangedFrom, DateTime appStatusChangedTo) {
        DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName("SearchDocType");
        criteria.setApplicationDocumentStatuses(appDocStatuses);
        criteria.setDateApplicationDocumentStatusChangedFrom(appStatusChangedFrom);
        criteria.setDateApplicationDocumentStatusChangedTo(appStatusChangedTo);
        return this.docSearchService.lookupDocuments(principalId, criteria.build());
    }

    @Test
    public void testDocSearch_maxResults() throws Exception {
        String[] docIds = this.routeTestDocs();
        String principalId = this.getPrincipalId("bmcgough");
        DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName("SearchDocType");
        criteria.setMaxResults(Integer.valueOf(5));
        DocumentSearchResults results = this.docSearchService.lookupDocuments(principalId, criteria.build());
        Assert.assertEquals((long)3L, (long)results.getSearchResults().size());
        criteria.setMaxResults(Integer.valueOf(2));
        results = this.docSearchService.lookupDocuments(principalId, criteria.build());
        Assert.assertEquals((long)2L, (long)results.getSearchResults().size());
        Assert.assertEquals((Object)"_blank", (Object)((DocumentSearchResult)results.getSearchResults().get(0)).getDocument().getDocumentHandlerUrl());
    }

    @Test
    public void testDocSearch_maxResultsIsNull() throws Exception {
        String[] docIds = this.routeTestDocs();
        String principalId = this.getPrincipalId("bmcgough");
        DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName("SearchDocType");
        criteria.setMaxResults(Integer.valueOf(5));
        DocumentSearchResults results = this.docSearchService.lookupDocuments(principalId, criteria.build());
        Assert.assertEquals((long)3L, (long)results.getSearchResults().size());
        criteria.setMaxResults(null);
        results = this.docSearchService.lookupDocuments(principalId, criteria.build());
        Assert.assertEquals((long)3L, (long)results.getSearchResults().size());
    }

    @Test
    public void testDocSearch_maxResultsIsZero() throws Exception {
        String[] docIds = this.routeTestDocs();
        String principalId = this.getPrincipalId("bmcgough");
        DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName("SearchDocType");
        criteria.setMaxResults(Integer.valueOf(5));
        DocumentSearchResults results = this.docSearchService.lookupDocuments(principalId, criteria.build());
        Assert.assertEquals((long)3L, (long)results.getSearchResults().size());
        criteria.setMaxResults(Integer.valueOf(0));
        results = this.docSearchService.lookupDocuments(principalId, criteria.build());
        Assert.assertEquals((long)0L, (long)results.getSearchResults().size());
    }

    @Test
    public void testDocSearch_startAtIndex() throws Exception {
        String[] docIds = this.routeTestDocs();
        String principalId = this.getPrincipalId("bmcgough");
        DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName("SearchDocType");
        criteria.setMaxResults(Integer.valueOf(5));
        DocumentSearchResults results = this.docSearchService.lookupDocuments(principalId, criteria.build());
        Assert.assertEquals((long)3L, (long)results.getSearchResults().size());
        criteria.setStartAtIndex(Integer.valueOf(1));
        results = this.docSearchService.lookupDocuments(principalId, criteria.build());
        Assert.assertEquals((long)2L, (long)results.getSearchResults().size());
    }

    @Test
    public void testDocSearch_startAtIndexMoreThanResuls() throws Exception {
        String[] docIds = this.routeTestDocs();
        String principalId = this.getPrincipalId("bmcgough");
        DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName("SearchDocType");
        criteria.setMaxResults(Integer.valueOf(5));
        DocumentSearchResults results = this.docSearchService.lookupDocuments(principalId, criteria.build());
        Assert.assertEquals((long)3L, (long)results.getSearchResults().size());
        criteria.setStartAtIndex(Integer.valueOf(5));
        results = this.docSearchService.lookupDocuments(principalId, criteria.build());
        Assert.assertEquals((long)0L, (long)results.getSearchResults().size());
    }

    @Test
    public void testDocSearch_startAtIndexNegative() throws Exception {
        String[] docIds = this.routeTestDocs();
        String principalId = this.getPrincipalId("bmcgough");
        DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName("SearchDocType");
        criteria.setMaxResults(Integer.valueOf(5));
        DocumentSearchResults results = this.docSearchService.lookupDocuments(principalId, criteria.build());
        Assert.assertEquals((long)3L, (long)results.getSearchResults().size());
        criteria.setStartAtIndex(Integer.valueOf(-1));
        results = this.docSearchService.lookupDocuments(principalId, criteria.build());
        Assert.assertEquals((long)0L, (long)results.getSearchResults().size());
    }

    @Test
    public void testDocSearch_startAtIndexZero() throws Exception {
        String[] docIds = this.routeTestDocs();
        String principalId = this.getPrincipalId("bmcgough");
        DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName("SearchDocType");
        criteria.setMaxResults(Integer.valueOf(5));
        DocumentSearchResults results = this.docSearchService.lookupDocuments(principalId, criteria.build());
        Assert.assertEquals((long)3L, (long)results.getSearchResults().size());
        criteria.setStartAtIndex(Integer.valueOf(0));
        results = this.docSearchService.lookupDocuments(principalId, criteria.build());
        Assert.assertEquals((long)3L, (long)results.getSearchResults().size());
    }

    @Test
    public void testUnnamedDocSearchPersistence() throws Exception {
        Person user = KimApiServiceLocator.getPersonService().getPersonByPrincipalName("bmcgough");
        Collection allUserOptions_before = this.userOptionsService.findByWorkflowUser(user.getPrincipalId());
        List namedSearches_before = this.userOptionsService.findByUserQualified(user.getPrincipalId(), "DocSearch.NamedSearch.%");
        Assert.assertEquals((long)0L, (long)namedSearches_before.size());
        Assert.assertEquals((long)0L, (long)allUserOptions_before.size());
        DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        criteria.setTitle("*IN");
        criteria.setDateCreatedFrom(DateTime.now().minus((ReadablePeriod)Years.ONE));
        DocumentSearchCriteria c1 = criteria.build();
        DocumentSearchResults results = this.docSearchService.lookupDocuments(user.getPrincipalId(), c1, true);
        Collection allUserOptions_after = this.userOptionsService.findByWorkflowUser(user.getPrincipalId());
        List namedSearches_after = this.userOptionsService.findByUserQualified(user.getPrincipalId(), "DocSearch.NamedSearch.%");
        Assert.assertEquals((long)(allUserOptions_before.size() + 2), (long)allUserOptions_after.size());
        Assert.assertEquals((long)namedSearches_before.size(), (long)namedSearches_after.size());
        Assert.assertEquals((Object)"DocSearch.LastSearch.Holding0", (Object)this.userOptionsService.findByOptionId("DocSearch.LastSearch.Order".toString(), user.getPrincipalId()).getOptionVal());
        Assert.assertEquals((Object)DocumentSearchTest.marshall(c1), (Object)this.userOptionsService.findByOptionId("DocSearch.LastSearch.Holding0", user.getPrincipalId()).getOptionVal());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setTitle("*IN-CFSG*");
        criteria.setDateCreatedFrom(DateTime.now().minus((ReadablePeriod)Years.ONE));
        DocumentSearchCriteria c2 = criteria.build();
        results = this.docSearchService.lookupDocuments(user.getPrincipalId(), c2, true);
        Assert.assertEquals((long)(allUserOptions_before.size() + 2), (long)allUserOptions_after.size());
        Assert.assertEquals((long)namedSearches_before.size(), (long)namedSearches_after.size());
        Assert.assertEquals((Object)"DocSearch.LastSearch.Holding1,DocSearch.LastSearch.Holding0", (Object)this.userOptionsService.findByOptionId("DocSearch.LastSearch.Order", user.getPrincipalId()).getOptionVal());
        Assert.assertEquals((Object)DocumentSearchTest.marshall(c1), (Object)this.userOptionsService.findByOptionId("DocSearch.LastSearch.Holding0", user.getPrincipalId()).getOptionVal());
        Assert.assertEquals((Object)DocumentSearchTest.marshall(c2), (Object)this.userOptionsService.findByOptionId("DocSearch.LastSearch.Holding1", user.getPrincipalId()).getOptionVal());
    }

    @Test
    public void testNamedDocSearchPersistence() throws Exception {
        Person user = KimApiServiceLocator.getPersonService().getPersonByPrincipalName("bmcgough");
        Collection allUserOptions_before = this.userOptionsService.findByWorkflowUser(user.getPrincipalId());
        List namedSearches_before = this.userOptionsService.findByUserQualified(user.getPrincipalId(), "DocSearch.NamedSearch.%");
        DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        criteria.setTitle("*IN");
        criteria.setSaveName("bytitle");
        criteria.setDateCreatedFrom(DateTime.now().minus((ReadablePeriod)Years.ONE));
        DocumentSearchCriteria c1 = criteria.build();
        DocumentSearchResults results = this.docSearchService.lookupDocuments(user.getPrincipalId(), c1);
        Collection allUserOptions_after = this.userOptionsService.findByWorkflowUser(user.getPrincipalId());
        List namedSearches_after = this.userOptionsService.findByUserQualified(user.getPrincipalId(), "DocSearch.NamedSearch.%");
        Assert.assertEquals((long)(allUserOptions_before.size() + 1), (long)allUserOptions_after.size());
        Assert.assertEquals((long)(namedSearches_before.size() + 1), (long)namedSearches_after.size());
        Assert.assertEquals((Object)DocumentSearchTest.marshall(c1), (Object)this.userOptionsService.findByOptionId("DocSearch.NamedSearch." + criteria.getSaveName(), user.getPrincipalId()).getOptionVal());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setTitle("*IN");
        criteria.setSaveName("bytitle2");
        criteria.setDateCreatedFrom(DateTime.now().minus((ReadablePeriod)Years.ONE));
        DocumentSearchCriteria c2 = criteria.build();
        results = this.docSearchService.lookupDocuments(user.getPrincipalId(), c2);
        allUserOptions_after = this.userOptionsService.findByWorkflowUser(user.getPrincipalId());
        namedSearches_after = this.userOptionsService.findByUserQualified(user.getPrincipalId(), "DocSearch.NamedSearch.%");
        Assert.assertEquals((long)(allUserOptions_before.size() + 2), (long)allUserOptions_after.size());
        Assert.assertEquals((long)(namedSearches_before.size() + 2), (long)namedSearches_after.size());
        Assert.assertEquals((Object)DocumentSearchTest.marshall(c2), (Object)this.userOptionsService.findByOptionId("DocSearch.NamedSearch." + criteria.getSaveName(), user.getPrincipalId()).getOptionVal());
    }

    protected static String marshall(DocumentSearchCriteria criteria) throws Exception {
        return DocumentSearchInternalUtils.marshalDocumentSearchCriteria((DocumentSearchCriteria)criteria);
    }

    @Test
    public void testDocSearch_criteriaModified() throws Exception {
        String principalId = this.getPrincipalId("ewestfal");
        DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        DocumentSearchResults results = this.docSearchService.lookupDocuments(principalId, criteria.build());
        Assert.assertTrue((String)"criteria should have been modified", (boolean)results.isCriteriaModified());
        Assert.assertNull((String)"original date created from should have been null", (Object)criteria.getDateCreatedFrom());
        Assert.assertNotNull((String)"modified date created from should be non-null", (Object)results.getCriteria().getDateCreatedFrom());
        Assert.assertEquals((String)"Criteria date minus today's date should equal the constant value", (long)KewApiConstants.DOCUMENT_SEARCH_NO_CRITERIA_CREATE_DATE_DAYS_AGO.intValue(), (long)DocumentSearchTest.getDifferenceInDays(results.getCriteria().getDateCreatedFrom()));
        criteria.setMaxResults(new Integer(50));
        criteria.setSaveName("myRadSearch");
        results = this.docSearchService.lookupDocuments(principalId, criteria.build());
        Assert.assertTrue((String)"criteria should have been modified", (boolean)results.isCriteriaModified());
        Assert.assertNotNull((String)"modified date created from should be non-null", (Object)results.getCriteria().getDateCreatedFrom());
        criteria.setTitle("My rad title search!");
        results = this.docSearchService.lookupDocuments(principalId, criteria.build());
        Assert.assertTrue((String)"criteria should have been modified", (boolean)results.isCriteriaModified());
        Assert.assertNotNull((String)"modified date created from should be non-null", (Object)results.getCriteria().getDateCreatedFrom());
        Assert.assertEquals((String)"Criteria date minus today's date should equal the constant value", (long)Math.abs(KewApiConstants.DOCUMENT_SEARCH_DOC_TITLE_CREATE_DATE_DAYS_AGO), (long)DocumentSearchTest.getDifferenceInDays(results.getCriteria().getDateCreatedFrom()));
        criteria.setApplicationDocumentId("12345");
        results = this.docSearchService.lookupDocuments(principalId, criteria.build());
        Assert.assertFalse((String)"criteria should *not* have been modified", (boolean)results.isCriteriaModified());
        Assert.assertNull((String)"modified date created from should still be null", (Object)results.getCriteria().getDateCreatedFrom());
        Assert.assertEquals((String)"both criterias should be equal", (Object)criteria.build(), (Object)results.getCriteria());
    }

    @Test
    public void testDocSearch_MissingInitiator() throws Exception {
        String documentTypeName = "SearchDocType";
        DocumentType docType = ((DocumentTypeService)KEWServiceLocator.getService((String)"enDocumentTypeService")).findByName(documentTypeName);
        String userNetworkId = "arh14";
        WorkflowDocument workflowDocument = WorkflowDocumentFactory.createDocument((String)this.getPrincipalId(userNetworkId), (String)documentTypeName);
        workflowDocument.setTitle("testDocSearch_MissingInitiator");
        workflowDocument.route("routing this document.");
        workflowDocument = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalId("jhopf"), (String)workflowDocument.getDocumentId());
        Assert.assertTrue((boolean)workflowDocument.isEnroute());
        Assert.assertTrue((boolean)workflowDocument.isApprovalRequested());
        new JdbcTemplate(TestHarnessServiceLocator.getDataSource()).execute("update KREW_DOC_HDR_T set INITR_PRNCPL_ID = 'bogus user' where DOC_HDR_ID = " + workflowDocument.getDocumentId());
        Person user = KimApiServiceLocator.getPersonService().getPersonByPrincipalName("jhopf");
        DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        DocumentSearchResults results = this.docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((String)"Search returned invalid number of documents", (long)1L, (long)results.getSearchResults().size());
    }

    @Test
    public void testDocSearch_SearchOnMissingInitiator() throws Exception {
        String documentTypeName = "SearchDocType";
        DocumentType docType = ((DocumentTypeService)KEWServiceLocator.getService((String)"enDocumentTypeService")).findByName(documentTypeName);
        String userNetworkId = "arh14";
        WorkflowDocument workflowDocument = WorkflowDocumentFactory.createDocument((String)this.getPrincipalId(userNetworkId), (String)documentTypeName);
        workflowDocument.setTitle("testDocSearch_MissingInitiator");
        workflowDocument.route("routing this document.");
        workflowDocument = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalId("jhopf"), (String)workflowDocument.getDocumentId());
        Assert.assertTrue((boolean)workflowDocument.isEnroute());
        Assert.assertTrue((boolean)workflowDocument.isApprovalRequested());
        new JdbcTemplate(TestHarnessServiceLocator.getDataSource()).execute("update KREW_DOC_HDR_T set INITR_PRNCPL_ID = 'bogus user' where DOC_HDR_ID = " + workflowDocument.getDocumentId());
        Person user = KimApiServiceLocator.getPersonService().getPersonByPrincipalName("jhopf");
        DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        criteria.setInitiatorPrincipalName("bogus user");
        DocumentSearchResults results = this.docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        int size = results.getSearchResults().size();
        Assert.assertTrue((String)"Searching by an invalid initiator should return nothing", (size == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDocSearch_RouteNodeName() throws Exception {
        this.loadXmlFile("DocSearchTest_RouteNode.xml");
        String documentTypeName = "SearchDocType_RouteNodeTest";
        DocumentType docType = ((DocumentTypeService)KEWServiceLocator.getService((String)"enDocumentTypeService")).findByName(documentTypeName);
        String userNetworkId = "rkirkend";
        WorkflowDocument workflowDocument = WorkflowDocumentFactory.createDocument((String)this.getPrincipalId(userNetworkId), (String)documentTypeName);
        workflowDocument.setTitle("Routing style");
        workflowDocument.route("routing this document.");
        workflowDocument = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalId("jhopf"), (String)workflowDocument.getDocumentId());
        Assert.assertTrue((boolean)workflowDocument.isEnroute());
        Assert.assertTrue((boolean)workflowDocument.isApprovalRequested());
        workflowDocument.approve("");
        workflowDocument = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalId("jhopf"), (String)workflowDocument.getDocumentId());
        Assert.assertTrue((boolean)workflowDocument.isFinal());
        workflowDocument = WorkflowDocumentFactory.createDocument((String)this.getPrincipalId(userNetworkId), (String)documentTypeName);
        workflowDocument.setTitle("Routing style");
        workflowDocument.route("routing this document.");
        workflowDocument = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalId("jhopf"), (String)workflowDocument.getDocumentId());
        Assert.assertTrue((boolean)workflowDocument.isEnroute());
        Assert.assertTrue((boolean)workflowDocument.isApprovalRequested());
        Person user = KimApiServiceLocator.getPersonService().getPersonByPrincipalName(userNetworkId);
        DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        DocumentSearchResults results = this.docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((String)"Search returned invalid number of documents", (long)2L, (long)results.getSearchResults().size());
        criteria.setRouteNodeName(this.getRouteNodeForSearch(documentTypeName, workflowDocument.getNodeNames()));
        criteria.setRouteNodeLookupLogic(RouteNodeLookupLogic.EXACTLY);
        results = this.docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((String)"Search returned invalid number of documents", (long)1L, (long)results.getSearchResults().size());
        this.loadXmlFile("DocSearchTest_RouteNode.xml");
        workflowDocument = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalId("jhopf"), (String)workflowDocument.getDocumentId());
        Assert.assertTrue((boolean)workflowDocument.isEnroute());
        Assert.assertTrue((boolean)workflowDocument.isApprovalRequested());
        criteria.setRouteNodeName(this.getRouteNodeForSearch(documentTypeName, workflowDocument.getNodeNames()));
        results = this.docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((String)"Search returned invalid number of documents", (long)1L, (long)results.getSearchResults().size());
    }

    private String getRouteNodeForSearch(String documentTypeName, Set<String> nodeNames) {
        Assert.assertEquals((long)1L, (long)nodeNames.size());
        String expectedNodeName = nodeNames.iterator().next();
        List routeNodes = KEWServiceLocator.getRouteNodeService().getFlattenedNodes(KEWServiceLocator.getDocumentTypeService().findByName(documentTypeName), true);
        for (RouteNode node : routeNodes) {
            if (!expectedNodeName.equals(node.getRouteNodeName())) continue;
            return node.getRouteNodeName();
        }
        return null;
    }

    @Test
    public void testGetNamedDocSearches() throws Exception {
        List namedSearches = this.docSearchService.getNamedSearches(this.getPrincipalId("bmcgough"));
        Assert.assertNotNull((Object)namedSearches);
    }

    private static int getDifferenceInDays(DateTime compareDate) {
        return Days.daysBetween((ReadableInstant)compareDate, (ReadableInstant)new DateTime()).getDays();
    }

    @Test
    public void testDocSearchWithAttributes() throws Exception {
        String[] docIds = this.routeTestDocs();
        String principalId = this.getPrincipalId("bmcgough");
        DocumentSearchCriteria.Builder builder = DocumentSearchCriteria.Builder.create();
        builder.setDocumentTypeName("SearchDocType");
        builder.setSaveName("testDocSearchWithAttributes");
        HashMap<String, List<String>> docAttrs = new HashMap<String, List<String>>();
        docAttrs.put("givenname", Arrays.asList("jack"));
        builder.setDocumentAttributeValues(docAttrs);
        DocumentSearchResults results = this.docSearchService.lookupDocuments(principalId, builder.build());
        Assert.assertEquals((long)docIds.length, (long)results.getSearchResults().size());
        DocumentSearchCriteria loaded = this.docSearchService.getNamedSearchCriteria(principalId, builder.getSaveName());
        Assert.assertNotNull((Object)loaded);
        Assert.assertEquals(docAttrs, (Object)loaded.getDocumentAttributeValues());
        results = this.docSearchService.lookupDocuments(principalId, loaded);
        Assert.assertEquals((long)docIds.length, (long)results.getSearchResults().size());
    }

    @Test
    public void testDocSearch_WildcardsOnRegularAttributes() throws Exception {
        int i;
        String[] docIds = this.routeTestDocs();
        String principalId = this.getPrincipalId("bmcgough");
        DocumentSearchCriteria.Builder criteria = null;
        DocumentSearchResults results = null;
        String[] searchStrings = new String[]{"!quickstart", "!quickstart&&!rkirkend", "!admin", "user1", "quickstart|bmcgough", "admin|rkirkend", ">bmcgough", ">=rkirkend", "<bmcgough", "<=quickstart", ">bmcgough&&<=rkirkend", "<rkirkend&&!bmcgough", "?mc?oug?", "*t", "*i?k*", "*", "!quick*", "!*g*&&!*k*", "quickstart..rkirkend"};
        int[] expectedResults = new int[]{2, 1, 3, 0, 2, 1, 2, 1, 0, 2, 2, 1, 1, 1, 2, 3, 2, 0, 2};
        for (i = 0; i < searchStrings.length; ++i) {
            criteria = DocumentSearchCriteria.Builder.create();
            criteria.setInitiatorPrincipalName(searchStrings[i]);
            results = this.docSearchService.lookupDocuments(principalId, criteria.build());
            Assert.assertEquals((String)("Initiator search at index " + i + " retrieved the wrong number of documents."), (long)expectedResults[i], (long)results.getSearchResults().size());
        }
        searchStrings = new String[]{"jhopf", "!jhopf", ">jhopf", "<jjopf", ">=quickstart", "<=jhopf", "jhope..jhopg", "?hopf", "*i*", "!*f", "j*"};
        expectedResults = new int[]{1, 0, 0, 1, 0, 1, 1, 1, 0, 0, 1};
        for (i = 0; i < searchStrings.length; ++i) {
            criteria = DocumentSearchCriteria.Builder.create();
            criteria.setApproverPrincipalName(searchStrings[i]);
            results = this.docSearchService.lookupDocuments(principalId, criteria.build());
            Assert.assertEquals((String)("Approver search at index " + i + " retrieved the wrong number of documents."), (long)expectedResults[i], (long)results.getSearchResults().size());
        }
        searchStrings = new String[]{"jhopf", "!jhopf", ">jhopf", "<jjopf", ">=quickstart", "<=jhopf", "jhope..jhopg", "?hopf", "*i*", "!*f", "j*"};
        expectedResults = new int[]{3, 0, 0, 3, 0, 3, 3, 3, 0, 0, 3};
        for (i = 0; i < searchStrings.length; ++i) {
            criteria = DocumentSearchCriteria.Builder.create();
            criteria.setViewerPrincipalName(searchStrings[i]);
            results = this.docSearchService.lookupDocuments(principalId, criteria.build());
            if (expectedResults[i] == results.getSearchResults().size()) continue;
            Assert.assertEquals((String)("Viewer search at index " + i + " retrieved the wrong number of documents."), (long)expectedResults[i], (long)results.getSearchResults().size());
        }
        searchStrings = new String[]{"!" + docIds[0], docIds[1] + "|" + docIds[2], "<=" + docIds[1], ">=" + docIds[2], "<" + docIds[0] + "&&>" + docIds[2], ">" + docIds[1], "<" + docIds[2] + "&&!" + docIds[0], docIds[0] + ".." + docIds[2], "?" + docIds[1] + "*", "?" + docIds[1].substring(1) + "*", "?9*7"};
        expectedResults = new int[]{2, 2, 2, 1, 0, 1, 1, 3, 0, 1, 0};
        for (i = 0; i < searchStrings.length; ++i) {
            criteria = DocumentSearchCriteria.Builder.create();
            criteria.setDocumentId(searchStrings[i]);
            results = this.docSearchService.lookupDocuments(principalId, criteria.build());
            Assert.assertEquals((String)("Doc ID search at index " + i + " retrieved the wrong number of documents."), (long)expectedResults[i], (long)results.getSearchResults().size());
        }
        searchStrings = new String[]{"6543", "5432|4321", ">4321", "<=5432", ">=6543", "<3210", "!3210", "!5432", "!4321!5432", ">4321&&!6543", "*5?3*", "*", "?3?1", "!*43*", "!???2", ">43*1", "<=5432&&!?32?", "5432..6543"};
        expectedResults = new int[]{1, 2, 2, 2, 1, 0, 3, 2, 1, 1, 2, 3, 1, 0, 2, 3, 1, 2};
        for (i = 0; i < searchStrings.length; ++i) {
            criteria = DocumentSearchCriteria.Builder.create();
            criteria.setApplicationDocumentId(searchStrings[i]);
            results = this.docSearchService.lookupDocuments(principalId, criteria.build());
            if (expectedResults[i] == results.getSearchResults().size()) continue;
            Assert.assertEquals((String)("App doc ID search at index " + i + " retrieved the wrong number of documents."), (long)expectedResults[i], (long)results.getSearchResults().size());
        }
        searchStrings = new String[]{"Some New Document", "Document Number 2|The New Doc", "!The New Doc", "!Some New Document!Document Number 2", "!The New Doc&&!Some New Document", ">Document Number 2", "<=Some New Document", ">=The New Doc&&<Some New Document", ">A New Doc", "<Some New Document|The New Doc", ">=Document Number 2&&!Some New Document", "*Docu??nt*", "*New*", "The ??? Doc", "*Doc*", "*Number*", "Some New Document..The New Doc", "Document..The", "*New*&&!*Some*", "!The ??? Doc|!*New*"};
        expectedResults = new int[]{1, 2, 2, 1, 1, 2, 2, 0, 3, 2, 2, 2, 2, 1, 3, 1, 2, 2, 1, 2};
        for (i = 0; i < searchStrings.length; ++i) {
            criteria = DocumentSearchCriteria.Builder.create();
            criteria.setTitle(searchStrings[i]);
            results = this.docSearchService.lookupDocuments(principalId, criteria.build());
            if (expectedResults[i] == results.getSearchResults().size()) continue;
            Assert.assertEquals((String)("Doc title search at index " + i + " retrieved the wrong number of documents."), (long)expectedResults[i], (long)results.getSearchResults().size());
        }
    }

    @Test
    public void testAdditionalDocumentTypesCriteria() throws Exception {
        String[] docIds = this.routeTestDocs();
        String docId2 = this.routeTestDoc2();
        String principalId = this.getPrincipalId("bmcgough");
        DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName("SearchDocType");
        DocumentSearchResults results = this.docSearchService.lookupDocuments(principalId, criteria.build());
        Assert.assertEquals((long)3L, (long)results.getSearchResults().size());
        criteria.setDocumentTypeName("SearchDocType2");
        results = this.docSearchService.lookupDocuments(principalId, criteria.build());
        Assert.assertEquals((long)1L, (long)results.getSearchResults().size());
        criteria.getAdditionalDocumentTypeNames().add("SearchDocType");
        results = this.docSearchService.lookupDocuments(principalId, criteria.build());
        Assert.assertEquals((long)4L, (long)results.getSearchResults().size());
    }

    @Test
    public void testDocumentStatusSearching() {
        String dt = "SearchDocType";
        String pid = this.getPrincipalIdForName("quickstart");
        WorkflowDocument initiated = WorkflowDocumentFactory.createDocument((String)pid, (String)dt);
        WorkflowDocument saved = WorkflowDocumentFactory.createDocument((String)pid, (String)dt);
        saved.saveDocument("saved");
        Assert.assertEquals((Object)DocumentStatus.SAVED, (Object)saved.getStatus());
        WorkflowDocument enroute = WorkflowDocumentFactory.createDocument((String)pid, (String)dt);
        enroute.route("routed");
        Assert.assertEquals((Object)DocumentStatus.ENROUTE, (Object)enroute.getStatus());
        WorkflowDocument exception = WorkflowDocumentFactory.createDocument((String)pid, (String)dt);
        exception.route("routed");
        exception.placeInExceptionRouting("placed in exception routing");
        Assert.assertEquals((Object)DocumentStatus.EXCEPTION, (Object)exception.getStatus());
        WorkflowDocument finl = WorkflowDocumentFactory.createDocument((String)pid, (String)dt);
        finl.route("routed");
        finl.switchPrincipal(this.getPrincipalId("jhopf"));
        finl.approve("approved");
        Assert.assertEquals((Object)DocumentStatus.FINAL, (Object)finl.getStatus());
        WorkflowDocument canceled = WorkflowDocumentFactory.createDocument((String)pid, (String)dt);
        canceled.cancel("canceled");
        Assert.assertEquals((Object)DocumentStatus.CANCELED, (Object)canceled.getStatus());
        WorkflowDocument disapproved = WorkflowDocumentFactory.createDocument((String)pid, (String)dt);
        disapproved.route("routed");
        disapproved.switchPrincipal(this.getPrincipalId("jhopf"));
        RequestedActions ra = disapproved.getRequestedActions();
        disapproved.disapprove("disapproved");
        Assert.assertEquals((Object)DocumentStatus.DISAPPROVED, (Object)disapproved.getStatus());
        this.assertDocumentStatuses(dt, pid, 1, 1, 1, 1, 0, 1, 1, 1);
    }

    protected void assertDocumentStatuses(String documentType, String principalId, int initiated, int saved, int enroute, int exception, int processed, int finl, int canceled, int disapproved) {
        this.assertDocumentStatus(documentType, principalId, DocumentStatus.INITIATED, initiated);
        this.assertDocumentStatus(documentType, principalId, DocumentStatus.SAVED, saved);
        this.assertDocumentStatus(documentType, principalId, DocumentStatus.ENROUTE, enroute);
        this.assertDocumentStatus(documentType, principalId, DocumentStatus.EXCEPTION, exception);
        this.assertDocumentStatusCategory(documentType, principalId, DocumentStatusCategory.PENDING, initiated + saved + enroute + exception);
        this.assertDocumentStatus(documentType, principalId, DocumentStatus.PROCESSED, processed);
        this.assertDocumentStatus(documentType, principalId, DocumentStatus.FINAL, finl);
        this.assertDocumentStatusCategory(documentType, principalId, DocumentStatusCategory.SUCCESSFUL, processed + finl);
        this.assertDocumentStatus(documentType, principalId, DocumentStatus.CANCELED, canceled);
        this.assertDocumentStatus(documentType, principalId, DocumentStatus.DISAPPROVED, finl);
        this.assertDocumentStatusCategory(documentType, principalId, DocumentStatusCategory.UNSUCCESSFUL, canceled + disapproved);
    }

    protected void assertDocumentStatus(String documentType, String principalId, DocumentStatus status, int num) {
        DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentType);
        criteria.setDocumentStatuses(Arrays.asList(status));
        DocumentSearchResults result = this.docSearchService.lookupDocuments(principalId, criteria.build());
        Assert.assertEquals((String)("Expected " + num + " documents in status " + status), (long)num, (long)result.getSearchResults().size());
    }

    protected void assertDocumentStatusCategory(String documentType, String principalId, DocumentStatusCategory status, int num) {
        DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentType);
        criteria.setDocumentStatusCategories(Arrays.asList(status));
        DocumentSearchResults result = this.docSearchService.lookupDocuments(principalId, criteria.build());
        Assert.assertEquals((String)("Expected " + num + " documents in status category " + status), (long)num, (long)result.getSearchResults().size());
    }

    protected String[] routeTestDocs() {
        String[] docIds = new String[TestDocData.titles.length];
        for (int i = 0; i < TestDocData.titles.length; ++i) {
            WorkflowDocument workflowDocument = WorkflowDocumentFactory.createDocument((String)this.getPrincipalId(TestDocData.principalNames[i]), (String)TestDocData.docTypeName);
            workflowDocument.setTitle(TestDocData.titles[i]);
            workflowDocument.setApplicationDocumentId(TestDocData.appDocIds[i]);
            workflowDocument.route("routing this document.");
            docIds[i] = workflowDocument.getDocumentId();
            if (TestDocData.approverNames[i] != null) {
                workflowDocument.switchPrincipal(this.getPrincipalId(TestDocData.approverNames[i]));
                workflowDocument.approve("approving this document.");
            }
            workflowDocument.setApplicationDocumentStatus(TestDocData.appDocStatuses[i]);
            workflowDocument.saveDocumentData();
        }
        return docIds;
    }

    protected String routeTestDoc2() {
        String docTypeName = "SearchDocType2";
        WorkflowDocument workflowDocument = WorkflowDocumentFactory.createDocument((String)this.getPrincipalId("ewestfal"), (String)docTypeName);
        workflowDocument.setTitle("Search Doc Type 2!");
        workflowDocument.saveDocument("saving the document");
        return workflowDocument.getDocumentId();
    }

    private String getPrincipalId(String principalName) {
        return KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName(principalName).getPrincipalId();
    }

    @Test
    public void testDocSearch_maxResultsCap() throws Exception {
        DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName("SearchDocType");
        int maxResultsCap = this.docSearchService.getMaxResultCap(criteria.build());
        Assert.assertEquals((long)500L, (long)maxResultsCap);
        criteria.setMaxResults(Integer.valueOf(5));
        int maxResultsCap1 = this.docSearchService.getMaxResultCap(criteria.build());
        Assert.assertEquals((long)5L, (long)maxResultsCap1);
        criteria.setMaxResults(Integer.valueOf(2));
        int maxResultsCap2 = this.docSearchService.getMaxResultCap(criteria.build());
        Assert.assertEquals((long)2L, (long)maxResultsCap2);
    }

    @Test
    public void testDocSearch_fetchMoreIterationLimit() throws Exception {
        DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName("SearchDocType");
        int fetchIterationLimit = this.docSearchService.getFetchMoreIterationLimit();
        Assert.assertEquals((long)10L, (long)fetchIterationLimit);
    }

    private static final class TestDocData {
        static String docTypeName = "SearchDocType";
        static String[] principalNames = new String[]{"bmcgough", "quickstart", "rkirkend"};
        static String[] titles = new String[]{"The New Doc", "Document Number 2", "Some New Document"};
        static String[] appDocIds = new String[]{"6543", "5432", "4321"};
        static String[] appDocStatuses = new String[]{"Submitted", "Pending", "Completed"};
        static String[] approverNames = new String[]{null, "jhopf", null};

        private TestDocData() {
            throw new IllegalStateException("leave me alone");
        }
    }
}

