/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.mail;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.mail.EmailContent;
import org.kuali.rice.coreservice.api.CoreServiceApiServiceLocator;
import org.kuali.rice.kew.actionitem.ActionItem;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.mail.service.impl.ActionListEmailServiceImpl;
import org.kuali.rice.kew.mail.service.impl.StyleableEmailContentServiceImpl;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class EmailMessageTest
extends KEWTestCase {
    private ActionListEmailServiceImpl actionListEmailService = new ActionListEmailServiceImpl();
    private StyleableEmailContentServiceImpl styleableContentService = new StyleableEmailContentServiceImpl();

    public void setUp() throws Exception {
        super.setUp();
        this.actionListEmailService.setDeploymentEnvironment("dev");
        this.styleableContentService.setDeploymentEnvironment("dev");
        this.styleableContentService.setStyleService(CoreServiceApiServiceLocator.getStyleService());
    }

    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("EmailMessageDocType.xml");
    }

    private int generateDocs(String[] docTypes, Person user) throws Exception {
        String principalId = user.getPrincipalId();
        for (String docType : docTypes) {
            WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)principalId, (String)docType);
            document.setTitle("a title");
            document.route("");
            document = WorkflowDocumentFactory.createDocument((String)principalId, (String)docType);
            document.setTitle("a title");
            document.route("");
            document = WorkflowDocumentFactory.createDocument((String)principalId, (String)docType);
            document.setTitle("a title");
            document.route("");
            document = WorkflowDocumentFactory.createDocument((String)principalId, (String)docType);
            document.setTitle("a title");
            document.route("");
            document = WorkflowDocumentFactory.createDocument((String)principalId, (String)docType);
            document.setTitle("a title");
            document.route("");
        }
        return 5 * docTypes.length;
    }

    @Test
    public void testGenerateRemindersCustomStyleSheet() throws Exception {
        this.loadXmlFile("customEmailStyleData.xml");
        Assert.assertNotNull((Object)CoreServiceApiServiceLocator.getStyleService().getStyle("kew.email.style"));
        Person user = KimApiServiceLocator.getPersonService().getPersonByPrincipalName("arh14");
        int count = this.generateDocs(new String[]{"PingDocument", "PingDocumentWithEmailAttrib"}, user);
        List actionItems = ActionItem.to(new ArrayList(KEWServiceLocator.getActionListService().getActionList(user.getPrincipalId(), null)));
        Assert.assertEquals((String)("user should have " + count + " items in his action list."), (long)count, (long)actionItems.size());
        EmailContent content = this.styleableContentService.generateImmediateReminder(user, (org.kuali.rice.kew.api.action.ActionItem)actionItems.iterator().next(), KEWServiceLocator.getDocumentTypeService().findByName(((org.kuali.rice.kew.api.action.ActionItem)actionItems.iterator().next()).getDocName()));
        Assert.assertTrue((String)"Unexpected subject", (boolean)content.getSubject().startsWith("CUSTOM:"));
        Assert.assertTrue((String)"Unexpected body", (boolean)content.getBody().startsWith("CUSTOM:"));
        content = this.styleableContentService.generateDailyReminder(user, (Collection)actionItems);
        Assert.assertTrue((String)"Unexpected subject", (boolean)content.getSubject().startsWith("CUSTOM:"));
        Assert.assertTrue((String)"Unexpected body", (boolean)content.getBody().startsWith("CUSTOM:"));
        content = this.styleableContentService.generateWeeklyReminder(user, (Collection)actionItems);
        Assert.assertTrue((String)"Unexpected subject", (boolean)content.getSubject().startsWith("CUSTOM:"));
        Assert.assertTrue((String)"Unexpected body", (boolean)content.getBody().startsWith("CUSTOM:"));
    }

    @Test
    public void testGenerateRemindersDocCustomStyleSheet() throws Exception {
        this.loadXmlFile("customEmailStyleData.xml");
        this.loadXmlFile("docCustomEmailStyleData.xml");
        Assert.assertNotNull((Object)CoreServiceApiServiceLocator.getStyleService().getStyle("kew.email.style"));
        Assert.assertNotNull((Object)CoreServiceApiServiceLocator.getStyleService().getStyle("doc.custom.email.style"));
        Person user = KimApiServiceLocator.getPersonService().getPersonByPrincipalName("arh14");
        int count = this.generateDocs(new String[]{"PingDocumentCustomStyle"}, user);
        List actionItems = ActionItem.to(new ArrayList(KEWServiceLocator.getActionListService().getActionList(user.getPrincipalId(), null)));
        Assert.assertEquals((String)("user should have " + count + " items in his action list."), (long)count, (long)actionItems.size());
        EmailContent content = this.styleableContentService.generateImmediateReminder(user, (org.kuali.rice.kew.api.action.ActionItem)actionItems.iterator().next(), KEWServiceLocator.getDocumentTypeService().findByName(((org.kuali.rice.kew.api.action.ActionItem)actionItems.iterator().next()).getDocName()));
        Assert.assertFalse((String)"Unexpected subject", (boolean)content.getSubject().startsWith("CUSTOM:"));
        Assert.assertFalse((String)"Unexpected body", (boolean)content.getBody().startsWith("CUSTOM:"));
        Assert.assertTrue((String)"Unexpected subject", (boolean)content.getSubject().startsWith("DOCTYPE CUSTOM:"));
        Assert.assertTrue((String)"Unexpected body", (boolean)content.getBody().startsWith("DOCTYPE CUSTOM:"));
        content = this.styleableContentService.generateDailyReminder(user, (Collection)actionItems);
        Assert.assertTrue((String)"Unexpected subject", (boolean)content.getSubject().startsWith("CUSTOM:"));
        Assert.assertTrue((String)"Unexpected body", (boolean)content.getBody().startsWith("CUSTOM:"));
        content = this.styleableContentService.generateWeeklyReminder(user, (Collection)actionItems);
        Assert.assertTrue((String)"Unexpected subject", (boolean)content.getSubject().startsWith("CUSTOM:"));
        Assert.assertTrue((String)"Unexpected body", (boolean)content.getBody().startsWith("CUSTOM:"));
    }
}

