/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.useroptions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kew.useroptions.UserOptions;
import org.kuali.rice.kew.useroptions.UserOptionsService;
import org.kuali.rice.kim.api.identity.principal.Principal;

public class UserOptionsServiceTest
extends KEWTestCase {
    private static final String REFRESH_RATE = "REFRESH_RATE";
    private static final String ELEVEN = "11";

    @Test
    public void testUserOptionsSaveWithPrincipalIdOptionIdOptionVal() throws Exception {
        UserOptionsService userOptionsService = this.getUserOptionsService();
        Principal principal = this.getPrincipalByPrincipalName("ewestfal");
        Collection userOptions = userOptionsService.findByWorkflowUser(principal.getPrincipalId());
        Assert.assertTrue((String)"UserOptions should by empty", (boolean)userOptions.isEmpty());
        userOptionsService.save(principal.getPrincipalId(), REFRESH_RATE, ELEVEN);
        userOptions = userOptionsService.findByWorkflowUser(principal.getPrincipalId());
        Assert.assertFalse((String)"UserOptions should not by empty", (boolean)userOptions.isEmpty());
        UserOptions firstUsrOpt = (UserOptions)new ArrayList(userOptions).get(0);
        Assert.assertTrue((String)"UserOption option id should be REFRESH_RATE", (boolean)REFRESH_RATE.equals(firstUsrOpt.getOptionId()));
        Assert.assertTrue((String)"UserOption option value should be 11", (boolean)ELEVEN.equals(firstUsrOpt.getOptionVal()));
    }

    @Test
    public void testUserOptionsSaveWithOptionMap() throws Exception {
        UserOptionsService userOptionsService = this.getUserOptionsService();
        Principal principal = this.getPrincipalByPrincipalName("ewestfal");
        Collection userOptions = userOptionsService.findByWorkflowUser(principal.getPrincipalId());
        Assert.assertTrue((String)"UserOptions should by empty", (boolean)userOptions.isEmpty());
        HashMap<String, String> userOptMap = new HashMap<String, String>();
        userOptMap.put("favoriteColor", "blue");
        userOptMap.put("backgroundColor", "white");
        userOptMap.put(REFRESH_RATE, "30");
        userOptionsService.save(principal.getPrincipalId(), userOptMap);
        userOptions = userOptionsService.findByWorkflowUser(principal.getPrincipalId());
        Assert.assertFalse((String)"UserOptions should not be empty", (boolean)userOptions.isEmpty());
        Assert.assertTrue((String)"UserOptions should contain three items", (userOptions.size() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testFindByUserQualified() throws Exception {
        UserOptionsService userOptionsService = this.getUserOptionsService();
        Principal principal = this.getPrincipalByPrincipalName("ewestfal");
        Collection userOptions = userOptionsService.findByWorkflowUser(principal.getPrincipalId());
        Assert.assertTrue((String)"UserOptions should by empty", (boolean)userOptions.isEmpty());
        HashMap<String, String> userOptMap = new HashMap<String, String>();
        userOptMap.put("favoriteColor", "blue");
        userOptMap.put("favoriteFood", "pizza");
        userOptMap.put("favoriteTimeOfYear", "summer");
        userOptMap.put(REFRESH_RATE, "30");
        userOptMap.put("lastSaveDate", "now");
        userOptionsService.save(principal.getPrincipalId(), userOptMap);
        userOptions = userOptionsService.findByWorkflowUser(principal.getPrincipalId());
        Assert.assertFalse((String)"UserOptions should not be empty", (boolean)userOptions.isEmpty());
        Assert.assertTrue((String)"UserOptions should contain five items", (userOptions.size() == 5 ? 1 : 0) != 0);
        userOptions = userOptionsService.findByUserQualified(principal.getPrincipalId(), "favorite%");
        Assert.assertFalse((String)"UserOptions should not be empty", (boolean)userOptions.isEmpty());
        Assert.assertTrue((String)"UserOptions should contain 3 items.", (userOptions.size() == 3 ? 1 : 0) != 0);
        for (UserOptions opt : userOptions) {
            Assert.assertTrue((String)("UserOptionId (" + opt.getOptionId() + ") should start with favorite"), (boolean)opt.getOptionId().startsWith("favorite"));
        }
    }

    @Test
    public void testRetrieveEmailPreferenceUserOptions() throws Exception {
        UserOptionsService userOptionsService = this.getUserOptionsService();
        Principal principal = this.getPrincipalByPrincipalName("ewestfal");
        Collection userOptions = userOptionsService.findByWorkflowUser(principal.getPrincipalId());
        Assert.assertTrue((String)"UserOptions should by empty", (boolean)userOptions.isEmpty());
        HashMap<String, String> userOptMap1 = new HashMap<String, String>();
        userOptMap1.put("favoriteColor", "blue");
        userOptMap1.put("favoriteFood", "pizza");
        userOptMap1.put("favoriteTimeOfYear", "summer");
        userOptMap1.put(REFRESH_RATE, "30");
        List optList = userOptionsService.retrieveEmailPreferenceUserOptions("testValue");
        Assert.assertTrue((String)"OptList should be empty.", (boolean)optList.isEmpty());
        HashMap<String, String> userOptMap2 = new HashMap<String, String>();
        userOptMap2.put("favoriteColor", "blue");
        userOptMap2.put("favoriteFood", "pizza");
        userOptMap2.put("favoriteTimeOfYear", "summer");
        userOptMap2.put(REFRESH_RATE, "30");
        userOptMap2.put("EMAIL_NOTIFICATION", "daily");
        userOptMap2.put("Error.DocumentTypeNotification", "daily");
        userOptMap2.put("Warning.DocumentTypeNotification", "daily");
        userOptionsService.save(principal.getPrincipalId(), userOptMap2);
        optList = userOptionsService.retrieveEmailPreferenceUserOptions("daily");
        Assert.assertFalse((String)"OptList should not be empty", (boolean)optList.isEmpty());
        Assert.assertTrue((String)("OptList should contain 3 items, optList size is: " + optList.size()), (optList.size() == 3 ? 1 : 0) != 0);
    }

    private UserOptionsService getUserOptionsService() {
        return KEWServiceLocator.getUserOptionsService();
    }

    private Principal getPrincipalByPrincipalName(String principleName) {
        return KEWServiceLocator.getIdentityHelperService().getPrincipalByPrincipalName(principleName);
    }
}

