/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.edl.impl;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.edl.impl.EDLController;
import org.kuali.rice.edl.impl.EDLControllerChain;
import org.kuali.rice.edl.impl.RequestParser;
import org.kuali.rice.edl.impl.service.EdlServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.test.BaselineTestCase;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.NONE)
public class EDLControllerChainTest
extends KEWTestCase {
    private static final String EXPECTED_OUTPUT = "<html xmlns:wf=\"http://xml.apaches.org/xalan/java/org.kuali.rice.edl.framework.util.EDLFunctions\">\n<body>admin</body>\n</html>";

    @Override
    protected void loadTestData() throws Exception {
        super.loadXmlFile("EDLControllerChainTest.xml");
    }

    @Test
    public void testRenderEdl_WithEdlFunctions() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addHeader("User-Agent", (Object)"JUnit");
        MockHttpServletResponse response = new MockHttpServletResponse();
        RequestParser requestParser = new RequestParser((HttpServletRequest)request);
        requestParser.setParameterValue("command", "initiate");
        requestParser.setParameterValue("userAction", "initiate");
        UserSession userSession = new UserSession("admin");
        GlobalVariables.setUserSession((UserSession)userSession);
        EDLController edlController = EdlServiceLocator.getEDocLiteService().getEDLControllerUsingEdlName("TestDocumentType");
        EDLControllerChain chain = new EDLControllerChain();
        chain.addEdlController(edlController);
        chain.renderEDL(requestParser, (HttpServletResponse)response);
        Assert.assertEquals((Object)EXPECTED_OUTPUT, (Object)response.getContentAsString().trim());
    }
}

