/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.batch;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.util.ClasspathOrFileResourceLoader;
import org.kuali.rice.core.api.util.xml.XmlJotter;
import org.kuali.rice.core.impl.impex.xml.ClassLoaderEntityResolver;
import org.kuali.rice.kew.rule.xmlrouting.WorkflowNamespaceContext;
import org.kuali.rice.kew.test.KEWTestCase;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlSchemaTest
extends KEWTestCase {
    private Document validate(InputStream stream) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(true);
        dbf.setNamespaceAware(true);
        dbf.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        DocumentBuilder db = dbf.newDocumentBuilder();
        db.setEntityResolver((EntityResolver)new ClassLoaderEntityResolver());
        db.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException se) {
                XmlSchemaTest.this.log.warn((Object)"Warning parsing xml", (Throwable)se);
            }

            @Override
            public void error(SAXParseException se) throws SAXException {
                XmlSchemaTest.this.log.error((Object)"Error parsing xml", (Throwable)se);
                throw se;
            }

            @Override
            public void fatalError(SAXParseException se) throws SAXException {
                XmlSchemaTest.this.log.error((Object)"Fatal error parsing xml", (Throwable)se);
                throw se;
            }
        });
        return db.parse(stream);
    }

    @Test
    public void testValidation() throws ParserConfigurationException, IOException, SAXException {
        Properties filesToIngest = new Properties();
        filesToIngest.load(((Object)((Object)this)).getClass().getResourceAsStream("XmlSchemaTest.txt"));
        for (Map.Entry<Object, Object> entry : filesToIngest.entrySet()) {
            String filePath = entry.getKey().toString();
            File testFile = new ClasspathOrFileResourceLoader().getResource(filePath).getFile();
            boolean shouldSucceed = Boolean.valueOf(entry.getValue().toString());
            System.out.println("Validating " + testFile);
            try {
                this.validate(new FileInputStream(testFile));
                if (shouldSucceed) continue;
                Assert.fail((String)("Invalid test file '" + testFile + "' passed validation"));
            }
            catch (Exception e) {
                if (!shouldSucceed) continue;
                e.printStackTrace();
                Assert.fail((String)("Valid test file '" + testFile + "' failed validation"));
            }
        }
    }

    @Test
    public void testDefaultAttributeValue() throws Exception {
        URL url = ((Object)((Object)this)).getClass().getResource("XmlConfig.xml");
        Document d = this.validate(url.openStream());
        System.out.println(XmlJotter.jotNode((Node)d));
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext((NamespaceContext)new WorkflowNamespaceContext());
        Node node = (Node)xpath.evaluate("/data/ruleAttributes/ruleAttribute[name='XMLSearchableAttribute']/searchingConfig/fieldDef[@name='givenname' and @workflowType='ALL']/@title", d, XPathConstants.NODE);
        System.out.println("n: " + node);
    }

    protected String getModuleName() {
        return "kew";
    }
}

