/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.docmentlink;

import java.util.List;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.document.DocumentLink;
import org.kuali.rice.kew.api.document.WorkflowDocumentService;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public class DocumentLinkTest
extends KEWTestCase {
    private static final Logger LOG = Logger.getLogger(DocumentLinkTest.class);
    private WorkflowDocumentService service;

    @Override
    protected void setUpAfterDataLoad() throws Exception {
        super.setUpAfterDataLoad();
        this.service = KewApiServiceLocator.getWorkflowDocumentService();
    }

    @Test
    public void testAddLinkBTW2DocsSucess() throws Exception {
        DocumentLink testDocLink1 = DocumentLink.Builder.create((String)"5000", (String)"6000").build();
        testDocLink1 = this.service.addDocumentLink(testDocLink1);
        Assert.assertNotNull((Object)testDocLink1.getId());
        Assert.assertEquals((Object)"5000", (Object)testDocLink1.getOriginatingDocumentId());
        Assert.assertEquals((Object)"6000", (Object)testDocLink1.getDestinationDocumentId());
        List outgoingLinks = this.service.getOutgoingDocumentLinks("6000");
        Assert.assertEquals((long)1L, (long)outgoingLinks.size());
        DocumentLink testDocLink2 = (DocumentLink)outgoingLinks.get(0);
        Assert.assertEquals((Object)testDocLink1.getOriginatingDocumentId(), (Object)testDocLink2.getDestinationDocumentId());
        Assert.assertEquals((Object)testDocLink2.getOriginatingDocumentId(), (Object)testDocLink1.getDestinationDocumentId());
    }

    @Test
    public void testAddDuplicatedLinkBTW2DocsFailure() throws Exception {
        DocumentLink testDocLink = DocumentLink.Builder.create((String)"5000", (String)"6000").build();
        DocumentLink testDocLinkAdded = this.service.addDocumentLink(testDocLink);
        Assert.assertNotNull((Object)testDocLinkAdded);
        Assert.assertNotNull((Object)testDocLinkAdded.getId());
        List links1 = this.service.getOutgoingDocumentLinks("5000");
        Assert.assertEquals((long)1L, (long)links1.size());
        DocumentLink testDocLinkAdded2 = this.service.addDocumentLink(testDocLink);
        Assert.assertNotNull((Object)testDocLinkAdded);
        Assert.assertNotNull((Object)testDocLinkAdded.getId());
        Assert.assertEquals((Object)testDocLinkAdded2, (Object)testDocLinkAdded);
        List links2 = this.service.getOutgoingDocumentLinks("5000");
        Assert.assertEquals((long)1L, (long)links2.size());
        Assert.assertEquals((long)links1.size(), (long)links2.size());
    }

    @Test
    public void testAddIncomplelteLinkBTW2DocsFailure() throws Exception {
        try {
            DocumentLink.Builder.create(null, null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            DocumentLink.Builder.create((String)"6000", null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("was null or blank"));
        }
    }

    @Test
    public void testGetLinkBTW2DocsSucess() throws Exception {
        DocumentLink testDocLink = DocumentLink.Builder.create((String)"5000", (String)"6000").build();
        DocumentLink link1 = this.service.addDocumentLink(testDocLink);
        link1 = this.service.getDocumentLink(link1.getId());
        Assert.assertNotNull((Object)link1);
        Assert.assertEquals((Object)testDocLink.getOriginatingDocumentId(), (Object)link1.getOriginatingDocumentId());
        Assert.assertEquals((Object)testDocLink.getDestinationDocumentId(), (Object)link1.getDestinationDocumentId());
    }

    @Test
    public void testGetLinkBTW2DocsFailure() throws Exception {
        DocumentLink testDocLink = DocumentLink.Builder.create((String)"5000", (String)"6000").build();
        this.service.addDocumentLink(testDocLink);
        List links = this.service.getOutgoingDocumentLinks("5001");
        Assert.assertTrue((boolean)links.isEmpty());
    }

    @Test
    public void testGetAllLinksFromOrgnDocSucess() throws Exception {
        DocumentLink link1 = DocumentLink.Builder.create((String)"5000", (String)"6000").build();
        this.service.addDocumentLink(link1);
        DocumentLink link2 = DocumentLink.Builder.create((String)"5009", (String)"6009").build();
        this.service.addDocumentLink(link2);
        DocumentLink link3 = DocumentLink.Builder.create((String)"5000", (String)"6003").build();
        this.service.addDocumentLink(link3);
        DocumentLink link4 = DocumentLink.Builder.create((String)"5000", (String)"6004").build();
        this.service.addDocumentLink(link4);
        List links = this.service.getOutgoingDocumentLinks("5000");
        Assert.assertEquals((long)3L, (long)links.size());
    }

    @Test
    public void testGetAllLinksFromOrgnDocFailure() throws Exception {
        DocumentLink link1 = DocumentLink.Builder.create((String)"5000", (String)"6000").build();
        this.service.addDocumentLink(link1);
        DocumentLink link2 = DocumentLink.Builder.create((String)"5009", (String)"6009").build();
        this.service.addDocumentLink(link2);
        DocumentLink link3 = DocumentLink.Builder.create((String)"5000", (String)"6003").build();
        this.service.addDocumentLink(link3);
        List links = this.service.getOutgoingDocumentLinks("8000");
        Assert.assertEquals((long)0L, (long)links.size());
    }

    @Test
    public void testRemoveLinkBTW2DocsSucess() throws Exception {
        DocumentLink link1 = DocumentLink.Builder.create((String)"5000", (String)"6000").build();
        link1 = this.service.addDocumentLink(link1);
        List links1 = this.service.getOutgoingDocumentLinks("5000");
        Assert.assertEquals((long)1L, (long)links1.size());
        List links2 = this.service.getOutgoingDocumentLinks("6000");
        Assert.assertEquals((long)1L, (long)links2.size());
        DocumentLink deletedLink = this.service.deleteDocumentLink(link1.getId());
        Assert.assertNotNull((Object)deletedLink);
        List links3 = this.service.getOutgoingDocumentLinks("5000");
        Assert.assertEquals((long)0L, (long)links3.size());
    }

    @Test
    public void testRemoveAllLinksFromOrgnDocSucess() throws Exception {
        DocumentLink link1 = DocumentLink.Builder.create((String)"5000", (String)"6000").build();
        link1 = this.service.addDocumentLink(link1);
        DocumentLink link2 = DocumentLink.Builder.create((String)"5000", (String)"6002").build();
        link2 = this.service.addDocumentLink(link2);
        List links01 = this.service.getOutgoingDocumentLinks("5000");
        List links02 = this.service.getOutgoingDocumentLinks("6000");
        List links03 = this.service.getOutgoingDocumentLinks("6002");
        Assert.assertEquals((long)2L, (long)links01.size());
        Assert.assertEquals((long)1L, (long)links02.size());
        Assert.assertEquals((long)1L, (long)links03.size());
        List deletedDocuments = this.service.deleteDocumentLinksByDocumentId("5000");
        Assert.assertEquals((long)2L, (long)deletedDocuments.size());
        links01 = this.service.getOutgoingDocumentLinks("5000");
        links02 = this.service.getOutgoingDocumentLinks("6000");
        links03 = this.service.getOutgoingDocumentLinks("6002");
        Assert.assertEquals((long)0L, (long)links01.size());
        Assert.assertEquals((long)0L, (long)links02.size());
        Assert.assertEquals((long)0L, (long)links03.size());
    }

    @Test
    public void testDocLinktoItself() throws Exception {
        try {
            DocumentLink.Builder.create((String)"5000", (String)"5000");
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("cannot link a document with itself"));
        }
    }
}

