/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.test.service;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kim.api.identity.CodedAttribute;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.address.EntityAddressContract;
import org.kuali.rice.kim.api.identity.affiliation.EntityAffiliation;
import org.kuali.rice.kim.api.identity.affiliation.EntityAffiliationType;
import org.kuali.rice.kim.api.identity.email.EntityEmailContract;
import org.kuali.rice.kim.api.identity.employment.EntityEmploymentContract;
import org.kuali.rice.kim.api.identity.entity.Entity;
import org.kuali.rice.kim.api.identity.name.EntityNameContract;
import org.kuali.rice.kim.api.identity.phone.EntityPhoneContract;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;
import org.kuali.rice.kim.api.identity.type.EntityTypeContactInfo;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.bo.ui.PersonDocumentAddress;
import org.kuali.rice.kim.bo.ui.PersonDocumentAffiliation;
import org.kuali.rice.kim.bo.ui.PersonDocumentEmail;
import org.kuali.rice.kim.bo.ui.PersonDocumentEmploymentInfo;
import org.kuali.rice.kim.bo.ui.PersonDocumentName;
import org.kuali.rice.kim.bo.ui.PersonDocumentPhone;
import org.kuali.rice.kim.bo.ui.PersonDocumentPrivacy;
import org.kuali.rice.kim.bo.ui.PersonDocumentRole;
import org.kuali.rice.kim.document.IdentityManagementPersonDocument;
import org.kuali.rice.kim.impl.identity.address.EntityAddressTypeBo;
import org.kuali.rice.kim.impl.identity.affiliation.EntityAffiliationTypeBo;
import org.kuali.rice.kim.impl.identity.email.EntityEmailTypeBo;
import org.kuali.rice.kim.impl.identity.name.EntityNameTypeBo;
import org.kuali.rice.kim.impl.identity.phone.EntityPhoneTypeBo;
import org.kuali.rice.kim.impl.identity.privacy.EntityPrivacyPreferencesBo;
import org.kuali.rice.kim.impl.type.KimTypeAttributeBo;
import org.kuali.rice.kim.impl.type.KimTypeBo;
import org.kuali.rice.kim.service.KIMServiceLocatorInternal;
import org.kuali.rice.kim.service.UiDocumentService;
import org.kuali.rice.kim.test.KIMTestCase;
import org.kuali.rice.kns.kim.type.DataDictionaryTypeServiceBase;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public class UiDocumentServiceImplTest
extends KIMTestCase {
    private UiDocumentService uiDocumentService;

    public void setUp() throws Exception {
        super.setUp();
        this.uiDocumentService = KIMServiceLocatorInternal.getUiDocumentService();
    }

    @Test
    public void testSaveToEntity() {
        Person adminPerson = KimApiServiceLocator.getPersonService().getPersonByPrincipalName("admin");
        IdentityManagementPersonDocument personDoc = this.initPersonDoc();
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)adminPerson.getPrincipalId(), (String)"TestDocumentType");
        personDoc.getDocumentHeader().setWorkflowDocument(document);
        this.uiDocumentService.saveEntityPerson(personDoc);
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("id", "entity124eId");
        criteria.put("entityTypeCode", "PERSON");
        Entity entity = KimApiServiceLocator.getIdentityService().getEntity(personDoc.getEntityId());
        EntityTypeContactInfo entityType = (EntityTypeContactInfo)entity.getEntityTypeContactInfos().get(0);
        personDoc.getExternalIdentifiers();
        this.assertAddressTrue((PersonDocumentAddress)personDoc.getAddrs().get(0), (EntityAddressContract)entityType.getAddresses().get(0));
        this.assertPhoneTrue((PersonDocumentPhone)personDoc.getPhones().get(0), (EntityPhoneContract)entityType.getPhoneNumbers().get(0));
        this.assertEmailTrue((PersonDocumentEmail)personDoc.getEmails().get(0), (EntityEmailContract)entityType.getEmailAddresses().get(0));
        this.assertNameTrue((PersonDocumentName)personDoc.getNames().get(0), (EntityNameContract)entity.getNames().get(0));
        this.assertPrincipalTrue(personDoc, (PrincipalContract)entity.getPrincipals().get(0));
        this.assertAffiliationTrue((PersonDocumentAffiliation)personDoc.getAffiliations().get(0), (EntityAffiliation)entity.getAffiliations().get(0));
        this.assertEmpInfoTrue((PersonDocumentEmploymentInfo)((PersonDocumentAffiliation)personDoc.getAffiliations().get(0)).getEmpInfos().get(0), (EntityEmploymentContract)entity.getEmploymentInformation().get(0));
        this.uiDocumentService.saveEntityPerson(personDoc);
        Entity entity2 = ((IdentityService)KIMServiceLocatorInternal.getService((String)"kimIdentityDelegateService")).getEntity(personDoc.getEntityId());
        EntityTypeContactInfo entityType2 = (EntityTypeContactInfo)entity2.getEntityTypeContactInfos().get(0);
        personDoc.getExternalIdentifiers();
        this.assertAddressTrue((PersonDocumentAddress)personDoc.getAddrs().get(0), (EntityAddressContract)entityType2.getAddresses().get(0));
        this.assertPhoneTrue((PersonDocumentPhone)personDoc.getPhones().get(0), (EntityPhoneContract)entityType2.getPhoneNumbers().get(0));
        this.assertEmailTrue((PersonDocumentEmail)personDoc.getEmails().get(0), (EntityEmailContract)entityType2.getEmailAddresses().get(0));
        this.assertNameTrue((PersonDocumentName)personDoc.getNames().get(0), (EntityNameContract)entity2.getNames().get(0));
        this.assertPrincipalTrue(personDoc, (PrincipalContract)entity2.getPrincipals().get(0));
    }

    @Test
    public void testLoadToPersonDocument() {
        Entity entity = KimApiServiceLocator.getIdentityService().getEntity("entity123eId");
        Assert.assertNotNull((Object)entity);
        IdentityManagementPersonDocument personDoc = new IdentityManagementPersonDocument();
        this.uiDocumentService.loadEntityToPersonDoc(personDoc, "entity123pId");
        EntityTypeContactInfo entityType = (EntityTypeContactInfo)entity.getEntityTypeContactInfos().get(0);
        personDoc.getExternalIdentifiers();
        this.assertAddressTrue((PersonDocumentAddress)personDoc.getAddrs().get(0), (EntityAddressContract)entityType.getAddresses().get(0));
        this.assertPhoneTrue((PersonDocumentPhone)personDoc.getPhones().get(0), (EntityPhoneContract)entityType.getPhoneNumbers().get(0));
        this.assertEmailTrue((PersonDocumentEmail)personDoc.getEmails().get(0), (EntityEmailContract)entityType.getEmailAddresses().get(0));
        this.assertNameTrue((PersonDocumentName)personDoc.getNames().get(0), (EntityNameContract)entity.getNames().get(0));
        this.assertAffiliationTrue((PersonDocumentAffiliation)personDoc.getAffiliations().get(0), (EntityAffiliation)entity.getAffiliations().get(0));
        this.assertEmpInfoTrue((PersonDocumentEmploymentInfo)((PersonDocumentAffiliation)personDoc.getAffiliations().get(0)).getEmpInfos().get(0), (EntityEmploymentContract)entity.getEmploymentInformation().get(0));
    }

    @Test
    @Ignore
    public void testSetAttributeEntry() throws Exception {
        PersonDocumentRole personDocRole = this.initPersonDocRole();
        DataDictionaryTypeServiceBase kimTypeService = (DataDictionaryTypeServiceBase)KIMServiceLocatorInternal.getService((String)personDocRole.getKimRoleType().getServiceName());
        personDocRole.setDefinitions(kimTypeService.getAttributeDefinitions(personDocRole.getKimTypeId()));
        personDocRole.setAttributeEntry(this.uiDocumentService.getAttributeEntries(personDocRole.getDefinitions()));
        for (Object key : personDocRole.getAttributeEntry().keySet()) {
            Map value;
            if (key.equals("namespaceCode")) {
                value = (Map)personDocRole.getAttributeEntry().get(key);
                Assert.assertEquals((Object)"Parameter Namespace Code", value.get("label"));
                Assert.assertEquals((Object)"Nmspc Cd", value.get("shortLabel"));
                Assert.assertEquals((Object)new Integer(20), value.get("maxLength"));
                continue;
            }
            if (key.equals("campusCode")) {
                value = (Map)personDocRole.getAttributeEntry().get(key);
                Assert.assertEquals((Object)"Campus Code", value.get("label"));
                Assert.assertEquals((Object)"Campus Code", value.get("shortLabel"));
                Assert.assertEquals((Object)new Integer(2), value.get("maxLength"));
                continue;
            }
            Assert.assertFalse((String)("Should not have this key " + key), (boolean)true);
        }
    }

    private PersonDocumentRole initPersonDocRole() throws Exception {
        PersonDocumentRole docRole = new PersonDocumentRole();
        docRole.setKimTypeId("roleType1");
        docRole.setRoleId("r1");
        KimTypeBo kimType = new KimTypeBo();
        kimType.setId("roleType1");
        kimType.setServiceName("kimRoleTypeService");
        ArrayList<KimTypeAttributeBo> attributeDefinitions = new ArrayList<KimTypeAttributeBo>();
        HashMap<String, String> pkMap = new HashMap<String, String>();
        pkMap.put("kimTypeAttributeId", "kimAttr3");
        KimTypeAttributeBo attr1 = (KimTypeAttributeBo)KRADServiceLocator.getBusinessObjectService().findByPrimaryKey(KimTypeAttributeBo.class, pkMap);
        attributeDefinitions.add(attr1);
        pkMap.put("kimTypeAttributeId", "kimAttr4");
        KimTypeAttributeBo attr2 = (KimTypeAttributeBo)KRADServiceLocator.getBusinessObjectService().findByPrimaryKey(KimTypeAttributeBo.class, pkMap);
        attributeDefinitions.add(attr2);
        kimType.setAttributeDefinitions(attributeDefinitions);
        Field fld = PersonDocumentRole.class.getField("kimRoleType");
        fld.set(docRole, kimType);
        return docRole;
    }

    private IdentityManagementPersonDocument initPersonDoc() {
        IdentityManagementPersonDocument personDoc = new IdentityManagementPersonDocument();
        personDoc.setEntityId("ent123");
        personDoc.setDocumentNumber("1");
        personDoc.setPrincipalId("pid123");
        personDoc.setPrincipalName("quickTest");
        personDoc.setAffiliations(this.initAffiliations());
        personDoc.setNames(this.initNames());
        personDoc.setAddrs(this.initAddresses());
        personDoc.setPhones(this.initPhones());
        personDoc.setEmails(this.initEmails());
        return personDoc;
    }

    private List<PersonDocumentName> initNames() {
        ArrayList<PersonDocumentName> docNames = new ArrayList<PersonDocumentName>();
        PersonDocumentName docName = new PersonDocumentName();
        docName.setEntityNameId("nameId123");
        docName.setNameCode("PRFR");
        docName.setEntityNameType(EntityNameTypeBo.from((CodedAttribute)KimApiServiceLocator.getIdentityService().getNameType("PRFR")));
        docName.setFirstName("John");
        docName.setLastName("Doe");
        docName.setMiddleName("M");
        docName.setNamePrefix("Mr");
        docName.setNameSuffix("Jr");
        docName.setActive(true);
        docName.setDflt(true);
        docNames.add(docName);
        return docNames;
    }

    private List<PersonDocumentAffiliation> initAffiliations() {
        ArrayList<PersonDocumentAffiliation> docAffiliations = new ArrayList<PersonDocumentAffiliation>();
        PersonDocumentAffiliation docAffiliation = new PersonDocumentAffiliation();
        docAffiliation.setAffiliationTypeCode("FCLTY");
        docAffiliation.setAffiliationType(EntityAffiliationTypeBo.from((EntityAffiliationType)KimApiServiceLocator.getIdentityService().getAffiliationType("FCLTY")));
        docAffiliation.setEntityAffiliationId("aflID123");
        docAffiliation.setCampusCode("BL");
        docAffiliation.setActive(true);
        docAffiliation.setDflt(true);
        docAffiliations.add(docAffiliation);
        ArrayList<PersonDocumentEmploymentInfo> docEmploymentInformations = new ArrayList<PersonDocumentEmploymentInfo>();
        PersonDocumentEmploymentInfo docEmpInfo = new PersonDocumentEmploymentInfo();
        docEmpInfo.setEmployeeId("12345");
        docEmpInfo.setEntityAffiliationId(docAffiliation.getEntityAffiliationId());
        docEmpInfo.setEntityEmploymentId("empId123");
        docEmpInfo.setEmploymentRecordId("1");
        docEmpInfo.setBaseSalaryAmount(new KualiDecimal(8000));
        docEmpInfo.setPrimaryDepartmentCode("BL-CHEM");
        docEmpInfo.setEmploymentStatusCode("A");
        docEmpInfo.setEmploymentTypeCode("P");
        docEmpInfo.setActive(true);
        docEmploymentInformations.add(docEmpInfo);
        docAffiliation.setEmpInfos(docEmploymentInformations);
        return docAffiliations;
    }

    private PersonDocumentPrivacy initPrivacyReferences(EntityPrivacyPreferencesBo privacyPreferences) {
        PersonDocumentPrivacy docPrivacy = new PersonDocumentPrivacy();
        docPrivacy.setSuppressAddress(true);
        docPrivacy.setSuppressEmail(false);
        docPrivacy.setSuppressName(false);
        docPrivacy.setSuppressPhone(false);
        docPrivacy.setSuppressPersonal(true);
        return docPrivacy;
    }

    private List<PersonDocumentPhone> initPhones() {
        ArrayList<PersonDocumentPhone> docPhones = new ArrayList<PersonDocumentPhone>();
        PersonDocumentPhone docPhone = new PersonDocumentPhone();
        docPhone.setPhoneTypeCode("HM");
        docPhone.setPhoneType(EntityPhoneTypeBo.from((CodedAttribute)KimApiServiceLocator.getIdentityService().getPhoneType("HM")));
        docPhone.setEntityPhoneId("phoneId123");
        docPhone.setEntityTypeCode("PERSON");
        docPhone.setPhoneNumber("123-45'6789");
        docPhone.setExtensionNumber("123");
        docPhone.setActive(true);
        docPhone.setDflt(true);
        docPhones.add(docPhone);
        return docPhones;
    }

    private List<PersonDocumentEmail> initEmails() {
        ArrayList<PersonDocumentEmail> emails = new ArrayList<PersonDocumentEmail>();
        PersonDocumentEmail docEmail = new PersonDocumentEmail();
        docEmail.setEntityEmailId("emailId123");
        docEmail.setEntityTypeCode("PERSON");
        docEmail.setEmailTypeCode("HM");
        docEmail.setEmailType(EntityEmailTypeBo.from((CodedAttribute)KimApiServiceLocator.getIdentityService().getEmailType("HM")));
        docEmail.setEmailAddress("test@abc.com");
        docEmail.setActive(true);
        docEmail.setDflt(true);
        emails.add(docEmail);
        return emails;
    }

    private List<PersonDocumentAddress> initAddresses() {
        ArrayList<PersonDocumentAddress> docAddresses = new ArrayList<PersonDocumentAddress>();
        PersonDocumentAddress docAddress = new PersonDocumentAddress();
        docAddress.setEntityTypeCode("PERSON");
        docAddress.setEntityAddressId("addrId123");
        docAddress.setAddressTypeCode("HM");
        docAddress.setAddressType(EntityAddressTypeBo.from((CodedAttribute)KimApiServiceLocator.getIdentityService().getAddressType("HM")));
        docAddress.setLine1("PO box 123");
        docAddress.setStateProvinceCode("IN");
        docAddress.setPostalCode("46123");
        docAddress.setCountryCode("US");
        docAddress.setCity("Indianapolis");
        docAddress.setActive(true);
        docAddress.setDflt(true);
        docAddresses.add(docAddress);
        return docAddresses;
    }

    private void assertPrincipalTrue(IdentityManagementPersonDocument personDoc, PrincipalContract principal) {
        Assert.assertEquals((Object)personDoc.getPrincipalId(), (Object)principal.getPrincipalId());
        Assert.assertEquals((Object)personDoc.getPrincipalName(), (Object)principal.getPrincipalName());
    }

    private void assertAddressTrue(PersonDocumentAddress docAddress, EntityAddressContract entityAddress) {
        Assert.assertEquals((Object)docAddress.getAddressTypeCode(), (Object)entityAddress.getAddressType().getCode());
        Assert.assertEquals((Object)docAddress.getCountryCode(), (Object)entityAddress.getCountryCode());
        Assert.assertEquals((Object)docAddress.getLine1(), (Object)entityAddress.getLine1());
        Assert.assertEquals((Object)docAddress.getCity(), (Object)entityAddress.getCity());
        Assert.assertEquals((Object)docAddress.getPostalCode(), (Object)entityAddress.getPostalCode());
        Assert.assertEquals((Object)docAddress.getStateProvinceCode(), (Object)entityAddress.getStateProvinceCode());
    }

    private void assertEmailTrue(PersonDocumentEmail docEmail, EntityEmailContract entityEmail) {
        Assert.assertEquals((Object)docEmail.getEntityEmailId(), (Object)entityEmail.getId());
        Assert.assertEquals((Object)docEmail.getEmailAddress(), (Object)entityEmail.getEmailAddressUnmasked());
        Assert.assertEquals((Object)docEmail.getEmailTypeCode(), (Object)entityEmail.getEmailType().getCode());
    }

    private void assertPhoneTrue(PersonDocumentPhone docPhone, EntityPhoneContract entityPhone) {
        Assert.assertEquals((Object)docPhone.getEntityPhoneId(), (Object)entityPhone.getId());
        Assert.assertEquals((Object)docPhone.getCountryCode(), (Object)entityPhone.getCountryCode());
        Assert.assertEquals((Object)docPhone.getPhoneNumber(), (Object)entityPhone.getPhoneNumber());
        Assert.assertEquals((Object)docPhone.getExtensionNumber(), (Object)entityPhone.getExtensionNumber());
        Assert.assertEquals((Object)docPhone.getPhoneTypeCode(), (Object)entityPhone.getPhoneType().getCode());
    }

    private void assertNameTrue(PersonDocumentName docName, EntityNameContract entityName) {
        Assert.assertEquals((Object)docName.getEntityNameId(), (Object)entityName.getId());
        Assert.assertEquals((Object)docName.getFirstName(), (Object)entityName.getFirstName());
        Assert.assertEquals((Object)docName.getLastName(), (Object)entityName.getLastName());
        Assert.assertEquals((Object)docName.getNameCode(), (Object)entityName.getNameType().getCode());
        Assert.assertEquals((Object)docName.getNameSuffix(), (Object)entityName.getNameSuffix());
        Assert.assertEquals((Object)docName.getNamePrefix(), (Object)entityName.getNamePrefix());
    }

    private void assertAffiliationTrue(PersonDocumentAffiliation docAffln, EntityAffiliation entityAffln) {
        Assert.assertEquals((Object)docAffln.getAffiliationTypeCode(), (Object)entityAffln.getAffiliationType().getCode());
        Assert.assertEquals((Object)docAffln.getCampusCode(), (Object)entityAffln.getCampusCode());
        Assert.assertEquals((Object)docAffln.getEntityAffiliationId(), (Object)entityAffln.getId());
    }

    private void assertEmpInfoTrue(PersonDocumentEmploymentInfo docEmpInfo, EntityEmploymentContract entityEmpInfo) {
        Assert.assertEquals((Object)docEmpInfo.getEmployeeId(), (Object)entityEmpInfo.getEmployeeId());
        Assert.assertEquals((Object)docEmpInfo.getEmploymentTypeCode(), (Object)entityEmpInfo.getEmployeeType().getCode());
        Assert.assertEquals((Object)docEmpInfo.getEmploymentStatusCode(), (Object)entityEmpInfo.getEmployeeStatus().getCode());
        Assert.assertEquals((Object)docEmpInfo.getEmploymentRecordId(), (Object)entityEmpInfo.getEmploymentRecordId());
        Assert.assertEquals((Object)docEmpInfo.getBaseSalaryAmount(), (Object)entityEmpInfo.getBaseSalaryAmount());
    }
}

