/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.kuali.rice.core.api.lifecycle.BaseLifecycle;
import org.kuali.rice.core.api.lifecycle.Lifecycle;
import org.kuali.rice.core.framework.resourceloader.SpringResourceLoader;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.impl.permission.PermissionTemplateBo;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.test.BaselineTestCase;
import org.kuali.rice.test.SQLDataLoader;
import org.kuali.rice.test.lifecycles.KEWXmlDataLoaderLifecycle;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.ROLLBACK_CLEAR_DB)
public abstract class KIMTestCase
extends BaselineTestCase {
    private static final String KIM_MODULE_NAME = "kim";

    public KIMTestCase() {
        super(KIM_MODULE_NAME);
    }

    protected List<Lifecycle> getSuiteLifecycles() {
        List suiteLifecycles = super.getSuiteLifecycles();
        suiteLifecycles.add(new KEWXmlDataLoaderLifecycle("classpath:org/kuali/rice/kim/test/DefaultSuiteTestData.xml"));
        return suiteLifecycles;
    }

    protected void loadSuiteTestData() throws Exception {
        super.loadSuiteTestData();
        new SQLDataLoader("classpath:org/kuali/rice/kim/test/DefaultSuiteTestData.sql", "/").runSql();
        new SQLDataLoader("classpath:org/kuali/rice/kim/test/CircularRolesTestData.sql", "/").runSql();
        new SQLDataLoader("classpath:org/kuali/rice/kim/test/CircularGroupsTestData.sql", "/").runSql();
        new SQLDataLoader("classpath:org/kuali/rice/kim/test/DefaultSuiteLDAPTestData.sql", "/").runSql();
    }

    protected Lifecycle getLoadApplicationLifecycle() {
        SpringResourceLoader springResourceLoader = new SpringResourceLoader(new QName("KIMTestHarnessApplicationResourceLoader"), "classpath:KIMTestHarnessSpringBeans.xml", null);
        springResourceLoader.setParentSpringResourceLoader(this.getTestHarnessSpringResourceLoader());
        return springResourceLoader;
    }

    protected List<Lifecycle> getPerTestLifecycles() {
        List lifecycles = super.getPerTestLifecycles();
        lifecycles.add(new ClearCacheLifecycle());
        return lifecycles;
    }

    protected List<String> getPerTestTablesNotToClear() {
        ArrayList<String> tablesNotToClear = new ArrayList<String>();
        tablesNotToClear.add("KRIM_.*");
        tablesNotToClear.add("KRNS_.*");
        tablesNotToClear.add("KRCR_.*");
        tablesNotToClear.add("KREW_.*");
        return tablesNotToClear;
    }

    protected String getModuleName() {
        return KIM_MODULE_NAME;
    }

    protected KimType getDefaultKimType() {
        KimType type = KimApiServiceLocator.getKimTypeInfoService().getKimType("1");
        if (type == null) {
            Assert.fail((String)"Failed to locate the default Kim Type.");
        }
        return type;
    }

    protected PermissionTemplateBo getDefaultPermissionTemplate() {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("namespaceCode", "KUALI");
        fieldValues.put("name", "Default");
        PermissionTemplateBo template = (PermissionTemplateBo)KRADServiceLocator.getBusinessObjectService().findByPrimaryKey(PermissionTemplateBo.class, fieldValues);
        if (template == null) {
            Assert.fail((String)"Failed to locate the default Permission Template.");
        }
        return template;
    }

    protected String getNewRoleId() {
        return this.getIdFromSequence("KRIM_ROLE_ID_S");
    }

    protected String getNewRoleMemberId() {
        return this.getIdFromSequence("KRIM_ROLE_MBR_ID_S");
    }

    protected String getNewRolePermissionId() {
        return this.getIdFromSequence("KRIM_ROLE_ID_S");
    }

    protected String getIdFromSequence(String sequenceName) {
        Long sequenceId = KRADServiceLocator.getSequenceAccessorService().getNextAvailableSequenceNumber(sequenceName);
        return "" + sequenceId;
    }

    public class ClearCacheLifecycle
    extends BaseLifecycle {
        public void stop() throws Exception {
            super.stop();
        }
    }
}

