/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.test.service;

import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kim.api.identity.CodedAttribute;
import org.kuali.rice.kim.api.identity.CodedAttributeContract;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.entity.Entity;
import org.kuali.rice.kim.api.identity.entity.EntityContract;
import org.kuali.rice.kim.api.identity.name.EntityName;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.identity.type.EntityTypeContactInfo;
import org.kuali.rice.kim.service.KIMServiceLocatorInternal;
import org.kuali.rice.kim.test.KIMTestCase;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.NONE)
public class IdentityServiceImplTest
extends KIMTestCase {
    private IdentityService identityService;

    public void setUp() throws Exception {
        super.setUp();
        this.identityService = (IdentityService)KIMServiceLocatorInternal.getBean((String)"kimIdentityDelegateService");
    }

    @Test
    public void testGetPrincipal() {
        Principal principal = this.identityService.getPrincipal("KULUSER");
        Assert.assertNotNull((String)"principal must not be null", (Object)principal);
        Assert.assertEquals((String)"Principal name did not match expected result", (Object)"kuluser", (Object)principal.getPrincipalName());
    }

    @Test
    public void testGetPrincipalsByEntityId() {
        List principals = this.identityService.getPrincipalsByEntityId("1136");
        Assert.assertNotNull((String)"principal must not be null", (Object)principals);
        for (Principal principal : principals) {
            Assert.assertEquals((String)"Principal name did not match expected result", (Object)"kuluser", (Object)principal.getPrincipalName());
        }
    }

    @Test
    public void testGetPrincipalsByEntityIdInactive() {
        List principals = this.identityService.getPrincipalsByEntityId("1139");
        Assert.assertNotNull((String)"principal must not be null", (Object)principals);
        for (Principal principal : principals) {
            Assert.assertEquals((String)"Principal name did not match expected result", (Object)"inactiveusernm", (Object)principal.getPrincipalName());
        }
    }

    @Test
    public void testGetPrincipalsByEmployeeId() {
        List principals = this.identityService.getPrincipalsByEmployeeId("0000001138");
        Assert.assertNotNull((String)"principal must not be null", (Object)principals);
        for (Principal principal : principals) {
            Assert.assertEquals((String)"Principal name did not match expected result", (Object)"activeusernm", (Object)principal.getPrincipalName());
            Assert.assertEquals((String)"Entity Id did not match expected result", (Object)"1138", (Object)principal.getEntityId());
        }
    }

    @Test
    public void testGetPrincipalsByEmployeeIdInactive() {
        List principals = this.identityService.getPrincipalsByEmployeeId("0000001140");
        Assert.assertNotNull((String)"principal must not be null", (Object)principals);
        for (Principal principal : principals) {
            Assert.assertEquals((String)"Principal name did not match expected result", (Object)"inactiveempid", (Object)principal.getPrincipalName());
            Assert.assertEquals((String)"Entity Id did not match expected result", (Object)"1140", (Object)principal.getEntityId());
        }
    }

    @Test
    public void testGetPrincipalByPrincipalName() {
        Principal principal = this.identityService.getPrincipalByPrincipalName("kuluser");
        Assert.assertNotNull((String)"principal must not be null", (Object)principal);
        Assert.assertEquals((String)"Principal ID did not match expected result", (Object)"KULUSER", (Object)principal.getPrincipalId());
    }

    @Test
    public void testGetContainedAttributes() {
        Principal principal = this.identityService.getPrincipal("p1");
        Entity entity = this.identityService.getEntity(principal.getEntityId());
        Assert.assertNotNull((String)"Entity Must not be null", (Object)entity);
        EntityTypeContactInfo eet = entity.getEntityTypeContactInfoByTypeCode("PERSON");
        Assert.assertNotNull((String)"PERSON EntityEntityType Must not be null", (Object)eet);
        Assert.assertEquals((String)"there should be 1 email address", (long)1L, (long)eet.getEmailAddresses().size());
        Assert.assertEquals((String)"email address does not match", (Object)"p1@kuali.org", (Object)eet.getDefaultEmailAddress().getEmailAddressUnmasked());
    }

    @Test
    public void testEntityUpdate() {
        Principal principal = this.identityService.getPrincipal("p1");
        Entity entity = this.identityService.getEntity(principal.getEntityId());
        Assert.assertNotNull((String)"Entity Must not be null", (Object)entity);
        Assert.assertEquals((String)"Entity should have 1 name", (long)1L, (long)entity.getNames().size());
        Entity.Builder builder = Entity.Builder.create((EntityContract)entity);
        List names = builder.getNames();
        names.add(this.getNewEntityName(entity.getId()));
        entity = this.identityService.updateEntity(builder.build());
        Assert.assertNotNull((String)"Entity Must not be null", (Object)entity);
        Assert.assertEquals((String)"Entity should have 2 names", (long)2L, (long)entity.getNames().size());
        builder = Entity.Builder.create((EntityContract)entity);
        builder.setNames(Collections.singletonList(this.getNewEntityName(entity.getId())));
        entity = this.identityService.updateEntity(builder.build());
        Assert.assertNotNull((String)"Entity Must not be null", (Object)entity);
        Assert.assertEquals((String)"Entity should have 1 names", (long)1L, (long)entity.getNames().size());
    }

    private EntityName.Builder getNewEntityName(String entityId) {
        EntityName.Builder builder = EntityName.Builder.create();
        builder.setActive(true);
        builder.setDefaultValue(false);
        builder.setEntityId(entityId);
        builder.setFirstName("Bob");
        builder.setLastName("Bobbers");
        builder.setNamePrefix("Mr");
        CodedAttribute.Builder nameType = CodedAttribute.Builder.create((CodedAttributeContract)this.identityService.getNameType("PRM"));
        builder.setNameType(nameType);
        return builder;
    }
}

