/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.test.service;

import java.util.List;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.affiliation.EntityAffiliation;
import org.kuali.rice.kim.api.identity.entity.Entity;
import org.kuali.rice.kim.api.identity.entity.EntityDefault;
import org.kuali.rice.kim.api.identity.phone.EntityPhone;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.identity.privacy.EntityPrivacyPreferences;
import org.kuali.rice.kim.api.identity.type.EntityTypeContactInfo;
import org.kuali.rice.kim.service.KIMServiceLocatorInternal;
import org.kuali.rice.kim.test.KIMTestCase;
import org.kuali.rice.test.BaselineTestCase;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.ldap.test.LdapTestUtils;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.NONE)
public class LDAPIdentityServiceImplTest
extends KIMTestCase {
    private static final DistinguishedName baseName = new DistinguishedName("o=Whoniverse");
    private static final String PRINCIPAL = "uid=admin,ou=system";
    private static final String CREDENTIALS = "secret";
    private static int PORT = 10389;
    private IdentityService identityService;

    @BeforeClass
    public static void startLDAPServer() throws Exception {
        LdapTestUtils.startApacheDirectoryServer((int)PORT, (String)baseName.toString(), (String)"test", (String)PRINCIPAL, (String)CREDENTIALS, null);
        LdapContextSource contextSource = new LdapContextSource();
        contextSource.setUrl("ldap://127.0.0.1:" + PORT);
        contextSource.setUserDn("");
        contextSource.setPassword("");
        contextSource.setPooled(false);
        contextSource.afterPropertiesSet();
        LdapTemplate template = new LdapTemplate((ContextSource)contextSource);
        LdapTestUtils.cleanAndSetup((ContextSource)template.getContextSource(), (DistinguishedName)baseName, (Resource)new ClassPathResource("ldap/testdata.ldif"));
        System.out.println("____________Started LDAP_________");
    }

    @AfterClass
    public static void shutdownLDAP() throws Exception {
        LdapTestUtils.destroyApacheDirectoryServer((String)PRINCIPAL, (String)CREDENTIALS);
        System.out.println("____________Shutdown LDAP_________");
    }

    public void setUp() throws Exception {
        super.setUp();
        this.identityService = (IdentityService)KIMServiceLocatorInternal.getBean((String)"kimLDAPIdentityDelegateService");
    }

    @Test
    public void testGetEntity() {
        Entity entity = this.identityService.getEntity("williamh");
        Assert.assertNotNull((String)"Entity must not be null", (Object)entity);
        Assert.assertEquals((String)"Entity name matched expected result", (Object)"williamh", (Object)((Principal)entity.getPrincipals().get(0)).getPrincipalName());
    }

    @Test
    public void testGetEntityByPrincipalId() {
        Entity entity = this.identityService.getEntityByPrincipalId("williamh");
        Assert.assertNotNull((String)"Entity must not be null", (Object)entity);
        Assert.assertEquals((String)"Entity name matched expected result", (Object)"williamh", (Object)((Principal)entity.getPrincipals().get(0)).getPrincipalName());
    }

    @Test
    public void testGetEntityByPrincipalName() {
        Entity entity = this.identityService.getEntityByPrincipalName("williamh");
        Assert.assertNotNull((String)"Entity must not be null", (Object)entity);
        Assert.assertEquals((String)"Entity name matched expected result", (Object)"williamh", (Object)((Principal)entity.getPrincipals().get(0)).getPrincipalName());
    }

    @Test
    public void testGetEntityDefault() {
        EntityDefault entity = this.identityService.getEntityDefault("williamh");
        Assert.assertNotNull((String)"Entity must not be null", (Object)entity);
        Assert.assertEquals((String)"Entity name matched expected result", (Object)"williamh", (Object)((Principal)entity.getPrincipals().get(0)).getPrincipalName());
    }

    @Test
    public void testGetEntityDefaultByPrincipalId() {
        EntityDefault entity = this.identityService.getEntityDefaultByPrincipalId("williamh");
        Assert.assertNotNull((String)"Entity must not be null", (Object)entity);
        Assert.assertEquals((String)"Entity name matched expected result", (Object)"williamh", (Object)((Principal)entity.getPrincipals().get(0)).getPrincipalName());
    }

    @Test
    public void testGetEntityDefaultByPrincipalName() {
        EntityDefault entity = this.identityService.getEntityDefaultByPrincipalName("williamh");
        Assert.assertNotNull((String)"Entity must not be null", (Object)entity);
        Assert.assertEquals((String)"Entity name matched expected result", (Object)"williamh", (Object)((Principal)entity.getPrincipals().get(0)).getPrincipalName());
    }

    @Test
    public void testGetEntityPrivacyPreferences() {
        EntityPrivacyPreferences entityPrivacyPreferences = this.identityService.getEntityPrivacyPreferences("williamh");
        Assert.assertNotNull((String)"Entity must not be null", (Object)entityPrivacyPreferences);
    }

    @Test
    public void testGetPrincipal() {
        Principal principal = this.identityService.getPrincipal("williamh");
        Assert.assertNotNull((String)"Principal must not be null", (Object)principal);
        Assert.assertEquals((String)"Principal name did not match expected result", (Object)"williamh", (Object)principal.getPrincipalName());
    }

    @Test
    public void testGetPrincipalByPrincipalName() {
        Principal principal = this.identityService.getPrincipalByPrincipalName("williamh");
        Assert.assertNotNull((String)"principal must not be null", (Object)principal);
        Assert.assertEquals((String)"Principal ID did not match expected result", (Object)"williamh", (Object)principal.getPrincipalId());
    }

    @Test
    public void testGetContainedAttributes() {
        Principal principal = this.identityService.getPrincipal("williamh");
        Entity entity = this.identityService.getEntity(principal.getEntityId());
        Assert.assertNotNull((String)"Entity Must not be null", (Object)entity);
        EntityTypeContactInfo eet = entity.getEntityTypeContactInfoByTypeCode("PERSON");
        List ea = entity.getAffiliations();
        Assert.assertNotNull((String)"PERSON EntityEntityType Must not be null", (Object)eet);
        Assert.assertEquals((String)"there should be 1 email address", (long)1L, (long)eet.getEmailAddresses().size());
        Assert.assertEquals((String)"Email address does not match", (Object)"williamh@test.edu", (Object)eet.getDefaultEmailAddress().getEmailAddressUnmasked());
        Assert.assertEquals((String)"there should be 1 phone number", (long)1L, (long)eet.getPhoneNumbers().size());
        Assert.assertEquals((String)"The Phone number does not match", (Object)"111-111-1111", (Object)((EntityPhone)eet.getPhoneNumbers().get(0)).getPhoneNumberUnmasked());
        Assert.assertEquals((String)"there should be 1 phone number", (long)1L, (long)ea.size());
        Assert.assertEquals((String)"The Affiliations do not match", (Object)"STAFF", (Object)((EntityAffiliation)ea.get(0)).getAffiliationType().getCode());
    }
}

