/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.test.service;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.group.GroupContract;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.test.KIMTestCase;

public class GroupServiceImplTest
extends KIMTestCase {
    private GroupService groupService;

    public void setUp() throws Exception {
        super.setUp();
        this.groupService = KimApiServiceLocator.getGroupService();
    }

    @Test
    public void testGetDirectMemberGroupIds() {
        List groupIds = this.groupService.getDirectMemberGroupIds("g1");
        Assert.assertTrue((String)"g1 must contain group g2", (boolean)groupIds.contains("g2"));
        Assert.assertFalse((String)"g1 must not contain group g3", (boolean)groupIds.contains("g3"));
        groupIds = this.groupService.getDirectMemberGroupIds("g2");
        Assert.assertTrue((String)"g2 must contain group g3", (boolean)groupIds.contains("g3"));
        Assert.assertFalse((String)"g2 must not contain group g4 (inactive)", (boolean)groupIds.contains("g4"));
    }

    @Test
    public void testGetMemberGroupIds() {
        List groupIds = this.groupService.getMemberGroupIds("g1");
        Assert.assertTrue((String)"g1 must contain group g2", (boolean)groupIds.contains("g2"));
        Assert.assertTrue((String)"g1 must contain group g3", (boolean)groupIds.contains("g3"));
        Assert.assertFalse((String)"g1 must not contain group g4 (inactive)", (boolean)groupIds.contains("g4"));
        groupIds = this.groupService.getMemberGroupIds("g2");
        Assert.assertTrue((String)"g2 must contain group g3", (boolean)groupIds.contains("g3"));
        Assert.assertFalse((String)"g2 must not contain group g1", (boolean)groupIds.contains("g1"));
    }

    @Test
    public void testPrincipalMembership() {
        Assert.assertTrue((String)"p1 must be in g2", (boolean)this.groupService.isMemberOfGroup("p1", "g2"));
        Assert.assertTrue((String)"p1 must be direct member of g2", (boolean)this.groupService.isDirectMemberOfGroup("p1", "g2"));
        Assert.assertTrue((String)"p3 must be in g2", (boolean)this.groupService.isMemberOfGroup("p3", "g2"));
        Assert.assertFalse((String)"p3 should not be a direct member of g2", (boolean)this.groupService.isDirectMemberOfGroup("p3", "g2"));
        Assert.assertFalse((String)"p4 should not be reported as a member of g2 (g4 is inactive)", (boolean)this.groupService.isMemberOfGroup("p4", "g2"));
        Group g4Info = this.groupService.getGroup("g4");
        Group.Builder builder = Group.Builder.create((GroupContract)g4Info);
        builder.setActive(true);
        this.groupService.updateGroup("g4", builder.build());
        Assert.assertTrue((String)"p4 should be reported as a member of g2 (now that g4 is active)", (boolean)this.groupService.isMemberOfGroup("p4", "g2"));
    }

    @Test
    public void testCircularGetMembers() {
        List pIds = this.groupService.getMemberPrincipalIds("g101");
        Assert.assertTrue((String)"group A should have 3 members", (pIds.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)"group A should have member p1", (boolean)pIds.contains("p1"));
        Assert.assertTrue((String)"group A should have member p3", (boolean)pIds.contains("p3"));
        Assert.assertTrue((String)"group A should have member p5", (boolean)pIds.contains("p5"));
        boolean isIt = this.groupService.isMemberOfGroup("p2", "g101");
        Assert.assertFalse((String)"p2 should not be a member of Group A", (boolean)isIt);
        List gIds = this.groupService.getGroupIdsByPrincipalId("p1");
        Assert.assertTrue((String)"p1 should be a member of Group A", (boolean)gIds.contains("g101"));
        Assert.assertTrue((String)"p1 should be a member of Group B", (boolean)gIds.contains("g102"));
        Assert.assertTrue((String)"p1 should be a member of Group C", (boolean)gIds.contains("g103"));
        gIds = this.groupService.getGroupIdsByPrincipalIdAndNamespaceCode("p1", "ADDL_GROUPS_TESTS");
        Assert.assertTrue((String)"p1 should be a member of Group A", (boolean)gIds.contains("g101"));
        Assert.assertTrue((String)"p1 should be a member of Group B", (boolean)gIds.contains("g102"));
        Assert.assertTrue((String)"p1 should be a member of Group C", (boolean)gIds.contains("g103"));
        ArrayList<String> inList = new ArrayList<String>();
        inList.add("g101");
        inList.add("g102");
        List gMembership = this.groupService.getMembers(inList);
        Assert.assertTrue((String)"Should return 4 members total.", (gMembership.size() == 4 ? 1 : 0) != 0);
        gMembership = this.groupService.getMembersOfGroup("g102");
        Assert.assertTrue((String)"Group B should have 2 members.", (gMembership.size() == 2 ? 1 : 0) != 0);
        List gInfo = this.groupService.getGroupsByPrincipalId("p1");
        Assert.assertTrue((String)"p1 should be a member of at least 3 groups.", (gInfo.size() >= 3 ? 1 : 0) != 0);
        gInfo = this.groupService.getGroupsByPrincipalIdAndNamespaceCode("p1", "ADDL_GROUPS_TESTS");
        Assert.assertTrue((String)"p1 should be a member of exactly 3 groups with namespace = ADDL_GROUPS_TESTS.", (gInfo.size() == 3 ? 1 : 0) != 0);
        gIds = this.groupService.getMemberGroupIds("g101");
        Assert.assertTrue((String)"Group A should have 3 member groups", (gIds.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Group B should be a member Group of Group A", (boolean)gIds.contains("g102"));
        Assert.assertTrue((String)"Group C should be a member Group of Group A", (boolean)gIds.contains("g103"));
        Assert.assertTrue((String)"Since these groups have a circular membership, Group A should have itself as a group member", (boolean)gIds.contains("g101"));
        gIds = this.groupService.getParentGroupIds("g101");
        Assert.assertTrue((String)"Group A should have 3 parent groups", (gIds.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Group B should be a parent of Group A", (boolean)gIds.contains("g102"));
        Assert.assertTrue((String)"Group C should be a parent of Group A", (boolean)gIds.contains("g103"));
        Assert.assertTrue((String)"Since these groups have a circular membership, Group A should be a parent of itself", (boolean)gIds.contains("g101"));
    }
}

