/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.test.service;

import java.util.Collections;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.entity.EntityDefault;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.impl.identity.IdentityArchiveService;
import org.kuali.rice.kim.test.KIMTestCase;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.NONE)
public class IdentityCurrentAndArchivedServiceTest
extends KIMTestCase {
    public static final String KIM_IDENTITY_SERVICE = "kimIdentityService";
    public static final String KIM_IDENTITY_ARCHIVE_SERVICE = "kimIdentityArchiveService";
    private IdentityService identityService;
    private IdentityArchiveService identityArchiveService;

    public static IdentityArchiveService getIdentityArchiveService() {
        return (IdentityArchiveService)GlobalResourceLoader.getService((String)KIM_IDENTITY_ARCHIVE_SERVICE);
    }

    public static IdentityService getIdentityService() {
        return (IdentityService)GlobalResourceLoader.getService((String)KIM_IDENTITY_SERVICE);
    }

    public void setUp() throws Exception {
        super.setUp();
        if (null == this.identityService) {
            this.identityService = IdentityCurrentAndArchivedServiceTest.getIdentityService();
        }
        if (null == this.identityArchiveService) {
            this.identityArchiveService = IdentityCurrentAndArchivedServiceTest.getIdentityArchiveService();
        }
    }

    @Test
    public void testGetEntityDefault() throws Exception {
        MinimalKEDIBuilder builder = new MinimalKEDIBuilder("bogususer");
        builder.setEntityId("bogususer");
        EntityDefault bogusUserInfo = builder.build();
        this.identityArchiveService.saveEntityDefaultToArchive(bogusUserInfo);
        this.identityArchiveService.flushToArchive();
        EntityDefault retrieved = this.identityArchiveService.getEntityDefaultFromArchiveByPrincipalId(builder.getPrincipalId());
        Assert.assertNotNull((String)("no value retrieved for principalId: " + ((Principal)retrieved.getPrincipals().get(0)).getPrincipalId()), (Object)retrieved);
        retrieved = this.identityService.getEntityDefaultByPrincipalId("bogususer");
        Assert.assertNotNull((String)("no value retrieved for principalId: " + ((Principal)retrieved.getPrincipals().get(0)).getPrincipalId()), (Object)retrieved);
        EntityDefault retrieveAgain = this.identityService.getEntityDefaultByPrincipalId("bogususer");
        Assert.assertNotNull((String)("no value retrieved for principalId: " + ((Principal)retrieveAgain.getPrincipals().get(0)).getPrincipalId()), (Object)retrieveAgain);
    }

    private static class MinimalKEDIBuilder {
        private String entityId = UUID.randomUUID().toString();
        private String principalId;
        private String principalName;
        private Boolean active;

        public MinimalKEDIBuilder(String name) {
            this.principalId = this.principalName = name;
        }

        public EntityDefault build() {
            if (this.entityId == null) {
                this.entityId = UUID.randomUUID().toString();
            }
            if (this.principalId == null) {
                this.principalId = UUID.randomUUID().toString();
            }
            if (this.principalName == null) {
                this.principalName = this.principalId;
            }
            if (this.active == null) {
                this.active = true;
            }
            Principal.Builder principal = Principal.Builder.create((String)this.principalName);
            principal.setActive(this.active.booleanValue());
            principal.setEntityId(this.entityId);
            principal.setPrincipalId(this.principalId);
            EntityDefault.Builder kedi = EntityDefault.Builder.create();
            kedi.setPrincipals(Collections.singletonList(principal));
            kedi.setEntityId(this.entityId);
            return kedi.build();
        }

        public String getEntityId() {
            return this.entityId;
        }

        public void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        public String getPrincipalId() {
            return this.principalId;
        }

        public void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        public String getPrincipalName() {
            return this.principalName;
        }

        public void setPrincipalName(String principalName) {
            this.principalName = principalName;
        }

        public Boolean getActive() {
            return this.active;
        }

        public void setActive(Boolean active) {
            this.active = active;
        }
    }
}

