/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.service.impl;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.delegation.DelegationType;
import org.kuali.rice.core.api.exception.RiceIllegalStateException;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kim.api.common.delegate.DelegateMember;
import org.kuali.rice.kim.api.common.delegate.DelegateMemberContract;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.role.RoleMember;
import org.kuali.rice.kim.api.role.RoleMemberContract;
import org.kuali.rice.kim.api.role.RoleMembership;
import org.kuali.rice.kim.api.role.RoleResponsibilityAction;
import org.kuali.rice.kim.api.role.RoleResponsibilityActionContract;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kim.impl.common.delegate.DelegateMemberAttributeDataBo;
import org.kuali.rice.kim.impl.common.delegate.DelegateMemberBo;
import org.kuali.rice.kim.impl.common.delegate.DelegateTypeBo;
import org.kuali.rice.kim.impl.role.RoleMemberAttributeDataBo;
import org.kuali.rice.kim.impl.role.RoleMemberBo;
import org.kuali.rice.kim.test.KIMTestCase;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.data.PersistenceOption;

public class RoleServiceImplTest
extends KIMTestCase {
    private RoleService roleService;
    static final DateTimeFormatter FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
    static final String ROLE_MEMBER_ID1 = "45123";
    static final String ROLE_ID = "100";
    static final String MEMBER_ID = "1";
    static final MemberType MEMBER_TYPE_R = MemberType.ROLE;
    static final String ACTIVE_FROM_STRING = "2011-01-01 12:00:00";
    static final DateTime ACTIVE_FROM = new DateTime((Object)FORMATTER.parseDateTime("2011-01-01 12:00:00"));
    static final String ACTIVE_TO_STRING1 = "2013-01-01 12:00:00";
    static final String ACTIVE_TO_STRING2 = "2014-01-01 12:00:00";
    static final DateTime ACTIVE_TO1 = new DateTime((Object)FORMATTER.parseDateTime("2013-01-01 12:00:00"));
    static final DateTime ACTIVE_TO2 = new DateTime((Object)FORMATTER.parseDateTime("2014-01-01 12:00:00"));

    public void setUp() throws Exception {
        super.setUp();
        this.roleService = (RoleService)GlobalResourceLoader.getService((QName)new QName("http://rice.kuali.org/kim/v2_0", "roleService"));
    }

    @Test
    public void testPrincipaHasRoleOfDirectAssignment() {
        ArrayList<String> roleIds = new ArrayList<String>();
        roleIds.add("r1");
        Assert.assertTrue((String)"p1 has direct role r1", (boolean)this.roleService.principalHasRole("p1", roleIds, Collections.emptyMap()));
        HashMap<String, String> qualification = new HashMap<String, String>();
        qualification.put("Attribute 2", "CHEM");
        Assert.assertTrue((String)"p1 has direct role r1 with rp2 attr data", (boolean)this.roleService.principalHasRole("p1", roleIds, qualification));
        qualification.clear();
        qualification.put("Attribute 3", "PHYS");
        Assert.assertTrue((String)"p1 has direct role r1 with rp2 attr data", (boolean)this.roleService.principalHasRole("p1", roleIds, (Map)Maps.newHashMap(qualification)));
    }

    @Test
    public void testPrincipalHasRoleOfHigherLevel() {
        ArrayList<String> roleIds = new ArrayList<String>();
        roleIds.add("r2");
        Assert.assertTrue((String)"p1 has assigned in higher level role r1", (boolean)this.roleService.principalHasRole("p1", roleIds, Collections.emptyMap()));
        Assert.assertTrue((String)"p1 has assigned in higher level role r1", (boolean)this.roleService.principalHasRole("p1", roleIds, Collections.emptyMap()));
    }

    @Test
    public void testDelegateMemberCreateUpdateRemove() {
        Role r2 = this.roleService.getRole("r2");
        RoleMember rm1 = this.roleService.assignPrincipalToRole("user2", r2.getNamespaceCode(), r2.getName(), new HashMap());
        String kimTypeId = MEMBER_ID;
        String id = this.getNextSequenceStringValue("KRIM_DLGN_MBR_ID_S");
        DelegateTypeBo delegate = new DelegateTypeBo();
        delegate.setDelegationId(id);
        delegate.setDelegationType(DelegationType.PRIMARY);
        delegate.setRoleId(r2.getId());
        delegate.setActive(true);
        delegate.setKimTypeId("" + kimTypeId);
        delegate = (DelegateTypeBo)KradDataServiceLocator.getDataObjectService().save((Object)delegate, new PersistenceOption[]{PersistenceOption.FLUSH});
        DelegateMember.Builder delegateMemberInfo = DelegateMember.Builder.create();
        delegateMemberInfo.setAttributes(Collections.emptyMap());
        delegateMemberInfo.setDelegationId(delegate.getDelegationId());
        delegateMemberInfo.setMemberId("user4");
        delegateMemberInfo.setRoleMemberId(rm1.getId());
        delegateMemberInfo.setType(MemberType.PRINCIPAL);
        DelegateMember inDelegateMember = delegateMemberInfo.build();
        DelegateMember newDelegateMember = this.roleService.createDelegateMember(inDelegateMember);
        Assert.assertNotNull((String)"delegateMember not created", (Object)newDelegateMember);
        delegateMemberInfo.setDelegationMemberId(newDelegateMember.getDelegationMemberId());
        DateTime dateTimeFrom = DateTime.now().minusDays(3);
        delegateMemberInfo.setActiveFromDate(dateTimeFrom);
        DateTime dateTimeTo = DateTime.now().plusDays(3);
        delegateMemberInfo.setActiveToDate(dateTimeTo);
        inDelegateMember = delegateMemberInfo.build();
        this.roleService.updateDelegateMember(inDelegateMember);
        DelegateMember updatedDelegateMember = DelegateMember.Builder.create((DelegateMemberContract)((DelegateMemberContract)KradDataServiceLocator.getDataObjectService().find(DelegateMemberBo.class, (Object)inDelegateMember.getDelegationMemberId()))).build();
        Assert.assertEquals((String)"Delegate member was updated", (Object)newDelegateMember.getDelegationMemberId(), (Object)updatedDelegateMember.getDelegationMemberId());
        Assert.assertNotNull((String)"updateDelegateMember not created", (Object)updatedDelegateMember);
        Assert.assertEquals((String)"activeFromDate not updated", (Object)dateTimeFrom, (Object)updatedDelegateMember.getActiveFromDate());
        Assert.assertEquals((String)"activeToDate not updated", (Object)dateTimeTo, (Object)updatedDelegateMember.getActiveToDate());
        this.roleService.removeDelegateMembers(Collections.singletonList(updatedDelegateMember));
        DelegateMemberBo removedDelegateMember = (DelegateMemberBo)KradDataServiceLocator.getDataObjectService().find(DelegateMemberBo.class, (Object)updatedDelegateMember.getDelegationMemberId());
        Assert.assertNotNull((String)"after removal, versionNumber should not be null", (Object)removedDelegateMember.getVersionNumber());
        Assert.assertEquals((String)"removeDelegateMembers did not update the existing member", (Object)new Long(updatedDelegateMember.getVersionNumber() + 1L), (Object)removedDelegateMember.getVersionNumber());
        Assert.assertNotNull((String)"after removal, active to date should not be null", (Object)removedDelegateMember.getActiveToDate());
        Assert.assertTrue((String)"removeDelegateMembers did not update activeToDate", (boolean)removedDelegateMember.getActiveToDate().isBeforeNow());
    }

    @Test
    public void testRoleMemberCreateUpdate() {
        Role roleId = this.roleService.getRole(ROLE_ID);
        ArrayList<String> roleIds = new ArrayList<String>();
        roleIds.add(roleId.getId());
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("parameterName", "parameterNameBefore");
        attributes.put("namespaceCode", "namespaceCodeBefore");
        attributes.put("componentName", "componentNameBefore");
        RoleMember roleMember = this.roleService.createRoleMember(RoleMember.Builder.create((String)ROLE_ID, (String)ROLE_MEMBER_ID1, (String)MEMBER_ID, (MemberType)MEMBER_TYPE_R, (DateTime)ACTIVE_FROM, (DateTime)ACTIVE_TO1, attributes, (String)"", (String)"").build());
        RoleMemberBo rmBo = this.getRoleMemberBo(roleMember.getId());
        RoleMember.Builder updatedRoleMember = RoleMember.Builder.create((RoleMemberContract)roleMember);
        updatedRoleMember.setActiveToDate(ACTIVE_TO2);
        HashMap<String, String> newAttributes = new HashMap<String, String>();
        newAttributes.put("parameterName", "parameterNameAfter");
        newAttributes.put("namespaceCode", "namespaceCodeAfter");
        newAttributes.put("componentName", "componentNameAfter");
        updatedRoleMember.setAttributes(newAttributes);
        this.roleService.updateRoleMember(updatedRoleMember.build());
        RoleMemberBo updatedRmBo = this.getRoleMemberBo(roleMember.getId());
        Assert.assertEquals((long)3L, (long)rmBo.getAttributeDetails().size());
        Assert.assertEquals((long)3L, (long)updatedRmBo.getAttributeDetails().size());
        for (RoleMemberAttributeDataBo newRoleMemberAttrDataBo : updatedRmBo.getAttributeDetails()) {
            for (RoleMemberAttributeDataBo oldRoleMemberAttrDataBo : rmBo.getAttributeDetails()) {
                if (!newRoleMemberAttrDataBo.getKimTypeId().equals(oldRoleMemberAttrDataBo.getKimTypeId()) || !newRoleMemberAttrDataBo.getKimAttributeId().equals(oldRoleMemberAttrDataBo.getKimAttributeId())) continue;
                Assert.assertEquals((String)"updated role member version number incorrect", (Object)new Long(2L), (Object)newRoleMemberAttrDataBo.getVersionNumber());
            }
        }
    }

    @Test
    public void testPrincipalCreateRemoveWithQualifiers() {
        Role roleId = this.roleService.getRole(ROLE_ID);
        ArrayList<String> roleIds = new ArrayList<String>();
        roleIds.add(roleId.getId());
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("parameterName", "parameterNameValue");
        attributes.put("namespaceCode", "namespaceCodeValue");
        attributes.put("componentName", "componentNameValue");
        int memberCountBeforeAdding = this.getActiveRoleMemberCount(roleIds, attributes);
        this.roleService.assignPrincipalToRole(ROLE_MEMBER_ID1, roleId.getNamespaceCode(), roleId.getName(), attributes);
        int memberCountAfterAdding = this.getActiveRoleMemberCount(roleIds, attributes);
        Assert.assertTrue((String)"Member not added to role.", (memberCountAfterAdding == memberCountBeforeAdding + 1 ? 1 : 0) != 0);
        this.roleService.removePrincipalFromRole(ROLE_MEMBER_ID1, roleId.getNamespaceCode(), roleId.getName(), attributes);
        int memberCountAfterRemoving = this.getActiveRoleMemberCount(roleIds, attributes);
        Assert.assertEquals((String)"Member not removed from role.", (long)memberCountBeforeAdding, (long)memberCountAfterRemoving);
    }

    private int getActiveRoleMemberCount(List<String> roleIds, Map<String, String> qualifiers) {
        List roleMembers = this.roleService.getRoleMembers(roleIds, qualifiers);
        return roleMembers.size();
    }

    @Test
    public void testRoleMemberCreateUpdateNoAttrChange() {
        Role roleId = this.roleService.getRole(ROLE_ID);
        ArrayList<String> roleIds = new ArrayList<String>();
        roleIds.add(roleId.getId());
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("parameterName", "parameterNameBefore");
        attributes.put("namespaceCode", "namespaceCodeBefore");
        attributes.put("componentName", "componentNameBefore");
        RoleMember roleMember = this.roleService.createRoleMember(RoleMember.Builder.create((String)ROLE_ID, (String)ROLE_MEMBER_ID1, (String)MEMBER_ID, (MemberType)MEMBER_TYPE_R, (DateTime)ACTIVE_FROM, (DateTime)ACTIVE_TO1, attributes, (String)"", (String)"").build());
        RoleMemberBo rmBo = this.getRoleMemberBo(roleMember.getId());
        RoleMember.Builder updatedRoleMember = RoleMember.Builder.create((RoleMemberContract)roleMember);
        updatedRoleMember.setActiveToDate(ACTIVE_TO2);
        updatedRoleMember.setAttributes(rmBo.getAttributes());
        this.roleService.updateRoleMember(updatedRoleMember.build());
        RoleMemberBo updatedRmBo = this.getRoleMemberBo(roleMember.getId());
        Assert.assertEquals((long)3L, (long)rmBo.getAttributeDetails().size());
        Assert.assertEquals((long)3L, (long)updatedRmBo.getAttributeDetails().size());
        for (RoleMemberAttributeDataBo newRoleMemberAttrDataBo : updatedRmBo.getAttributeDetails()) {
            for (RoleMemberAttributeDataBo oldRoleMemberAttrDataBo : rmBo.getAttributeDetails()) {
                if (!newRoleMemberAttrDataBo.getKimTypeId().equals(oldRoleMemberAttrDataBo.getKimTypeId()) || !newRoleMemberAttrDataBo.getKimAttributeId().equals(oldRoleMemberAttrDataBo.getKimAttributeId())) continue;
                Assert.assertEquals((Object)oldRoleMemberAttrDataBo.getAttributeValue(), (Object)newRoleMemberAttrDataBo.getAttributeValue());
                Assert.assertEquals((String)"updated role member version number incorrect (since no update - should not have been changed)", (Object)new Long(1L), (Object)newRoleMemberAttrDataBo.getVersionNumber());
            }
        }
    }

    @Test
    public void testRoleMemberCreateUpdateRemoveOneAttr() {
        Role roleId = this.roleService.getRole(ROLE_ID);
        ArrayList<String> roleIds = new ArrayList<String>();
        roleIds.add(roleId.getId());
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("parameterName", "parameterNameBefore");
        attributes.put("namespaceCode", "namespaceCodeBefore");
        attributes.put("componentName", "componentNameBefore");
        RoleMember roleMember = this.roleService.createRoleMember(RoleMember.Builder.create((String)ROLE_ID, (String)ROLE_MEMBER_ID1, (String)MEMBER_ID, (MemberType)MEMBER_TYPE_R, (DateTime)ACTIVE_FROM, (DateTime)ACTIVE_TO1, attributes, (String)"", (String)"").build());
        RoleMemberBo rmBo = this.getRoleMemberBo(roleMember.getId());
        Assert.assertEquals((long)3L, (long)rmBo.getAttributeDetails().size());
        RoleMember.Builder updatedRoleMember = RoleMember.Builder.create((RoleMemberContract)roleMember);
        updatedRoleMember.setActiveToDate(ACTIVE_TO2);
        HashMap<String, String> newAttributes = new HashMap<String, String>();
        newAttributes.put("parameterName", "parameterNameAfter");
        newAttributes.put("namespaceCode", "namespaceCodeAfter");
        updatedRoleMember.setAttributes(newAttributes);
        this.roleService.updateRoleMember(updatedRoleMember.build());
        RoleMemberBo updatedRmBo = this.getRoleMemberBo(roleMember.getId());
        Assert.assertEquals((long)2L, (long)updatedRmBo.getAttributeDetails().size());
        for (RoleMemberAttributeDataBo newRoleMemberAttrDataBo : updatedRmBo.getAttributeDetails()) {
            for (RoleMemberAttributeDataBo oldRoleMemberAttrDataBo : rmBo.getAttributeDetails()) {
                if (!newRoleMemberAttrDataBo.getKimTypeId().equals(oldRoleMemberAttrDataBo.getKimTypeId()) || !newRoleMemberAttrDataBo.getKimAttributeId().equals(oldRoleMemberAttrDataBo.getKimAttributeId())) continue;
                Assert.assertEquals((Object)new Long(2L), (Object)newRoleMemberAttrDataBo.getVersionNumber());
            }
        }
    }

    @Test
    public void testRoleMemberCreateUpdateAddOneAttr() {
        Role roleId = this.roleService.getRole(ROLE_ID);
        ArrayList<String> roleIds = new ArrayList<String>();
        roleIds.add(roleId.getId());
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("parameterName", "parameterNameBefore");
        attributes.put("namespaceCode", "namespaceCodeBefore");
        RoleMember roleMember = this.roleService.createRoleMember(RoleMember.Builder.create((String)ROLE_ID, (String)ROLE_MEMBER_ID1, (String)MEMBER_ID, (MemberType)MEMBER_TYPE_R, (DateTime)ACTIVE_FROM, (DateTime)ACTIVE_TO1, attributes, (String)"", (String)"").build());
        RoleMemberBo rmBo = this.getRoleMemberBo(roleMember.getId());
        Assert.assertEquals((String)"Original role member number of attributes is incorrect", (long)2L, (long)rmBo.getAttributeDetails().size());
        RoleMember.Builder updatedRoleMember = RoleMember.Builder.create((RoleMemberContract)roleMember);
        updatedRoleMember.setActiveToDate(ACTIVE_TO2);
        HashMap<String, String> newAttributes = new HashMap<String, String>();
        newAttributes.put("parameterName", "parameterNameAfter");
        newAttributes.put("namespaceCode", "namespaceCodeAfter");
        newAttributes.put("componentName", "componentNameAfter");
        updatedRoleMember.setAttributes(newAttributes);
        this.roleService.updateRoleMember(updatedRoleMember.build());
        RoleMemberBo updatedRmBo = this.getRoleMemberBo(roleMember.getId());
        Assert.assertEquals((String)"updated role member number of attributes is incorrect", (long)3L, (long)updatedRmBo.getAttributeDetails().size());
        System.err.println(updatedRmBo);
        for (RoleMemberAttributeDataBo newRoleMemberAttrDataBo : updatedRmBo.getAttributeDetails()) {
            Assert.assertEquals((String)(newRoleMemberAttrDataBo.getKimAttribute().getAttributeName() + " value is incorrect"), (Object)(newRoleMemberAttrDataBo.getKimAttribute().getAttributeName() + "After"), (Object)newRoleMemberAttrDataBo.getAttributeValue());
            if (newRoleMemberAttrDataBo.getKimAttribute().getAttributeName().equals("componentName")) {
                Assert.assertEquals((String)"componentName (new attribute) versionNumber incorrect", (Object)new Long(1L), (Object)newRoleMemberAttrDataBo.getVersionNumber());
                continue;
            }
            Assert.assertEquals((String)(newRoleMemberAttrDataBo.getKimAttribute().getAttributeName() + " (updated attribute) versionNumber incorrect"), (Object)new Long(2L), (Object)newRoleMemberAttrDataBo.getVersionNumber());
        }
    }

    @Test
    public void testDelegateMemberCreateUpdateRemoveWithAttr() {
        Role r2 = this.roleService.getRole(ROLE_ID);
        RoleMember rm1 = this.roleService.assignPrincipalToRole("user2", r2.getNamespaceCode(), r2.getName(), new HashMap());
        String kimTypeId = MEMBER_ID;
        String id = this.getNextSequenceStringValue("KRIM_DLGN_MBR_ID_S");
        DelegateTypeBo delegate = new DelegateTypeBo();
        delegate.setDelegationId(id);
        delegate.setDelegationType(DelegationType.PRIMARY);
        delegate.setRoleId(r2.getId());
        delegate.setActive(true);
        delegate.setKimTypeId(kimTypeId);
        delegate = (DelegateTypeBo)KradDataServiceLocator.getDataObjectService().save((Object)delegate, new PersistenceOption[]{PersistenceOption.FLUSH});
        DelegateMember.Builder delegateMemberInfo = DelegateMember.Builder.create();
        delegateMemberInfo.setDelegationId(delegate.getDelegationId());
        delegateMemberInfo.setMemberId("user4");
        delegateMemberInfo.setRoleMemberId(rm1.getId());
        delegateMemberInfo.setType(MemberType.PRINCIPAL);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("parameterName", "parameterNameBefore");
        attributes.put("namespaceCode", "namespaceCodeBefore");
        attributes.put("componentName", "componentNameBefore");
        delegateMemberInfo.setAttributes(attributes);
        DelegateMember inDelegateMember = delegateMemberInfo.build();
        DelegateMember newDelegateMember = this.roleService.createDelegateMember(inDelegateMember);
        Assert.assertNotNull((String)"delegateMember not created", (Object)newDelegateMember);
        DateTime threeDaysAgo = DateTime.now().minusDays(3);
        DateTime threeDaysFromNow = DateTime.now().plusDays(3);
        delegateMemberInfo.setActiveFromDate(threeDaysAgo);
        delegateMemberInfo.setActiveToDate(threeDaysFromNow);
        delegateMemberInfo.setDelegationMemberId(newDelegateMember.getDelegationMemberId());
        HashMap<String, String> newAttributes = new HashMap<String, String>();
        newAttributes.put("parameterName", "parameterNameAfter");
        newAttributes.put("namespaceCode", "namespaceCodeAfter");
        newAttributes.put("componentName", "componentNameAfter");
        delegateMemberInfo.setAttributes(newAttributes);
        newDelegateMember = delegateMemberInfo.build();
        DelegateMember updateDelegateMember = this.roleService.updateDelegateMember(newDelegateMember);
        Assert.assertNotNull((String)"updateDelegateMember not updated", (Object)updateDelegateMember);
        Assert.assertEquals((String)"activeFromDate not updated", (Object)threeDaysAgo, (Object)updateDelegateMember.getActiveFromDate());
        Assert.assertEquals((String)"activeToDate not updated", (Object)threeDaysFromNow, (Object)updateDelegateMember.getActiveToDate());
        DelegateMemberBo updatedDelegateMemberBo = this.getDelegateMemberBo(updateDelegateMember.getDelegationMemberId());
        for (DelegateMemberAttributeDataBo newRoleMemberAttrDataBo : updatedDelegateMemberBo.getAttributeDetails()) {
            for (DelegateMemberAttributeDataBo oldRoleMemberAttrDataBo : updatedDelegateMemberBo.getAttributeDetails()) {
                if (!newRoleMemberAttrDataBo.getKimTypeId().equals(oldRoleMemberAttrDataBo.getKimTypeId()) || !newRoleMemberAttrDataBo.getKimAttributeId().equals(oldRoleMemberAttrDataBo.getKimAttributeId())) continue;
                Assert.assertEquals((String)"version number on new role member incorrect", (Object)new Long(2L), (Object)newRoleMemberAttrDataBo.getVersionNumber());
            }
        }
        ArrayList<DelegateMember> removeDelegateMembers = new ArrayList<DelegateMember>();
        removeDelegateMembers.add(updateDelegateMember);
        this.roleService.removeDelegateMembers(removeDelegateMembers);
        DelegateMember removedDelegateMember = this.roleService.getDelegationMemberById(updateDelegateMember.getDelegationMemberId());
        Assert.assertTrue((String)"removeDelegateMembers did not remove the existing member", (boolean)removedDelegateMember.getDelegationMemberId().equals(updateDelegateMember.getDelegationMemberId()));
        Assert.assertNotNull((String)"after removal, versionNumber should not be null", (Object)removedDelegateMember.getVersionNumber());
        Assert.assertTrue((String)"removeDelegateMembers did not remove the existing member", (boolean)removedDelegateMember.getVersionNumber().equals(updateDelegateMember.getVersionNumber() + 1L));
        Assert.assertNotNull((String)"after removal, active to date should not be null", (Object)removedDelegateMember.getActiveToDate());
        Assert.assertTrue((String)"removeDelegateMembers did not update activeToDate", (boolean)removedDelegateMember.getActiveToDate().isBeforeNow());
    }

    protected RoleMemberBo getRoleMemberBo(String roleMemberId) {
        if (StringUtils.isBlank((String)roleMemberId)) {
            return null;
        }
        return (RoleMemberBo)KradDataServiceLocator.getDataObjectService().find(RoleMemberBo.class, (Object)roleMemberId);
    }

    protected DelegateMemberBo getDelegateMemberBo(String delegationMemberId) {
        if (StringUtils.isBlank((String)delegationMemberId)) {
            return null;
        }
        return (DelegateMemberBo)KradDataServiceLocator.getDataObjectService().find(DelegateMemberBo.class, (Object)delegationMemberId);
    }

    @Test
    public void testPrincipalHasRoleContainsGroupAssigned() {
        ArrayList<String> roleIds = new ArrayList<String>();
        roleIds.add("r2");
        Assert.assertTrue((String)"p2 is assigned to g1 and g1 assigned to r2", (boolean)this.roleService.principalHasRole("p2", roleIds, Collections.emptyMap()));
    }

    @Test
    public void testAddPrincipalToRoleAndRemove() {
        Role r2 = this.roleService.getRole("r2");
        RoleMember rm1 = this.roleService.assignPrincipalToRole("user4", r2.getNamespaceCode(), r2.getName(), new HashMap());
        Assert.assertTrue((String)"principal should be assigned to role", (boolean)this.roleService.principalHasRole("user4", Collections.singletonList(r2.getId()), new HashMap()));
        this.roleService.removePrincipalFromRole("user4", r2.getNamespaceCode(), r2.getName(), new HashMap());
        RoleMember rm2 = this.roleService.assignPrincipalToRole("user4", r2.getNamespaceCode(), r2.getName(), new HashMap());
        Assert.assertFalse((boolean)rm1.getId().equals(rm2.getId()));
    }

    @Test
    public void testAddMultiplePrincipalsToRole() {
        Role r2 = this.roleService.getRole("r2");
        HashMap conditions = new HashMap();
        int originalNumberOfPrincipals = this.roleService.getRoleMemberPrincipalIds(r2.getNamespaceCode(), r2.getName(), conditions).size();
        RoleMember rm1 = this.roleService.assignPrincipalToRole("user3", r2.getNamespaceCode(), r2.getName(), conditions);
        RoleMember rm2 = this.roleService.assignPrincipalToRole("user4", r2.getNamespaceCode(), r2.getName(), conditions);
        Assert.assertTrue((String)"principal should be assigned to role", (boolean)this.roleService.principalHasRole("user3", Collections.singletonList(r2.getId()), conditions));
        Assert.assertTrue((String)"principal should be assigned to role", (boolean)this.roleService.principalHasRole("user4", Collections.singletonList(r2.getId()), conditions));
        int numberOfPrincipals = this.roleService.getRoleMemberPrincipalIds(r2.getNamespaceCode(), r2.getName(), conditions).size();
        Assert.assertEquals((String)"Should have been two Principals added to role", (long)(numberOfPrincipals - 2), (long)originalNumberOfPrincipals);
        r2 = this.roleService.getRole("r2");
        this.roleService.removePrincipalFromRole("user3", r2.getNamespaceCode(), r2.getName(), conditions);
        this.roleService.removePrincipalFromRole("user4", r2.getNamespaceCode(), r2.getName(), conditions);
        r2 = this.roleService.getRole("r2");
        Assert.assertFalse((String)"principal should have been removed from role", (boolean)this.roleService.principalHasRole("user3", Collections.singletonList(r2.getId()), conditions));
        Assert.assertFalse((String)"principal should have been removed from role", (boolean)this.roleService.principalHasRole("user4", Collections.singletonList(r2.getId()), conditions));
        numberOfPrincipals = this.roleService.getRoleMemberPrincipalIds(r2.getNamespaceCode(), r2.getName(), new HashMap()).size();
        Assert.assertEquals((String)"Should have had the two added Principals removed", (long)numberOfPrincipals, (long)originalNumberOfPrincipals);
    }

    @Test
    public void testAddMultipleQualifiedPrincipalsToRole() {
        Role rCampus = this.roleService.getRole("r-campus");
        Map<String, String> conditions = Collections.singletonMap("campusCode", "BL");
        int originalNumberOfPrincipals = this.roleService.getRoleMemberPrincipalIds(rCampus.getNamespaceCode(), rCampus.getName(), Collections.singletonMap("campusCode", "BL")).size();
        this.roleService.assignPrincipalToRole("user3", rCampus.getNamespaceCode(), rCampus.getName(), conditions);
        this.roleService.assignPrincipalToRole("user4", rCampus.getNamespaceCode(), rCampus.getName(), conditions);
        Assert.assertTrue((String)"principal should be assigned to role", (boolean)this.roleService.principalHasRole("user3", Collections.singletonList(rCampus.getId()), conditions));
        Assert.assertTrue((String)"principal should be assigned to role", (boolean)this.roleService.principalHasRole("user4", Collections.singletonList(rCampus.getId()), conditions));
        int numberOfPrincipals = this.roleService.getRoleMemberPrincipalIds(rCampus.getNamespaceCode(), rCampus.getName(), Collections.singletonMap("campusCode", "BL")).size();
        Assert.assertEquals((String)"Should have been two Principals added to role", (long)numberOfPrincipals, (long)(originalNumberOfPrincipals + 2));
        rCampus = this.roleService.getRole("r-campus");
        this.roleService.removePrincipalFromRole("user3", rCampus.getNamespaceCode(), rCampus.getName(), conditions);
        this.roleService.removePrincipalFromRole("user4", rCampus.getNamespaceCode(), rCampus.getName(), conditions);
        rCampus = this.roleService.getRole("r-campus");
        Assert.assertFalse((String)"principal should have been removed from role", (boolean)this.roleService.principalHasRole("user3", Collections.singletonList(rCampus.getId()), conditions));
        Assert.assertFalse((String)"principal should have been removed from role", (boolean)this.roleService.principalHasRole("user3", Collections.singletonList(rCampus.getId()), conditions));
        numberOfPrincipals = this.roleService.getRoleMemberPrincipalIds(rCampus.getNamespaceCode(), rCampus.getName(), Collections.singletonMap("campusCode", "BL")).size();
        Assert.assertEquals((String)"Should have had the two added Principals removed", (long)numberOfPrincipals, (long)originalNumberOfPrincipals);
    }

    @Test
    public void testAddQualifiedPrincipalToRoleDoesNotReuseWrongRoleMember() {
        Role rCampus = this.roleService.getRole("r-campus");
        Map<String, String> campusBLqualifier = Collections.singletonMap("campusCode", "BL");
        Map<String, String> campusKOqualifier = Collections.singletonMap("campusCode", "KO");
        List roleMembers = this.roleService.getRoleMembers(Collections.singletonList(rCampus.getId()), campusBLqualifier);
        for (RoleMembership rm : roleMembers) {
            this.roleService.removePrincipalFromRole(rm.getMemberId(), rCampus.getNamespaceCode(), rCampus.getName(), campusBLqualifier);
        }
        roleMembers = this.roleService.getRoleMembers(Collections.singletonList(rCampus.getId()), campusBLqualifier);
        Assert.assertEquals((String)("Pre-check failed - should not be any members with" + campusBLqualifier + ".  Members: " + roleMembers), (long)0L, (long)roleMembers.size());
        roleMembers = this.roleService.getRoleMembers(Collections.singletonList(rCampus.getId()), campusKOqualifier);
        for (RoleMembership rm : roleMembers) {
            this.roleService.removePrincipalFromRole(rm.getMemberId(), rCampus.getNamespaceCode(), rCampus.getName(), campusKOqualifier);
        }
        roleMembers = this.roleService.getRoleMembers(Collections.singletonList(rCampus.getId()), campusKOqualifier);
        Assert.assertEquals((String)("Pre-check failed - should not be any members with" + campusKOqualifier + ".  Members: " + roleMembers), (long)0L, (long)roleMembers.size());
        RoleMember rm1 = this.roleService.assignPrincipalToRole("user3", rCampus.getNamespaceCode(), rCampus.getName(), campusBLqualifier);
        Assert.assertTrue((String)"user3 should be assigned to role", (boolean)this.roleService.principalHasRole("user3", Collections.singletonList(rCampus.getId()), campusBLqualifier));
        Assert.assertNotNull((String)"Role member ID should have been assigned", (Object)rm1.getId());
        Assert.assertNotNull((String)"role member missing campus code qualifier", rm1.getAttributes().get("campusCode"));
        Assert.assertEquals((String)"campus code on role member incorrect", (Object)"BL", rm1.getAttributes().get("campusCode"));
        RoleMember rm2 = this.roleService.assignPrincipalToRole("user3", rCampus.getNamespaceCode(), rCampus.getName(), campusKOqualifier);
        Assert.assertNotNull((String)"role member missing campus code qualifier", rm2.getAttributes().get("campusCode"));
        Assert.assertEquals((String)"campus code on role member incorrect", (Object)"KO", rm2.getAttributes().get("campusCode"));
        Assert.assertTrue((String)"user3 should be assigned to role for campus code KO", (boolean)this.roleService.principalHasRole("user3", Collections.singletonList(rCampus.getId()), campusKOqualifier));
        Assert.assertNotNull((String)"Role member ID should have been assigned", (Object)rm1.getId());
        Assert.assertFalse((String)"Role member ID SHOULD NOT be the same as previous assignment since qualifiers are different", (boolean)rm1.getId().equals(rm2.getId()));
        roleMembers = this.roleService.getRoleMembers(Collections.singletonList(rCampus.getId()), campusBLqualifier);
        Assert.assertEquals((String)("Should only be one principal in role with " + campusBLqualifier + ".  Members: " + roleMembers), (long)1L, (long)roleMembers.size());
        roleMembers = this.roleService.getRoleMembers(Collections.singletonList(rCampus.getId()), campusKOqualifier);
        Assert.assertEquals((String)("Should only be one principal in role with " + campusKOqualifier + ".  Members: " + roleMembers), (long)1L, (long)roleMembers.size());
        this.roleService.removePrincipalFromRole("user3", rCampus.getNamespaceCode(), rCampus.getName(), campusBLqualifier);
        Assert.assertFalse((String)"principal should have been removed from role", (boolean)this.roleService.principalHasRole("user3", Collections.singletonList(rCampus.getId()), campusBLqualifier));
    }

    @Test
    public void testAddQualifiedPrincipalToRoleTwice() {
        Role rCampus = this.roleService.getRole("r-campus");
        Map<String, String> campusBLqualifier = Collections.singletonMap("campusCode", "BL");
        List roleMembers = this.roleService.getRoleMembers(Collections.singletonList(rCampus.getId()), campusBLqualifier);
        for (RoleMembership rm : roleMembers) {
            this.roleService.removePrincipalFromRole(rm.getMemberId(), rCampus.getNamespaceCode(), rCampus.getName(), campusBLqualifier);
        }
        roleMembers = this.roleService.getRoleMembers(Collections.singletonList(rCampus.getId()), campusBLqualifier);
        Assert.assertEquals((String)("Pre-check failed - should not be any members with campus code BL.  Members: " + roleMembers), (long)0L, (long)roleMembers.size());
        RoleMember rm1 = this.roleService.assignPrincipalToRole("user3", rCampus.getNamespaceCode(), rCampus.getName(), campusBLqualifier);
        Assert.assertTrue((String)"user3 should be assigned to role", (boolean)this.roleService.principalHasRole("user3", Collections.singletonList(rCampus.getId()), campusBLqualifier));
        Assert.assertNotNull((String)"Role member ID should have been assigned", (Object)rm1.getId());
        RoleMember rm2 = this.roleService.assignPrincipalToRole("user3", rCampus.getNamespaceCode(), rCampus.getName(), campusBLqualifier);
        Assert.assertTrue((String)"user3 should be still assigned to role", (boolean)this.roleService.principalHasRole("user3", Collections.singletonList(rCampus.getId()), campusBLqualifier));
        Assert.assertNotNull((String)"Role member ID should have been assigned", (Object)rm1.getId());
        Assert.assertEquals((String)"Role member ID be the same as previous assignment since user and qualifiers are the same", (Object)rm1.getId(), (Object)rm2.getId());
        roleMembers = this.roleService.getRoleMembers(Collections.singletonList(rCampus.getId()), campusBLqualifier);
        Assert.assertEquals((String)("Should only be one principal in role with campus code BL.  Members: " + roleMembers), (long)1L, (long)roleMembers.size());
        this.roleService.removePrincipalFromRole("user3", rCampus.getNamespaceCode(), rCampus.getName(), campusBLqualifier);
        Assert.assertFalse((String)"principal should have been removed from role", (boolean)this.roleService.principalHasRole("user3", Collections.singletonList(rCampus.getId()), campusBLqualifier));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCircularRoleAssignment() {
        HashMap map = new HashMap();
        ArrayList<String> roleIds = new ArrayList<String>();
        roleIds.add("r1");
        this.roleService.assignRoleToRole("r5", "AUTH_SVC_TEST2", "RoleThree", map);
    }

    protected RoleResponsibilityAction createRoleResponsibilityAction() {
        List members = this.roleService.getRoleMembers(Collections.singletonList("r1"), null);
        RoleMembership rm = (RoleMembership)members.get(0);
        RoleResponsibilityAction.Builder builder = RoleResponsibilityAction.Builder.create();
        builder.setRoleMemberId(rm.getMemberId());
        builder.setActionTypeCode(ActionType.APPROVE.getCode());
        RoleResponsibilityAction saved = this.roleService.createRoleResponsibilityAction(builder.build());
        List rra = this.roleService.getRoleMemberResponsibilityActions(rm.getMemberId());
        Assert.assertEquals((String)"incorrect number of RoleResponsibilityAction returned", (long)1L, (long)rra.size());
        Assert.assertEquals((String)"saved RoleResponsibilityAction does not match expected", (Object)saved, rra.get(0));
        return (RoleResponsibilityAction)rra.get(0);
    }

    @Test
    public void testGetRoleMembers() {
        List members = this.roleService.getRoleMembers(Collections.singletonList("r1"), null);
        Assert.assertNotNull((String)"returned member list should not be null", (Object)members);
        Assert.assertEquals((String)"Wrong numbers of members in the role", (long)2L, (long)members.size());
    }

    @Test
    public void testGetRoleMembersWithExactMatchRoleTypeEmptyQualifier() {
        Role rCampus = this.roleService.getRole("r-campus");
        Assert.assertNotNull((String)"Campus-based role missing from test data", (Object)rCampus);
        Assert.assertEquals((String)"Campus role type incorrect", (Object)"kt-campus", (Object)rCampus.getKimTypeId());
        List members = this.roleService.getRoleMembers(Collections.singletonList("r-campus"), Collections.emptyMap());
        Assert.assertNotNull((String)"returned member list should not be null", (Object)members);
        Assert.assertEquals((String)("Wrong numbers of members in the role: " + members), (long)2L, (long)members.size());
    }

    @Test
    public void testGetRoleMembersWithExactMatchRoleType() {
        Role rCampus = this.roleService.getRole("r-campus");
        Assert.assertNotNull((String)"Campus-based role missing from test data", (Object)rCampus);
        Assert.assertEquals((String)"Campus role type incorrect", (Object)"kt-campus", (Object)rCampus.getKimTypeId());
        List members = this.roleService.getRoleMembers(Collections.singletonList("r-campus"), Collections.singletonMap("campusCode", "BL"));
        Assert.assertNotNull((String)"returned member list should not be null", (Object)members);
        Assert.assertEquals((String)("Wrong numbers of members returned from role: " + members), (long)1L, (long)members.size());
    }

    @Test
    public void testRemoveRoleFromRoleWithExactQualification() {
        Role rCampus = this.roleService.getRole("r-campus-2");
        Assert.assertNotNull((String)"Campus-based role missing from test data", (Object)rCampus);
        Assert.assertEquals((String)"Campus role type incorrect", (Object)"kt-campus", (Object)rCampus.getKimTypeId());
        List firstLevelRoleMembers = this.roleService.getFirstLevelRoleMembers(Collections.singletonList("r-campus-2"));
        Assert.assertEquals((String)("wrong number of role members: " + firstLevelRoleMembers), (long)2L, (long)firstLevelRoleMembers.size());
        RoleMembership blRoleMember = null;
        RoleMembership nonBlRoleMember = null;
        for (RoleMembership rm : firstLevelRoleMembers) {
            if (StringUtils.equals((String)((String)rm.getQualifier().get("campusCode")), (String)"BL")) {
                blRoleMember = rm;
                continue;
            }
            nonBlRoleMember = rm;
        }
        Assert.assertNotNull((String)"Both role members have qualifer BL, the test can not function", nonBlRoleMember);
        Assert.assertNotNull((String)"Neither role member has qualifer BL, the test can not function", blRoleMember);
        Assert.assertEquals((String)"The BL role member needs to be a role", (Object)MemberType.ROLE, (Object)blRoleMember.getType());
        Role blMemberRole = this.roleService.getRole(blRoleMember.getMemberId());
        Assert.assertNotNull((String)"role specified on BL role member does not exist", (Object)blMemberRole);
        this.roleService.removeRoleFromRole(blRoleMember.getMemberId(), rCampus.getNamespaceCode(), rCampus.getName(), Collections.singletonMap("campusCode", "BL"));
        firstLevelRoleMembers = this.roleService.getFirstLevelRoleMembers(Collections.singletonList("r-campus-2"));
        Assert.assertEquals((String)("wrong number of role members after removal: " + firstLevelRoleMembers), (long)1L, (long)firstLevelRoleMembers.size());
        Assert.assertEquals((String)"Wrong role member remains", (Object)"r1", (Object)((RoleMembership)firstLevelRoleMembers.get(0)).getMemberId());
    }

    @Test
    public void testGetRoleQualifersForPrincipalByNamespaceAndRolenameWithoutQualifier() {
        Role rCampus = this.roleService.getRoleByNamespaceCodeAndName("AUTH_SVC_TEST2", "Campus Reviewer");
        Assert.assertNotNull((String)"Campus-based role missing from test data", (Object)rCampus);
        Assert.assertEquals((String)"Campus role type incorrect", (Object)"kt-campus", (Object)rCampus.getKimTypeId());
        List qualifiers = this.roleService.getRoleQualifersForPrincipalByNamespaceAndRolename("p9", "AUTH_SVC_TEST2", "Campus Reviewer", Collections.emptyMap());
        Assert.assertNotNull((String)"Returned qualifier list should not be null", (Object)qualifiers);
        Assert.assertEquals((String)"Qualifier list should have one entry", (long)1L, (long)qualifiers.size());
        Assert.assertTrue((String)"campus code qualifier missing", (boolean)((Map)qualifiers.get(0)).containsKey("campusCode"));
        Assert.assertEquals((String)"campus code qualifier incorrect", (Object)"BL", ((Map)qualifiers.get(0)).get("campusCode"));
    }

    @Test
    public void testGetRoleQualifersForPrincipalByNamespaceAndRolenameWithQualifier() {
        Role rCampus = this.roleService.getRoleByNamespaceCodeAndName("AUTH_SVC_TEST2", "Campus Reviewer");
        Assert.assertNotNull((String)"Campus-based role missing from test data", (Object)rCampus);
        Assert.assertEquals((String)"Campus role type incorrect", (Object)"kt-campus", (Object)rCampus.getKimTypeId());
        List qualifiers = this.roleService.getRoleQualifersForPrincipalByNamespaceAndRolename("p9", "AUTH_SVC_TEST2", "Campus Reviewer", Collections.singletonMap("campusCode", "BL"));
        Assert.assertNotNull((String)"Returned qualifier list should not be null", (Object)qualifiers);
        Assert.assertEquals((String)"Qualifier list should have one entry", (long)1L, (long)qualifiers.size());
        Assert.assertTrue((String)"campus code qualifier missing", (boolean)((Map)qualifiers.get(0)).containsKey("campusCode"));
        Assert.assertEquals((String)"campus code qualifier incorrect", (Object)"BL", ((Map)qualifiers.get(0)).get("campusCode"));
    }

    @Test
    public void testCreateRoleResponsibilityAction() {
        this.createRoleResponsibilityAction();
    }

    @Test
    public void testUpdateRoleResponsibilityAction() {
        RoleResponsibilityAction rra = this.createRoleResponsibilityAction();
        RoleResponsibilityAction.Builder builder = RoleResponsibilityAction.Builder.create((RoleResponsibilityActionContract)rra);
        Assert.assertFalse((boolean)builder.isForceAction());
        builder.setForceAction(true);
        builder.setActionTypeCode(ActionType.ACKNOWLEDGE.getCode());
        RoleResponsibilityAction updated = this.roleService.updateRoleResponsibilityAction(builder.build());
        builder.setVersionNumber(updated.getVersionNumber());
        Assert.assertEquals((Object)builder.build(), (Object)updated);
        List rras = this.roleService.getRoleMemberResponsibilityActions(rra.getRoleMemberId());
        Assert.assertEquals((String)"incorrect number of RoleResponsibilityAction returned", (long)1L, (long)rras.size());
        Assert.assertEquals((String)"updated RoleResponsibilityAction does not match expected", (Object)updated, rras.get(0));
    }

    @Test
    public void testDeleteRoleResponsibilityAction() {
        RoleResponsibilityAction rra = this.createRoleResponsibilityAction();
        this.roleService.deleteRoleResponsibilityAction(rra.getId());
        List rras = this.roleService.getRoleMemberResponsibilityActions(rra.getRoleMemberId());
        Assert.assertEquals((long)0L, (long)rras.size());
        try {
            this.roleService.deleteRoleResponsibilityAction(rra.getId());
            Assert.fail((String)"Expected to throw RiceIllegalStateException due to missing RuleResponsibilityAction");
        }
        catch (RiceIllegalStateException riceIllegalStateException) {
            // empty catch block
        }
    }
}

