/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.test.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.entity.Entity;
import org.kuali.rice.kim.api.identity.entity.EntityDefault;
import org.kuali.rice.kim.api.identity.entity.EntityDefaultQueryResults;
import org.kuali.rice.kim.api.identity.name.EntityName;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;
import org.kuali.rice.kim.api.identity.type.EntityTypeContactInfoDefault;
import org.kuali.rice.kim.impl.identity.PersonServiceImpl;
import org.kuali.rice.kim.service.KIMServiceLocatorInternal;
import org.kuali.rice.kim.test.KIMTestCase;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.NONE)
public class IdentityServiceTest
extends KIMTestCase {
    private IdentityService identityService;

    public void setUp() throws Exception {
        super.setUp();
        if (null == this.identityService) {
            this.identityService = this.findIdSvc();
        }
    }

    @Test
    public void testGetPrincipal() {
        Principal principal = this.identityService.getPrincipal("KULUSER");
        Assert.assertNotNull((String)"principal must not be null", (Object)principal);
        Assert.assertEquals((String)"Principal name did not match expected result", (Object)"kuluser", (Object)principal.getPrincipalName());
    }

    @Test
    public void testGetPrincipalNotFound() {
        Principal principal = this.identityService.getPrincipal("DoesNotExist");
        Assert.assertNull((String)"principal should not be found", (Object)principal);
    }

    @Test
    public void testGetPrincipals() {
        ArrayList<String> principalIds = new ArrayList<String>();
        principalIds.add("KULUSER");
        List validPrincipals = this.identityService.getPrincipals(principalIds);
        Assert.assertNotNull((String)"validPrincipals must not be null", (Object)validPrincipals);
        Assert.assertEquals((String)"validPrincipals name did not match expected result", (Object)"kuluser", (Object)((Principal)validPrincipals.get(0)).getPrincipalName());
    }

    @Test
    public void testGetPrincipalByPrincipalName() {
        Principal principal = this.identityService.getPrincipalByPrincipalName("kuluser");
        Assert.assertNotNull((String)"principal must not be null", (Object)principal);
        Assert.assertEquals((String)"Principal ID did not match expected result", (Object)"KULUSER", (Object)principal.getPrincipalId());
    }

    @Test
    public void testGetPrincipalByPrincipalNameNotFound() {
        Principal principal = this.identityService.getPrincipalByPrincipalName("DoesNotExist");
        Assert.assertNull((String)"principal should not be found", (Object)principal);
    }

    @Test
    public void testUpdatePrincipal() {
        String principalName = "kuluser";
        String principalId = "KULUSER";
        String newPrincipalName = "kuluserUpdatedName";
        Principal principal = this.identityService.getPrincipalByPrincipalName(principalName);
        Assert.assertNotNull((String)"principal must not be null", (Object)principal);
        Assert.assertEquals((String)("principal id should be " + principalId), (Object)principalId, (Object)principal.getPrincipalId());
        Assert.assertEquals((String)("principal name should be " + principalName), (Object)principalName, (Object)principal.getPrincipalName());
        Principal.Builder builder = Principal.Builder.create((PrincipalContract)principal);
        builder.setPrincipalName(newPrincipalName);
        Principal updatedPrincipal = this.identityService.updatePrincipal(builder.build());
        Assert.assertNotNull((String)"principal must not be null", (Object)updatedPrincipal);
        Assert.assertEquals((String)("principal id should be " + principalId), (Object)principalId, (Object)updatedPrincipal.getPrincipalId());
        Assert.assertEquals((String)("principal name should be " + newPrincipalName), (Object)newPrincipalName, (Object)updatedPrincipal.getPrincipalName());
        Principal principalById = this.identityService.getPrincipal(principalId);
        Assert.assertNotNull((String)"principal must not be null", (Object)principalById);
        Assert.assertEquals((String)("principal name should be " + newPrincipalName), (Object)newPrincipalName, (Object)principalById.getPrincipalName());
        Principal.Builder builder2 = Principal.Builder.create((PrincipalContract)principalById);
        builder2.setPrincipalName(principalName);
        Principal revertedPrincipal = this.identityService.updatePrincipal(builder2.build());
        Assert.assertNotNull((String)"principal must not be null", (Object)revertedPrincipal);
        Assert.assertEquals((String)("principal id should be " + principalId), (Object)principalId, (Object)revertedPrincipal.getPrincipalId());
        Assert.assertEquals((String)("principal name should be " + principalName), (Object)principalName, (Object)revertedPrincipal.getPrincipalName());
    }

    @Test
    public void testGetDefaultEntityByPrincipalId() {
        String principalId = "KULUSER";
        EntityDefault info = this.identityService.getEntityDefaultByPrincipalId(principalId);
        Assert.assertNotNull((String)"entity must not be null", (Object)info);
        Assert.assertNotNull((String)"entity principals must not be null", (Object)info.getPrincipals());
        Assert.assertEquals((String)"entity must have exactly 1 principal", (long)1L, (long)info.getPrincipals().size());
        for (Principal principalInfo : info.getPrincipals()) {
            Assert.assertEquals((String)"Wrong principal id", (Object)principalId, (Object)principalInfo.getPrincipalId());
        }
        Assert.assertTrue((String)"entity external identifiers must not be null", (info.getExternalIdentifiers() == null || info.getExternalIdentifiers().isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testGetDefaultEntityByPrincipalName() {
        String principalName = "kuluser";
        EntityDefault info = this.identityService.getEntityDefaultByPrincipalName(principalName);
        Assert.assertNotNull((String)"entity must not be null", (Object)info);
        Assert.assertNotNull((String)"entity principals must not be null", (Object)info.getPrincipals());
        Assert.assertEquals((String)"entity must have exactly 1 principal", (long)1L, (long)info.getPrincipals().size());
        for (Principal principalInfo : info.getPrincipals()) {
            Assert.assertEquals((String)"Wrong principal name", (Object)principalName, (Object)principalInfo.getPrincipalName());
        }
        Assert.assertTrue((String)"entity external identifiers must not be null", (info.getExternalIdentifiers() == null || info.getExternalIdentifiers().isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testGetEntityByPrincipalId() {
        String principalId = "KULUSER";
        Entity info = this.identityService.getEntityByPrincipalId(principalId);
        Assert.assertNotNull((String)"entity must not be null", (Object)info);
        Assert.assertNotNull((String)"entity principals must not be null", (Object)info.getPrincipals());
        Assert.assertEquals((String)"entity must have exactly 1 principal", (long)1L, (long)info.getPrincipals().size());
        for (Principal principalInfo : info.getPrincipals()) {
            Assert.assertEquals((String)"Wrong principal id", (Object)principalId, (Object)principalInfo.getPrincipalId());
        }
        Assert.assertTrue((String)"entity external identifiers must not be null", (info.getExternalIdentifiers() == null || info.getExternalIdentifiers().isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((String)"entity residencies must not be null", (info.getResidencies() == null || info.getResidencies().isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testGetEntityByPrincipalName() {
        String principalName = "kuluser";
        Entity info = this.identityService.getEntityByPrincipalName(principalName);
        Assert.assertNotNull((String)"entity must not be null", (Object)info);
        Assert.assertNotNull((String)"entity principals must not be null", (Object)info.getPrincipals());
        Assert.assertEquals((String)"entity must have exactly 1 principal", (long)1L, (long)info.getPrincipals().size());
        for (Principal principalInfo : info.getPrincipals()) {
            Assert.assertEquals((String)"Wrong principal name", (Object)principalName, (Object)principalInfo.getPrincipalName());
        }
        Assert.assertTrue((String)"entity external identifiers must not be null", (info.getExternalIdentifiers() == null || info.getExternalIdentifiers().isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((String)"entity residencies must not be null", (info.getResidencies() == null || info.getResidencies().isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testGetContainedAttributes() {
        Principal principal = this.identityService.getPrincipal("p1");
        EntityDefault entity = this.identityService.getEntityDefault(principal.getEntityId());
        Assert.assertNotNull((String)"Entity Must not be null", (Object)entity);
        EntityTypeContactInfoDefault eet = entity.getEntityType("PERSON");
        Assert.assertNotNull((String)"PERSON EntityTypeData must not be null", (Object)eet);
        Assert.assertNotNull((String)"EntityEntityType's default email address must not be null", (Object)eet.getDefaultEmailAddress());
        Assert.assertEquals((Object)"p1@kuali.org", (Object)eet.getDefaultEmailAddress().getEmailAddressUnmasked());
    }

    protected QueryByCriteria setUpEntityLookupCriteria(String principalId) {
        PersonServiceImpl personServiceImpl = (PersonServiceImpl)KIMServiceLocatorInternal.getService((String)"personService");
        HashMap<String, String> criteria = new HashMap<String, String>(1);
        criteria.put("principalId", principalId);
        Map entityCriteria = personServiceImpl.convertPersonPropertiesToEntityProperties(criteria);
        entityCriteria.put("entityTypeContactInfos.entityTypeCode", "PERSON");
        QueryByCriteria.Builder query = QueryByCriteria.Builder.create();
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        for (String key : entityCriteria.keySet()) {
            predicates.add(PredicateFactory.like((String)key, (CharSequence)((CharSequence)entityCriteria.get(key))));
        }
        if (!predicates.isEmpty()) {
            query.setPredicates(new Predicate[]{PredicateFactory.and((Predicate[])predicates.toArray(new Predicate[predicates.size()]))});
        }
        return query.build();
    }

    @Test
    public void testLookupEntityDefaultInfo() {
        String principalIdToTest = "p1";
        EntityDefaultQueryResults qr = this.identityService.findEntityDefaults(this.setUpEntityLookupCriteria(principalIdToTest));
        List results = qr.getResults();
        Assert.assertNotNull((String)"Lookup results should never be null", (Object)results);
        Assert.assertEquals((String)"Lookup result count is invalid", (long)1L, (long)results.size());
        for (EntityDefault kimEntityDefaultInfo : results) {
            Assert.assertEquals((String)"Entity should have only one principal for this test", (long)1L, (long)kimEntityDefaultInfo.getPrincipals().size());
            Assert.assertEquals((String)"Principal Ids should match", (Object)principalIdToTest, (Object)((Principal)kimEntityDefaultInfo.getPrincipals().get(0)).getPrincipalId());
        }
    }

    @Test
    public void testLookupEntityInfo() {
        String principalIdToTest = "p1";
        List results = this.identityService.findEntities(this.setUpEntityLookupCriteria(principalIdToTest)).getResults();
        Assert.assertNotNull((String)"Lookup results should never be null", (Object)results);
        Assert.assertEquals((String)"Lookup result count is invalid", (long)1L, (long)results.size());
        for (Entity kimEntityInfo : results) {
            Assert.assertEquals((String)"Entity should have only one principal for this test", (long)1L, (long)kimEntityInfo.getPrincipals().size());
            Assert.assertEquals((String)"Principal Ids should match", (Object)principalIdToTest, (Object)((Principal)kimEntityInfo.getPrincipals().get(0)).getPrincipalId());
        }
    }

    @Test
    public void testGetEntityWithNameChangeDate() {
        String principalName = "testuser7";
        Entity info = this.identityService.getEntityByPrincipalName(principalName);
        List names = info.getNames();
        for (EntityName name : names) {
            Assert.assertNotNull((String)("nameChangeDate should have been set for PrincipalName " + principalName), (Object)name.getNameChangedDate());
        }
    }

    protected IdentityService findIdSvc() throws Exception {
        return (IdentityService)GlobalResourceLoader.getService((QName)new QName("http://rice.kuali.org/kim/v2_0", "identityService"));
    }

    protected void setIdentityService(IdentityService idSvc) {
        this.identityService = idSvc;
    }
}

