/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.test.service;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.kim.api.KimConstants;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.group.GroupContract;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.kim.impl.group.GroupMemberBo;
import org.kuali.rice.kim.test.KIMTestCase;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.util.CollectionUtils;

public class GroupUpdateServiceImplTest
extends KIMTestCase {
    private GroupService groupService;
    private BusinessObjectService businessObjectService;

    public void setUp() throws Exception {
        super.setUp();
        this.groupService = (GroupService)GlobalResourceLoader.getService((QName)new QName("http://rice.kuali.org/kim/v2_0", "groupService"));
        this.businessObjectService = KNSServiceLocator.getBusinessObjectService();
    }

    @Test
    public void testCreateGroup() {
        Group groupInfo = this.createGroup();
        Group result = this.groupService.getGroupByNamespaceCodeAndName("KUALI", "gA");
        Assert.assertEquals((Object)groupInfo.isActive(), (Object)result.isActive());
        Assert.assertTrue((boolean)groupInfo.getNamespaceCode().equals(result.getNamespaceCode()));
        Assert.assertTrue((boolean)groupInfo.getName().equals(result.getName()));
        Assert.assertTrue((boolean)groupInfo.getKimTypeId().equals(result.getKimTypeId()));
    }

    @Test
    public void testRemoveGroupFromGroup() {
        List preGroupIds = this.groupService.getDirectMemberGroupIds("g1");
        Assert.assertTrue((String)"g1 must contain group g2", (boolean)preGroupIds.contains("g2"));
        this.groupService.removeGroupFromGroup("g2", "g1");
        ArrayList<String> postGroupIds = this.groupService.getDirectMemberGroupIds("g1");
        Assert.assertFalse((String)"g1 must not contain group g2", (boolean)postGroupIds.contains("g2"));
        postGroupIds = new ArrayList<String>(postGroupIds);
        postGroupIds.add("g2");
        Assert.assertTrue((postGroupIds.containsAll(preGroupIds) && preGroupIds.containsAll(postGroupIds) ? 1 : 0) != 0);
        List<GroupMemberBo> members = this.getActiveAndInactiveGroupTypeMembers("g1");
        GroupMemberBo g2 = null;
        for (GroupMemberBo member : members) {
            if (!member.getMemberId().equals("g2")) continue;
            g2 = member;
        }
        Assert.assertNotNull((String)"should have found g2", g2);
        Assert.assertFalse((String)"g2 should be inactive", (boolean)g2.isActive(new Timestamp(System.currentTimeMillis())));
    }

    @Test
    public void testRemovePrincipalFromGroup() {
        List preDirectPrincipalMemberIds = this.groupService.getDirectMemberPrincipalIds("g2");
        Assert.assertTrue((String)"p1 must be direct member of g2", (boolean)preDirectPrincipalMemberIds.contains("p1"));
        this.groupService.removePrincipalFromGroup("p1", "g2");
        ArrayList<String> postDirectPrincipalMemberIds = this.groupService.getDirectMemberPrincipalIds("g2");
        Assert.assertFalse((String)"p1 must no longer be a direct member of g2", (boolean)postDirectPrincipalMemberIds.contains("p1"));
        postDirectPrincipalMemberIds = new ArrayList<String>(postDirectPrincipalMemberIds);
        postDirectPrincipalMemberIds.add("p1");
        Assert.assertTrue((preDirectPrincipalMemberIds.containsAll(postDirectPrincipalMemberIds) && postDirectPrincipalMemberIds.containsAll(preDirectPrincipalMemberIds) ? 1 : 0) != 0);
        List<GroupMemberBo> members = this.getActiveAndInactivePrincipalTypeMembers("g2");
        GroupMemberBo p1 = null;
        for (GroupMemberBo member : members) {
            if (!member.getMemberId().equals("p1")) continue;
            p1 = member;
        }
        Assert.assertNotNull((String)"should have found p1", p1);
        Assert.assertFalse((String)"p1 should be inactive", (boolean)p1.isActive(new Timestamp(System.currentTimeMillis())));
    }

    @Test
    public void testRemoveGroupMembers() {
        List before = this.groupService.getMemberPrincipalIds("g1");
        this.groupService.addPrincipalToGroup("p1", "g1");
        Assert.assertTrue((String)"p1 must be direct member of g1", (boolean)this.groupService.isDirectMemberOfGroup("p1", "g1"));
        Assert.assertTrue((String)"g2 must be direct member of g1", (boolean)this.groupService.isGroupMemberOfGroup("g2", "g1"));
        this.groupService.removeAllMembers("g1");
        List memberInfos = this.groupService.getMembersOfGroup("g1");
        Assert.assertTrue((String)"should be no active members", (boolean)CollectionUtils.isEmpty((Collection)memberInfos));
        List<GroupMemberBo> members = this.getActiveAndInactivePrincipalTypeMembers("g1");
        members.addAll(this.getActiveAndInactiveGroupTypeMembers("g1"));
        GroupMemberBo p1 = null;
        GroupMemberBo g2 = null;
        for (GroupMemberBo member : members) {
            if (member.getMemberId().equals("p1")) {
                p1 = member;
            }
            if (!member.getMemberId().equals("g2")) continue;
            g2 = member;
        }
        Assert.assertNotNull((String)"should have found p1", p1);
        Assert.assertNotNull((String)"should have found g2", g2);
        Assert.assertFalse((String)"p1 should be inactive", (boolean)p1.isActive(new Timestamp(System.currentTimeMillis())));
        Assert.assertFalse((String)"g2 should be inactive", (boolean)g2.isActive(new Timestamp(System.currentTimeMillis())));
    }

    @Test
    public void testUpdateGroup() {
        Group group = this.createGroup();
        Group.Builder builder = Group.Builder.create((GroupContract)group);
        builder.setDescription("This is a new description.  It is useful.");
        this.groupService.updateGroup(group.getId(), builder.build());
        Group result = this.groupService.getGroupByNamespaceCodeAndName("KUALI", "gA");
        Assert.assertEquals((Object)group.isActive(), (Object)result.isActive());
        Assert.assertEquals((Object)group.getNamespaceCode(), (Object)result.getNamespaceCode());
        Assert.assertEquals((Object)group.getName(), (Object)result.getName());
        Assert.assertEquals((Object)group.getKimTypeId(), (Object)result.getKimTypeId());
        Assert.assertEquals((Object)builder.getDescription(), (Object)result.getDescription());
    }

    @Test
    public void testAddGroupToGroup() {
        Group group = this.createGroup();
        Assert.assertFalse((boolean)this.groupService.isGroupMemberOfGroup("g1", group.getId()));
        this.groupService.addGroupToGroup("g1", group.getId());
        this.groupService.isGroupMemberOfGroup("g1", group.getId());
    }

    @Test
    public void testAddPrincipalToGroup() {
        Group group = this.createGroup();
        Assert.assertFalse((boolean)this.groupService.isMemberOfGroup("p1", group.getId()));
        this.groupService.addPrincipalToGroup("p1", group.getId());
        this.groupService.isMemberOfGroup("p1", group.getId());
    }

    private List<GroupMemberBo> getActiveAndInactiveGroupTypeMembers(String groupId) {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("groupId", groupId);
        criteria.put("typeCode", KimConstants.KimGroupMemberTypes.GROUP_MEMBER_TYPE.getCode());
        return new ArrayList<GroupMemberBo>(KradDataServiceLocator.getDataObjectService().findMatching(GroupMemberBo.class, QueryByCriteria.Builder.andAttributes(criteria).build()).getResults());
    }

    private List<GroupMemberBo> getActiveAndInactivePrincipalTypeMembers(String groupId) {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("groupId", groupId);
        criteria.put("typeCode", KimConstants.KimGroupMemberTypes.PRINCIPAL_MEMBER_TYPE.getCode());
        return new ArrayList<GroupMemberBo>(KradDataServiceLocator.getDataObjectService().findMatching(GroupMemberBo.class, QueryByCriteria.Builder.andAttributes(criteria).build()).getResults());
    }

    private Group createGroup() {
        Group.Builder groupInfo = Group.Builder.create((String)"KUALI", (String)"gA", (String)"1");
        groupInfo.setActive(true);
        return this.groupService.createGroup(groupInfo.build());
    }
}

