/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.service.impl;

import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kim.api.identity.CodedAttribute;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.address.EntityAddressContract;
import org.kuali.rice.kim.api.identity.affiliation.EntityAffiliation;
import org.kuali.rice.kim.api.identity.affiliation.EntityAffiliationType;
import org.kuali.rice.kim.api.identity.email.EntityEmailContract;
import org.kuali.rice.kim.api.identity.employment.EntityEmploymentContract;
import org.kuali.rice.kim.api.identity.entity.Entity;
import org.kuali.rice.kim.api.identity.entity.EntityDefault;
import org.kuali.rice.kim.api.identity.name.EntityNameContract;
import org.kuali.rice.kim.api.identity.phone.EntityPhoneContract;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;
import org.kuali.rice.kim.api.identity.type.EntityTypeContactInfo;
import org.kuali.rice.kim.api.role.RoleMember;
import org.kuali.rice.kim.api.role.RoleMemberContract;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.bo.ui.KimDocumentRoleMember;
import org.kuali.rice.kim.bo.ui.PersonDocumentAddress;
import org.kuali.rice.kim.bo.ui.PersonDocumentAffiliation;
import org.kuali.rice.kim.bo.ui.PersonDocumentEmail;
import org.kuali.rice.kim.bo.ui.PersonDocumentEmploymentInfo;
import org.kuali.rice.kim.bo.ui.PersonDocumentName;
import org.kuali.rice.kim.bo.ui.PersonDocumentPhone;
import org.kuali.rice.kim.bo.ui.PersonDocumentPrivacy;
import org.kuali.rice.kim.bo.ui.PersonDocumentRole;
import org.kuali.rice.kim.document.IdentityManagementPersonDocument;
import org.kuali.rice.kim.document.IdentityManagementRoleDocument;
import org.kuali.rice.kim.impl.common.delegate.DelegateMemberBo;
import org.kuali.rice.kim.impl.identity.address.EntityAddressTypeBo;
import org.kuali.rice.kim.impl.identity.affiliation.EntityAffiliationTypeBo;
import org.kuali.rice.kim.impl.identity.email.EntityEmailTypeBo;
import org.kuali.rice.kim.impl.identity.name.EntityNameTypeBo;
import org.kuali.rice.kim.impl.identity.phone.EntityPhoneTypeBo;
import org.kuali.rice.kim.impl.identity.privacy.EntityPrivacyPreferencesBo;
import org.kuali.rice.kim.impl.role.RoleMemberBo;
import org.kuali.rice.kim.impl.type.KimTypeAttributeBo;
import org.kuali.rice.kim.impl.type.KimTypeBo;
import org.kuali.rice.kim.service.KIMServiceLocatorInternal;
import org.kuali.rice.kim.service.UiDocumentService;
import org.kuali.rice.kim.service.impl.UiDocumentServiceImpl;
import org.kuali.rice.kim.test.KIMTestCase;
import org.kuali.rice.kns.kim.type.DataDictionaryTypeServiceBase;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.ROLLBACK_CLEAR_DB)
public class UiDocumentServiceImplTest
extends KIMTestCase {
    private UiDocumentService uiDocumentService;
    static Person adminPerson = null;

    @BeforeClass
    public static void beforeClassSetup() {
        adminPerson = KimApiServiceLocator.getPersonService().getPersonByPrincipalName("admin");
    }

    public void setUp() throws Exception {
        super.setUp();
        this.uiDocumentService = KIMServiceLocatorInternal.getUiDocumentService();
    }

    protected EntityDefault createTestingEntity() {
        IdentityManagementPersonDocument personDoc = this.initPersonDoc();
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)adminPerson.getPrincipalId(), (String)"TestDocumentType");
        DocumentHeader documentHeader = new DocumentHeader();
        documentHeader.setWorkflowDocument(document);
        documentHeader.setDocumentNumber(document.getDocumentId());
        personDoc.setDocumentHeader(documentHeader);
        this.uiDocumentService.saveEntityPerson(personDoc);
        EntityDefault entity = KimApiServiceLocator.getIdentityService().getEntityDefault(personDoc.getEntityId());
        Assert.assertNotNull((String)("Entity was not saved: " + personDoc), (Object)entity);
        Assert.assertNotNull((String)"Principal list was null on retrieved record", (Object)entity.getPrincipals());
        Assert.assertEquals((String)"Principal list was incorrect length", (long)1L, (long)entity.getPrincipals().size());
        Assert.assertTrue((String)"Principal is not active on saved record", (boolean)((Principal)entity.getPrincipals().get(0)).isActive());
        return entity;
    }

    @Test
    public void testInactiveRoleMemberOnly() {
        KimType.Builder ktBuilder = KimType.Builder.create();
        ktBuilder.setId("1");
        ktBuilder.setNamespaceCode("KUALI");
        ktBuilder.setName("Default");
        Long version = new Long(1L);
        ktBuilder.setVersionNumber(version);
        KimType kt = ktBuilder.build();
        IdentityManagementRoleDocument identityManagementRoleDocument = new IdentityManagementRoleDocument();
        identityManagementRoleDocument.setKimType(kt);
        identityManagementRoleDocument.setRoleId("KRSAP10003");
        identityManagementRoleDocument.setRoleTypeId("1");
        identityManagementRoleDocument.setRoleName("Default");
        identityManagementRoleDocument.setRoleNamespace("KR_SAP");
        identityManagementRoleDocument.setRoleName("Sample App Admin");
        RoleMemberBo roleMemberBo = new RoleMemberBo();
        roleMemberBo.setId("KRSAP10003");
        roleMemberBo.setRoleId("KRSAP1003");
        roleMemberBo.setMemberId("dev1");
        roleMemberBo.setTypeCode("P");
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        roleMemberBo.setActiveToDateValue(timestamp);
        ArrayList<RoleMemberBo> roleMemberBos = new ArrayList<RoleMemberBo>();
        roleMemberBos.add(roleMemberBo);
        UiDocumentServiceImpl uiDocumentServiceImpl = new UiDocumentServiceImpl();
        List kimDocumentRoleMembers = uiDocumentServiceImpl.loadRoleMembers(identityManagementRoleDocument, roleMemberBos);
        Assert.assertEquals((String)"KimDocuemtnRoleMember size is incorrect", (long)0L, (long)kimDocumentRoleMembers.size());
    }

    @Test
    public void testInactivatePrincipal() {
        this.createTestingEntity();
        IdentityManagementPersonDocument personDoc = this.initPersonDoc();
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)adminPerson.getPrincipalId(), (String)"TestDocumentType");
        DocumentHeader documentHeader = new DocumentHeader();
        documentHeader.setWorkflowDocument(document);
        documentHeader.setDocumentNumber(document.getDocumentId());
        personDoc.setDocumentHeader(documentHeader);
        personDoc.setActive(false);
        this.uiDocumentService.saveEntityPerson(personDoc);
        EntityDefault entity = KimApiServiceLocator.getIdentityService().getEntityDefault(personDoc.getEntityId());
        Assert.assertNotNull((String)("Entity missing after inactivation: " + personDoc), (Object)entity);
        Assert.assertNotNull((String)"Principal list was null on retrieved record", (Object)entity.getPrincipals());
        Assert.assertEquals((String)"Principal list was incorrect length", (long)1L, (long)entity.getPrincipals().size());
        Assert.assertFalse((String)"Principal is active on saved record (after inactivation)", (boolean)((Principal)entity.getPrincipals().get(0)).isActive());
    }

    @Test
    public void testInactivatePrincipalDelegations() {
        EntityDefault entity = this.createTestingEntity();
        String delegateMemberId = UUID.randomUUID().toString();
        DelegateMemberBo delegateMemberBo = new DelegateMemberBo();
        delegateMemberBo.setMemberId(((Principal)entity.getPrincipals().get(0)).getPrincipalId());
        delegateMemberBo.setType(MemberType.PRINCIPAL);
        delegateMemberBo.setDelegationMemberId(delegateMemberId);
        KradDataServiceLocator.getDataObjectService().save((Object)delegateMemberBo, new PersistenceOption[]{PersistenceOption.FLUSH});
        delegateMemberBo = (DelegateMemberBo)KradDataServiceLocator.getDataObjectService().find(DelegateMemberBo.class, (Object)delegateMemberId);
        Assert.assertNotNull((String)"Unable to find delegate member bo", (Object)delegateMemberBo);
        Assert.assertTrue((String)"delegate member should be active", (boolean)delegateMemberBo.isActive());
        IdentityManagementPersonDocument personDoc = this.initPersonDoc();
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)adminPerson.getPrincipalId(), (String)"TestDocumentType");
        DocumentHeader documentHeader = new DocumentHeader();
        documentHeader.setWorkflowDocument(document);
        documentHeader.setDocumentNumber(document.getDocumentId());
        personDoc.setDocumentHeader(documentHeader);
        personDoc.setActive(false);
        this.uiDocumentService.saveEntityPerson(personDoc);
        delegateMemberBo = (DelegateMemberBo)KradDataServiceLocator.getDataObjectService().find(DelegateMemberBo.class, (Object)delegateMemberId);
        Assert.assertNotNull((String)"Unable to find delegate member bo", (Object)delegateMemberBo);
        Assert.assertFalse((String)("delegate member should be inactive: " + delegateMemberBo), (boolean)delegateMemberBo.isActive());
    }

    @Test
    public void testSaveToEntity() {
        Person adminPerson = KimApiServiceLocator.getPersonService().getPersonByPrincipalName("admin");
        IdentityManagementPersonDocument personDoc = this.initPersonDoc();
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)adminPerson.getPrincipalId(), (String)"TestDocumentType");
        DocumentHeader documentHeader = new DocumentHeader();
        documentHeader.setWorkflowDocument(document);
        documentHeader.setDocumentNumber(document.getDocumentId());
        personDoc.setDocumentHeader(documentHeader);
        this.uiDocumentService.saveEntityPerson(personDoc);
        Entity entity = KimApiServiceLocator.getIdentityService().getEntity(personDoc.getEntityId());
        EntityTypeContactInfo entityType = (EntityTypeContactInfo)entity.getEntityTypeContactInfos().get(0);
        personDoc.getExternalIdentifiers();
        this.assertAddressTrue((PersonDocumentAddress)personDoc.getAddrs().get(0), (EntityAddressContract)entityType.getAddresses().get(0));
        this.assertPhoneTrue((PersonDocumentPhone)personDoc.getPhones().get(0), (EntityPhoneContract)entityType.getPhoneNumbers().get(0));
        this.assertEmailTrue((PersonDocumentEmail)personDoc.getEmails().get(0), (EntityEmailContract)entityType.getEmailAddresses().get(0));
        this.assertNameTrue((PersonDocumentName)personDoc.getNames().get(0), (EntityNameContract)entity.getNames().get(0));
        this.assertPrincipalTrue(personDoc, (PrincipalContract)entity.getPrincipals().get(0));
        this.assertAffiliationTrue((PersonDocumentAffiliation)personDoc.getAffiliations().get(0), (EntityAffiliation)entity.getAffiliations().get(0));
        this.assertEmpInfoTrue((PersonDocumentEmploymentInfo)((PersonDocumentAffiliation)personDoc.getAffiliations().get(0)).getEmpInfos().get(0), (EntityEmploymentContract)entity.getEmploymentInformation().get(0));
        this.uiDocumentService.saveEntityPerson(personDoc);
        Entity entity2 = ((IdentityService)KIMServiceLocatorInternal.getService((String)"kimIdentityDelegateService")).getEntity(personDoc.getEntityId());
        EntityTypeContactInfo entityType2 = (EntityTypeContactInfo)entity2.getEntityTypeContactInfos().get(0);
        personDoc.getExternalIdentifiers();
        this.assertAddressTrue((PersonDocumentAddress)personDoc.getAddrs().get(0), (EntityAddressContract)entityType2.getAddresses().get(0));
        this.assertPhoneTrue((PersonDocumentPhone)personDoc.getPhones().get(0), (EntityPhoneContract)entityType2.getPhoneNumbers().get(0));
        this.assertEmailTrue((PersonDocumentEmail)personDoc.getEmails().get(0), (EntityEmailContract)entityType2.getEmailAddresses().get(0));
        this.assertNameTrue((PersonDocumentName)personDoc.getNames().get(0), (EntityNameContract)entity2.getNames().get(0));
        this.assertPrincipalTrue(personDoc, (PrincipalContract)entity2.getPrincipals().get(0));
    }

    @Test
    public void testLoadToPersonDocument() {
        Entity entity = KimApiServiceLocator.getIdentityService().getEntity("entity123eId");
        Assert.assertNotNull((Object)entity);
        IdentityManagementPersonDocument personDoc = new IdentityManagementPersonDocument();
        this.uiDocumentService.loadEntityToPersonDoc(personDoc, "entity123pId");
        EntityTypeContactInfo entityType = (EntityTypeContactInfo)entity.getEntityTypeContactInfos().get(0);
        personDoc.getExternalIdentifiers();
        this.assertAddressTrue((PersonDocumentAddress)personDoc.getAddrs().get(0), (EntityAddressContract)entityType.getAddresses().get(0));
        this.assertPhoneTrue((PersonDocumentPhone)personDoc.getPhones().get(0), (EntityPhoneContract)entityType.getPhoneNumbers().get(0));
        this.assertEmailTrue((PersonDocumentEmail)personDoc.getEmails().get(0), (EntityEmailContract)entityType.getEmailAddresses().get(0));
        this.assertNameTrue((PersonDocumentName)personDoc.getNames().get(0), (EntityNameContract)entity.getNames().get(0));
        this.assertAffiliationTrue((PersonDocumentAffiliation)personDoc.getAffiliations().get(0), (EntityAffiliation)entity.getAffiliations().get(0));
        this.assertEmpInfoTrue((PersonDocumentEmploymentInfo)((PersonDocumentAffiliation)personDoc.getAffiliations().get(0)).getEmpInfos().get(0), (EntityEmploymentContract)entity.getEmploymentInformation().get(0));
    }

    @Test
    public void testSetAttributeEntry() throws Exception {
        PersonDocumentRole personDocRole = this.initPersonDocRole();
        DataDictionaryTypeServiceBase kimTypeService = (DataDictionaryTypeServiceBase)KIMServiceLocatorInternal.getService((String)personDocRole.getKimRoleType().getServiceName());
        personDocRole.setDefinitions(kimTypeService.getAttributeDefinitions(personDocRole.getKimTypeId()));
        personDocRole.setAttributeEntry(this.uiDocumentService.getAttributeEntries(personDocRole.getDefinitions()));
        for (Object key : personDocRole.getAttributeEntry().keySet()) {
            Map value;
            if (key.equals("namespaceCode")) {
                value = (Map)personDocRole.getAttributeEntry().get(key);
                Assert.assertEquals((Object)"Parameter Namespace Code", value.get("label"));
                Assert.assertEquals((Object)"Nmspc Cd", value.get("shortLabel"));
                Assert.assertEquals((Object)new Integer(20), value.get("maxLength"));
                continue;
            }
            if (key.equals("campusCode")) {
                value = (Map)personDocRole.getAttributeEntry().get(key);
                Assert.assertEquals((Object)"Campus Code", value.get("label"));
                Assert.assertEquals((Object)"Campus Code", value.get("shortLabel"));
                Assert.assertEquals((Object)new Integer(2), value.get("maxLength"));
                continue;
            }
            Assert.assertFalse((String)("Should not have this key " + key), (boolean)true);
        }
    }

    private PersonDocumentRole initPersonDocRole() throws Exception {
        PersonDocumentRole docRole = new PersonDocumentRole();
        docRole.setKimTypeId("roleType1");
        docRole.setRoleId("r1");
        KimTypeBo kimType = new KimTypeBo();
        kimType.setId("roleType1");
        kimType.setServiceName("kimRoleTypeService");
        ArrayList<KimTypeAttributeBo> attributeDefinitions = new ArrayList<KimTypeAttributeBo>();
        KimTypeAttributeBo attr1 = (KimTypeAttributeBo)KradDataServiceLocator.getDataObjectService().find(KimTypeAttributeBo.class, (Object)"kimAttr3");
        attributeDefinitions.add(attr1);
        KimTypeAttributeBo attr2 = (KimTypeAttributeBo)KradDataServiceLocator.getDataObjectService().find(KimTypeAttributeBo.class, (Object)"kimAttr4");
        attributeDefinitions.add(attr2);
        kimType.setAttributeDefinitions(attributeDefinitions);
        Field fld = PersonDocumentRole.class.getDeclaredField("kimRoleType");
        fld.setAccessible(true);
        fld.set(docRole, kimType);
        return docRole;
    }

    private IdentityManagementPersonDocument initPersonDoc() {
        IdentityManagementPersonDocument personDoc = new IdentityManagementPersonDocument();
        personDoc.setEntityId("ent123");
        personDoc.setDocumentNumber("1");
        personDoc.setPrincipalId("pid123");
        personDoc.setPrincipalName("quickTest");
        personDoc.setAffiliations(this.initAffiliations());
        personDoc.setNames(this.initNames());
        personDoc.setAddrs(this.initAddresses());
        personDoc.setPhones(this.initPhones());
        personDoc.setEmails(this.initEmails());
        return personDoc;
    }

    private List<PersonDocumentName> initNames() {
        ArrayList<PersonDocumentName> docNames = new ArrayList<PersonDocumentName>();
        PersonDocumentName docName = new PersonDocumentName();
        docName.setEntityNameId("nameId123");
        docName.setNameCode("PRFR");
        docName.setEntityNameType(EntityNameTypeBo.from((CodedAttribute)KimApiServiceLocator.getIdentityService().getNameType("PRFR")));
        docName.setFirstName("John");
        docName.setLastName("Doe");
        docName.setMiddleName("M");
        docName.setNamePrefix("Mr");
        docName.setNameSuffix("Jr");
        docName.setActive(true);
        docName.setDflt(true);
        docNames.add(docName);
        return docNames;
    }

    private List<PersonDocumentAffiliation> initAffiliations() {
        ArrayList<PersonDocumentAffiliation> docAffiliations = new ArrayList<PersonDocumentAffiliation>();
        PersonDocumentAffiliation docAffiliation = new PersonDocumentAffiliation();
        docAffiliation.setAffiliationTypeCode("FCLTY");
        docAffiliation.setAffiliationType(EntityAffiliationTypeBo.from((EntityAffiliationType)KimApiServiceLocator.getIdentityService().getAffiliationType("FCLTY")));
        docAffiliation.setEntityAffiliationId("aflID123");
        docAffiliation.setCampusCode("BL");
        docAffiliation.setActive(true);
        docAffiliation.setDflt(true);
        docAffiliations.add(docAffiliation);
        ArrayList<PersonDocumentEmploymentInfo> docEmploymentInformations = new ArrayList<PersonDocumentEmploymentInfo>();
        PersonDocumentEmploymentInfo docEmpInfo = new PersonDocumentEmploymentInfo();
        docEmpInfo.setEmployeeId("12345");
        docEmpInfo.setEntityAffiliationId(docAffiliation.getEntityAffiliationId());
        docEmpInfo.setEntityEmploymentId("empId123");
        docEmpInfo.setEmploymentRecordId("1");
        docEmpInfo.setBaseSalaryAmount(new KualiDecimal(8000));
        docEmpInfo.setPrimaryDepartmentCode("BL-CHEM");
        docEmpInfo.setEmploymentStatusCode("A");
        docEmpInfo.setEmploymentTypeCode("P");
        docEmpInfo.setActive(true);
        docEmploymentInformations.add(docEmpInfo);
        docAffiliation.setEmpInfos(docEmploymentInformations);
        return docAffiliations;
    }

    private PersonDocumentPrivacy initPrivacyReferences(EntityPrivacyPreferencesBo privacyPreferences) {
        PersonDocumentPrivacy docPrivacy = new PersonDocumentPrivacy();
        docPrivacy.setSuppressAddress(true);
        docPrivacy.setSuppressEmail(false);
        docPrivacy.setSuppressName(false);
        docPrivacy.setSuppressPhone(false);
        docPrivacy.setSuppressPersonal(true);
        return docPrivacy;
    }

    private List<PersonDocumentPhone> initPhones() {
        ArrayList<PersonDocumentPhone> docPhones = new ArrayList<PersonDocumentPhone>();
        PersonDocumentPhone docPhone = new PersonDocumentPhone();
        docPhone.setPhoneTypeCode("HM");
        docPhone.setPhoneType(EntityPhoneTypeBo.from((CodedAttribute)KimApiServiceLocator.getIdentityService().getPhoneType("HM")));
        docPhone.setEntityPhoneId("phoneId123");
        docPhone.setEntityTypeCode("PERSON");
        docPhone.setPhoneNumber("123-45'6789");
        docPhone.setExtensionNumber("123");
        docPhone.setActive(true);
        docPhone.setDflt(true);
        docPhones.add(docPhone);
        return docPhones;
    }

    private List<PersonDocumentEmail> initEmails() {
        ArrayList<PersonDocumentEmail> emails = new ArrayList<PersonDocumentEmail>();
        PersonDocumentEmail docEmail = new PersonDocumentEmail();
        docEmail.setEntityEmailId("emailId123");
        docEmail.setEntityTypeCode("PERSON");
        docEmail.setEmailTypeCode("HM");
        docEmail.setEmailType(EntityEmailTypeBo.from((CodedAttribute)KimApiServiceLocator.getIdentityService().getEmailType("HM")));
        docEmail.setEmailAddress("test@abc.com");
        docEmail.setActive(true);
        docEmail.setDflt(true);
        emails.add(docEmail);
        return emails;
    }

    private List<PersonDocumentAddress> initAddresses() {
        ArrayList<PersonDocumentAddress> docAddresses = new ArrayList<PersonDocumentAddress>();
        PersonDocumentAddress docAddress = new PersonDocumentAddress();
        docAddress.setEntityTypeCode("PERSON");
        docAddress.setEntityAddressId("addrId123");
        docAddress.setAddressTypeCode("HM");
        docAddress.setAddressType(EntityAddressTypeBo.from((CodedAttribute)KimApiServiceLocator.getIdentityService().getAddressType("HM")));
        docAddress.setLine1("PO box 123");
        docAddress.setStateProvinceCode("IN");
        docAddress.setPostalCode("46123");
        docAddress.setCountryCode("US");
        docAddress.setCity("Indianapolis");
        docAddress.setActive(true);
        docAddress.setDflt(true);
        docAddresses.add(docAddress);
        return docAddresses;
    }

    private void assertPrincipalTrue(IdentityManagementPersonDocument personDoc, PrincipalContract principal) {
        Assert.assertEquals((Object)personDoc.getPrincipalId(), (Object)principal.getPrincipalId());
        Assert.assertEquals((Object)personDoc.getPrincipalName(), (Object)principal.getPrincipalName());
    }

    private void assertAddressTrue(PersonDocumentAddress docAddress, EntityAddressContract entityAddress) {
        Assert.assertEquals((Object)docAddress.getAddressTypeCode(), (Object)entityAddress.getAddressType().getCode());
        Assert.assertEquals((Object)docAddress.getCountryCode(), (Object)entityAddress.getCountryCode());
        Assert.assertEquals((Object)docAddress.getLine1(), (Object)entityAddress.getLine1());
        Assert.assertEquals((Object)docAddress.getCity(), (Object)entityAddress.getCity());
        Assert.assertEquals((Object)docAddress.getPostalCode(), (Object)entityAddress.getPostalCode());
        Assert.assertEquals((Object)docAddress.getStateProvinceCode(), (Object)entityAddress.getStateProvinceCode());
    }

    private void assertEmailTrue(PersonDocumentEmail docEmail, EntityEmailContract entityEmail) {
        Assert.assertEquals((Object)docEmail.getEntityEmailId(), (Object)entityEmail.getId());
        Assert.assertEquals((Object)docEmail.getEmailAddress(), (Object)entityEmail.getEmailAddressUnmasked());
        Assert.assertEquals((Object)docEmail.getEmailTypeCode(), (Object)entityEmail.getEmailType().getCode());
    }

    private void assertPhoneTrue(PersonDocumentPhone docPhone, EntityPhoneContract entityPhone) {
        Assert.assertEquals((Object)docPhone.getEntityPhoneId(), (Object)entityPhone.getId());
        Assert.assertEquals((Object)docPhone.getCountryCode(), (Object)entityPhone.getCountryCode());
        Assert.assertEquals((Object)docPhone.getPhoneNumber(), (Object)entityPhone.getPhoneNumber());
        Assert.assertEquals((Object)docPhone.getExtensionNumber(), (Object)entityPhone.getExtensionNumber());
        Assert.assertEquals((Object)docPhone.getPhoneTypeCode(), (Object)entityPhone.getPhoneType().getCode());
    }

    private void assertNameTrue(PersonDocumentName docName, EntityNameContract entityName) {
        Assert.assertEquals((Object)docName.getEntityNameId(), (Object)entityName.getId());
        Assert.assertEquals((Object)docName.getFirstName(), (Object)entityName.getFirstName());
        Assert.assertEquals((Object)docName.getLastName(), (Object)entityName.getLastName());
        Assert.assertEquals((Object)docName.getNameCode(), (Object)entityName.getNameType().getCode());
        Assert.assertEquals((Object)docName.getNameSuffix(), (Object)entityName.getNameSuffix());
        Assert.assertEquals((Object)docName.getNamePrefix(), (Object)entityName.getNamePrefix());
    }

    private void assertAffiliationTrue(PersonDocumentAffiliation docAffln, EntityAffiliation entityAffln) {
        Assert.assertEquals((Object)docAffln.getAffiliationTypeCode(), (Object)entityAffln.getAffiliationType().getCode());
        Assert.assertEquals((Object)docAffln.getCampusCode(), (Object)entityAffln.getCampusCode());
        Assert.assertEquals((Object)docAffln.getEntityAffiliationId(), (Object)entityAffln.getId());
    }

    private void assertEmpInfoTrue(PersonDocumentEmploymentInfo docEmpInfo, EntityEmploymentContract entityEmpInfo) {
        Assert.assertEquals((Object)docEmpInfo.getEmployeeId(), (Object)entityEmpInfo.getEmployeeId());
        Assert.assertEquals((Object)docEmpInfo.getEmploymentTypeCode(), (Object)entityEmpInfo.getEmployeeType().getCode());
        Assert.assertEquals((Object)docEmpInfo.getEmploymentStatusCode(), (Object)entityEmpInfo.getEmployeeStatus().getCode());
        Assert.assertEquals((Object)docEmpInfo.getEmploymentRecordId(), (Object)entityEmpInfo.getEmploymentRecordId());
        Assert.assertEquals((Object)docEmpInfo.getBaseSalaryAmount(), (Object)entityEmpInfo.getBaseSalaryAmount());
    }

    @Test
    public void test_KimDocumentRoleMember_copyProperties() {
        DateTimeFormatter FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
        String ROLE_MEMBER_ID = "1";
        String ROLE_ID = "23";
        HashMap ATTRIBUTES = new HashMap();
        String MEMBER_NAME = "WorkflowAdmin";
        String MEMBER_NAMESPACE_CODE = "KR-WKFLW";
        String MEMBER_ID = "1";
        MemberType MEMBER_TYPE = MemberType.GROUP;
        String ACTIVE_FROM_STRING = "2011-01-01 12:00:00";
        DateTime ACTIVE_FROM = new DateTime((Object)FORMATTER.parseDateTime(ACTIVE_FROM_STRING));
        String ACTIVE_TO_STRING = "2115-01-01 12:00:00";
        DateTime ACTIVE_TO = new DateTime((Object)FORMATTER.parseDateTime(ACTIVE_TO_STRING));
        String OBJ_ID = "123";
        long VER_NUM = 4L;
        KimDocumentRoleMember newKimDocumentRoleMember = new KimDocumentRoleMember();
        RoleMember rmc = RoleMember.Builder.create((String)ROLE_ID, (String)ROLE_MEMBER_ID, (String)MEMBER_ID, (MemberType)MEMBER_TYPE, (DateTime)ACTIVE_FROM, (DateTime)ACTIVE_TO, ATTRIBUTES, (String)MEMBER_NAME, (String)MEMBER_NAMESPACE_CODE).build();
        RoleMember rm = RoleMember.Builder.create((RoleMemberContract)rmc).build();
        RoleMemberBo roleMemberBo = RoleMemberBo.from((RoleMember)rm);
        roleMemberBo.setObjectId(OBJ_ID);
        roleMemberBo.setVersionNumber(Long.valueOf(VER_NUM));
        KimDocumentRoleMember.copyProperties((KimDocumentRoleMember)newKimDocumentRoleMember, (RoleMemberBo)roleMemberBo);
        Assert.assertTrue((String)("newKimDocumentRoleMember should have a roleId of " + ROLE_ID), (boolean)newKimDocumentRoleMember.getRoleId().equals(ROLE_ID));
        Assert.assertTrue((String)("newKimDocumentRoleMember should have a MemberId of " + MEMBER_ID), (boolean)newKimDocumentRoleMember.getMemberId().equals(MEMBER_ID));
        Assert.assertTrue((String)("newKimDocumentRoleMember should have a MemberName of " + MEMBER_NAME), (boolean)newKimDocumentRoleMember.getMemberName().equals(MEMBER_NAME));
        Assert.assertTrue((String)("newKimDocumentRoleMember should have a MemberNamespaceCode of " + MEMBER_NAMESPACE_CODE), (boolean)newKimDocumentRoleMember.getMemberNamespaceCode().equals(MEMBER_NAMESPACE_CODE));
        Assert.assertTrue((String)"newKimDocumentRoleMember should be active.", (boolean)newKimDocumentRoleMember.isActive());
        Assert.assertTrue((String)("newKimDocumentRoleMember should have a ActiveToDate of " + MEMBER_NAMESPACE_CODE), (boolean)newKimDocumentRoleMember.getActiveToDate().equals(roleMemberBo.getActiveToDateValue()));
        Assert.assertTrue((String)("newKimDocumentRoleMember should have a ActiveFromDate of " + ACTIVE_FROM_STRING), (boolean)newKimDocumentRoleMember.getActiveFromDate().equals(roleMemberBo.getActiveFromDateValue()));
        Assert.assertTrue((String)("newKimDocumentRoleMember should have a VersionNumber of " + VER_NUM), (boolean)newKimDocumentRoleMember.getVersionNumber().equals(VER_NUM));
        Assert.assertTrue((String)("newKimDocumentRoleMember should have a ObjectId of " + OBJ_ID), (boolean)newKimDocumentRoleMember.getObjectId().equals(OBJ_ID));
        Class<?> c = newKimDocumentRoleMember.getClass();
        Field[] fields = c.getDeclaredFields();
        List<Field> fieldsList = Arrays.asList(fields);
        int numberOfFieldsInKimDocumentRoleMember = 11;
        Assert.assertTrue((String)("KimDocumentRoleMember.copyProperties may need to be updated if the number of fieldsin KimDocumentRoleMember does not equal " + numberOfFieldsInKimDocumentRoleMember + ".  Size is " + fieldsList.size()), (fieldsList.size() == numberOfFieldsInKimDocumentRoleMember ? 1 : 0) != 0);
    }
}

