/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.test.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kim.api.identity.CodedAttribute;
import org.kuali.rice.kim.api.identity.CodedAttributeContract;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.affiliation.EntityAffiliation;
import org.kuali.rice.kim.api.identity.affiliation.EntityAffiliationType;
import org.kuali.rice.kim.api.identity.citizenship.EntityCitizenship;
import org.kuali.rice.kim.api.identity.employment.EntityEmployment;
import org.kuali.rice.kim.api.identity.entity.Entity;
import org.kuali.rice.kim.api.identity.entity.EntityContract;
import org.kuali.rice.kim.api.identity.external.EntityExternalIdentifier;
import org.kuali.rice.kim.api.identity.name.EntityName;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.identity.residency.EntityResidency;
import org.kuali.rice.kim.api.identity.type.EntityTypeContactInfo;
import org.kuali.rice.kim.api.identity.visa.EntityVisa;
import org.kuali.rice.kim.impl.identity.employment.EntityEmploymentBo;
import org.kuali.rice.kim.impl.identity.entity.EntityBo;
import org.kuali.rice.kim.service.KIMServiceLocatorInternal;
import org.kuali.rice.kim.test.KIMTestCase;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.NONE)
public class IdentityServiceImplTest
extends KIMTestCase {
    private IdentityService identityService;

    public void setUp() throws Exception {
        super.setUp();
        this.identityService = (IdentityService)KIMServiceLocatorInternal.getBean((String)"kimIdentityDelegateService");
    }

    @Test
    public void testGetPrincipal() {
        Principal principal = this.identityService.getPrincipal("KULUSER");
        Assert.assertNotNull((String)"principal must not be null", (Object)principal);
        Assert.assertEquals((String)"Principal name did not match expected result", (Object)"kuluser", (Object)principal.getPrincipalName());
    }

    @Test
    public void testGetPrincipalsByEntityId() {
        List principals = this.identityService.getPrincipalsByEntityId("1136");
        Assert.assertNotNull((String)"principal must not be null", (Object)principals);
        for (Principal principal : principals) {
            Assert.assertEquals((String)"Principal name did not match expected result", (Object)"kuluser", (Object)principal.getPrincipalName());
        }
    }

    @Test
    public void testGetPrincipalsByEntityIdInactive() {
        List principals = this.identityService.getPrincipalsByEntityId("1139");
        Assert.assertNotNull((String)"principal must not be null", (Object)principals);
        for (Principal principal : principals) {
            Assert.assertEquals((String)"Principal name did not match expected result", (Object)"inactiveusernm", (Object)principal.getPrincipalName());
        }
    }

    @Test
    public void testGetPrincipalsByEmployeeId() {
        List principals = this.identityService.getPrincipalsByEmployeeId("0000001138");
        Assert.assertNotNull((String)"principal must not be null", (Object)principals);
        for (Principal principal : principals) {
            Assert.assertEquals((String)"Principal name did not match expected result", (Object)"activeusernm", (Object)principal.getPrincipalName());
            Assert.assertEquals((String)"Entity Id did not match expected result", (Object)"1138", (Object)principal.getEntityId());
        }
    }

    @Test
    public void testGetPrincipalsByEmployeeIdInactive() {
        List principals = this.identityService.getPrincipalsByEmployeeId("0000001140");
        Assert.assertNotNull((String)"principal must not be null", (Object)principals);
        for (Principal principal : principals) {
            Assert.assertEquals((String)"Principal name did not match expected result", (Object)"inactiveempid", (Object)principal.getPrincipalName());
            Assert.assertEquals((String)"Entity Id did not match expected result", (Object)"1140", (Object)principal.getEntityId());
        }
    }

    @Test
    public void testGetPrincipalByPrincipalName() {
        Principal principal = this.identityService.getPrincipalByPrincipalName("kuluser");
        Assert.assertNotNull((String)"principal must not be null", (Object)principal);
        Assert.assertEquals((String)"Principal ID did not match expected result", (Object)"KULUSER", (Object)principal.getPrincipalId());
    }

    @Test
    public void testGetContainedAttributes() {
        Principal principal = this.identityService.getPrincipal("p1");
        Entity entity = this.identityService.getEntity(principal.getEntityId());
        Assert.assertNotNull((String)"Entity Must not be null", (Object)entity);
        EntityTypeContactInfo eet = entity.getEntityTypeContactInfoByTypeCode("PERSON");
        Assert.assertNotNull((String)"PERSON EntityEntityType Must not be null", (Object)eet);
        Assert.assertEquals((String)"there should be 1 email address", (long)1L, (long)eet.getEmailAddresses().size());
        Assert.assertEquals((String)"email address does not match", (Object)"p1@kuali.org", (Object)eet.getDefaultEmailAddress().getEmailAddressUnmasked());
    }

    @Test
    public void testCreateEntity() {
        Entity.Builder entity = Entity.Builder.create();
        entity.setActive(true);
        this.populateEntityForCreate(entity);
        Entity createdEntity = this.identityService.createEntity(entity.build());
        Entity entityFromDb = this.identityService.getEntity(createdEntity.getId());
        Assert.assertNotNull((String)"createdEntity must not be null", (Object)entityFromDb);
        List createdPrincipals = entityFromDb.getPrincipals();
        Assert.assertNotNull((String)"createdPrincipals must not be null", (Object)createdPrincipals);
        Assert.assertEquals((String)"There must be one principal", (long)1L, (long)createdPrincipals.size());
        for (Object principal : createdPrincipals) {
            Assert.assertNotNull((String)"principal entityId must not be null", (Object)principal.getEntityId());
            Assert.assertNotNull((String)"principal principalId must not be null", (Object)principal.getPrincipalId());
        }
        List createdNames = entityFromDb.getNames();
        Assert.assertNotNull((String)"createdNames must not be null", (Object)createdNames);
        Assert.assertEquals((String)"There must be one name", (long)1L, (long)createdNames.size());
        for (Object name : createdNames) {
            Assert.assertNotNull((String)"name entityId must not be null", (Object)name.getEntityId());
        }
        List entityExternalIdentifiers = entityFromDb.getExternalIdentifiers();
        Assert.assertNotNull((String)"entityExternalIdentifiers must not be null", (Object)entityExternalIdentifiers);
        Assert.assertEquals((String)"There must be one entityExternalIdentifier", (long)1L, (long)entityExternalIdentifiers.size());
        for (Object entityExternalIdentifier : entityExternalIdentifiers) {
            Assert.assertNotNull((String)"entityExternalIdentifier entityId must not be null", (Object)entityExternalIdentifier.getEntityId());
        }
        List createdEntityAffiliations = entityFromDb.getAffiliations();
        Assert.assertNotNull((String)"createdEntityAffiliations must not be null", (Object)createdEntityAffiliations);
        Assert.assertEquals((String)"There must be two createdEntityAffiliations", (long)2L, (long)createdEntityAffiliations.size());
        for (Object entityAffiliation : createdEntityAffiliations) {
            Assert.assertNotNull((String)"entityAffiliation entityId must not be null", (Object)entityAffiliation.getEntityId());
        }
        List createdEntityEmployments = entityFromDb.getEmploymentInformation();
        Assert.assertNotNull((String)"createdEntityEmployments must not be null", (Object)createdEntityEmployments);
        Assert.assertEquals((String)"There must be one createdEntityEmployment", (long)1L, (long)createdEntityEmployments.size());
        for (Object entityEmployment : createdEntityEmployments) {
            Assert.assertNotNull((String)"entityEmployment entityId must not be null", (Object)entityEmployment.getEntityId());
            EntityEmploymentBo entityEmploymentBo = EntityEmploymentBo.from((EntityEmployment)entityEmployment);
            Assert.assertNotNull((String)"entityEmploymentBo entityAffiliationId must not be null", (Object)entityEmploymentBo.getEntityAffiliationId());
            EntityAffiliation entityAffiliation = entityEmployment.getEntityAffiliation();
            Assert.assertNotNull((String)"entityAffiliation Id must not be null", (Object)entityAffiliation.getId());
            Assert.assertNotNull((String)"entityAffiliation entityId must not be null", (Object)entityAffiliation.getEntityId());
        }
        List createdEntityCitizenships = entityFromDb.getCitizenships();
        Assert.assertNotNull((String)"entityCitizenships must not be null", (Object)createdEntityCitizenships);
        Assert.assertEquals((String)"There must be 1 entityCitizenship", (long)1L, (long)createdEntityCitizenships.size());
        for (Object entityCitizenship : createdEntityCitizenships) {
            Assert.assertNotNull((String)"entityCitizenship entityId must not be null", (Object)entityCitizenship.getEntityId());
        }
        List createdEntityResidencies = entityFromDb.getResidencies();
        Assert.assertNotNull((String)"createdEntityResidencies must not be null", (Object)createdEntityResidencies);
        Assert.assertEquals((String)"There must be 1 createdEntityResidency", (long)1L, (long)createdEntityResidencies.size());
        for (Object entityResidency : createdEntityResidencies) {
            Assert.assertNotNull((String)"entityResidency entityId must not be null", (Object)entityResidency.getEntityId());
        }
        List createdEntityVisas = entityFromDb.getVisas();
        Assert.assertNotNull((String)"createdEntityVisas must not be null", (Object)createdEntityVisas);
        Assert.assertEquals((String)"There must be 1 createdEntityVisa", (long)1L, (long)createdEntityVisas.size());
        for (EntityVisa entityVisa : createdEntityVisas) {
            Assert.assertNotNull((String)"entityVisa entityId must not be null", (Object)entityVisa.getEntityId());
        }
        HashMap<String, Object> criteriaToAnd = new HashMap<String, Object>(3);
        criteriaToAnd.put("employmentInformation.employeeId", Arrays.asList("1234test", "xxxxtest", "zzzztest"));
        criteriaToAnd.put("employmentInformation.primaryDepartmentCode", Arrays.asList("BL-CHEM", "BL-ART", "BL-MY"));
        criteriaToAnd.put("active", Boolean.TRUE);
        QueryByCriteria finalCriteria = QueryByCriteria.Builder.andAttributes(criteriaToAnd).build();
        List results = KRADServiceLocator.getDataObjectService().findMatching(EntityBo.class, finalCriteria).getResults();
        Assert.assertTrue((results.size() == 1 ? 1 : 0) != 0);
        HashMap<String, Object> criteriaToAnd2 = new HashMap<String, Object>(3);
        criteriaToAnd2.put("employmentInformation.employeeId", Arrays.asList("1234test", "xxxxtest", "zzzztest"));
        criteriaToAnd2.put("affiliations.campusCode", Arrays.asList("BL", "MX", "UT"));
        criteriaToAnd2.put("active", Boolean.TRUE);
        QueryByCriteria finalCriteria2 = QueryByCriteria.Builder.andAttributes(criteriaToAnd2).build();
        List results2 = KRADServiceLocator.getDataObjectService().findMatching(EntityBo.class, finalCriteria2).getResults();
        Assert.assertTrue((results2.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testUpdateEntity() {
        Principal principal = this.identityService.getPrincipal("p1");
        Entity entity = this.identityService.getEntity(principal.getEntityId());
        Assert.assertNotNull((String)"Entity Must not be null", (Object)entity);
        Assert.assertEquals((String)"Entity should have 1 name", (long)1L, (long)entity.getNames().size());
        Entity.Builder builder = Entity.Builder.create((EntityContract)entity);
        List names = builder.getNames();
        names.add(this.getNewEntityName(entity.getId()));
        EntityAffiliation.Builder affiliationStdnt = EntityAffiliation.Builder.create();
        affiliationStdnt.setActive(true);
        affiliationStdnt.setCampusCode("MX");
        affiliationStdnt.setAffiliationType(EntityAffiliationType.Builder.create((String)"STDNT"));
        builder.getAffiliations().add(affiliationStdnt);
        EntityEmployment.Builder entityEmploymentBuilder = EntityEmployment.Builder.create();
        EntityAffiliation.Builder affiliationStaff = EntityAffiliation.Builder.create();
        affiliationStaff.setActive(true);
        affiliationStaff.setCampusCode("GR");
        affiliationStaff.setAffiliationType(EntityAffiliationType.Builder.create((String)"STAFF"));
        entityEmploymentBuilder.setEntityAffiliation(affiliationStaff);
        entityEmploymentBuilder.setActive(true);
        entityEmploymentBuilder.setEmployeeId("1234test");
        entityEmploymentBuilder.setPrimary(false);
        entityEmploymentBuilder.setBaseSalaryAmount(new KualiDecimal(8000));
        entityEmploymentBuilder.setPrimaryDepartmentCode("BL-CHEM");
        builder.getEmploymentInformation().add(entityEmploymentBuilder);
        entity = this.identityService.updateEntity(builder.build());
        entity = EntityBo.to((EntityBo)((EntityBo)KradDataServiceLocator.getDataObjectService().find(EntityBo.class, (Object)entity.getId())));
        Assert.assertNotNull((String)"Entity Must not be null", (Object)entity);
        Assert.assertEquals((String)"Entity should have 2 names", (long)2L, (long)entity.getNames().size());
        List createdEntityAffiliations = entity.getAffiliations();
        Assert.assertNotNull((String)"createdEntityAffiliations must not be null", (Object)createdEntityAffiliations);
        Assert.assertEquals((String)"There must be two createdEntityAffiliations", (long)2L, (long)createdEntityAffiliations.size());
        for (EntityAffiliation entityAffiliation : createdEntityAffiliations) {
            Assert.assertNotNull((String)"entityAffiliation entityId must not be null", (Object)entityAffiliation.getEntityId());
        }
        List createdEntityEmployments = entity.getEmploymentInformation();
        ArrayList entityEmploymentToRemove = new ArrayList();
        Assert.assertNotNull((String)"createdEntityEmployments must not be null", (Object)createdEntityEmployments);
        Assert.assertEquals((String)"There must be two createdEntityEmployments", (long)2L, (long)createdEntityEmployments.size());
        for (EntityEmployment entityEmployment : createdEntityEmployments) {
            Assert.assertNotNull((String)"entityEmployment entityId must not be null", (Object)entityEmployment.getEntityId());
            if (!entityEmployment.getEmployeeId().equalsIgnoreCase("1234test")) continue;
            EntityEmploymentBo entityEmploymentBo = EntityEmploymentBo.from((EntityEmployment)entityEmployment);
            Assert.assertNotNull((String)"entityEmploymentBo entityAffiliationId must not be null", (Object)entityEmploymentBo.getEntityAffiliationId());
            EntityAffiliation entityAffiliation = entityEmployment.getEntityAffiliation();
            Assert.assertNotNull((String)"entityAffiliation Id must not be null", (Object)entityAffiliation.getId());
            Assert.assertNotNull((String)"entityAffiliation entityId must not be null", (Object)entityAffiliation.getEntityId());
        }
        builder = Entity.Builder.create((EntityContract)entity);
        builder.setNames(Collections.singletonList(this.getNewEntityName(entity.getId())));
        entity = this.identityService.updateEntity(builder.build());
        Assert.assertNotNull((String)"Entity Must not be null", (Object)entity);
        Assert.assertEquals((String)"Entity should have 1 names", (long)1L, (long)entity.getNames().size());
    }

    private EntityName.Builder getNewEntityName(String entityId) {
        EntityName.Builder builder = EntityName.Builder.create();
        builder.setActive(true);
        builder.setDefaultValue(false);
        builder.setEntityId(entityId);
        builder.setFirstName("Bob");
        builder.setLastName("Bobbers");
        builder.setNamePrefix("Mr");
        CodedAttribute.Builder nameType = CodedAttribute.Builder.create((CodedAttributeContract)this.identityService.getNameType("PRM"));
        builder.setNameType(nameType);
        return builder;
    }

    private void populateEntityForCreate(Entity.Builder entityBuilder) {
        Principal.Builder principalBuilder = Principal.Builder.create((String)"tinMan");
        principalBuilder.setActive(true);
        ArrayList<Principal.Builder> principals = new ArrayList<Principal.Builder>();
        principals.add(principalBuilder);
        entityBuilder.setPrincipals(principals);
        EntityName.Builder nameBuilder = EntityName.Builder.create();
        nameBuilder.setFirstName("Nick");
        nameBuilder.setLastName("Chopper");
        nameBuilder.setDefaultValue(true);
        ArrayList<EntityName.Builder> entityNames = new ArrayList<EntityName.Builder>();
        entityNames.add(nameBuilder);
        entityBuilder.setNames(entityNames);
        EntityAffiliation.Builder affiliationStdnt = EntityAffiliation.Builder.create();
        affiliationStdnt.setActive(true);
        affiliationStdnt.setCampusCode("MX");
        affiliationStdnt.setAffiliationType(EntityAffiliationType.Builder.create((String)"STDNT"));
        ArrayList<EntityAffiliation.Builder> entityAffiliations = new ArrayList<EntityAffiliation.Builder>();
        entityAffiliations.add(affiliationStdnt);
        entityBuilder.setAffiliations(entityAffiliations);
        EntityEmployment.Builder entityEmploymentBuilder = EntityEmployment.Builder.create();
        EntityAffiliation.Builder affiliationStaff = EntityAffiliation.Builder.create();
        affiliationStaff.setActive(true);
        affiliationStaff.setCampusCode("GR");
        affiliationStaff.setAffiliationType(EntityAffiliationType.Builder.create((String)"STAFF"));
        entityEmploymentBuilder.setEntityAffiliation(affiliationStaff);
        entityEmploymentBuilder.setActive(true);
        entityEmploymentBuilder.setEmployeeId("1234test");
        entityEmploymentBuilder.setPrimary(true);
        entityEmploymentBuilder.setBaseSalaryAmount(new KualiDecimal(8000));
        entityEmploymentBuilder.setPrimaryDepartmentCode("BL-CHEM");
        ArrayList<EntityEmployment.Builder> entityEmployments = new ArrayList<EntityEmployment.Builder>();
        entityEmployments.add(entityEmploymentBuilder);
        entityBuilder.setEmploymentInformation(entityEmployments);
        EntityExternalIdentifier.Builder externalIdentifierBuilder = EntityExternalIdentifier.Builder.create();
        externalIdentifierBuilder.setExternalIdentifierTypeCode("SSN");
        externalIdentifierBuilder.setExternalId("444-44-4444");
        ArrayList<EntityExternalIdentifier.Builder> externalIdentifiers = new ArrayList<EntityExternalIdentifier.Builder>();
        externalIdentifiers.add(externalIdentifierBuilder);
        entityBuilder.setExternalIdentifiers(externalIdentifiers);
        EntityCitizenship.Builder citizenshipBuilder = EntityCitizenship.Builder.create();
        citizenshipBuilder.setCountryCode("OZ");
        citizenshipBuilder.setActive(true);
        ArrayList<EntityCitizenship.Builder> entityCitizenships = new ArrayList<EntityCitizenship.Builder>();
        entityCitizenships.add(citizenshipBuilder);
        entityBuilder.setCitizenships(entityCitizenships);
        EntityResidency.Builder residencyBuilder = EntityResidency.Builder.create();
        residencyBuilder.setDeterminationMethod("XXX");
        residencyBuilder.setInState("YYY");
        ArrayList<EntityResidency.Builder> entityResidencies = new ArrayList<EntityResidency.Builder>();
        entityResidencies.add(residencyBuilder);
        entityBuilder.setResidencies(entityResidencies);
        EntityVisa.Builder visaBuilder = EntityVisa.Builder.create();
        visaBuilder.setVisaId("1234");
        ArrayList<EntityVisa.Builder> entityVisas = new ArrayList<EntityVisa.Builder>();
        entityVisas.add(visaBuilder);
        entityBuilder.setVisas(entityVisas);
    }
}

