/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.test.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.role.RoleMembership;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.test.KIMTestCase;

public class AuthorizationServiceImplTest
extends KIMTestCase {
    private PermissionService permissionService;
    private RoleService roleService;
    private String principal1Id = "p1";
    private String principal2Id = "p2";
    private String principal3Id = "p3";
    private String group1Id = "g1";
    private String role1Id = "r1";
    private String role1NamespaceCode = "AUTH_SVC_TEST1";
    private String role1Description = "Role 1 Description";
    private String role1Name = "RoleOne";
    private String role2Id = "r2";
    private String role2NamespaceCode = "AUTH_SVC_TEST2";
    private String role2Description = "Role 2 Description";
    private String role2Name = "RoleTwo";
    private String permission1Name = "perm1";
    private String permission1NamespaceCode = "KR-NS";
    private String permission1Id = "p1";
    private String permission2Name = "perm2";
    private String permission2NamespaceCode = "KR-NS";
    private String permission2Id = "p2";
    private String permission3Name = "perm3";
    private String permission3NamespaceCode = "KR-NS";
    private String permission3Id = "p3";

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.permissionService = KimApiServiceLocator.getPermissionService();
        this.roleService = KimApiServiceLocator.getRoleService();
    }

    @Test
    public void testRoleMembership() {
        Role role = this.roleService.getRole(this.role2Id);
        Assert.assertNotNull((String)"r2 must exist", (Object)role);
        ArrayList<String> roleList = new ArrayList<String>(1);
        roleList.add(this.role2Id);
        Collection memberPrincipalIds = this.roleService.getRoleMemberPrincipalIds(this.role2NamespaceCode, this.role2Name, Collections.emptyMap());
        Assert.assertNotNull((Object)memberPrincipalIds);
        Assert.assertEquals((String)"RoleTwo should have 6 principal ids", (long)5L, (long)memberPrincipalIds.size());
        Assert.assertTrue((String)"p3 must belong to role", (boolean)memberPrincipalIds.contains(this.principal3Id));
        Assert.assertTrue((String)"p2 must belong to role (assigned via group)", (boolean)memberPrincipalIds.contains(this.principal2Id));
        Assert.assertTrue((String)"p1 must belong to r2 (via r1)", (boolean)memberPrincipalIds.contains(this.principal1Id));
        List members = this.roleService.getRoleMembers(roleList, Collections.emptyMap());
        Assert.assertNotNull((String)"returned list may not be null", (Object)members);
        Assert.assertFalse((String)"list must not be empty", (boolean)members.isEmpty());
        Assert.assertEquals((String)"Returned list must have 4 members.", (long)4L, (long)members.size());
        boolean foundP3 = false;
        boolean foundG1 = false;
        boolean foundR1 = false;
        for (RoleMembership member : members) {
            if (member.getMemberId().equals(this.principal3Id) && member.getType().equals((Object)MemberType.PRINCIPAL)) {
                foundP3 = true;
                continue;
            }
            if (member.getMemberId().equals(this.group1Id) && member.getType().equals((Object)MemberType.GROUP)) {
                foundG1 = true;
                continue;
            }
            if (!member.getMemberId().equals(this.principal1Id) || !member.getType().equals((Object)MemberType.PRINCIPAL)) continue;
            foundR1 = true;
            Assert.assertEquals((String)"Should have r1 embedded role id.", (Object)this.role1Id, (Object)member.getEmbeddedRoleId());
        }
        Assert.assertTrue((String)"Failed to find p3 principal member", (boolean)foundP3);
        Assert.assertTrue((String)"Failed to find g1 group member", (boolean)foundG1);
        Assert.assertTrue((String)"Failed to find r1 role member", (boolean)foundR1);
        role = this.roleService.getRole(this.role1Id);
        Assert.assertNotNull((String)"r1 must exist", (Object)role);
        roleList.clear();
        roleList.add(this.role1Id);
        members = this.roleService.getRoleMembers(roleList, Collections.emptyMap());
        Assert.assertNotNull((String)"returned list may not be null", (Object)members);
        Assert.assertEquals((String)"Should have 2 members", (long)2L, (long)members.size());
        Iterator iter = members.iterator();
        Assert.assertTrue((String)"One of those members should be p1.", (this.principal1Id.equals(((RoleMembership)iter.next()).getMemberId()) || this.principal1Id.equals(((RoleMembership)iter.next()).getMemberId()) ? 1 : 0) != 0);
    }

    @Test
    public void testHasPermission() {
        Assert.assertTrue((String)"p1 must have perm1 (via r1)", (boolean)this.permissionService.hasPermission("p1", "KR-NS", "perm1"));
        Assert.assertTrue((String)"p1 must have perm2 (via r1)", (boolean)this.permissionService.hasPermission("p1", "KR-NS", "perm2"));
        Assert.assertTrue((String)"p1 must have perm3 (via r2)", (boolean)this.permissionService.hasPermission("p1", "KR-NS", "perm3"));
        Assert.assertTrue((String)"p3 must have perm3 (via r2)", (boolean)this.permissionService.hasPermission("p3", "KR-NS", "perm3"));
        Assert.assertFalse((String)"p3 must not have perm1", (boolean)this.permissionService.hasPermission("p3", "KR-NS", "perm1"));
        Assert.assertFalse((String)"p3 must not have perm2", (boolean)this.permissionService.hasPermission("p3", "KR-NS", "perm2"));
    }
}

