/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.test.service;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.delegation.DelegationType;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kim.api.common.delegate.DelegateMember;
import org.kuali.rice.kim.api.common.delegate.DelegateMemberContract;
import org.kuali.rice.kim.api.common.delegate.DelegateType;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.role.RoleMember;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.api.type.KimTypeInfoService;
import org.kuali.rice.kim.test.KIMTestCase;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public class RoleServiceTest
extends KIMTestCase {
    private RoleService roleService;
    private KimTypeInfoService kimTypeInfoService;

    public void setUp() throws Exception {
        super.setUp();
        this.roleService = KimApiServiceLocator.getRoleService();
        this.kimTypeInfoService = KimApiServiceLocator.getKimTypeInfoService();
    }

    @Test
    public void testPrincipaHasRoleOfDirectAssignment() {
        ArrayList<String> roleIds = new ArrayList<String>();
        roleIds.add("r1");
        Assert.assertTrue((String)"p1 has direct role r1", (boolean)this.roleService.principalHasRole("p1", roleIds, Collections.emptyMap()));
        HashMap<String, String> qualification = new HashMap<String, String>();
        qualification.put("Attribute 2", "CHEM");
        Assert.assertTrue((String)"p1 has direct role r1 with rp2 attr data", (boolean)this.roleService.principalHasRole("p1", roleIds, qualification));
        qualification.clear();
        qualification.put("Attribute 3", "PHYS");
        Assert.assertTrue((String)"p1 has direct role r1 with rp2 attr data", (boolean)this.roleService.principalHasRole("p1", roleIds, (Map)Maps.newHashMap(qualification)));
    }

    @Test
    public void testPrincipalHasRoleOfHigherLevel() {
        ArrayList<String> roleIds = new ArrayList<String>();
        roleIds.add("r2");
        Assert.assertTrue((String)"p1 has assigned in higher level role r1", (boolean)this.roleService.principalHasRole("p1", roleIds, Collections.emptyMap()));
    }

    @Test
    public void testPrincipalHasRoleContainsGroupAssigned() {
        ArrayList<String> roleIds = new ArrayList<String>();
        roleIds.add("r2");
        Assert.assertTrue((String)"p2 is assigned to g1 and g1 assigned to r2", (boolean)this.roleService.principalHasRole("p2", roleIds, Collections.emptyMap()));
    }

    @Test
    public void testGetPrincipalsFromCircularRoles() {
        ArrayList<String> roleIds = new ArrayList<String>();
        roleIds.add("r101");
        Collection rolePrincipalIds = this.roleService.getRoleMemberPrincipalIds("ADDL_ROLES_TESTS", "Role A", Collections.emptyMap());
        Assert.assertNotNull((Object)rolePrincipalIds);
        Assert.assertEquals((String)"RoleTwo should have 6 principal ids", (long)5L, (long)rolePrincipalIds.size());
    }

    @Test
    public void testSwitchFromPrimaryToSecondaryDelegation() {
        KimType typeWithAttributes = this.kimTypeInfoService.findKimTypeByNameAndNamespace("TEST", "type-with-attributes");
        Assert.assertNotNull((Object)typeWithAttributes);
        String roleId = UUID.randomUUID().toString();
        Role.Builder roleBuilder = Role.Builder.create((String)roleId, (String)("testSwitchFromPrimaryToSecondaryDelegation" + roleId), (String)"TEST", (String)"test role", (String)typeWithAttributes.getId());
        Role role = this.roleService.createRole(roleBuilder.build());
        String roleMemberId = UUID.randomUUID().toString();
        RoleMember.Builder roleMemberBuilder = RoleMember.Builder.create((String)roleId, (String)roleMemberId, (String)"p10", (MemberType)MemberType.PRINCIPAL, null, null, null, null, null);
        RoleMember roleMember = this.roleService.createRoleMember(roleMemberBuilder.build());
        DelegateType.Builder delegateTypeBuilder = DelegateType.Builder.create((String)roleId, (DelegationType)DelegationType.PRIMARY, new ArrayList());
        delegateTypeBuilder.setKimTypeId(typeWithAttributes.getId());
        DelegateType primaryDelegateType = this.roleService.createDelegateType(delegateTypeBuilder.build());
        DelegateMember.Builder delegateMemberBuilder = DelegateMember.Builder.create();
        delegateMemberBuilder.setDelegationId(primaryDelegateType.getDelegationId());
        delegateMemberBuilder.setRoleMemberId(roleMember.getMemberId());
        delegateMemberBuilder.setType(MemberType.PRINCIPAL);
        delegateMemberBuilder.setMemberId("p9");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("attr1", "value1");
        attributes.put("attr2", "value2");
        delegateMemberBuilder.setAttributes(attributes);
        DelegateMember delegateMember = this.roleService.createDelegateMember(delegateMemberBuilder.build());
        Assert.assertNotNull((Object)delegateMember.getDelegationMemberId());
        Assert.assertEquals((long)1L, (long)this.roleService.getDelegationMembersByDelegationId(primaryDelegateType.getDelegationId()).size());
        DelegateMember originalMember = this.roleService.getDelegationMemberById(delegateMember.getDelegationMemberId());
        Assert.assertNotNull((Object)originalMember);
        Map originalMemberAttributes = originalMember.getAttributes();
        Assert.assertEquals((long)2L, (long)originalMemberAttributes.keySet().size());
        Assert.assertEquals((Object)"value1", originalMemberAttributes.get("attr1"));
        Assert.assertEquals((Object)"value2", originalMemberAttributes.get("attr2"));
        DelegateMember.Builder updatedMember = DelegateMember.Builder.create((DelegateMemberContract)originalMember);
        this.roleService.removeDelegateMembers(Collections.singletonList(originalMember));
        DelegateType.Builder delegateTypeBuilder2 = DelegateType.Builder.create((String)roleId, (DelegationType)DelegationType.SECONDARY, new ArrayList());
        delegateTypeBuilder2.setKimTypeId("1");
        DelegateType secondaryDelegateType = this.roleService.createDelegateType(delegateTypeBuilder2.build());
        DelegateMember.Builder newMember = DelegateMember.Builder.create();
        newMember.setDelegationId(secondaryDelegateType.getDelegationId());
        newMember.setMemberId(originalMember.getMemberId());
        newMember.setType(originalMember.getType());
        newMember.setRoleMemberId(originalMember.getRoleMemberId());
        newMember.setAttributes(originalMember.getAttributes());
        newMember.setActiveFromDate(originalMember.getActiveFromDate());
        newMember.setActiveToDate(originalMember.getActiveToDate());
        DelegateMember addedMember = this.roleService.createDelegateMember(newMember.build());
        DelegateType finalPrimaryDelegateType = this.roleService.getDelegateTypeByRoleIdAndDelegateTypeCode(roleId, DelegationType.PRIMARY);
        DelegateType finalSecondaryDelegateType = this.roleService.getDelegateTypeByRoleIdAndDelegateTypeCode(roleId, DelegationType.SECONDARY);
        Assert.assertEquals((long)1L, (long)finalPrimaryDelegateType.getMembers().size());
        Assert.assertEquals((long)1L, (long)finalSecondaryDelegateType.getMembers().size());
        DelegateMember finalPrimaryDelegationMember = (DelegateMember)finalPrimaryDelegateType.getMembers().get(0);
        Assert.assertFalse((boolean)finalPrimaryDelegationMember.isActive());
        DelegateMember finalSecondaryDelegationMember = (DelegateMember)finalSecondaryDelegateType.getMembers().get(0);
        Assert.assertEquals((Object)"p9", (Object)finalSecondaryDelegationMember.getMemberId());
        Assert.assertTrue((boolean)finalSecondaryDelegationMember.isActive());
        Map finalAttributes = finalSecondaryDelegationMember.getAttributes();
        Assert.assertEquals((long)2L, (long)finalAttributes.keySet().size());
        Assert.assertEquals((Object)"value1", finalAttributes.get("attr1"));
        Assert.assertEquals((Object)"value2", finalAttributes.get("attr2"));
    }
}

