/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kns.service.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kns.KNSTestCase;
import org.kuali.rice.kns.maintainable.AccountType2MaintainableImpl;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.authorization.PessimisticLock;
import org.kuali.rice.krad.maintenance.MaintenanceDocument;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.PessimisticLockService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.NONE)
public class PessimisticLockServiceTest
extends KNSTestCase {
    String sessionId = "ad4d6c83-4d0f-4309-a528-c2f81ec00395";

    public void setUp() throws Exception {
        super.setUp();
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
        GlobalVariables.getUserSession().setKualiSessionId(this.sessionId);
    }

    @Test
    public void testPessimisticLockingWithCustomMaintainableLockDescriptors() throws Exception {
        MaintenanceDocument maintDoc = (MaintenanceDocument)KRADServiceLocatorWeb.getDocumentService().getNewDocument("AccountType2MaintenanceDocument");
        Assert.assertTrue((String)"The AccountType2MaintenanceDocument should be using pessimistic locking", (boolean)KRADServiceLocatorWeb.getDataDictionaryService().getDataDictionary().getDocumentEntry(maintDoc.getNewMaintainableObject().getDataObjectClass().getSimpleName() + "MaintenanceDocument").getUsePessimisticLocking());
        Assert.assertTrue((String)"The AccountType2MaintenanceDocument should be using custom lock descriptors", (boolean)maintDoc.useCustomLockDescriptors());
        Assert.assertTrue((String)"The AccountType2MaintenanceDocument's new maintainable uses the wrong class", (boolean)(maintDoc.getNewMaintainableObject() instanceof AccountType2MaintainableImpl));
        AccountType2MaintainableImpl newMaint = (AccountType2MaintainableImpl)maintDoc.getNewMaintainableObject();
        Assert.assertTrue((String)"The AccountType2MaintainableImpl should be using custom lock descriptors", (boolean)newMaint.useCustomLockDescriptors());
        this.assertCustomLockDescriptorsAreWorking((Document)maintDoc, "acctType2MaintFieldsToEdit", (Serializable)((Object)"editCodeOnly"), (Serializable)((Object)"editNameOnly"));
    }

    private void assertCustomLockDescriptorsAreWorking(Document testDoc, String LOCK_KEY, Serializable LOCK_VALUE1, Serializable LOCK_VALUE2) throws Exception {
        PessimisticLockService lockService = KRADServiceLocatorWeb.getPessimisticLockService();
        UserSession quickstartSession = new UserSession("quickstart");
        Person[] allPersons = new Person[]{quickstartSession.getPerson(), null};
        HashMap<String, String> editMode = new HashMap<String, String>();
        editMode.put("fullEntry", "true");
        GlobalVariables.getUserSession().addObject(LOCK_KEY, (Object)LOCK_VALUE1);
        String[] allDescriptors = new String[]{testDoc.getCustomLockDescriptor(quickstartSession.getPerson()), null};
        Assert.assertNotNull((String)"The document should have generated a custom lock descriptor", (Object)allDescriptors[0]);
        Map finalModes = lockService.establishLocks(testDoc, editMode, quickstartSession.getPerson());
        this.assertCorrectLocksAreInPlace(true, finalModes, 1, testDoc.getPessimisticLocks(), allPersons, allDescriptors);
        editMode = new HashMap();
        editMode.put("fullEntry", "true");
        GlobalVariables.getUserSession().addObject(LOCK_KEY, (Object)LOCK_VALUE1);
        lockService.establishLocks(testDoc, editMode, quickstartSession.getPerson());
        this.assertCorrectLocksAreInPlace(false, null, 1, testDoc.getPessimisticLocks(), allPersons, allDescriptors);
        UserSession adminSession = new UserSession("admin");
        editMode = new HashMap();
        editMode.put("fullEntry", "true");
        GlobalVariables.getUserSession().addObject(LOCK_KEY, (Object)LOCK_VALUE1);
        Assert.assertEquals((String)"The document should have generated the same lock descriptors for both 'quickstart' and 'admin'", (Object)allDescriptors[0], (Object)testDoc.getCustomLockDescriptor(adminSession.getPerson()));
        finalModes = lockService.establishLocks(testDoc, editMode, adminSession.getPerson());
        this.assertCorrectLocksAreInPlace(false, finalModes, 1, testDoc.getPessimisticLocks(), allPersons, allDescriptors);
        allPersons[1] = adminSession.getPerson();
        editMode = new HashMap();
        editMode.put("fullEntry", "true");
        GlobalVariables.getUserSession().addObject(LOCK_KEY, (Object)LOCK_VALUE2);
        allDescriptors[1] = testDoc.getCustomLockDescriptor(adminSession.getPerson());
        Assert.assertNotNull((String)"The document should have generated a custom lock descriptor", (Object)allDescriptors[1]);
        Assert.assertNotSame((String)"'quickstart' and 'admin' should have different custom lock descriptors now", (Object)allDescriptors[0], (Object)allDescriptors[1]);
        finalModes = lockService.establishLocks(testDoc, editMode, adminSession.getPerson());
        this.assertCorrectLocksAreInPlace(true, finalModes, 2, testDoc.getPessimisticLocks(), allPersons, allDescriptors);
        editMode = new HashMap();
        editMode.put("fullEntry", "true");
        GlobalVariables.getUserSession().addObject(LOCK_KEY, (Object)LOCK_VALUE2);
        lockService.establishLocks(testDoc, editMode, quickstartSession.getPerson());
        this.assertCorrectLocksAreInPlace(false, null, 2, testDoc.getPessimisticLocks(), allPersons, allDescriptors);
        lockService.releaseAllLocksForUser(testDoc.getPessimisticLocks(), allPersons[1], allDescriptors[1]);
        testDoc.refreshPessimisticLocks();
        this.assertCorrectLocksAreInPlace(false, null, 1, testDoc.getPessimisticLocks(), allPersons, allDescriptors);
        allPersons[1] = allPersons[0];
        editMode = new HashMap();
        editMode.put("fullEntry", "true");
        GlobalVariables.getUserSession().addObject(LOCK_KEY, (Object)LOCK_VALUE2);
        finalModes = lockService.establishLocks(testDoc, editMode, quickstartSession.getPerson());
        this.assertCorrectLocksAreInPlace(true, finalModes, 2, testDoc.getPessimisticLocks(), allPersons, allDescriptors);
        GlobalVariables.getUserSession().removeObject(LOCK_KEY);
        lockService.releaseAllLocksForUser(testDoc.getPessimisticLocks(), allPersons[0]);
        testDoc.refreshPessimisticLocks();
        Assert.assertTrue((String)"There should not be any pessimistic locks present on the document", (boolean)testDoc.getPessimisticLocks().isEmpty());
    }

    private void assertCorrectLocksAreInPlace(boolean latestUserHasFullEntry, Map<?, ?> finalModes, int expectedLockQuantity, List<PessimisticLock> pessimisticLocks, Person[] expectedOwners, String[] expectedDescriptors) throws Exception {
        if (finalModes != null) {
            Assert.assertEquals((String)"The last user that tried to establish locks does not have the expected status on their full entry privileges", (Object)latestUserHasFullEntry, (Object)StringUtils.equalsIgnoreCase((String)"true", (String)((String)finalModes.get("fullEntry"))));
        }
        Assert.assertEquals((String)"The wrong number of pessimistic locks are in place", (long)expectedLockQuantity, (long)pessimisticLocks.size());
        for (int i = pessimisticLocks.size() - 1; i > -1; --i) {
            Assert.assertTrue((String)("The lock at index " + i + " did not have the expected owner of " + expectedOwners[i].getPrincipalName()), (boolean)pessimisticLocks.get(i).isOwnedByUser(expectedOwners[i]));
            if (expectedDescriptors == null) continue;
            Assert.assertTrue((String)("The lock at index " + i + " did not have the expected lock descriptor of " + expectedDescriptors[i]), (boolean)pessimisticLocks.get(i).getLockDescriptor().equals(expectedDescriptors[i]));
        }
    }
}

