/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kns.lookup;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.coreservice.impl.parameter.ParameterBo;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.impl.identity.PersonImpl;
import org.kuali.rice.kns.KNSTestCase;
import org.kuali.rice.kns.lookup.LookupResultsDDBo;
import org.kuali.rice.kns.lookup.LookupResultsService;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.bo.BusinessObject;

@Deprecated
public class LookupResultsServiceTest
extends KNSTestCase {
    public static final String MOCK_PARAMETER_NMSPC = "KR-NS";
    public static final String MOCK_PARAMETER_DETAIL_TYPE_CODE = "All";
    public static final String MOCK_PARAMETER_NAME = "DATE_TO_STRING_FORMAT_FOR_FILE_NAME";
    public static final String MOCK_PERSON = "quickstart";

    @Test
    public void testLookupIds() {
        HashMap<String, String> parameterPK = new HashMap<String, String>();
        parameterPK.put("namespaceCode", MOCK_PARAMETER_NMSPC);
        parameterPK.put("componentCode", MOCK_PARAMETER_DETAIL_TYPE_CODE);
        parameterPK.put("name", MOCK_PARAMETER_NAME);
        ParameterBo parameter = (ParameterBo)KNSServiceLocator.getBusinessObjectService().findByPrimaryKey(ParameterBo.class, parameterPK);
        Person person = KimApiServiceLocator.getPersonService().getPerson(MOCK_PERSON);
        LookupResultsDDBo ddBo = new LookupResultsDDBo("horse");
        LookupResultsService lookupResultsService = KNSServiceLocator.getLookupResultsService();
        Assert.assertEquals((String)"Parameter's lookup id should be its object id", (Object)parameter.getObjectId(), (Object)lookupResultsService.getLookupId((BusinessObject)parameter));
        Assert.assertNull((String)"Person's lookup id should be null", (Object)lookupResultsService.getLookupId((BusinessObject)person));
        Assert.assertEquals((String)"LookupResultsDDBo's lookup id should be a squashed PK String", (Object)"someValue-horse", (Object)lookupResultsService.getLookupId((BusinessObject)ddBo));
    }

    @Test
    public void testPersistableBusinessObjectSearch() throws Exception {
        HashMap<String, String> parameterPK = new HashMap<String, String>();
        parameterPK.put("namespaceCode", MOCK_PARAMETER_NMSPC);
        parameterPK.put("componentCode", MOCK_PARAMETER_DETAIL_TYPE_CODE);
        parameterPK.put("name", MOCK_PARAMETER_NAME);
        ParameterBo parameter = (ParameterBo)KNSServiceLocator.getBusinessObjectService().findByPrimaryKey(ParameterBo.class, parameterPK);
        LookupResultsService lookupResultsService = KNSServiceLocator.getLookupResultsService();
        HashSet<String> parameterIds = new HashSet<String>();
        parameterIds.add(lookupResultsService.getLookupId((BusinessObject)parameter));
        lookupResultsService.persistSelectedObjectIds("testPBOSearch", parameterIds, MOCK_PERSON);
        Collection retrievedParameters = lookupResultsService.retrieveSelectedResultBOs("testPBOSearch", ParameterBo.class, MOCK_PERSON);
        Assert.assertNotNull((String)"We have a collection of retrieved Parameters", (Object)retrievedParameters);
        Assert.assertEquals((String)"Retrieved parameters collection size is 1", (Object)new Integer(1), (Object)new Integer(retrievedParameters.size()));
        Iterator parameterIterator = retrievedParameters.iterator();
        ParameterBo retrievedParameter = (ParameterBo)parameterIterator.next();
        while (parameterIterator.hasNext()) {
            parameterIterator.next();
        }
        Assert.assertTrue((String)"Parameter was one which was saved", (retrievedParameter.getNamespaceCode().equals(MOCK_PARAMETER_NMSPC) && retrievedParameter.getComponentCode().equals(MOCK_PARAMETER_DETAIL_TYPE_CODE) && retrievedParameter.getName().equals(MOCK_PARAMETER_NAME) ? 1 : 0) != 0);
    }

    @Test
    public void testDataDictionaryBusinessObjectSearch() throws Exception {
        LookupResultsDDBo ddBo = new LookupResultsDDBo("gorilla");
        LookupResultsService lookupResultsService = KNSServiceLocator.getLookupResultsService();
        HashSet<String> ddBoIds = new HashSet<String>();
        ddBoIds.add(lookupResultsService.getLookupId((BusinessObject)ddBo));
        lookupResultsService.persistSelectedObjectIds("testDDBOSearch", ddBoIds, MOCK_PERSON);
        Collection retrievedDDBos = lookupResultsService.retrieveSelectedResultBOs("testDDBOSearch", LookupResultsDDBo.class, MOCK_PERSON);
        Assert.assertNotNull((String)"We have a collection of retrieved Parameters", (Object)retrievedDDBos);
        Assert.assertEquals((String)"Retrieved parameters collection size is 1", (Object)new Integer(1), (Object)new Integer(retrievedDDBos.size()));
        Iterator ddBosIterator = retrievedDDBos.iterator();
        LookupResultsDDBo retrievedDDBo = (LookupResultsDDBo)((Object)ddBosIterator.next());
        while (ddBosIterator.hasNext()) {
            ddBosIterator.next();
        }
        Assert.assertEquals((String)"LookupResultsDDBo lookup worked as expected", (Object)"gorilla", (Object)retrievedDDBo.getSomeValue());
    }

    @Test
    public void testBadSearch() {
        boolean threwException = false;
        LookupResultsService lookupResultsService = KNSServiceLocator.getLookupResultsService();
        try {
            lookupResultsService.retrieveSelectedResultBOs("test data2", PersonImpl.class, MOCK_PERSON);
        }
        catch (RuntimeException re) {
            threwException = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Assert.assertTrue((String)"Exception should have been thrown", (boolean)threwException);
    }
}

