/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.mo.common.GloballyUnique;
import org.kuali.rice.krad.bo.Attachment;
import org.kuali.rice.krad.bo.Note;
import org.kuali.rice.krad.service.AttachmentService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.test.KRADTestCase;

public class AmazonS3AttachmentServiceTest
extends KRADTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSaveAndDeleteAttachments() throws Exception {
        AttachmentService attachmentService = KRADServiceLocator.getAttachmentService();
        File file = null;
        try {
            GloballyUnique gu = new GloballyUnique(){
                private final String id = UUID.randomUUID().toString();

                public String getObjectId() {
                    return this.id;
                }
            };
            file = File.createTempFile("file", "txt");
            FileWriter writer = new FileWriter(file);
            String fileContent = "This is the file text";
            writer.write(fileContent);
            writer.close();
            FileInputStream fileInputStream = new FileInputStream(file);
            Note note = new Note();
            Attachment attachment = attachmentService.createAttachment(gu, file.getName(), "plain/text", (int)file.length(), (InputStream)fileInputStream, "F");
            attachment.setNote(note);
            Assert.assertEquals((Object)file.getName(), (Object)attachment.getAttachmentFileName());
            Assert.assertEquals((Object)"plain/text", (Object)attachment.getAttachmentMimeTypeCode());
            Assert.assertEquals((long)file.length(), (long)attachment.getAttachmentFileSize());
            Assert.assertNotNull((Object)attachment.getAttachmentIdentifier());
            InputStream is = attachmentService.retrieveAttachmentContents(attachment);
            InputStreamReader reader = new InputStreamReader(is);
            char[] cbuf = new char[fileContent.length()];
            reader.read(cbuf, 0, fileContent.length());
            Assert.assertEquals((Object)fileContent, (Object)new String(cbuf));
            reader.close();
            attachmentService.deleteAttachmentContents(attachment);
            try {
                attachmentService.retrieveAttachmentContents(attachment);
                Assert.fail((String)"Should have received an exception when attempting to retrieve attachment contents of a deleted attachment");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            file.delete();
        }
    }
}

