/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation.charlevel;

import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kns.datadictionary.validation.charlevel.CharsetValidationPattern;
import org.kuali.rice.test.BaseRiceTestCase;

public class CharsetValidationPatternTest
extends BaseRiceTestCase {
    private CharsetValidationPattern charsetPattern;

    public void setUp() throws Exception {
        this.charsetPattern = new CharsetValidationPattern();
    }

    @Test
    public final void testSetBoth_AB() {
        boolean failedAsExpected = false;
        try {
            this.charsetPattern.setMaxLength(5);
            this.charsetPattern.setExactLength(5);
        }
        catch (IllegalStateException e) {
            failedAsExpected = true;
        }
        Assert.assertTrue((boolean)failedAsExpected);
    }

    @Test
    public final void testSetBoth_BA() {
        boolean failedAsExpected = false;
        try {
            this.charsetPattern.setExactLength(5);
            this.charsetPattern.setMaxLength(5);
        }
        catch (IllegalStateException e) {
            failedAsExpected = true;
        }
        Assert.assertTrue((boolean)failedAsExpected);
    }

    @Test
    public final void testMatch_exactLength1() {
        this.charsetPattern.setExactLength(3);
        this.charsetPattern.setValidChars("abc");
        Assert.assertFalse((boolean)this.charsetPattern.matches("aaaa"));
    }

    @Test
    public final void testMatch_exactLength2() {
        this.charsetPattern.setExactLength(3);
        this.charsetPattern.setValidChars("abc");
        Assert.assertFalse((boolean)this.charsetPattern.matches("aa"));
    }

    @Test
    public final void testMatch_exactLength3() {
        this.charsetPattern.setExactLength(3);
        this.charsetPattern.setValidChars("abc");
        Assert.assertTrue((boolean)this.charsetPattern.matches("aaa"));
    }

    @Test
    public final void testMatch_maxLength1() {
        this.charsetPattern.setMaxLength(3);
        this.charsetPattern.setValidChars("abc");
        Assert.assertFalse((boolean)this.charsetPattern.matches("aaaa"));
    }

    @Test
    public final void testMatch_maxLength2() {
        this.charsetPattern.setMaxLength(3);
        this.charsetPattern.setValidChars("abc");
        Assert.assertTrue((boolean)this.charsetPattern.matches("aa"));
    }

    @Test
    public final void testMatch_maxLength3() {
        this.charsetPattern.setMaxLength(3);
        this.charsetPattern.setValidChars("abc");
        Assert.assertTrue((boolean)this.charsetPattern.matches("aaa"));
    }

    @Test
    public final void testSetValidChars_emptyString() {
        boolean failedAsExpected = false;
        try {
            this.charsetPattern.setValidChars("");
        }
        catch (IllegalArgumentException e) {
            failedAsExpected = true;
        }
        Assert.assertTrue((boolean)failedAsExpected);
    }

    @Test
    public final void testMatch_trailingSlash1() {
        this.charsetPattern.setValidChars("abcd\\");
        Assert.assertTrue((boolean)this.charsetPattern.matches("a"));
    }

    @Test
    public final void testMatch_trailingSlash2() {
        this.charsetPattern.setValidChars("abcd\\");
        Assert.assertTrue((boolean)this.charsetPattern.matches("c"));
    }

    @Test
    public final void testMatch_trailingSlash3() {
        this.charsetPattern.setValidChars("abcd\\");
        Assert.assertTrue((boolean)this.charsetPattern.matches("\\"));
    }

    @Test
    public final void testMatch_pseudoSet1() {
        this.charsetPattern.setValidChars("[A-Z]");
        Assert.assertTrue((boolean)this.charsetPattern.matches("A"));
    }

    @Test
    public final void testMatch_pseudoSet2() {
        this.charsetPattern.setValidChars("[A-Z]");
        Assert.assertTrue((boolean)this.charsetPattern.matches("Z"));
    }

    @Test
    public final void testMatch_pseudoSet3() {
        this.charsetPattern.setValidChars("[A-Z]");
        Assert.assertTrue((boolean)this.charsetPattern.matches("-"));
    }

    @Test
    public final void testMatch_pseudoSet4() {
        this.charsetPattern.setValidChars("[A-Z]");
        Assert.assertTrue((boolean)this.charsetPattern.matches("["));
    }

    @Test
    public final void testMatch_pseudoSet5() {
        this.charsetPattern.setValidChars("[A-Z]");
        Assert.assertFalse((boolean)this.charsetPattern.matches("C"));
    }

    @Test
    public final void testMatch_partialPseudoSet1() {
        this.charsetPattern.setValidChars("[ABC");
        Assert.assertTrue((boolean)this.charsetPattern.matches("A"));
    }

    @Test
    public final void testMatch_partialPseudoSet2() {
        this.charsetPattern.setValidChars("[ABC");
        Assert.assertFalse((boolean)this.charsetPattern.matches("Z"));
    }

    @Test
    public final void testMatch_pseudoSetTrailingSlash1() {
        this.charsetPattern.setValidChars("[A-Z]\\");
        Assert.assertTrue((boolean)this.charsetPattern.matches("A"));
    }

    @Test
    public final void testMatch_pseudoSetTrailingSlash2() {
        this.charsetPattern.setValidChars("[A-Z]\\");
        Assert.assertTrue((boolean)this.charsetPattern.matches("Z"));
    }

    @Test
    public final void testMatch_pseudoSetTrailingSlash3() {
        this.charsetPattern.setValidChars("[A-Z]\\");
        Assert.assertTrue((boolean)this.charsetPattern.matches("-"));
    }

    @Test
    public final void testMatch_pseudoSetTrailingSlash4() {
        this.charsetPattern.setValidChars("[A-Z]\\");
        Assert.assertTrue((boolean)this.charsetPattern.matches("["));
    }

    @Test
    public final void testMatch_pseudoSetTrailingSlash5() {
        this.charsetPattern.setValidChars("[A-Z]\\");
        Assert.assertFalse((boolean)this.charsetPattern.matches("C"));
    }

    @Test
    public final void testMatch_pseudoCapture1() {
        this.charsetPattern.setValidChars("(ABC)");
        Assert.assertTrue((boolean)this.charsetPattern.matches("("));
    }

    @Test
    public final void testMatch_pseudoCapture2() {
        this.charsetPattern.setValidChars("(ABC)");
        Assert.assertTrue((boolean)this.charsetPattern.matches(")"));
    }

    @Test
    public final void testMatch_pseudoCapture3() {
        this.charsetPattern.setValidChars("(ABC)");
        Assert.assertTrue((boolean)this.charsetPattern.matches("B"));
    }

    @Test
    public final void testMatch_pseudoRange1() {
        this.charsetPattern.setValidChars("A-Z");
        Assert.assertTrue((boolean)this.charsetPattern.matches("A"));
    }

    @Test
    public final void testMatch_pseudoRange2() {
        this.charsetPattern.setValidChars("A-Z");
        Assert.assertTrue((boolean)this.charsetPattern.matches("-"));
    }

    @Test
    public final void testMatch_pseudoRange3() {
        this.charsetPattern.setValidChars("A-Z");
        Assert.assertFalse((boolean)this.charsetPattern.matches("B"));
    }

    @Test
    public final void testMatch_pseudoIntersection1() {
        this.charsetPattern.setValidChars("A&&Z");
        Assert.assertTrue((boolean)this.charsetPattern.matches("A"));
    }

    @Test
    public final void testMatch_pseudoIntersection2() {
        this.charsetPattern.setValidChars("A&&Z");
        Assert.assertTrue((boolean)this.charsetPattern.matches("&"));
    }

    @Test
    public final void testMatch_pseudoIntersection3() {
        this.charsetPattern.setValidChars("A&&Z");
        Assert.assertTrue((boolean)this.charsetPattern.matches("Z"));
    }
}

