/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.kim.api.common.template.Template;
import org.kuali.rice.kim.api.permission.Permission;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.impl.common.attribute.KimAttributeDataBo;
import org.kuali.rice.kim.impl.permission.PermissionAttributeBo;
import org.kuali.rice.kim.impl.permission.PermissionBo;
import org.kuali.rice.kim.impl.permission.PermissionTemplateBo;
import org.kuali.rice.krad.kim.NamespaceWildcardAllowedAndOrStringExactMatchPermissionTypeServiceImpl;
import org.kuali.rice.krad.test.KRADTestCase;

public class NamespaceWildcardAllowedAndOrStringExactMatchPermissionTypeServiceImplTest
extends KRADTestCase {
    static final String INGESTER_ACTION = "org.kuali.rice.core.web.impex.IngesterAction";
    NamespaceWildcardAllowedAndOrStringExactMatchPermissionTypeServiceImpl permissionService;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.permissionService = new NamespaceWildcardAllowedAndOrStringExactMatchPermissionTypeServiceImpl(){

            protected boolean isCheckRequiredAttributes() {
                return true;
            }
        };
        this.permissionService.setExactMatchStringAttributeName("actionClass");
        this.permissionService.setNamespaceRequiredOnStoredMap(false);
    }

    @Test
    public void testIngesterPermissionExampleLikeRice() {
        Map<String, String> requestedDetails = this.getUseIngesterRequestedDetails();
        ArrayList<PermissionBo> permissionsList = new ArrayList<PermissionBo>();
        Template template = KimApiServiceLocator.getPermissionService().findPermTemplateByNamespaceCodeAndName("KR-NS", "Use Screen");
        permissionsList.add(this.createPermission(template, "Use All Screens", "KR-SYS", "namespaceCode=KR*"));
        PermissionBo exactMatch = this.createPermission(template, "Use Ingester Screen", "KR-WKFLW", "actionClass=org.kuali.rice.core.web.impex.IngesterAction", "namespaceCode=KR-WKFLW");
        permissionsList.add(exactMatch);
        ArrayList<Permission> immutablePermissionList = new ArrayList<Permission>();
        for (PermissionBo bo : permissionsList) {
            immutablePermissionList.add(PermissionBo.to((PermissionBo)bo));
        }
        List returnedPermissions = this.permissionService.getMatchingPermissions(requestedDetails, immutablePermissionList);
        Assert.assertTrue((returnedPermissions.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((Permission)returnedPermissions.get(0)).equals((Object)PermissionBo.to((PermissionBo)exactMatch)));
    }

    @Test
    public void testIngesterPermissionExampleLikeKFS() {
        Map<String, String> requestedDetails = this.getUseIngesterRequestedDetails();
        ArrayList<PermissionBo> permissionsList = new ArrayList<PermissionBo>();
        Template template = KimApiServiceLocator.getPermissionService().findPermTemplateByNamespaceCodeAndName("KR-NS", "Use Screen");
        permissionsList.add(this.createPermission(template, "Use Screen", "KR-SYS", "namespaceCode=KR*"));
        PermissionBo exactMatch = this.createPermission(template, "Use Screen", "KR-WKFLW", "actionClass=org.kuali.rice.core.web.impex.IngesterAction");
        permissionsList.add(exactMatch);
        ArrayList<Permission> immutablePermissionList = new ArrayList<Permission>();
        for (PermissionBo bo : permissionsList) {
            immutablePermissionList.add(PermissionBo.to((PermissionBo)bo));
        }
        List returnedPermissions = this.permissionService.getMatchingPermissions(requestedDetails, immutablePermissionList);
        Assert.assertTrue((returnedPermissions.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((Permission)returnedPermissions.get(0)).equals((Object)PermissionBo.to((PermissionBo)exactMatch)));
    }

    private Map<String, String> getUseIngesterRequestedDetails() {
        HashMap<String, String> requestedDetails = new HashMap<String, String>();
        requestedDetails.put("actionClass", INGESTER_ACTION);
        requestedDetails.put("namespaceCode", "KR-WKFLW");
        return requestedDetails;
    }

    private PermissionBo createPermission(Template permissionTemplate, String name, String namespace, String ... attrs) {
        PermissionBo perm = new PermissionBo();
        perm.setName(name);
        perm.setNamespaceCode(namespace);
        perm.setTemplate(PermissionTemplateBo.from((Template)permissionTemplate));
        perm.setTemplateId(permissionTemplate.getId());
        HashMap<String, String> permissionDetails = new HashMap<String, String>();
        for (String attr : attrs) {
            String[] splitAttr = attr.split("=", 2);
            permissionDetails.put(splitAttr[0], splitAttr[1]);
        }
        List attrBos = KimAttributeDataBo.createFrom(PermissionAttributeBo.class, permissionDetails, (String)perm.getTemplate().getKimTypeId());
        perm.setAttributeDetails(attrBos);
        return perm;
    }
}

