/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif;

import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.krad.test.KRADTestCase;
import org.kuali.rice.krad.test.TestDictionaryBean;
import org.kuali.rice.krad.test.TestDictionaryConfig;
import org.kuali.rice.krad.uif.field.InputField;

@TestDictionaryConfig(namespaceCode="KR-NS", dataDictionaryFiles="classpath:org/kuali/rice/krad/uif/UifBeanFactoryPostProcessorTestBeans.xml")
public class UifBeanFactoryPostProcessorTest
extends KRADTestCase {
    @Test
    public void testOverrideOfNestedBeanExpression() throws Exception {
        InputField inputField = (InputField)this.getTestDictionaryObject("testNestedExpressionOverride2");
        Assert.assertNotNull((String)"No bean exists with id: testNestedExpressionOverride2", (Object)inputField);
        Assert.assertNotNull((String)"Expression not in graph", inputField.getExpressionGraph().get("inquiry.render"));
        inputField = (InputField)this.getTestDictionaryObject("testNestedExpressionOverride3");
        Assert.assertNotNull((String)"No bean exists with id: testNestedExpressionOverride3", (Object)inputField);
        Assert.assertTrue((String)"Child property did not override", (boolean)inputField.getInquiry().isRender());
        Assert.assertNull((String)"Parent nested bean expression still in expression graph", inputField.getExpressionGraph().get("inquiry.render"));
        TestDictionaryBean testBean = (TestDictionaryBean)((Object)this.getTestDictionaryObject("testNestedExpressionOverride5"));
        Assert.assertNotNull((String)"No bean exists with id: testNestedExpressionOverride5", (Object)((Object)testBean));
        Assert.assertEquals((String)"Child property did not override", (Object)"old school", (Object)testBean.getReference1().getReference1().getProperty1());
        Assert.assertNull((String)"Parent nested bean expression still in expression graph", testBean.getExpressionGraph().get("reference1.reference1.property1"));
    }

    @Test
    public void testMergingOfMapExpressions() throws Exception {
        TestDictionaryBean testBean = (TestDictionaryBean)((Object)this.getTestDictionaryObject("testExpressionMapMerging2"));
        Assert.assertNotNull((String)"No bean exists with id: testExpressionMapMerging2", (Object)((Object)testBean));
        Assert.assertTrue((String)"Merged map is not correct size (2)", (testBean.getMap1().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Merged map does not contain key2", (boolean)testBean.getMap1().containsKey("key2"));
        Assert.assertTrue((String)"Merged map does not contain key3)", (boolean)testBean.getMap1().containsKey("key3"));
        Assert.assertTrue((String)"Expression count not correct for merged map", (testBean.getExpressionGraph().size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Bean does not contain expression for property key1", (Object)"@{expr1}", testBean.getExpressionGraph().get("map1['key1']"));
        Assert.assertEquals((String)"Bean does not contain expression for property key4", (Object)"@{expr4}", testBean.getExpressionGraph().get("map1['key4']"));
    }

    @Test
    public void testNonMergingOfMapExpressions() throws Exception {
        TestDictionaryBean testBean = (TestDictionaryBean)((Object)this.getTestDictionaryObject("testExpressionMapNonMerging"));
        Assert.assertNotNull((String)"No bean exists with id: testExpressionMapNonMerging", (Object)((Object)testBean));
        Assert.assertTrue((String)"Non-Merged map is not correct size (1)", (testBean.getMap1().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Non-Merged map does not contain key3)", (boolean)testBean.getMap1().containsKey("key3"));
        Assert.assertTrue((String)"Expression count not correct for non-merged map", (testBean.getExpressionGraph().size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Bean does not contain expression for property key4", (Object)"@{expr4}", testBean.getExpressionGraph().get("map1['key4']"));
    }

    public void testNestedListExpressions() throws Exception {
        TestDictionaryBean testBean = (TestDictionaryBean)((Object)this.getTestDictionaryObject("testListBeanExpressionMerging"));
        Assert.assertNotNull((String)"No bean exists with id: testListBeanExpressionMerging", (Object)((Object)testBean));
        Map<String, String> mergedMap = testBean.getListReference1().get(0).getReference1().getMap1();
        Assert.assertTrue((String)"Merged map is not correct size (2)", (mergedMap.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Merged map does not contain key2", (boolean)mergedMap.containsKey("key2"));
        Assert.assertTrue((String)"Merged map does not contain key3)", (boolean)mergedMap.containsKey("key3"));
        TestDictionaryBean rootListBean = testBean.getListReference1().get(0);
        Assert.assertTrue((String)"Expression count not correct for merged map", (rootListBean.getExpressionGraph().size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Bean does not contain expression for property key1", (Object)"@{expr1}", rootListBean.getExpressionGraph().get("reference1.map1['key1']"));
        Assert.assertEquals((String)"Bean does not contain expression for property key1", (Object)"@{expr4}", rootListBean.getExpressionGraph().get("reference1.map1['key4']"));
    }

    @Test
    public void testListExpressions() throws Exception {
        TestDictionaryBean testBean = (TestDictionaryBean)((Object)this.getTestDictionaryObject("testListExpressionMerging"));
        Assert.assertNotNull((String)"No bean exists with id: testListExpressionMerging", (Object)((Object)testBean));
        List<String> list1 = testBean.getList1();
        Assert.assertTrue((String)"List with expressions is not correct size", (list1.size() == 6 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Second value in list is not correct", (Object)"val1", (Object)list1.get(0));
        Assert.assertEquals((String)"Fifth value in list is not correct", (Object)"val5", (Object)list1.get(4));
        Assert.assertTrue((String)"Expression graph for inheritance list not correct size", (testBean.getExpressionGraph().size() == 4 ? 1 : 0) != 0);
        Assert.assertEquals((String)"First expression in expression graph not correct", (Object)"@{expr2} before val", testBean.getExpressionGraph().get("list1[1]"));
        Assert.assertEquals((String)"Second expression in expression graph not correct", (Object)"@{expr3}", testBean.getExpressionGraph().get("list1[2]"));
        Assert.assertEquals((String)"Third expression in expression graph not correct", (Object)"@{expr4}", testBean.getExpressionGraph().get("list1[3]"));
        Assert.assertEquals((String)"Fourth expression in expression graph not correct", (Object)"@{expr6}", testBean.getExpressionGraph().get("list1[5]"));
    }

    public void testNestedListMerging() throws Exception {
        TestDictionaryBean testBean = (TestDictionaryBean)((Object)this.getTestDictionaryObject("testListMerging2"));
        Assert.assertNotNull((String)"No bean exists with id: testListMerging2", (Object)((Object)testBean));
        List<String> list1 = testBean.getReference1().getList1();
        Assert.assertTrue((String)"List with expressions is not correct size", (list1.size() == 4 ? 1 : 0) != 0);
        Assert.assertEquals((String)"First value in list not correct", (Object)"val1", (Object)list1.get(0));
        Assert.assertEquals((String)"Second value in list not correct", (Object)"val2", (Object)list1.get(0));
        Assert.assertEquals((String)"Third value in list not correct", (Object)"val3", (Object)list1.get(0));
        Assert.assertEquals((String)"Fourth value in list not correct", (Object)"val4", (Object)list1.get(0));
    }

    @Test
    public void testPostProcessBeanFactoryWithSimpleInheritanceSucceeds() throws Exception {
        TestDictionaryBean simpleBean1 = (TestDictionaryBean)((Object)this.getTestDictionaryObject("testSimpleBean1"));
        TestDictionaryBean simpleBean2 = (TestDictionaryBean)((Object)this.getTestDictionaryObject("testSimpleBean2"));
        Assert.assertEquals((String)"Bean does not have the correct property3 value", simpleBean1.getExpressionGraph().get("property3"), (Object)"@{1 eq 1}");
        Assert.assertNull((String)"Bean should not have a property3 value", simpleBean2.getExpressionGraph().get("property3"));
    }

    @Test
    public void testPostProcessBeanFactoryWithSimpleNestingSucceeds() throws Exception {
        TestDictionaryBean simpleBean1 = (TestDictionaryBean)((Object)this.getTestDictionaryObject("testSimpleBean1"));
        TestDictionaryBean simpleBean4 = (TestDictionaryBean)((Object)this.getTestDictionaryObject("testSimpleBean4"));
        Assert.assertEquals((String)"Bean does not have the correct property3 value", simpleBean1.getExpressionGraph().get("property3"), (Object)"@{1 eq 1}");
        Assert.assertNull((String)"Bean should not have a property3 value", simpleBean4.getExpressionGraph().get("property3"));
    }

    @Test
    public void testBeanDefinitionNaming() {
        TestDictionaryBean testListBeanDefinitionNaming = (TestDictionaryBean)((Object)this.getTestDictionaryObject("testListBeanDefinitionNaming"));
        TestDictionaryBean uifTestBeanObject = testListBeanDefinitionNaming.getListReference1().get(0);
        Assert.assertTrue((String)"expression graph should have a property1", (boolean)uifTestBeanObject.getExpressionGraph().containsKey("property1"));
        TestDictionaryBean uifTestBeanObject1 = testListBeanDefinitionNaming.getListReference1().get(1);
        Assert.assertTrue((String)"expression graph should have a property1", (boolean)uifTestBeanObject1.getExpressionGraph().containsKey("property1"));
    }
}

