/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.util;

import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kns.util.WebUtils;
import org.kuali.rice.krad.test.KRADTestCase;

public class WebUtilsTest
extends KRADTestCase {
    @Test
    public void testButtonImageUrl() {
        String test1 = "test1";
        String test2 = "test2";
        String test2Image = WebUtils.getButtonImageUrl((String)"test2");
        String test2DefaultImage = WebUtils.getDefaultButtonImageUrl((String)"test2");
        Assert.assertEquals((String)"test2 image did not equal default for test2", (Object)test2Image, (Object)test2DefaultImage);
        String test1Image = WebUtils.getButtonImageUrl((String)"test1");
        String test1DefaultImage = WebUtils.getDefaultButtonImageUrl((String)"test1");
        Assert.assertNotSame((String)"the test1 image should not be the default", (Object)test1Image, (Object)test1DefaultImage);
        Assert.assertEquals((Object)"/test/images/test1.png", (Object)test1Image);
    }

    @Test
    public void testFilterHtmlAndReplaceRiceMarkup() {
        String questionText = "";
        questionText = "<script> function () </script>";
        String filteredText = WebUtils.filterHtmlAndReplaceRiceMarkup((String)questionText);
        Assert.assertTrue((String)"Script tags not filtered out", (!StringUtils.equals((String)questionText, (String)filteredText) ? 1 : 0) != 0);
        questionText = "[p][/p]";
        filteredText = WebUtils.filterHtmlAndReplaceRiceMarkup((String)questionText);
        Assert.assertEquals((String)"Paragraph tag not translated to markup", (Object)"<p></p>", (Object)filteredText);
        questionText = "[b][/b]";
        filteredText = WebUtils.filterHtmlAndReplaceRiceMarkup((String)questionText);
        Assert.assertEquals((String)"Bold tag not translated to markup", (Object)"<b></b>", (Object)filteredText);
        questionText = "[br][/br]";
        filteredText = WebUtils.filterHtmlAndReplaceRiceMarkup((String)questionText);
        Assert.assertEquals((String)"Break tag not translated to markup", (Object)"<br></br>", (Object)filteredText);
        questionText = "[tr][/tr]";
        filteredText = WebUtils.filterHtmlAndReplaceRiceMarkup((String)questionText);
        Assert.assertEquals((String)"Table row tag not translated to markup", (Object)"<tr></tr>", (Object)filteredText);
        questionText = "[td][/td]";
        filteredText = WebUtils.filterHtmlAndReplaceRiceMarkup((String)questionText);
        Assert.assertEquals((String)"Table cell tag not translated to markup", (Object)"<td></td>", (Object)filteredText);
        questionText = "[font #000000][/font]";
        filteredText = WebUtils.filterHtmlAndReplaceRiceMarkup((String)questionText);
        Assert.assertEquals((String)"Font with hex color tag not translated to markup", (Object)"<font color=\"#000000\"></font>", (Object)filteredText);
        questionText = "[font red][/font]";
        filteredText = WebUtils.filterHtmlAndReplaceRiceMarkup((String)questionText);
        Assert.assertEquals((String)"Font with color name tag not translated to markup", (Object)"<font color=\"red\"></font>", (Object)filteredText);
        questionText = "[table][/table]";
        filteredText = WebUtils.filterHtmlAndReplaceRiceMarkup((String)questionText);
        Assert.assertEquals((String)"Table tag not translated to markup", (Object)"<table></table>", (Object)filteredText);
        questionText = "[table questionTable][/table]";
        filteredText = WebUtils.filterHtmlAndReplaceRiceMarkup((String)questionText);
        Assert.assertEquals((String)"Table with class tag not translated to markup", (Object)"<table class=\"questionTable\"></table>", (Object)filteredText);
        questionText = "[td leftTd][/td]";
        filteredText = WebUtils.filterHtmlAndReplaceRiceMarkup((String)questionText);
        Assert.assertEquals((String)"Table cell with class tag not translated to markup", (Object)"<td class=\"leftTd\"></td>", (Object)filteredText);
    }

    @Test
    public void testToAbsoluteURL() {
        Assert.assertEquals((Object)"base/relative", (Object)WebUtils.toAbsoluteURL((String)"base", (String)"/relative"));
        Assert.assertEquals((Object)"http://base/relative", (Object)WebUtils.toAbsoluteURL((String)"http://base", (String)"/relative"));
        Assert.assertEquals((Object)"http://absolute", (Object)WebUtils.toAbsoluteURL((String)"http://base", (String)"http://absolute"));
        Assert.assertEquals((Object)"https://absolute", (Object)WebUtils.toAbsoluteURL((String)"http://base", (String)"https://absolute"));
        Assert.assertEquals((Object)"https://absolute", (Object)WebUtils.toAbsoluteURL(null, (String)"https://absolute"));
        Assert.assertEquals((Object)"", (Object)WebUtils.toAbsoluteURL((String)"", (String)""));
        Assert.assertEquals((Object)"base", (Object)WebUtils.toAbsoluteURL((String)"base", (String)""));
        Assert.assertEquals((Object)"base", (Object)WebUtils.toAbsoluteURL((String)"base", null));
    }
}

